# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.anomaly_model_metadata_clusters_inner import AnomalyModelMetadataClustersInner

class AnomalyModelMetadataResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    created: datetime = Field(..., description="Date when the model was trained")
    scale: List[float] = Field(..., description="Scale input for StandardScaler. Values are scaled like this (where `ix` is axis index): `input[ix] = (input[ix] - mean[ix]) / scale[ix];`")
    mean: List[float] = Field(..., description="Mean input for StandardScaler. Values are scaled like this (where `ix` is axis index): `input[ix] = (input[ix] - mean[ix]) / scale[ix];`")
    clusters: List[AnomalyModelMetadataClustersInner] = Field(..., description="Trained K-means clusters")
    axes: List[StrictInt] = Field(..., description="Which axes were included during training (by index)")
    default_minimum_confidence_rating: Optional[float] = Field(None, alias="defaultMinimumConfidenceRating", description="Default minimum confidence rating required before tagging as anomaly, based on scores of training data (GMM only).")
    __properties = ["success", "error", "created", "scale", "mean", "clusters", "axes", "defaultMinimumConfidenceRating"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnomalyModelMetadataResponse:
        """Create an instance of AnomalyModelMetadataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in clusters (list)
        _items = []
        if self.clusters:
            for _item in self.clusters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['clusters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnomalyModelMetadataResponse:
        """Create an instance of AnomalyModelMetadataResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AnomalyModelMetadataResponse.parse_obj(obj)

        _obj = AnomalyModelMetadataResponse.parse_obj({
            "success": obj.get("success"),
            "error": obj.get("error"),
            "created": obj.get("created"),
            "scale": obj.get("scale"),
            "mean": obj.get("mean"),
            "clusters": [AnomalyModelMetadataClustersInner.from_dict(_item) for _item in obj.get("clusters")] if obj.get("clusters") is not None else None,
            "axes": obj.get("axes"),
            "default_minimum_confidence_rating": obj.get("defaultMinimumConfidenceRating")
        })
        return _obj

