# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.anomaly_model_metadata_response import AnomalyModelMetadataResponse
from edgeimpulse_api.models.anomaly_trained_features_response import AnomalyTrainedFeaturesResponse
from edgeimpulse_api.models.classify_job_response import ClassifyJobResponse
from edgeimpulse_api.models.classify_sample_response import ClassifySampleResponse
from edgeimpulse_api.models.count_samples_response import CountSamplesResponse
from edgeimpulse_api.models.dsp_metadata_response import DSPMetadataResponse
from edgeimpulse_api.models.data_explorer_predictions_response import DataExplorerPredictionsResponse
from edgeimpulse_api.models.deployment_target_engine import DeploymentTargetEngine
from edgeimpulse_api.models.deployment_targets_response import DeploymentTargetsResponse
from edgeimpulse_api.models.dsp_run_response_with_sample import DspRunResponseWithSample
from edgeimpulse_api.models.dsp_sample_features_response import DspSampleFeaturesResponse
from edgeimpulse_api.models.dsp_trained_features_response import DspTrainedFeaturesResponse
from edgeimpulse_api.models.get_data_explorer_features_response import GetDataExplorerFeaturesResponse
from edgeimpulse_api.models.get_notes_response import GetNotesResponse
from edgeimpulse_api.models.get_performance_calibration_ground_truth_response import GetPerformanceCalibrationGroundTruthResponse
from edgeimpulse_api.models.get_performance_calibration_parameter_sets_response import GetPerformanceCalibrationParameterSetsResponse
from edgeimpulse_api.models.get_performance_calibration_parameters_response import GetPerformanceCalibrationParametersResponse
from edgeimpulse_api.models.get_performance_calibration_raw_result_response import GetPerformanceCalibrationRawResultResponse
from edgeimpulse_api.models.get_performance_calibration_status_response import GetPerformanceCalibrationStatusResponse
from edgeimpulse_api.models.get_sample_response import GetSampleResponse
from edgeimpulse_api.models.has_data_explorer_features_response import HasDataExplorerFeaturesResponse
from edgeimpulse_api.models.keras_model_metadata import KerasModelMetadata
from edgeimpulse_api.models.keras_model_type_enum import KerasModelTypeEnum
from edgeimpulse_api.models.list_samples_response import ListSamplesResponse
from edgeimpulse_api.models.project_deployment_targets_response import ProjectDeploymentTargetsResponse
from edgeimpulse_api.models.project_info_summary_response import ProjectInfoSummaryResponse
from edgeimpulse_api.models.test_pretrained_model_request import TestPretrainedModelRequest
from edgeimpulse_api.models.test_pretrained_model_response import TestPretrainedModelResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AllowsReadOnlyApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def anomaly_trained_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], **kwargs) -> AnomalyTrainedFeaturesResponse:  # noqa: E501
        """Trained features

        Get a sample of trained features, this extracts a number of samples and their features.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnomalyTrainedFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._anomaly_trained_features_with_http_info(project_id, learn_id, feature_ax1, feature_ax2, **kwargs)  # noqa: E501

    @validate_arguments
    def _anomaly_trained_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], **kwargs):  # noqa: E501
        """Trained features 

        Get a sample of trained features, this extracts a number of samples and their features.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnomalyTrainedFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'feature_ax1',
            'feature_ax2'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method anomaly_trained_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []
        if _params.get('feature_ax1') is not None:  # noqa: E501
            _query_params.append(('featureAx1', _params['feature_ax1']))
        if _params.get('feature_ax2') is not None:  # noqa: E501
            _query_params.append(('featureAx2', _params['feature_ax2']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AnomalyTrainedFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/training/anomaly/{learnId}/features/get-graph', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def anomaly_trained_features_per_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> AnomalyTrainedFeaturesResponse:  # noqa: E501
        """Trained features for sample

        Get trained features for a single sample. This runs both the DSP prerequisites and the anomaly classifier.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnomalyTrainedFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._anomaly_trained_features_per_sample_with_http_info(project_id, learn_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _anomaly_trained_features_per_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Trained features for sample 

        Get trained features for a single sample. This runs both the DSP prerequisites and the anomaly classifier.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnomalyTrainedFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method anomaly_trained_features_per_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AnomalyTrainedFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/training/anomaly/{learnId}/features/get-graph/classification/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> ClassifySampleResponse:  # noqa: E501
        """Classify sample

        Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Classify sample 

        Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample_by_learn_block(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], **kwargs) -> ClassifySampleResponse:  # noqa: E501
        """Classify sample by learn block

        Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_by_learn_block_with_http_info(project_id, sample_id, block_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_by_learn_block_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], **kwargs):  # noqa: E501
        """Classify sample by learn block 

        Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'block_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample_by_learn_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']
        if _params['block_id']:
            _path_params['blockId'] = _params['block_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/anomaly-gmm/{blockId}/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def count_samples(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, **kwargs) -> CountSamplesResponse:  # noqa: E501
        """Count samples

        Count all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: str
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CountSamplesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._count_samples_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, **kwargs)  # noqa: E501

    @validate_arguments
    def _count_samples_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, **kwargs):  # noqa: E501
        """Count samples 

        Count all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: str
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CountSamplesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_samples" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CountSamplesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_build(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, **kwargs) -> str:  # noqa: E501
        """Download

        Download the build artefacts for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_build_with_http_info(project_id, type, model_type, engine, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_build_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], type : Annotated[StrictStr, Field(..., description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")], model_type : Annotated[Optional[KerasModelTypeEnum], Field(description="Optional model type of the build (if not, it uses the settings in the Keras block)")] = None, engine : Annotated[Optional[DeploymentTargetEngine], Field(description="Optional engine for the build (if not, it uses the default engine for the deployment target)")] = None, **kwargs):  # noqa: E501
        """Download 

        Download the build artefacts for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param type: The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type. (required)
        :type type: str
        :param model_type: Optional model type of the build (if not, it uses the settings in the Keras block)
        :type model_type: KerasModelTypeEnum
        :param engine: Optional engine for the build (if not, it uses the default engine for the deployment target)
        :type engine: DeploymentTargetEngine
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'type',
            'model_type',
            'engine'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_build" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))
        if _params.get('model_type') is not None:  # noqa: E501
            _query_params.append(('modelType', _params['model_type']))
        if _params.get('engine') is not None:  # noqa: E501
            _query_params.append(('engine', _params['engine']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/download', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_dsp_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], raw : Annotated[Optional[StrictBool], Field(description="Whether to download raw data or processed data. Processed data is the default.")] = None, **kwargs) -> str:  # noqa: E501
        """Download DSP data

        Download output from a DSP block over all data in the training set, already sliced in windows. In Numpy binary format.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param raw: Whether to download raw data or processed data. Processed data is the default.
        :type raw: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_dsp_data_with_http_info(project_id, dsp_id, category, raw, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_dsp_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], raw : Annotated[Optional[StrictBool], Field(description="Whether to download raw data or processed data. Processed data is the default.")] = None, **kwargs):  # noqa: E501
        """Download DSP data 

        Download output from a DSP block over all data in the training set, already sliced in windows. In Numpy binary format.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param raw: Whether to download raw data or processed data. Processed data is the default.
        :type raw: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'category',
            'raw'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_dsp_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []
        if _params.get('raw') is not None:  # noqa: E501
            _query_params.append(('raw', _params['raw']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp-data/{dspId}/x/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_dsp_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs) -> str:  # noqa: E501
        """Download DSP labels

        Download labels for a DSP block over all data in the training set, already sliced in windows.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_dsp_labels_with_http_info(project_id, dsp_id, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_dsp_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs):  # noqa: E501
        """Download DSP labels 

        Download labels for a DSP block over all data in the training set, already sliced in windows.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_dsp_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp-data/{dspId}/y/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_learn_model(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], model_download_id : Annotated[StrictStr, Field(..., description="Model download ID, which can be obtained from the project information")], **kwargs) -> str:  # noqa: E501
        """Download trained model

        Download a trained model for a learning block. Depending on the block this can be a TensorFlow model, or the cluster centroids.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param model_download_id: Model download ID, which can be obtained from the project information (required)
        :type model_download_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_learn_model_with_http_info(project_id, learn_id, model_download_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_learn_model_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], model_download_id : Annotated[StrictStr, Field(..., description="Model download ID, which can be obtained from the project information")], **kwargs):  # noqa: E501
        """Download trained model 

        Download a trained model for a learning block. Depending on the block this can be a TensorFlow model, or the cluster centroids.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param model_download_id: Model download ID, which can be obtained from the project information (required)
        :type model_download_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id',
            'model_download_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_learn_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']
        if _params['model_download_id']:
            _path_params['modelDownloadId'] = _params['model_download_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/learn-data/{learnId}/model/{modelDownloadId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def dsp_get_features_for_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> DspSampleFeaturesResponse:  # noqa: E501
        """Features for sample

        Runs the DSP block against a sample. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and run the DSP function for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspSampleFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._dsp_get_features_for_sample_with_http_info(project_id, dsp_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _dsp_get_features_for_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Features for sample 

        Runs the DSP block against a sample. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and run the DSP function for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspSampleFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dsp_get_features_for_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspSampleFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/get-graph/classification/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def dsp_sample_trained_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], feature_ax3 : Annotated[StrictInt, Field(..., description="Feature axis 3")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs) -> DspTrainedFeaturesResponse:  # noqa: E501
        """Sample of trained features

        Get a sample of trained features, this extracts a number of samples and their labels. Used to visualize the current training set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param feature_ax3: Feature axis 3 (required)
        :type feature_ax3: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspTrainedFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._dsp_sample_trained_features_with_http_info(project_id, dsp_id, feature_ax1, feature_ax2, feature_ax3, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _dsp_sample_trained_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], feature_ax3 : Annotated[StrictInt, Field(..., description="Feature axis 3")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs):  # noqa: E501
        """Sample of trained features 

        Get a sample of trained features, this extracts a number of samples and their labels. Used to visualize the current training set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param feature_ax3: Feature axis 3 (required)
        :type feature_ax3: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspTrainedFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'feature_ax1',
            'feature_ax2',
            'feature_ax3',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dsp_sample_trained_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []
        if _params.get('feature_ax1') is not None:  # noqa: E501
            _query_params.append(('featureAx1', _params['feature_ax1']))
        if _params.get('feature_ax2') is not None:  # noqa: E501
            _query_params.append(('featureAx2', _params['feature_ax2']))
        if _params.get('feature_ax3') is not None:  # noqa: E501
            _query_params.append(('featureAx3', _params['feature_ax3']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspTrainedFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/get-graph/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_anomaly_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> AnomalyModelMetadataResponse:  # noqa: E501
        """Anomaly metadata

        Get metadata about a trained anomaly block. Use the impulse blocks to find the learnId.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnomalyModelMetadataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_anomaly_metadata_with_http_info(project_id, learn_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_anomaly_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Anomaly metadata 

        Get metadata about a trained anomaly block. Use the impulse blocks to find the learnId.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnomalyModelMetadataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_anomaly_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AnomalyModelMetadataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/training/anomaly/{learnId}/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_classify_job_result(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> ClassifyJobResponse:  # noqa: E501
        """Classify job result

        Get classify job result, containing the result for the complete testing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifyJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_classify_job_result_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_classify_job_result_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Classify job result 

        Get classify job result, containing the result for the complete testing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifyJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classify_job_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifyJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/all/result', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetDataExplorerFeaturesResponse:  # noqa: E501
        """Get data explorer features

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_data_explorer_features_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get data explorer features 

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/features', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_data_explorer_predictions(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> DataExplorerPredictionsResponse:  # noqa: E501
        """Get data explorer predictions

        Predictions for every data explorer point (only available when using current impulse to populate data explorer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataExplorerPredictionsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_data_explorer_predictions_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_data_explorer_predictions_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get data explorer predictions 

        Predictions for every data explorer point (only available when using current impulse to populate data explorer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataExplorerPredictionsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_explorer_predictions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DataExplorerPredictionsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/predictions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DSPMetadataResponse:  # noqa: E501
        """Get metadata

        Retrieve the metadata from a generated DSP block.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DSPMetadataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_metadata_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get metadata 

        Retrieve the metadata from a generated DSP block.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DSPMetadataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DSPMetadataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_raw_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get raw sample

        Get raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out. If you pass dspId = 0 this will return a raw graph without any processing.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_raw_sample_with_http_info(project_id, dsp_id, sample_id, limit_payload_values, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_raw_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, **kwargs):  # noqa: E501
        """Get raw sample 

        Get raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out. If you pass dspId = 0 this will return a raw graph without any processing.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'limit_payload_values'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_raw_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit_payload_values') is not None:  # noqa: E501
            _query_params.append(('limitPayloadValues', _params['limit_payload_values']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_sample_slice(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get raw sample (slice)

        Get slice of raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_sample_slice_with_http_info(project_id, dsp_id, sample_id, slice_start, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_sample_slice_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs):  # noqa: E501
        """Get raw sample (slice) 

        Get slice of raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'slice_start',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_sample_slice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}/slice', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_keras_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GetDataExplorerFeaturesResponse:  # noqa: E501
        """Get data explorer features

        t-SNE2 output of the raw dataset using embeddings from this Keras block

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_keras_data_explorer_features_with_http_info(project_id, learn_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_keras_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get data explorer features 

        t-SNE2 output of the raw dataset using embeddings from this Keras block

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_keras_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/training/keras/{learnId}/data-explorer/features', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_keras_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> KerasModelMetadata:  # noqa: E501
        """Keras metadata

        Get metadata about a trained Keras block. Use the impulse blocks to find the learnId.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: KerasModelMetadata
        """
        kwargs['_return_http_data_only'] = True
        return self._get_keras_metadata_with_http_info(project_id, learn_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_keras_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], learn_id : Annotated[StrictInt, Field(..., description="Learn Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Keras metadata 

        Get metadata about a trained Keras block. Use the impulse blocks to find the learnId.

        :param project_id: Project ID (required)
        :type project_id: int
        :param learn_id: Learn Block ID, use the impulse functions to retrieve the ID (required)
        :type learn_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(KerasModelMetadata, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'learn_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_keras_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['learn_id']:
            _path_params['learnId'] = _params['learn_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "KerasModelMetadata",
        }

        return self.api_client.call_api(
            '/api/{projectId}/training/keras/{learnId}/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_notes(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetNotesResponse:  # noqa: E501
        """Get notes

        Get all notes in project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetNotesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_notes_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_notes_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get notes 

        Get all notes in project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetNotesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetNotesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/notes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_calibration_ground_truth(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetPerformanceCalibrationGroundTruthResponse:  # noqa: E501
        """Get ground truth

        Get performance calibration ground truth data

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPerformanceCalibrationGroundTruthResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_calibration_ground_truth_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_calibration_ground_truth_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get ground truth 

        Get performance calibration ground truth data

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPerformanceCalibrationGroundTruthResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_calibration_ground_truth" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPerformanceCalibrationGroundTruthResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/ground-truth', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_calibration_parameter_sets(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetPerformanceCalibrationParameterSetsResponse:  # noqa: E501
        """Get parameter sets

        Get performance calibration parameter sets

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPerformanceCalibrationParameterSetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_calibration_parameter_sets_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_calibration_parameter_sets_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get parameter sets 

        Get performance calibration parameter sets

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPerformanceCalibrationParameterSetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_calibration_parameter_sets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPerformanceCalibrationParameterSetsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/parameter-sets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_calibration_raw_result(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetPerformanceCalibrationRawResultResponse:  # noqa: E501
        """Get raw result

        Get performance calibration raw result

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPerformanceCalibrationRawResultResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_calibration_raw_result_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_calibration_raw_result_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get raw result 

        Get performance calibration raw result

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPerformanceCalibrationRawResultResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_calibration_raw_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPerformanceCalibrationRawResultResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/raw-result', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_calibration_saved_parameters(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetPerformanceCalibrationParametersResponse:  # noqa: E501
        """Get parameters

        Get performance calibration stored parameters

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPerformanceCalibrationParametersResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_calibration_saved_parameters_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_calibration_saved_parameters_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get parameters 

        Get performance calibration stored parameters

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPerformanceCalibrationParametersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_calibration_saved_parameters" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPerformanceCalibrationParametersResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/parameters', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_calibration_status(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetPerformanceCalibrationStatusResponse:  # noqa: E501
        """Get status

        Get performance calibration status

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPerformanceCalibrationStatusResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_calibration_status_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_calibration_status_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get status 

        Get performance calibration status

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPerformanceCalibrationStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_calibration_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPerformanceCalibrationStatusResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/status', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_project_info_summary(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> ProjectInfoSummaryResponse:  # noqa: E501
        """Public project information

        List a summary about this project - available for public projects.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProjectInfoSummaryResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_project_info_summary_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_project_info_summary_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Public project information 

        List a summary about this project - available for public projects.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProjectInfoSummaryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_info_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ProjectInfoSummaryResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/public-info', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get sample

        Get a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_with_http_info(project_id, sample_id, limit_payload_values, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, **kwargs):  # noqa: E501
        """Get sample 

        Get a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'limit_payload_values'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit_payload_values') is not None:  # noqa: E501
            _query_params.append(('limitPayloadValues', _params['limit_payload_values']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_audio(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], axis_ix : Annotated[StrictInt, Field(..., description="Axis index")], slice_start : Annotated[Optional[StrictInt], Field(description="Begin index of the slice")] = None, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice")] = None, **kwargs) -> str:  # noqa: E501
        """Get WAV file

        Get a sample as a WAV file. This only applies to samples with an audio axis.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param axis_ix: Axis index (required)
        :type axis_ix: int
        :param slice_start: Begin index of the slice
        :type slice_start: int
        :param slice_end: End index of the slice
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_audio_with_http_info(project_id, sample_id, axis_ix, slice_start, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_audio_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], axis_ix : Annotated[StrictInt, Field(..., description="Axis index")], slice_start : Annotated[Optional[StrictInt], Field(description="Begin index of the slice")] = None, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice")] = None, **kwargs):  # noqa: E501
        """Get WAV file 

        Get a sample as a WAV file. This only applies to samples with an audio axis.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param axis_ix: Axis index (required)
        :type axis_ix: int
        :param slice_start: Begin index of the slice
        :type slice_start: int
        :param slice_end: End index of the slice
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'axis_ix',
            'slice_start',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_audio" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('axis_ix') is not None:  # noqa: E501
            _query_params.append(('axisIx', _params['axis_ix']))
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['audio/wav'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/wav', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_image(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, **kwargs) -> str:  # noqa: E501
        """Get image file

        Get a sample as an image file. This only applies to samples with RGBA data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_image_with_http_info(project_id, sample_id, after_input_block, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_image_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, **kwargs):  # noqa: E501
        """Get image file 

        Get a sample as an image file. This only applies to samples with RGBA data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'after_input_block'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_image" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('after_input_block') is not None:  # noqa: E501
            _query_params.append(('afterInputBlock', _params['after_input_block']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['image/jpeg'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/image', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_raw(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> str:  # noqa: E501
        """Download file

        Download a sample in it's original format as uploaded to the ingestion service.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_raw_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_raw_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Download file 

        Download a sample in it's original format as uploaded to the ingestion service.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_raw" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/raw', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_video(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, **kwargs) -> str:  # noqa: E501
        """Get video file

        Get a sample as an video file. This only applies to samples with video data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_video_with_http_info(project_id, sample_id, after_input_block, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_video_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, **kwargs):  # noqa: E501
        """Get video file 

        Get a sample as an video file. This only applies to samples with video data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'after_input_block'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_video" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('after_input_block') is not None:  # noqa: E501
            _query_params.append(('afterInputBlock', _params['after_input_block']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['video/mp4'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/video', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_slice(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get sample slice

        Get a slice of a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_slice_with_http_info(project_id, sample_id, slice_start, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_slice_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs):  # noqa: E501
        """Get sample slice 

        Get a slice of a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'slice_start',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_slice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/slice', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_wav_file(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> str:  # noqa: E501
        """Get WAV file

        Get the synthetic sample as a WAV file

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_wav_file_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_wav_file_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get WAV file 

        Get the synthetic sample as a WAV file

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wav_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['audio/wav'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/performance-calibration/wav', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def has_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> HasDataExplorerFeaturesResponse:  # noqa: E501
        """Check data explorer features

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HasDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._has_data_explorer_features_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _has_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Check data explorer features 

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HasDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method has_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "HasDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/has-features', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_all_deployment_targets(self, **kwargs) -> DeploymentTargetsResponse:  # noqa: E501
        """Deployment targets

        List all deployment targets

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_all_deployment_targets_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def _list_all_deployment_targets_with_http_info(self, **kwargs):  # noqa: E501
        """Deployment targets 

        List all deployment targets

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_deployment_targets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/deployment/targets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_deployment_targets_for_project(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> ProjectDeploymentTargetsResponse:  # noqa: E501
        """Deployment targets

        List deployment targets for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProjectDeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_deployment_targets_for_project_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_deployment_targets_for_project_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Deployment targets 

        List deployment targets for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProjectDeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment_targets_for_project" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ProjectDeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/targets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_deployment_targets_for_project_data_sources(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> DeploymentTargetsResponse:  # noqa: E501
        """Deployment targets (data sources)

        List deployment targets for a project from data sources page  (it shows some things like all Linux deploys, and hides 'fake' deploy targets like mobile phone / computer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeploymentTargetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_deployment_targets_for_project_data_sources_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_deployment_targets_for_project_data_sources_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Deployment targets (data sources) 

        List deployment targets for a project from data sources page  (it shows some things like all Linux deploys, and hides 'fake' deploy targets like mobile phone / computer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeploymentTargetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment_targets_for_project_data_sources" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DeploymentTargetsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/deployment/targets/data-sources', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_samples(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to retrieve data from")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_sensors : Annotated[Optional[StrictBool], Field(description="Whether to exclude sensors in the response (as these can slow down requests when you have large pages).")] = None, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, **kwargs) -> ListSamplesResponse:  # noqa: E501
        """List samples

        Retrieve all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: str
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_sensors: Whether to exclude sensors in the response (as these can slow down requests when you have large pages).
        :type exclude_sensors: bool
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListSamplesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_samples_with_http_info(project_id, category, limit, offset, exclude_sensors, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_samples_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[StrictStr, Field(..., description="Which of the three acquisition categories to retrieve data from")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_sensors : Annotated[Optional[StrictBool], Field(description="Whether to exclude sensors in the response (as these can slow down requests when you have large pages).")] = None, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, **kwargs):  # noqa: E501
        """List samples 

        Retrieve all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: str
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_sensors: Whether to exclude sensors in the response (as these can slow down requests when you have large pages).
        :type exclude_sensors: bool
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListSamplesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'limit',
            'offset',
            'exclude_sensors',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_samples" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('exclude_sensors') is not None:  # noqa: E501
            _query_params.append(('excludeSensors', _params['exclude_sensors']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListSamplesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_dsp_sample_slice_read_only(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs) -> DspRunResponseWithSample:  # noqa: E501
        """Get processed sample (slice)

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspRunResponseWithSample
        """
        kwargs['_return_http_data_only'] = True
        return self._run_dsp_sample_slice_read_only_with_http_info(project_id, dsp_id, sample_id, slice_start, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _run_dsp_sample_slice_read_only_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[StrictInt, Field(..., description="End index of the slice")], **kwargs):  # noqa: E501
        """Get processed sample (slice) 

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice (required)
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspRunResponseWithSample, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'slice_start',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_dsp_sample_slice_read_only" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspRunResponseWithSample",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}/slice/run/readonly', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def test_pretrained_model(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], test_pretrained_model_request : Optional[TestPretrainedModelRequest] = None, **kwargs) -> TestPretrainedModelResponse:  # noqa: E501
        """Test pretrained model

        Test out a pretrained model (using raw features) - upload first via  `uploadPretrainedModel`. If you want to deploy a pretrained model from the API, see `startDeployPretrainedModelJob`.

        :param project_id: Project ID (required)
        :type project_id: int
        :param test_pretrained_model_request:
        :type test_pretrained_model_request: TestPretrainedModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TestPretrainedModelResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._test_pretrained_model_with_http_info(project_id, test_pretrained_model_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _test_pretrained_model_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], test_pretrained_model_request : Optional[TestPretrainedModelRequest] = None, **kwargs):  # noqa: E501
        """Test pretrained model 

        Test out a pretrained model (using raw features) - upload first via  `uploadPretrainedModel`. If you want to deploy a pretrained model from the API, see `startDeployPretrainedModelJob`.

        :param project_id: Project ID (required)
        :type project_id: int
        :param test_pretrained_model_request:
        :type test_pretrained_model_request: TestPretrainedModelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TestPretrainedModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'test_pretrained_model_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_pretrained_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['test_pretrained_model_request']:
            _body_params = _params['test_pretrained_model_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "TestPretrainedModelResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/pretrained-model/test', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
