/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.Arrays;
import libpadeldescriptor.GraphUtil;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public final class ShortestPaths {
    private static final int[] EMPTY_PATH = new int[0];
    private static final int[][] EMPTY_PATHS = new int[0][];
    private final Route[] routeTo;
    private final int[] distTo;
    private final int[] nPathsTo;
    private final boolean[] precedes;
    private final int start;
    private final int limit;
    private final IAtomContainer container;

    @TestMethod(value="testConstructor_Container_Empty,testConstructor_Container_Null,testConstructor_Container_MissingAtom")
    public ShortestPaths(IAtomContainer iAtomContainer, IAtom iAtom) {
        this(GraphUtil.toAdjList(iAtomContainer), iAtomContainer, iAtomContainer.getAtomNumber(iAtom));
    }

    ShortestPaths(int[][] nArray, IAtomContainer iAtomContainer, int n) {
        this(nArray, iAtomContainer, n, null);
    }

    ShortestPaths(int[][] nArray, IAtomContainer iAtomContainer, int n, int[] nArray2) {
        this(nArray, iAtomContainer, n, nArray.length, nArray2);
    }

    ShortestPaths(int[][] nArray, IAtomContainer iAtomContainer, int n, int n2, int[] nArray2) {
        int n3 = nArray.length;
        this.container = iAtomContainer;
        this.start = n;
        this.limit = n2;
        this.distTo = new int[n3];
        this.routeTo = new Route[n3];
        this.nPathsTo = new int[n3];
        this.precedes = new boolean[n3];
        if (n3 == 0) {
            return;
        }
        if (n == -1) {
            throw new IllegalArgumentException("invalid vertex start - atom not found container");
        }
        for (int i = 0; i < n3; ++i) {
            this.distTo[i] = Integer.MAX_VALUE;
        }
        this.distTo[n] = 0;
        this.routeTo[n] = new Source(n);
        this.nPathsTo[n] = 1;
        this.precedes[n] = true;
        if (nArray2 != null) {
            this.compute(nArray, nArray2);
        } else {
            this.compute(nArray);
        }
    }

    private void compute(int[][] nArray) {
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            int n3 = this.distTo[n2] + 1;
            for (int n4 : nArray[n2]) {
                if (n3 > this.limit) continue;
                if (n3 < this.distTo[n4]) {
                    this.distTo[n4] = n3;
                    this.routeTo[n4] = new SequentialRoute(this.routeTo[n2], n4);
                    this.nPathsTo[n4] = this.nPathsTo[n2];
                    nArray2[n++] = n4;
                    continue;
                }
                if (this.distTo[n4] != n3) continue;
                this.routeTo[n4] = new Branch(this.routeTo[n4], new SequentialRoute(this.routeTo[n2], n4));
                int n5 = n4;
                this.nPathsTo[n5] = this.nPathsTo[n5] + this.nPathsTo[n2];
            }
        }
    }

    private void compute(int[][] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        nArray3[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray3[i];
            int n3 = this.distTo[n2] + 1;
            for (int n4 : nArray[n2]) {
                if (n3 < this.distTo[n4]) {
                    this.distTo[n4] = n3;
                    this.routeTo[n4] = new SequentialRoute(this.routeTo[n2], n4);
                    this.nPathsTo[n4] = this.nPathsTo[n2];
                    this.precedes[n4] = this.precedes[n2] && nArray2[n4] < nArray2[this.start];
                    nArray3[n++] = n4;
                    continue;
                }
                if (this.distTo[n4] != n3 || !this.precedes[n2] || nArray2[n4] >= nArray2[this.start]) continue;
                if (this.precedes[n4]) {
                    this.routeTo[n4] = new Branch(this.routeTo[n4], new SequentialRoute(this.routeTo[n2], n4));
                    int n5 = n4;
                    this.nPathsTo[n5] = this.nPathsTo[n5] + this.nPathsTo[n2];
                    continue;
                }
                this.precedes[n4] = true;
                this.routeTo[n4] = new SequentialRoute(this.routeTo[n2], n4);
            }
        }
    }

    @TestMethod(value="testPathTo_Int_Simple,testPathTo_Int_Benzene,testPathTo_Int_Norbornane,testPathTo_Int_Spiroundecane,testPathTo_Int_Pentadecaspiro,testPathTo_Int_OutOfBoundsIndex,testPathTo_Int_NegativeIndex,testPathTo_Int_Disconnected")
    public int[] pathTo(int n) {
        if (n < 0 || n >= this.routeTo.length) {
            return EMPTY_PATH;
        }
        return this.routeTo[n] != null ? this.routeTo[n].toPath(this.distTo[n] + 1) : EMPTY_PATH;
    }

    @TestMethod(value="testPathTo_Atom_Simple,testPathTo_Atom_Benzene,testPathTo_Atom_Norbornane,testPathTo_Atom_Spiroundecane,testPathTo_Atom_Pentadecaspiro,testPathTo_Atom_MissingAtom,testPathTo_Atom_Null,testPathTo_Atom_Disconnected")
    public int[] pathTo(IAtom iAtom) {
        return this.pathTo(this.container.getAtomNumber(iAtom));
    }

    @TestMethod(value="testIsPrecedingPathTo_OutOfBounds,testIsPrecedingPathTo")
    public boolean isPrecedingPathTo(int n) {
        return (n >= 0 || n < this.routeTo.length) && this.precedes[n];
    }

    @TestMethod(value="testPathsTo_Int_Simple,testPathsTo_Int_Benzene,testPathsTo_Int_Spiroundecane,testPathsTo_Int_Norbornane,testPathsTo_Int_OutOfBoundsIndex,testPathsTo_Int_NegativeIndex,testPathsTo_Int_Disconnected")
    public int[][] pathsTo(int n) {
        if (n < 0 || n >= this.routeTo.length) {
            return EMPTY_PATHS;
        }
        return this.routeTo[n] != null ? this.routeTo[n].toPaths(this.distTo[n] + 1) : EMPTY_PATHS;
    }

    @TestMethod(value="testPathsTo_Atom_Simple,testPathsTo_Atom_Benzene,testPathsTo_Atom_Spiroundecane,testPathsTo_Atom_Norbornane,testPathsTo_Atom_Pentadecaspiro,testPathsTo_Atom_MissingAtom,testPathsTo_Atom_Null,testPathsTo_Atom_Disconnected")
    public int[][] pathsTo(IAtom iAtom) {
        return this.pathsTo(this.container.getAtomNumber(iAtom));
    }

    @TestMethod(value="testAtomsTo_Int_Simple,testAtomsTo_Int_Benzene,testAtomsTo_Int_Disconnected,testAtomsTo_Int_OutOfBoundsIndex,testAtomsTo_Int_NegativeIndex")
    public IAtom[] atomsTo(int n) {
        int[] nArray = this.pathTo(n);
        IAtom[] iAtomArray = new IAtom[nArray.length];
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            iAtomArray[i] = this.container.getAtom(nArray[i]);
        }
        return iAtomArray;
    }

    @TestMethod(value="testAtomsTo_Atom_Simple,testAtomsTo_Atom_Benzene,testAtomsTo_Atom_Disconnected,testAtomsTo_Atom_MissingAtom,testAtomsTo_Atom_Null")
    public IAtom[] atomsTo(IAtom iAtom) {
        return this.atomsTo(this.container.getAtomNumber(iAtom));
    }

    @TestMethod(value="testNPathsTo_Int_Simple,testNPathsTo_Int_Benzene,testNPathsTo_Int_Norbornane,testNPathsTo_Int_Spiroundecane,testNPathsTo_Int_Pentadecaspiro,testNPathsTo_Int_Disconnected,testNPathsTo_Int_OutOfBoundIndex,testNPathsTo_Int_NegativeIndex")
    public int nPathsTo(int n) {
        return n < 0 || n >= this.nPathsTo.length ? 0 : this.nPathsTo[n];
    }

    @TestMethod(value="testNPathsTo_Atom_Simple,testNPathsTo_Atom_Benzene,testNPathsTo_Atom_Norbornane,testNPathsTo_Atom_Spiroundecane,testNPathsTo_Atom_Pentadecaspiro,testNPathsTo_Atom_Disconnected,testNPathsTo_Atom_MissingAtom,testNPathsTo_Atom_Null")
    public int nPathsTo(IAtom iAtom) {
        return this.nPathsTo(this.container.getAtomNumber(iAtom));
    }

    @TestMethod(value="testDistanceTo_Int_Simple,testDistanceTo_Int_OutOfBoundIndex,testDistanceTo_Int_NegativeIndex,testDistanceTo_Int_Disconnected,testDistanceTo_Int_Benzene,testDistanceTo_Int_Spiroundecane,testDistanceTo_Int_Pentadecaspiro")
    public int distanceTo(int n) {
        return n < 0 || n >= this.nPathsTo.length ? Integer.MAX_VALUE : this.distTo[n];
    }

    @TestMethod(value="testDistanceTo_Atom_Simple,testDistanceTo_Atom_MissingAtom,testDistanceTo_Atom_Null,testDistanceTo_Atom_Disconnected,testDistanceTo_Atom_Benzene,testDistanceTo_Atom_Spiroundecane,testDistanceTo_Atom_Pentadecaspiro")
    public int distanceTo(IAtom iAtom) {
        return this.distanceTo(this.container.getAtomNumber(iAtom));
    }

    private class Branch
    implements Route {
        private final Route left;
        private final Route right;

        private Branch(Route route, Route route2) {
            this.left = route;
            this.right = route2;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] nArray = this.left.toPaths(n);
            int[][] nArray2 = this.right.toPaths(n);
            int[][] nArray3 = (int[][])Arrays.copyOf(nArray, nArray.length + nArray2.length);
            System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
            return nArray3;
        }

        @Override
        public int[] toPath(int n) {
            return this.left.toPath(n);
        }
    }

    private class SequentialRoute
    implements Route {
        private final int v;
        private final Route parent;

        private SequentialRoute(Route route, int n) {
            this.v = n;
            this.parent = route;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] nArray = this.parent.toPaths(n);
            int n2 = ShortestPaths.this.distTo[this.v];
            for (int[] nArray2 : nArray) {
                nArray2[n2] = this.v;
            }
            return nArray;
        }

        @Override
        public int[] toPath(int n) {
            int[] nArray = this.parent.toPath(n);
            nArray[((ShortestPaths)ShortestPaths.this).distTo[this.v]] = this.v;
            return nArray;
        }
    }

    private static class Source
    implements Route {
        private final int v;

        public Source(int n) {
            this.v = n;
        }

        @Override
        public int[][] toPaths(int n) {
            return new int[][]{this.toPath(n)};
        }

        @Override
        public int[] toPath(int n) {
            int[] nArray = new int[n];
            nArray[0] = this.v;
            return nArray;
        }
    }

    private static interface Route {
        public int[][] toPaths(int var1);

        public int[] toPath(int var1);
    }
}

