# TorchSenti

Sentiment Analysis Library for Research with PyTorch

TorchSenti provides sentiment analysis datasets from a simple one (positive/negative labels) to fine-grained one (aspect-based). TorchSenti is compatible with PyTorch to develop model and use pre-trained model to benchmark your work with other researchers.

#### Features
    - Text Cleansing e.g removing hyperlinks
    - WordPiece Tokenization with tagging for aspect extraction
    - Entity metrics for aspect detection

#### Dataset Available
    - **Sentiment Analysis**
        - IMDB Movie Reviews
        - Pros and Cons
        - Movie Review
        - Trip Advisor
        - City Search Data
        - Yelp Review
    - **Aspect-based Sentiment Analysis**
        - SemEval 2014 Task 4 (ToDo)
        - SemEval 2015 Task 12 (ToDo)
        - SemEval 2016 Task 5 (ToDo)

## Installation
You can install TorchSenti using pip

```
    pip install torchsenti
```

from source

```
    git clone https://github.com/jakartaresearch/pytorch-sentiment.git
    cd pytorch-sentiment
    python setup.py install
```

## Getting Started


## Contributors

