/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadWritableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MutableDateTime
extends BaseDateTime
implements ReadWritableDateTime,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2852608688135209575L;
    public static final int ROUND_NONE = 0;
    public static final int ROUND_FLOOR = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_HALF_FLOOR = 3;
    public static final int ROUND_HALF_CEILING = 4;
    public static final int ROUND_HALF_EVEN = 5;
    private DateTimeField iRoundingField;
    private int iRoundingMode;

    public static MutableDateTime now() {
        return new MutableDateTime();
    }

    public static MutableDateTime now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new MutableDateTime(dateTimeZone);
    }

    public static MutableDateTime now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new MutableDateTime(chronology);
    }

    @FromString
    public static MutableDateTime parse(String string) {
        return MutableDateTime.parse(string, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static MutableDateTime parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string).toMutableDateTime();
    }

    public MutableDateTime() {
    }

    public MutableDateTime(DateTimeZone dateTimeZone) {
        super(dateTimeZone);
    }

    public MutableDateTime(Chronology chronology) {
        super(chronology);
    }

    public MutableDateTime(long l2) {
        super(l2);
    }

    public MutableDateTime(long l2, DateTimeZone dateTimeZone) {
        super(l2, dateTimeZone);
    }

    public MutableDateTime(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public MutableDateTime(Object object) {
        super(object, (Chronology)null);
    }

    public MutableDateTime(Object object, DateTimeZone dateTimeZone) {
        super(object, dateTimeZone);
    }

    public MutableDateTime(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology));
    }

    public MutableDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n2, n3, n4, n5, n6, n7, n8);
    }

    public MutableDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, n5, n6, n7, n8, dateTimeZone);
    }

    public MutableDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Chronology chronology) {
        super(n2, n3, n4, n5, n6, n7, n8, chronology);
    }

    public DateTimeField getRoundingField() {
        return this.iRoundingField;
    }

    public int getRoundingMode() {
        return this.iRoundingMode;
    }

    public void setRounding(DateTimeField dateTimeField) {
        this.setRounding(dateTimeField, 1);
    }

    public void setRounding(DateTimeField dateTimeField, int n2) {
        if (dateTimeField != null && (n2 < 0 || n2 > 5)) {
            throw new IllegalArgumentException("Illegal rounding mode: " + n2);
        }
        this.iRoundingField = n2 == 0 ? null : dateTimeField;
        this.iRoundingMode = dateTimeField == null ? 0 : n2;
        this.setMillis(this.getMillis());
    }

    public void setMillis(long l2) {
        switch (this.iRoundingMode) {
            case 0: {
                break;
            }
            case 1: {
                l2 = this.iRoundingField.roundFloor(l2);
                break;
            }
            case 2: {
                l2 = this.iRoundingField.roundCeiling(l2);
                break;
            }
            case 3: {
                l2 = this.iRoundingField.roundHalfFloor(l2);
                break;
            }
            case 4: {
                l2 = this.iRoundingField.roundHalfCeiling(l2);
                break;
            }
            case 5: {
                l2 = this.iRoundingField.roundHalfEven(l2);
            }
        }
        super.setMillis(l2);
    }

    public void setMillis(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        this.setMillis(l2);
    }

    public void add(long l2) {
        this.setMillis(FieldUtils.safeAdd(this.getMillis(), l2));
    }

    public void add(ReadableDuration readableDuration) {
        this.add(readableDuration, 1);
    }

    public void add(ReadableDuration readableDuration, int n2) {
        if (readableDuration != null) {
            this.add(FieldUtils.safeMultiply(readableDuration.getMillis(), n2));
        }
    }

    public void add(ReadablePeriod readablePeriod) {
        this.add(readablePeriod, 1);
    }

    public void add(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod != null) {
            this.setMillis(this.getChronology().add(readablePeriod, this.getMillis(), n2));
        }
    }

    public void setChronology(Chronology chronology) {
        super.setChronology(chronology);
    }

    public void setZone(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.getChronology();
        if (chronology.getZone() != dateTimeZone) {
            this.setChronology(chronology.withZone(dateTimeZone));
        }
    }

    public void setZoneRetainFields(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2;
        if ((dateTimeZone = DateTimeUtils.getZone(dateTimeZone)) == (dateTimeZone2 = DateTimeUtils.getZone(this.getZone()))) {
            return;
        }
        long l2 = dateTimeZone2.getMillisKeepLocal(dateTimeZone, this.getMillis());
        this.setChronology(this.getChronology().withZone(dateTimeZone));
        this.setMillis(l2);
    }

    public void set(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        this.setMillis(dateTimeFieldType.getField(this.getChronology()).set(this.getMillis(), n2));
    }

    public void add(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 != 0) {
            this.setMillis(durationFieldType.getField(this.getChronology()).add(this.getMillis(), n2));
        }
    }

    public void setYear(int n2) {
        this.setMillis(this.getChronology().year().set(this.getMillis(), n2));
    }

    public void addYears(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().years().add(this.getMillis(), n2));
        }
    }

    public void setWeekyear(int n2) {
        this.setMillis(this.getChronology().weekyear().set(this.getMillis(), n2));
    }

    public void addWeekyears(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().weekyears().add(this.getMillis(), n2));
        }
    }

    public void setMonthOfYear(int n2) {
        this.setMillis(this.getChronology().monthOfYear().set(this.getMillis(), n2));
    }

    public void addMonths(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().months().add(this.getMillis(), n2));
        }
    }

    public void setWeekOfWeekyear(int n2) {
        this.setMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), n2));
    }

    public void addWeeks(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().weeks().add(this.getMillis(), n2));
        }
    }

    public void setDayOfYear(int n2) {
        this.setMillis(this.getChronology().dayOfYear().set(this.getMillis(), n2));
    }

    public void setDayOfMonth(int n2) {
        this.setMillis(this.getChronology().dayOfMonth().set(this.getMillis(), n2));
    }

    public void setDayOfWeek(int n2) {
        this.setMillis(this.getChronology().dayOfWeek().set(this.getMillis(), n2));
    }

    public void addDays(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().days().add(this.getMillis(), n2));
        }
    }

    public void setHourOfDay(int n2) {
        this.setMillis(this.getChronology().hourOfDay().set(this.getMillis(), n2));
    }

    public void addHours(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().hours().add(this.getMillis(), n2));
        }
    }

    public void setMinuteOfDay(int n2) {
        this.setMillis(this.getChronology().minuteOfDay().set(this.getMillis(), n2));
    }

    public void setMinuteOfHour(int n2) {
        this.setMillis(this.getChronology().minuteOfHour().set(this.getMillis(), n2));
    }

    public void addMinutes(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().minutes().add(this.getMillis(), n2));
        }
    }

    public void setSecondOfDay(int n2) {
        this.setMillis(this.getChronology().secondOfDay().set(this.getMillis(), n2));
    }

    public void setSecondOfMinute(int n2) {
        this.setMillis(this.getChronology().secondOfMinute().set(this.getMillis(), n2));
    }

    public void addSeconds(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().seconds().add(this.getMillis(), n2));
        }
    }

    public void setMillisOfDay(int n2) {
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), n2));
    }

    public void setMillisOfSecond(int n2) {
        this.setMillis(this.getChronology().millisOfSecond().set(this.getMillis(), n2));
    }

    public void addMillis(int n2) {
        if (n2 != 0) {
            this.setMillis(this.getChronology().millis().add(this.getMillis(), n2));
        }
    }

    public void setDate(long l2) {
        this.setMillis(this.getChronology().millisOfDay().set(l2, this.getMillisOfDay()));
    }

    public void setDate(ReadableInstant readableInstant) {
        ReadableDateTime readableDateTime;
        Chronology chronology;
        DateTimeZone dateTimeZone;
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        if (readableInstant instanceof ReadableDateTime && (dateTimeZone = (chronology = DateTimeUtils.getChronology((readableDateTime = (ReadableDateTime)readableInstant).getChronology())).getZone()) != null) {
            l2 = dateTimeZone.getMillisKeepLocal(this.getZone(), l2);
        }
        this.setDate(l2);
    }

    public void setDate(int n2, int n3, int n4) {
        Chronology chronology = this.getChronology();
        long l2 = chronology.getDateTimeMillis(n2, n3, n4, 0);
        this.setDate(l2);
    }

    public void setTime(long l2) {
        int n2 = ISOChronology.getInstanceUTC().millisOfDay().get(l2);
        this.setMillis(this.getChronology().millisOfDay().set(this.getMillis(), n2));
    }

    public void setTime(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        DateTimeZone dateTimeZone = chronology.getZone();
        if (dateTimeZone != null) {
            l2 = dateTimeZone.getMillisKeepLocal(DateTimeZone.UTC, l2);
        }
        this.setTime(l2);
    }

    public void setTime(int n2, int n3, int n4, int n5) {
        long l2 = this.getChronology().getDateTimeMillis(this.getMillis(), n2, n3, n4, n5);
        this.setMillis(l2);
    }

    public void setDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        long l2 = this.getChronology().getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
        this.setMillis(l2);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public MutableDateTime copy() {
        return (MutableDateTime)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -4481126543819298617L;
        private MutableDateTime iInstant;
        private DateTimeField iField;

        Property(MutableDateTime mutableDateTime, DateTimeField dateTimeField) {
            this.iInstant = mutableDateTime;
            this.iField = dateTimeField;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (MutableDateTime)objectInputStream.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)objectInputStream.readObject();
            this.iField = dateTimeFieldType.getField(this.iInstant.getChronology());
        }

        public DateTimeField getField() {
            return this.iField;
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public MutableDateTime getMutableDateTime() {
            return this.iInstant;
        }

        public MutableDateTime add(int n2) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), n2));
            return this.iInstant;
        }

        public MutableDateTime add(long l2) {
            this.iInstant.setMillis(this.getField().add(this.iInstant.getMillis(), l2));
            return this.iInstant;
        }

        public MutableDateTime addWrapField(int n2) {
            this.iInstant.setMillis(this.getField().addWrapField(this.iInstant.getMillis(), n2));
            return this.iInstant;
        }

        public MutableDateTime set(int n2) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), n2));
            return this.iInstant;
        }

        public MutableDateTime set(String string, Locale locale) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), string, locale));
            return this.iInstant;
        }

        public MutableDateTime set(String string) {
            this.set(string, null);
            return this.iInstant;
        }

        public MutableDateTime roundFloor() {
            this.iInstant.setMillis(this.getField().roundFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundCeiling() {
            this.iInstant.setMillis(this.getField().roundCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfFloor() {
            this.iInstant.setMillis(this.getField().roundHalfFloor(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfCeiling() {
            this.iInstant.setMillis(this.getField().roundHalfCeiling(this.iInstant.getMillis()));
            return this.iInstant;
        }

        public MutableDateTime roundHalfEven() {
            this.iInstant.setMillis(this.getField().roundHalfEven(this.iInstant.getMillis()));
            return this.iInstant;
        }
    }
}

