"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestApiOrigin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * An Origin for an API Gateway REST API.
 */
class RestApiOrigin extends cloudfront.OriginBase {
    constructor(restApi, props = {}) {
        // urlForPath() is of the form 'https://<rest-api-id>.execute-api.<region>.amazonaws.com/<stage>'
        // Splitting on '/' gives: ['https', '', '<rest-api-id>.execute-api.<region>.amazonaws.com', '<stage>']
        // The element at index 2 is the domain name, the element at index 3 is the stage name
        super(cdk.Fn.select(2, cdk.Fn.split('/', restApi.url)), {
            originPath: `/${cdk.Fn.select(3, cdk.Fn.split('/', restApi.url))}`,
            ...props,
        });
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_RestApiOriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RestApiOrigin);
            }
            throw error;
        }
        utils_1.validateSecondsInRangeOrUndefined('readTimeout', 1, 180, props.readTimeout);
        utils_1.validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 180, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        return {
            originSslProtocols: [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            originReadTimeout: this.props.readTimeout?.toSeconds(),
            originKeepaliveTimeout: this.props.keepaliveTimeout?.toSeconds(),
        };
    }
}
exports.RestApiOrigin = RestApiOrigin;
_a = JSII_RTTI_SYMBOL_1;
RestApiOrigin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.RestApiOrigin", version: "1.183.0" };
//# sourceMappingURL=data:application/json;base64,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