"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const utils_1 = require("./private/utils");
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 */
class HttpOrigin extends cloudfront.OriginBase {
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_HttpOriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpOrigin);
            }
            throw error;
        }
        utils_1.validateSecondsInRangeOrUndefined('readTimeout', 1, 180, props.readTimeout);
        utils_1.validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 180, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        return {
            originSslProtocols: this.props.originSslProtocols ?? [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: this.props.protocolPolicy ?? cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: this.props.readTimeout?.toSeconds(),
            originKeepaliveTimeout: this.props.keepaliveTimeout?.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
_a = JSII_RTTI_SYMBOL_1;
HttpOrigin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.HttpOrigin", version: "1.183.0" };
//# sourceMappingURL=data:application/json;base64,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