"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlSync = exports.readJsonSync = void 0;
const fs = require("fs");
const yaml = require("yaml");
function readJsonSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return JSON.parse(fileContents.toString());
}
exports.readJsonSync = readJsonSync;
function readYamlSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return parseYamlStrWithCfnTags(fileContents.toString());
}
exports.readYamlSync = readYamlSync;
function makeTagForCfnIntrinsic(intrinsicName, addFnPrefix = true, resolveFun) {
    return {
        identify(value) { return typeof value === 'string'; },
        tag: `!${intrinsicName}`,
        resolve: resolveFun || ((_doc, cstNode) => {
            const ret = {};
            ret[addFnPrefix ? `Fn::${intrinsicName}` : intrinsicName] =
                // the +1 is to account for the ! the short form begins with
                parseYamlStrWithCfnTags(cstNode.toString().substring(intrinsicName.length + 1));
            return ret;
        }),
    };
}
const shortForms = [
    'Base64', 'Cidr', 'FindInMap', 'GetAZs', 'ImportValue', 'Join', 'Sub',
    'Select', 'Split', 'Transform', 'And', 'Equals', 'If', 'Not', 'Or',
].map(name => makeTagForCfnIntrinsic(name)).concat(makeTagForCfnIntrinsic('Ref', false), makeTagForCfnIntrinsic('GetAtt', true, (_doc, cstNode) => {
    // The position of the leftmost period and opening bracket tell us what syntax is being used
    // If no brackets are found, then the dot notation is being used; the leftmost dot separates the
    // logical ID from the attribute.
    //
    // If a bracket is found, then the list notation is being used; if present, the leftmost dot separates the
    // logical ID from the attribute.
    const firstDot = cstNode.toString().indexOf('.');
    const firstBracket = cstNode.toString().indexOf('[');
    return {
        'Fn::GetAtt': firstDot !== -1 && firstBracket === -1
            ? [
                cstNode.toString().substring('!GetAtt '.length, firstDot),
                parseYamlStrWithCfnTags((cstNode.toString().substring(firstDot + 1))),
            ]
            : parseYamlStrWithCfnTags(cstNode.toString().substring('!GetAtt'.length)),
    };
}));
function parseYamlStrWithCfnTags(text) {
    return yaml.parse(text, {
        customTags: shortForms,
        schema: 'yaml-1.1',
    });
}
//# sourceMappingURL=data:application/json;base64,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