"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceBase = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class InstanceBase extends core_1.Resource {
    /**
     * Generate a unique instance Id that is safe to pass to CloudMap
     */
    uniqueInstanceId() {
        // Max length of 64 chars, get the last 64 chars
        const id = this.node.uniqueId;
        return id.substring(Math.max(id.length - 64, 0), id.length);
    }
}
exports.InstanceBase = InstanceBase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBaUQsQ0FBQyxnREFBZ0Q7QUFpQ2xHLE1BQXNCLFlBQWEsU0FBUSxlQUFRO0lBUy9DOztPQUVHO0lBQ08sZ0JBQWdCO1FBQ3RCLGdEQUFnRDtRQUNoRCxNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUM5QixPQUFPLEVBQUUsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDaEUsQ0FBQztDQUNKO0FBakJELG9DQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElSZXNvdXJjZSwgUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IElTZXJ2aWNlIH0gZnJvbSAnLi9zZXJ2aWNlJztcbmV4cG9ydCBpbnRlcmZhY2UgSUluc3RhbmNlIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgaWQgb2YgdGhlIGluc3RhbmNlIHJlc291cmNlXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlSWQ6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRtYXAgc2VydmljZSB0aGlzIHJlc291cmNlIGlzIHJlZ2lzdGVyZWQgdG8uXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZTogSVNlcnZpY2U7XG59XG4vKipcbiAqIFVzZWQgd2hlbiB0aGUgcmVzb3VyY2UgdGhhdCdzIGFzc29jaWF0ZWQgd2l0aCB0aGUgc2VydmljZSBpbnN0YW5jZSBpcyBhY2Nlc3NpYmxlIHVzaW5nIHZhbHVlcyBvdGhlciB0aGFuIGFuIElQXG4gKiBhZGRyZXNzIG9yIGEgZG9tYWluIG5hbWUgKENOQU1FKSwgaS5lLiBmb3Igbm9uLWlwLWluc3RhbmNlc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VJbnN0YW5jZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgaWQgb2YgdGhlIGluc3RhbmNlIHJlc291cmNlXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBBdXRvbWF0aWNhbGx5IGdlbmVyYXRlZCBuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VJZD86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBDdXN0b20gYXR0cmlidXRlcyBvZiB0aGUgaW5zdGFuY2UuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBub25lXG4gICAgICovXG4gICAgcmVhZG9ubHkgY3VzdG9tQXR0cmlidXRlcz86IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogc3RyaW5nO1xuICAgIH07XG59XG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSW5zdGFuY2VCYXNlIGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJSW5zdGFuY2Uge1xuICAgIC8qKlxuICAgICAqIFRoZSBJZCBvZiB0aGUgaW5zdGFuY2VcbiAgICAgKi9cbiAgICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgaW5zdGFuY2VJZDogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZG1hcCBzZXJ2aWNlIHRvIHdoaWNoIHRoZSBpbnN0YW5jZSBpcyByZWdpc3RlcmVkLlxuICAgICAqL1xuICAgIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBzZXJ2aWNlOiBJU2VydmljZTtcbiAgICAvKipcbiAgICAgKiBHZW5lcmF0ZSBhIHVuaXF1ZSBpbnN0YW5jZSBJZCB0aGF0IGlzIHNhZmUgdG8gcGFzcyB0byBDbG91ZE1hcFxuICAgICAqL1xuICAgIHByb3RlY3RlZCB1bmlxdWVJbnN0YW5jZUlkKCkge1xuICAgICAgICAvLyBNYXggbGVuZ3RoIG9mIDY0IGNoYXJzLCBnZXQgdGhlIGxhc3QgNjQgY2hhcnNcbiAgICAgICAgY29uc3QgaWQgPSB0aGlzLm5vZGUudW5pcXVlSWQ7XG4gICAgICAgIHJldHVybiBpZC5zdWJzdHJpbmcoTWF0aC5tYXgoaWQubGVuZ3RoIC0gNjQsIDApLCBpZC5sZW5ndGgpO1xuICAgIH1cbn1cbiJdfQ==