"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined
     */
    static getHostedZoneId(scope) {
        var _a;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_a = scopeStack.node.tryFindChild(mappingName)) !== null && _a !== void 0 ? _a : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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