import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::MediaLive::Channel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export interface CfnChannelProps {
    /**
     * `AWS::MediaLive::Channel.ChannelClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     */
    readonly channelClass?: string;
    /**
     * `AWS::MediaLive::Channel.Destinations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     */
    readonly destinations?: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     */
    readonly encoderSettings?: any | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     */
    readonly inputAttachments?: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     */
    readonly inputSpecification?: CfnChannel.InputSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.LogLevel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     */
    readonly logLevel?: string;
    /**
     * `AWS::MediaLive::Channel.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Channel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Channel.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`
 *
 * @cloudformationResource AWS::MediaLive::Channel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Channel";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Inputs
     */
    readonly attrInputs: string[];
    /**
     * `AWS::MediaLive::Channel.ChannelClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     */
    channelClass: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Destinations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     */
    destinations: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     */
    encoderSettings: any | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     */
    inputAttachments: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     */
    inputSpecification: CfnChannel.InputSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.LogLevel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     */
    logLevel: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Channel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaLive::Channel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html
     */
    interface AribSourceSettingsProperty {
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html
     */
    interface AudioLanguageSelectionProperty {
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageSelectionPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy
         */
        readonly languageSelectionPolicy?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html
     */
    interface AudioPidSelectionProperty {
        /**
         * `CfnChannel.AudioPidSelectionProperty.Pid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid
         */
        readonly pid?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html
     */
    interface AudioSelectorProperty {
        /**
         * `CfnChannel.AudioSelectorProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.AudioSelectorProperty.SelectorSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.AudioSelectorSettingsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html
     */
    interface AudioSelectorSettingsProperty {
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioLanguageSelection`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection
         */
        readonly audioLanguageSelection?: CfnChannel.AudioLanguageSelectionProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioPidSelection`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection
         */
        readonly audioPidSelection?: CfnChannel.AudioPidSelectionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html
     */
    interface CaptionSelectorProperty {
        /**
         * `CfnChannel.CaptionSelectorProperty.LanguageCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name
         */
        readonly name?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.SelectorSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.CaptionSelectorSettingsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html
     */
    interface CaptionSelectorSettingsProperty {
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.AribSourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings
         */
        readonly aribSourceSettings?: CfnChannel.AribSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.DvbSubSourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings
         */
        readonly dvbSubSourceSettings?: CfnChannel.DvbSubSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.EmbeddedSourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings
         */
        readonly embeddedSourceSettings?: CfnChannel.EmbeddedSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte20SourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings
         */
        readonly scte20SourceSettings?: CfnChannel.Scte20SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte27SourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings
         */
        readonly scte27SourceSettings?: CfnChannel.Scte27SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.TeletextSourceSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings
         */
        readonly teletextSourceSettings?: CfnChannel.TeletextSourceSettingsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html
     */
    interface DvbSubSourceSettingsProperty {
        /**
         * `CfnChannel.DvbSubSourceSettingsProperty.Pid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid
         */
        readonly pid?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html
     */
    interface EmbeddedSourceSettingsProperty {
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Convert608To708`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-convert608to708
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Scte20Detection`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-scte20detection
         */
        readonly scte20Detection?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608ChannelNumber`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608channelnumber
         */
        readonly source608ChannelNumber?: number;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608TrackNumber`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608tracknumber
         */
        readonly source608TrackNumber?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html
     */
    interface HlsInputSettingsProperty {
        /**
         * `CfnChannel.HlsInputSettingsProperty.Bandwidth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-bandwidth
         */
        readonly bandwidth?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.BufferSegments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-buffersegments
         */
        readonly bufferSegments?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.Retries`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retries
         */
        readonly retries?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.RetryInterval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retryinterval
         */
        readonly retryInterval?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html
     */
    interface InputAttachmentProperty {
        /**
         * `CfnChannel.InputAttachmentProperty.InputAttachmentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputattachmentname
         */
        readonly inputAttachmentName?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputid
         */
        readonly inputId?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputsettings
         */
        readonly inputSettings?: CfnChannel.InputSettingsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html
     */
    interface InputSettingsProperty {
        /**
         * `CfnChannel.InputSettingsProperty.AudioSelectors`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-audioselectors
         */
        readonly audioSelectors?: Array<CfnChannel.AudioSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.CaptionSelectors`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-captionselectors
         */
        readonly captionSelectors?: Array<CfnChannel.CaptionSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.DeblockFilter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-deblockfilter
         */
        readonly deblockFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.DenoiseFilter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-denoisefilter
         */
        readonly denoiseFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.FilterStrength`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-filterstrength
         */
        readonly filterStrength?: number;
        /**
         * `CfnChannel.InputSettingsProperty.InputFilter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-inputfilter
         */
        readonly inputFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.NetworkInputSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-networkinputsettings
         */
        readonly networkInputSettings?: CfnChannel.NetworkInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.SourceEndBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-sourceendbehavior
         */
        readonly sourceEndBehavior?: string;
        /**
         * `CfnChannel.InputSettingsProperty.VideoSelector`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-videoselector
         */
        readonly videoSelector?: CfnChannel.VideoSelectorProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html
     */
    interface InputSpecificationProperty {
        /**
         * `CfnChannel.InputSpecificationProperty.Codec`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-codec
         */
        readonly codec?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.MaximumBitrate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-maximumbitrate
         */
        readonly maximumBitrate?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.Resolution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-resolution
         */
        readonly resolution?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html
     */
    interface MediaPackageOutputDestinationSettingsProperty {
        /**
         * `CfnChannel.MediaPackageOutputDestinationSettingsProperty.ChannelId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html#cfn-medialive-channel-mediapackageoutputdestinationsettings-channelid
         */
        readonly channelId?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html
     */
    interface MultiplexProgramChannelDestinationSettingsProperty {
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.MultiplexId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-multiplexid
         */
        readonly multiplexId?: string;
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.ProgramName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-programname
         */
        readonly programName?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html
     */
    interface NetworkInputSettingsProperty {
        /**
         * `CfnChannel.NetworkInputSettingsProperty.HlsInputSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-hlsinputsettings
         */
        readonly hlsInputSettings?: CfnChannel.HlsInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.NetworkInputSettingsProperty.ServerValidation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-servervalidation
         */
        readonly serverValidation?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html
     */
    interface OutputDestinationProperty {
        /**
         * `CfnChannel.OutputDestinationProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-id
         */
        readonly id?: string;
        /**
         * `CfnChannel.OutputDestinationProperty.MediaPackageSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-mediapackagesettings
         */
        readonly mediaPackageSettings?: Array<CfnChannel.MediaPackageOutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.MultiplexSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-multiplexsettings
         */
        readonly multiplexSettings?: CfnChannel.MultiplexProgramChannelDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.Settings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-settings
         */
        readonly settings?: Array<CfnChannel.OutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html
     */
    interface OutputDestinationSettingsProperty {
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.PasswordParam`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-passwordparam
         */
        readonly passwordParam?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.StreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-streamname
         */
        readonly streamName?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-url
         */
        readonly url?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html
     */
    interface Scte20SourceSettingsProperty {
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Convert608To708`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-convert608to708
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Source608ChannelNumber`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-source608channelnumber
         */
        readonly source608ChannelNumber?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html
     */
    interface Scte27SourceSettingsProperty {
        /**
         * `CfnChannel.Scte27SourceSettingsProperty.Pid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html#cfn-medialive-channel-scte27sourcesettings-pid
         */
        readonly pid?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html
     */
    interface TeletextSourceSettingsProperty {
        /**
         * `CfnChannel.TeletextSourceSettingsProperty.PageNumber`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html#cfn-medialive-channel-teletextsourcesettings-pagenumber
         */
        readonly pageNumber?: string;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html
     */
    interface VideoSelectorProperty {
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspace
         */
        readonly colorSpace?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpaceUsage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspaceusage
         */
        readonly colorSpaceUsage?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.SelectorSettings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-selectorsettings
         */
        readonly selectorSettings?: CfnChannel.VideoSelectorSettingsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html
     */
    interface VideoSelectorPidProperty {
        /**
         * `CfnChannel.VideoSelectorPidProperty.Pid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html#cfn-medialive-channel-videoselectorpid-pid
         */
        readonly pid?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html
     */
    interface VideoSelectorProgramIdProperty {
        /**
         * `CfnChannel.VideoSelectorProgramIdProperty.ProgramId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html#cfn-medialive-channel-videoselectorprogramid-programid
         */
        readonly programId?: number;
    }
}
export declare namespace CfnChannel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html
     */
    interface VideoSelectorSettingsProperty {
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorPid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorpid
         */
        readonly videoSelectorPid?: CfnChannel.VideoSelectorPidProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorProgramId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorprogramid
         */
        readonly videoSelectorProgramId?: CfnChannel.VideoSelectorProgramIdProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::MediaLive::Input`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export interface CfnInputProps {
    /**
     * `AWS::MediaLive::Input.Destinations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     */
    readonly destinations?: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     */
    readonly inputSecurityGroups?: string[];
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     */
    readonly mediaConnectFlows?: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Input.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Input.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     */
    readonly sources?: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::Input.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     */
    readonly type?: string;
    /**
     * `AWS::MediaLive::Input.Vpc`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     */
    readonly vpc?: CfnInput.InputVpcRequestProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::Input`
 *
 * @cloudformationResource AWS::MediaLive::Input
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Input";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Destinations
     */
    readonly attrDestinations: string[];
    /**
     * @cloudformationAttribute Sources
     */
    readonly attrSources: string[];
    /**
     * `AWS::MediaLive::Input.Destinations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     */
    destinations: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     */
    inputSecurityGroups: string[] | undefined;
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     */
    mediaConnectFlows: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Input.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Input.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     */
    sources: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::Input.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     */
    type: string | undefined;
    /**
     * `AWS::MediaLive::Input.Vpc`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     */
    vpc: CfnInput.InputVpcRequestProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::Input`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html
     */
    interface InputDestinationRequestProperty {
        /**
         * `CfnInput.InputDestinationRequestProperty.StreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html#cfn-medialive-input-inputdestinationrequest-streamname
         */
        readonly streamName?: string;
    }
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html
     */
    interface InputSourceRequestProperty {
        /**
         * `CfnInput.InputSourceRequestProperty.PasswordParam`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-passwordparam
         */
        readonly passwordParam?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-url
         */
        readonly url?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html
     */
    interface InputVpcRequestProperty {
        /**
         * `CfnInput.InputVpcRequestProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnInput.InputVpcRequestProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-subnetids
         */
        readonly subnetIds?: string[];
    }
}
export declare namespace CfnInput {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html
     */
    interface MediaConnectFlowRequestProperty {
        /**
         * `CfnInput.MediaConnectFlowRequestProperty.FlowArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html#cfn-medialive-input-mediaconnectflowrequest-flowarn
         */
        readonly flowArn?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaLive::InputSecurityGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
export interface CfnInputSecurityGroupProps {
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     */
    readonly whitelistRules?: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`
 *
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
export declare class CfnInputSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::InputSecurityGroup";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     */
    whitelistRules: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::InputSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputSecurityGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnInputSecurityGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html
     */
    interface InputWhitelistRuleCidrProperty {
        /**
         * `CfnInputSecurityGroup.InputWhitelistRuleCidrProperty.Cidr`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html#cfn-medialive-inputsecuritygroup-inputwhitelistrulecidr-cidr
         */
        readonly cidr?: string;
    }
}
