"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
    }
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
//# sourceMappingURL=data:application/json;base64,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