"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._attachKubectlResourceScope(this);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
            },
        });
    }
}
exports.KubernetesManifest = KubernetesManifest;
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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