"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Type = void 0;
/**
 * Enum containing the Types that can be used to define ObjectTypes
 */
var Type;
(function (Type) {
    /**
     * `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     */
    Type["ID"] = "ID";
    /**
     * `String` scalar type is a free-form human-readable text.
     */
    Type["STRING"] = "String";
    /**
     * `Int` scalar type is a signed non-fractional numerical value.
     */
    Type["INT"] = "Int";
    /**
     * `Float` scalar type is a signed double-precision fractional value.
     */
    Type["FLOAT"] = "Float";
    /**
     * `Boolean` scalar type is a boolean value: true or false.
     */
    Type["BOOLEAN"] = "Boolean";
    /**
     * `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Calendar_dates
     */
    Type["AWS_DATE"] = "AWSDate";
    /**
     * `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     */
    Type["AWS_TIME"] = "AWSTime";
    /**
     * `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Combined_date_and_time_representations
     */
    Type["AWS_DATE_TIME"] = "AWSDateTime";
    /**
     * `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     */
    Type["AWS_TIMESTAMP"] = "AWSTimestamp";
    /**
     * `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`)
     */
    Type["AWS_EMAIL"] = "AWSEmail";
    /**
     * `AWSJson` scalar type represents a JSON string.
     */
    Type["AWS_JSON"] = "AWSJSON";
    /**
     * `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     */
    Type["AWS_URL"] = "AWSURL";
    /**
     * `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     */
    Type["AWS_PHONE"] = "AWSPhone";
    /**
     * `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     */
    Type["AWS_IP_ADDRESS"] = "AWSIPAddress";
    /**
     * Type used for Intermediate Types
     * (i.e. an interface or an object type)
     */
    Type["INTERMEDIATE"] = "INTERMEDIATE";
})(Type = exports.Type || (exports.Type = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZW1hLWJhc2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzY2hlbWEtYmFzZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7R0FFRztBQUNILElBQVksSUFrRlg7QUFsRkQsV0FBWSxJQUFJO0lBQ1o7Ozs7T0FJRztJQUNILGlCQUFTLENBQUE7SUFDVDs7T0FFRztJQUNILHlCQUFpQixDQUFBO0lBQ2pCOztPQUVHO0lBQ0gsbUJBQVcsQ0FBQTtJQUNYOztPQUVHO0lBQ0gsdUJBQWUsQ0FBQTtJQUNmOztPQUVHO0lBQ0gsMkJBQW1CLENBQUE7SUFDbkI7Ozs7OztPQU1HO0lBQ0gsNEJBQW9CLENBQUE7SUFDcEI7Ozs7OztPQU1HO0lBQ0gsNEJBQW9CLENBQUE7SUFDcEI7Ozs7OztPQU1HO0lBQ0gscUNBQTZCLENBQUE7SUFDN0I7Ozs7T0FJRztJQUNILHNDQUE4QixDQUFBO0lBQzlCOztPQUVHO0lBQ0gsOEJBQXNCLENBQUE7SUFDdEI7O09BRUc7SUFDSCw0QkFBb0IsQ0FBQTtJQUNwQjs7OztPQUlHO0lBQ0gsMEJBQWtCLENBQUE7SUFDbEI7Ozs7T0FJRztJQUNILDhCQUFzQixDQUFBO0lBQ3RCOztPQUVHO0lBQ0gsdUNBQStCLENBQUE7SUFDL0I7OztPQUdHO0lBQ0gscUNBQTZCLENBQUE7QUFDakMsQ0FBQyxFQWxGVyxJQUFJLEdBQUosWUFBSSxLQUFKLFlBQUksUUFrRmYiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEVudW0gY29udGFpbmluZyB0aGUgVHlwZXMgdGhhdCBjYW4gYmUgdXNlZCB0byBkZWZpbmUgT2JqZWN0VHlwZXNcbiAqL1xuZXhwb3J0IGVudW0gVHlwZSB7XG4gICAgLyoqXG4gICAgICogYElEYCBzY2FsYXIgdHlwZSBpcyBhIHVuaXF1ZSBpZGVudGlmaWVyLiBgSURgIHR5cGUgaXMgc2VyaWFsaXplZCBzaW1pbGFyIHRvIGBTdHJpbmdgLlxuICAgICAqXG4gICAgICogT2Z0ZW4gdXNlZCBhcyBhIGtleSBmb3IgYSBjYWNoZSBhbmQgbm90IGludGVuZGVkIHRvIGJlIGh1bWFuLXJlYWRhYmxlLlxuICAgICAqL1xuICAgIElEID0gJ0lEJyxcbiAgICAvKipcbiAgICAgKiBgU3RyaW5nYCBzY2FsYXIgdHlwZSBpcyBhIGZyZWUtZm9ybSBodW1hbi1yZWFkYWJsZSB0ZXh0LlxuICAgICAqL1xuICAgIFNUUklORyA9ICdTdHJpbmcnLFxuICAgIC8qKlxuICAgICAqIGBJbnRgIHNjYWxhciB0eXBlIGlzIGEgc2lnbmVkIG5vbi1mcmFjdGlvbmFsIG51bWVyaWNhbCB2YWx1ZS5cbiAgICAgKi9cbiAgICBJTlQgPSAnSW50JyxcbiAgICAvKipcbiAgICAgKiBgRmxvYXRgIHNjYWxhciB0eXBlIGlzIGEgc2lnbmVkIGRvdWJsZS1wcmVjaXNpb24gZnJhY3Rpb25hbCB2YWx1ZS5cbiAgICAgKi9cbiAgICBGTE9BVCA9ICdGbG9hdCcsXG4gICAgLyoqXG4gICAgICogYEJvb2xlYW5gIHNjYWxhciB0eXBlIGlzIGEgYm9vbGVhbiB2YWx1ZTogdHJ1ZSBvciBmYWxzZS5cbiAgICAgKi9cbiAgICBCT09MRUFOID0gJ0Jvb2xlYW4nLFxuICAgIC8qKlxuICAgICAqIGBBV1NEYXRlYCBzY2FsYXIgdHlwZSByZXByZXNlbnRzIGEgdmFsaWQgZXh0ZW5kZWQgYElTTyA4NjAxIERhdGVgIHN0cmluZy5cbiAgICAgKlxuICAgICAqIEluIG90aGVyIHdvcmRzLCBhY2NlcHRzIGRhdGUgc3RyaW5ncyBpbiB0aGUgZm9ybSBvZiBgWVlZWS1NTS1ERGAuIEl0IGFjY2VwdHMgdGltZSB6b25lIG9mZnNldHMuXG4gICAgICpcbiAgICAgKiBAc2VlIGh0dHBzOi8vZW4ud2lraXBlZGlhLm9yZy93aWtpL0lTT184NjAxI0NhbGVuZGFyX2RhdGVzXG4gICAgICovXG4gICAgQVdTX0RBVEUgPSAnQVdTRGF0ZScsXG4gICAgLyoqXG4gICAgICogYEFXU1RpbWVgIHNjYWxhciB0eXBlIHJlcHJlc2VudHMgYSB2YWxpZCBleHRlbmRlZCBgSVNPIDg2MDEgVGltZWAgc3RyaW5nLlxuICAgICAqXG4gICAgICogSW4gb3RoZXIgd29yZHMsIGFjY2VwdHMgZGF0ZSBzdHJpbmdzIGluIHRoZSBmb3JtIG9mIGBoaDptbTpzcy5zc3NgLiBJdCBhY2NlcHRzIHRpbWUgem9uZSBvZmZzZXRzLlxuICAgICAqXG4gICAgICogQHNlZSBodHRwczovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9JU09fODYwMSNUaW1lc1xuICAgICAqL1xuICAgIEFXU19USU1FID0gJ0FXU1RpbWUnLFxuICAgIC8qKlxuICAgICAqIGBBV1NEYXRlVGltZWAgc2NhbGFyIHR5cGUgcmVwcmVzZW50cyBhIHZhbGlkIGV4dGVuZGVkIGBJU08gODYwMSBEYXRlVGltZWAgc3RyaW5nLlxuICAgICAqXG4gICAgICogSW4gb3RoZXIgd29yZHMsIGFjY2VwdHMgZGF0ZSBzdHJpbmdzIGluIHRoZSBmb3JtIG9mIGBZWVlZLU1NLUREVGhoOm1tOnNzLnNzc1pgLiBJdCBhY2NlcHRzIHRpbWUgem9uZSBvZmZzZXRzLlxuICAgICAqXG4gICAgICogQHNlZSBodHRwczovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9JU09fODYwMSNDb21iaW5lZF9kYXRlX2FuZF90aW1lX3JlcHJlc2VudGF0aW9uc1xuICAgICAqL1xuICAgIEFXU19EQVRFX1RJTUUgPSAnQVdTRGF0ZVRpbWUnLFxuICAgIC8qKlxuICAgICAqIGBBV1NUaW1lc3RhbXBgIHNjYWxhciB0eXBlIHJlcHJlc2VudHMgdGhlIG51bWJlciBvZiBzZWNvbmRzIHNpbmNlIGAxOTcwLTAxLTAxVDAwOjAwWmAuXG4gICAgICpcbiAgICAgKiBUaW1lc3RhbXBzIGFyZSBzZXJpYWxpemVkIGFuZCBkZXNlcmlhbGl6ZWQgYXMgbnVtYmVycy5cbiAgICAgKi9cbiAgICBBV1NfVElNRVNUQU1QID0gJ0FXU1RpbWVzdGFtcCcsXG4gICAgLyoqXG4gICAgICogYEFXU0VtYWlsYCBzY2FsYXIgdHlwZSByZXByZXNlbnRzIGFuIGVtYWlsIGFkZHJlc3Mgc3RyaW5nIChpLmUuYHVzZXJuYW1lQGV4YW1wbGUuY29tYClcbiAgICAgKi9cbiAgICBBV1NfRU1BSUwgPSAnQVdTRW1haWwnLFxuICAgIC8qKlxuICAgICAqIGBBV1NKc29uYCBzY2FsYXIgdHlwZSByZXByZXNlbnRzIGEgSlNPTiBzdHJpbmcuXG4gICAgICovXG4gICAgQVdTX0pTT04gPSAnQVdTSlNPTicsXG4gICAgLyoqXG4gICAgICogYEFXU1VSTGAgc2NhbGFyIHR5cGUgcmVwcmVzZXRucyBhIHZhbGlkIFVSTCBzdHJpbmcuXG4gICAgICpcbiAgICAgKiBVUkxzIHdpaHRvdXQgc2NoZW1lcyBvciBjb250YWluIGRvdWJsZSBzbGFzaGVzIGFyZSBjb25zaWRlcmVkIGludmFsaWQuXG4gICAgICovXG4gICAgQVdTX1VSTCA9ICdBV1NVUkwnLFxuICAgIC8qKlxuICAgICAqIGBBV1NQaG9uZWAgc2NhbGFyIHR5cGUgcmVwcmVzZW50cyBhIHZhbGlkIHBob25lIG51bWJlci4gUGhvbmUgbnVtYmVycyBtYXliZSBiZSB3aGl0ZXNwYWNlIGRlbGltaXRlZCBvciBoeXBoZW5hdGVkLlxuICAgICAqXG4gICAgICogVGhlIG51bWJlciBjYW4gc3BlY2lmeSBhIGNvdW50cnkgY29kZSBhdCB0aGUgYmVnaW5uaW5nLCBidXQgaXMgbm90IHJlcXVpcmVkIGZvciBVUyBwaG9uZSBudW1iZXJzLlxuICAgICAqL1xuICAgIEFXU19QSE9ORSA9ICdBV1NQaG9uZScsXG4gICAgLyoqXG4gICAgICogYEFXU0lQQWRkcmVzc2Agc2NhbGFyIHR5cGUgcmVzcHJlc2VudHMgYSB2YWxpZCBgSVB2NGAgb2YgYElQdjZgIGFkZHJlc3Mgc3RyaW5nLlxuICAgICAqL1xuICAgIEFXU19JUF9BRERSRVNTID0gJ0FXU0lQQWRkcmVzcycsXG4gICAgLyoqXG4gICAgICogVHlwZSB1c2VkIGZvciBJbnRlcm1lZGlhdGUgVHlwZXNcbiAgICAgKiAoaS5lLiBhbiBpbnRlcmZhY2Ugb3IgYW4gb2JqZWN0IHR5cGUpXG4gICAgICovXG4gICAgSU5URVJNRURJQVRFID0gJ0lOVEVSTUVESUFURSdcbn1cbiJdfQ==