"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("../../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class LambdaProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(options) {
        var _a, _b;
        const route = options.route;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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