import { Construct, Resource, IResolvable } from "../../core";
import { IApp } from './app';
import { IBranch } from './branch';
/**
 * Options to add a domain to an application
 */
export interface DomainOptions {
    /**
     * The name of the domain
     *
     * @default - the construct's id
     */
    readonly domainName?: string;
    /**
     * Subdomains
     *
     * @default - use `addSubDomain()` to add subdomains
     */
    readonly subDomains?: SubDomain[];
}
/**
 * Properties for a Domain
 */
export interface DomainProps extends DomainOptions {
    /**
     * The application to which the domain must be connected
     */
    readonly app: IApp;
}
/**
 * An Amplify Console domain
 */
export declare class Domain extends Resource {
    /**
     * The ARN of the domain
     *
     * @attribute
     */
    readonly arn: string;
    /**
     * The DNS Record for certificate verification
     *
     * @attribute
     */
    readonly certificateRecord: string;
    /**
     * The name of the domain
     *
     * @attribute
     */
    readonly domainName: string;
    /**
     * The status of the domain association
     *
     * @attribute
     */
    readonly domainStatus: string;
    /**
     * The reason for the current status of the domain
     *
     * @attribute
     */
    readonly statusReason: string;
    /**
     * Branch patterns for the automatically created subdomain.
     *
     * @attribute
     */
    readonly domainAutoSubDomainCreationPatterns: string[];
    /**
     * The IAM service role for the subdomain.
     *
     * @attribute
     */
    readonly domainAutoSubDomainIamRole: string;
    /**
     * Specifies whether the automated creation of subdomains for branches is enabled.
     *
     * @attribute
     */
    readonly domainEnableAutoSubDomain: IResolvable;
    private readonly subDomains;
    constructor(scope: Construct, id: string, props: DomainProps);
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch: IBranch, prefix?: string): this;
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch: IBranch): this;
    protected validate(): string[];
    private renderSubDomainSettings;
}
/**
 * Sub domain settings
 */
export interface SubDomain {
    /**
     * The branch
     */
    readonly branch: IBranch;
    /**
     * The prefix. Use '' to map to the root of the domain
     *
     * @default - the branch name
     */
    readonly prefix?: string;
}
