#!/usr/bin/env bash

# AUTOGENERATED FILE.
# Do not modify the installed version. Check source:
# https://github.com/exasol/script-languages-container-tool/blob/main/exasol_script_languages_container_tool/starter_scripts/exaslct_within_docker_container_without_container_build.sh

#####################################################################################
###REMEMBER TO TEST ANY CHANGES HERE ON MACOSX!!!
#####################################################################################


set -euo pipefail

rl=readlink
if [[ "$(uname)" = Darwin ]]; then
  rl=greadlink
fi

if [[ ! "$(command -v $rl)" ]]; then
  echo readlink not available! Please install coreutils: On Linux \"apt-get install coreutils\" or similar. On MacOsX \"brew install coreutils\".
  exit 1
fi

SCRIPT_DIR="$(dirname "$($rl -f "${BASH_SOURCE[0]}")")"


RUNNER_IMAGE_NAME="$1"
shift 1

FIND_IMAGE_LOCALLY=$(docker images -q "$RUNNER_IMAGE_NAME")
if [ -z "$FIND_IMAGE_LOCALLY" ]; then
  docker pull "$RUNNER_IMAGE_NAME"
fi

BASH_MAJOR_VERSION=$(echo "${BASH_VERSION}" | cut -f1 -d".")

EXEC_SCRIPT=exaslct_within_docker_container.sh
# Bash versions before 4.0 didn't support associative arrays which are used in mount_point_parsing.sh. https://tldp.org/LDP/abs/html/bashver4.html
# MaxOSX uses per default Bash version 3.*. 
if [[ "$(uname)" = Darwin ]] || [[ $BASH_MAJOR_VERSION -lt 4 ]]; then
  EXEC_SCRIPT=exaslct_within_docker_container_slim.sh
fi

bash "$SCRIPT_DIR/$EXEC_SCRIPT" "$RUNNER_IMAGE_NAME" "${@}"
