/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.security.ProviderUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SimpleAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";
    private String accessKey;
    private String secretKey;
    private IOException lookupIOE;

    public SimpleAWSCredentialsProvider(URI uri, Configuration conf) {
        try {
            Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
            this.accessKey = S3AUtils.lookupPassword(c, "fs.s3a.access.key", null);
            this.secretKey = S3AUtils.lookupPassword(c, "fs.s3a.secret.key", null);
        }
        catch (IOException e) {
            this.lookupIOE = e;
        }
    }

    public AWSCredentials getCredentials() {
        if (this.lookupIOE != null) {
            throw new CredentialInitializationException(this.lookupIOE.toString(), this.lookupIOE);
        }
        if (!StringUtils.isEmpty((String)this.accessKey) && !StringUtils.isEmpty((String)this.secretKey)) {
            return new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        throw new CredentialInitializationException("Access key, secret key or session token is unset");
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

