/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.algorithms;

import com.amazonaws.services.sagemaker.sparksdk.algorithms.LinearLearnerParams;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import scala.runtime.BoxesRunTime;

public abstract class LinearLearnerParams$class {
    public static int getEpochs(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.epochs()));
    }

    public static boolean getUseBias(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.useBias());
    }

    public static String getNumModels(LinearLearnerParams $this) {
        return (String)$this.$($this.numModels());
    }

    public static int getNumCalibrationSamples(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.numCalibrationSamples()));
    }

    public static String getInitMethod(LinearLearnerParams $this) {
        return (String)$this.$($this.initMethod());
    }

    public static double getInitScale(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.initScale()));
    }

    public static double getInitSigma(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.initSigma()));
    }

    public static double getInitBias(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.initBias()));
    }

    public static String getOptimizer(LinearLearnerParams $this) {
        return (String)$this.$($this.optimizer());
    }

    public static String getLoss(LinearLearnerParams $this) {
        return (String)$this.$($this.loss());
    }

    public static double getWd(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.wd()));
    }

    public static double getL1(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.l1()));
    }

    public static double getMomentum(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.momentum()));
    }

    public static String getLearningRate(LinearLearnerParams $this) {
        return (String)$this.$($this.learningRate());
    }

    public static double getBeta1(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.beta1()));
    }

    public static double getBeta2(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.beta2()));
    }

    public static double getBiasLrMult(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.biasLrMult()));
    }

    public static double getBiasWdMult(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.biasWdMult()));
    }

    public static boolean getUseLrScheduler(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.useLrScheduler());
    }

    public static int getLrSchedulerStep(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.lrSchedulerStep()));
    }

    public static double getLrSchedulerFactor(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.lrSchedulerFactor()));
    }

    public static double getLrSchedulerMinimumLr(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.lrSchedulerMinimumLr()));
    }

    public static boolean getNormalizeData(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.normalizeData());
    }

    public static boolean getNormalizeLabel(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.normalizeLabel());
    }

    public static boolean getUnbiasData(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.unbiasData());
    }

    public static boolean getUnbiasLabel(LinearLearnerParams $this) {
        return $this.parseTrueAndFalse($this.unbiasLabel());
    }

    public static int getNumPointForScaler(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.numPointForScaler()));
    }

    public static int getEarlyStoppingPatience(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.earlyStoppingPatience()));
    }

    public static double getEarlyStoppingTolerance(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.earlyStoppingTolerance()));
    }

    public static double getMargin(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.margin()));
    }

    public static double getQuantile(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.quantile()));
    }

    public static double getLossInsensitivity(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.lossInsensitivity()));
    }

    public static double getHuberDelta(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.huberDelta()));
    }

    public static double getFBeta(LinearLearnerParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.fBeta()));
    }

    public static void $init$(LinearLearnerParams $this) {
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$epochs_$eq(new IntParam((Identifiable)$this, "epochs", "Max number of passes over the data. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$predictorType_$eq(new Param((Identifiable)$this, "predictor_type", "Whether training is for binary classification or regression. Supported options: 'binary_classifier', 'multiclass_classifier', and 'regressor'.", ParamValidators$.MODULE$.inArray((Object)new String[]{"binary_classifier", "multiclass_classifier", "regressor"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$useBias_$eq(new Param((Identifiable)$this, "use_bias", "Whether model should include bias. ", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$numModels_$eq(new Param((Identifiable)$this, "num_models", "Number of models to train in parallel. Must be > 0 or 'auto'", $this.autoOrAboveParamValidator(0.0, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$numCalibrationSamples_$eq(new IntParam((Identifiable)$this, "num_calibration_samples", "Number of samples to use from validation dataset for doing model calibration (finding the best threshold). Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$initMethod_$eq(new Param((Identifiable)$this, "init_method", "Initialization function for the model weights. Supported options: 'uniform' and 'normal'.", ParamValidators$.MODULE$.inArray((Object)new String[]{"uniform", "normal"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$initScale_$eq(new DoubleParam((Identifiable)$this, "init_scale", "Scale for init method uniform. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$initSigma_$eq(new DoubleParam((Identifiable)$this, "init_sigma", "Standard deviation for init method normal. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$initBias_$eq(new DoubleParam((Identifiable)$this, "init_bias", "Initial weight for bias. Must be number."));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$optimizer_$eq(new Param((Identifiable)$this, "optimizer", "Which optimizer is to be used. Supported options: 'sgd', 'adam', 'rmsprop' and 'auto'.", ParamValidators$.MODULE$.inArray((Object)new String[]{"sgd", "adam", "rmsprop", "auto"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$loss_$eq(new Param((Identifiable)$this, "loss", "The loss function to apply. Supported options: 'logistic', 'squared_loss', 'absolute_loss', 'hinge_loss','eps_insensitive_squared_loss', 'eps_insensitive_absolute_loss', 'quantile_loss','huber_loss', 'softmax_loss' and 'auto'.", ParamValidators$.MODULE$.inArray((Object)new String[]{"logistic", "squared_loss", "absolute_loss", "hinge_loss", "eps_insensitive_squared_loss", "eps_insensitive_absolute_loss", "quantile_loss", "huber_loss", "softmax_loss", "auto"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$wd_$eq(new DoubleParam((Identifiable)$this, "wd", "The L2 regularization, i.e. the weight decay parameter. Must be >= 0.", ParamValidators$.MODULE$.gtEq(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$l1_$eq(new DoubleParam((Identifiable)$this, "l1", "The L1 regularization parameter. Use 0 for no L1 regularization. Must be >= 0.", ParamValidators$.MODULE$.gtEq(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$momentum_$eq(new DoubleParam((Identifiable)$this, "momentum", "Momentum parameter of sgd optimizer. Must be in range [0, 1).", ParamValidators$.MODULE$.inRange(0.0, 1.0, true, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$learningRate_$eq(new Param((Identifiable)$this, "learning_rate", "The learning rate. Must be > 0 or 'auto'", $this.autoOrAboveParamValidator(0.0, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$beta1_$eq(new DoubleParam((Identifiable)$this, "beta_1", "Parameter specific to adam optimizer. Exponential decay rate for first moment estimates. Ignored when optimizer is not adam. Must be in range [0, 1).", ParamValidators$.MODULE$.inRange(0.0, 1.0, true, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$beta2_$eq(new DoubleParam((Identifiable)$this, "beta_2", "Parameter specific to adam optimizer. exponential decay rate for second moment estimates. Ignored when optimizer is not adam. Must be in range [0, 1).", ParamValidators$.MODULE$.inRange(0.0, 1.0, true, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$biasLrMult_$eq(new DoubleParam((Identifiable)$this, "bias_lr_mult", "Learning rate bias multiplier. The actual learning rate for the bias is learning rate times bias_lr_mult. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$biasWdMult_$eq(new DoubleParam((Identifiable)$this, "bias_wd_mult", "Weight decay parameter multiplier. The actual L2 regularization weight for the bias is wd times bias_wd_mult. Must be >= 0.", ParamValidators$.MODULE$.gtEq(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$useLrScheduler_$eq(new Param((Identifiable)$this, "use_lr_scheduler", "Whether to use a scheduler for the learning rate. ", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$lrSchedulerStep_$eq(new IntParam((Identifiable)$this, "lr_scheduler_step", "Parameter specific to lr_scheduler. Ignored otherwise.The number of steps between decreases of the learning rate. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$lrSchedulerFactor_$eq(new DoubleParam((Identifiable)$this, "lr_scheduler_factor", "Parameter specific to lr_scheduler. Ignored otherwise.Every lr_scheduler_step the learning rate will decrease by this quantity. Must be in (0, 1).", ParamValidators$.MODULE$.inRange(0.0, 1.0, false, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$lrSchedulerMinimumLr_$eq(new DoubleParam((Identifiable)$this, "lr_scheduler_minimum_lr", "Parameter specific to lr_scheduler. Ignored otherwise.The learning rate will never decrease to a value lower than lr_scheduler_minimum_lr. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$normalizeData_$eq(new Param((Identifiable)$this, "normalize_data", "Whether to normalize the features before training to have std_dev of 1. ", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$normalizeLabel_$eq(new Param((Identifiable)$this, "normalize_label", "Whether regression label is normalized. If set for classification, it will be ignored.", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$unbiasData_$eq(new Param((Identifiable)$this, "unbias_data", "Whether to unbias the features before training so that mean is 0. By default data is unbiased if use_bias is set to true.", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$unbiasLabel_$eq(new Param((Identifiable)$this, "unbias_label", "Whether to unbias the labels before training so that mean is 0. Only done for regrssion if use_bias is true. Otherwise will be ignored.", ParamValidators$.MODULE$.inArray((Object)new String[]{"True", "False"})));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$numPointForScaler_$eq(new IntParam((Identifiable)$this, "num_point_for_scaler", "Number of data points to use for calcuating the normalizing / unbiasing terms. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$earlyStoppingPatience_$eq(new IntParam((Identifiable)$this, "early_stopping_patience", "The number of epochs to wait before ending training if no improvement is made in therelevant metric. The metric is the binary_classifier_model_selection_criteria ifprovided,otherwise the metric is the same as loss. The metric is evaluated on thevalidation data. If no validation data is provided, the metric is always the same as lossand is evaluated on the training data. To disable early stopping, setearly_stopping_patience to a value larger than epochs. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$earlyStoppingTolerance_$eq(new DoubleParam((Identifiable)$this, "early_stopping_tolerance", "Relative tolerance to measure an improvement in loss. If the ratio of the improvement inloss divided by the previous best loss is smaller than this value, early stopping willconsider the improvement to be zero. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$margin_$eq(new DoubleParam((Identifiable)$this, "margin", "Margin for hinge_loss. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$quantile_$eq(new DoubleParam((Identifiable)$this, "quantile", "Quantile for quantile loss. For quantile q, the model will attempt to produce predictionssuch that true_label < prediction with probability q. Must be in (0, 1).", ParamValidators$.MODULE$.inRange(0.0, 1.0, false, false)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$lossInsensitivity_$eq(new DoubleParam((Identifiable)$this, "loss_insensitivity", "Parameter for epsilon insensitive loss type. During training and metric evaluation,any error smaller than this is considered to be zero. Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$huberDelta_$eq(new DoubleParam((Identifiable)$this, "huber_delta", "Parameter for Huber loss. During training and metric evaluation, compute L2 loss forerrors smaller than delta and L1 loss for errors larger than delta.Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
        $this.com$amazonaws$services$sagemaker$sparksdk$algorithms$LinearLearnerParams$_setter_$fBeta_$eq(new DoubleParam((Identifiable)$this, "f_beta", "The value of beta to use when calculating F score metrics for binary or multiclassclassification. Also used if binary_classifier_model_selection_criteria is f_beta.Must be > 0.", ParamValidators$.MODULE$.gt(0.0)));
    }
}

