from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUaAgNa9r45P7lGSz9yjEAMmSYuA4wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDczMTAyMDgwOFoXDTMyMDcy
ODAyMDgwOFowRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAnTwel56+tLKkGLedJB0CRNyiCYiWS0sNuoCYpRN6MTnj
o5pYCN6rFQvdRvkaBRTodlU4stoEAy7b/v2ny7h00M8iWkVXqiDIB8u1pefEE53G
p7ezsPNSf5sX4+1kvm/+TJd4UEeAnSYaN6LWnTbEov18Kb7Xgy9yoGPpnYHmoYme
lmnV9rSXmI+nFzLIMWKTFfaGW4icTI3d8m53Teqhj0XiPI9VU7PHjUakAEkybyPM
tGJ0f7yq4OG29haDfWicyAKjYm3KxAQwdRUR4AuUWjXhk3flSyEnFsu5aevHd5xJ
88W7sp7UJWw3NDPHIxrehVeo+ZWNiMJWC/Ff1bVMBwIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQCLXqq05Wp9/J3atNhSo+qoFETF
aO2VokcUYonsiXxNqTKruNtTHMSIHZwerwhIPqEA0KGUVR1oyJvvdBu2VAxv8IpC
vR4aJAtI8X2UgDYElsDkmahEiCja+1f3+w7AK78HGCzm+5d2kz3p4vQHGkE4N57c
g6uZVoouma3LJMpKS9R++Y2JBjg1EfXoleYdh+CPac0AihHMvV64/7tkTt7Wd++O
4pe/yUy7qcZL1b4JKoSb2bKAwDTYMljJ1buLLvBlhjIwqxOiYjnEZJK1MHfEp+sF
HPPfgGE01n8iANfXwjob4OY1SB0n7vxz2tCMEBMqAdOt0T7ThGhCVRGILcKH
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCdPB6Xnr60sqQY
t50kHQJE3KIJiJZLSw26gJilE3oxOeOjmlgI3qsVC91G+RoFFOh2VTiy2gQDLtv+
/afLuHTQzyJaRVeqIMgHy7Wl58QTncant7Ow81J/mxfj7WS+b/5Ml3hQR4CdJho3
otadNsSi/XwpvteDL3KgY+mdgeahiZ6WadX2tJeYj6cXMsgxYpMV9oZbiJxMjd3y
bndN6qGPReI8j1VTs8eNRqQASTJvI8y0YnR/vKrg4bb2FoN9aJzIAqNibcrEBDB1
FRHgC5RaNeGTd+VLIScWy7lp68d3nEnzxbuyntQlbDc0M8cjGt6FV6j5lY2IwlYL
8V/VtUwHAgMBAAECggEAYjyXmH9UAy3BnLfLdC6zpjZ6/p3Z2PzxfN6vgCOlKnBS
q3rZGeGU3jdlbtxfx2ECxDwGiqfv7dUvGid82KlMQtHHUsMUPHTyxPwfZ6JgPSlM
XqlFmX7MwnEyAfPmB52NMmlIgE/MKWMO6kfQ8rSvMm5RTvuvRoU0hsUlxoTMhYut
VZbYOJGMes5zqAJbZPyt5+mFMPOMk8/ceDf3s3toZbvBtVXQ5tFsIpudA15Z2TLV
W4U+Hkkpru0pmV3h5cdYxM+Sb+igmsmP3sXc4/t3v25TB0ppRH+fO/MfQ452KXP/
91LbpedRFj7o6hQRlJwQwPYGWKmfF+fjlqsTpme+UQKBgQDKdJNyxzRzL49g3IR/
Da57S+bXPh/hupkW/bQhIv5VE/r1m/wy77SQetI6Dec1+0uZ1zTfqUCTkSzp50Rd
wXUnrB3/+bY6UtXN7wQpauiTitdcvcTPpHw4AOczUe39//6UW0qbi68CWz+Rduhb
rQ5xAI7vsRdtkBS1+yKm7NKHmwKBgQDG0dizsRVy/08iygrO/UPPvGkB9xqXr+0Z
CJT5bUnud6P1T5Zosrv8duDNoyJ4JcnguJ/SnKT68Efl41jF5BthU4KPOvt1j8P+
j/vNjKFJF3S2Cp8DAFtcRog1rKs8S2ZhrwVhGDNi6sXnsXwDdXaLBbkpB5IYgmGz
1NhpP4tSBQKBgDLrPQZ6Kavqw1HmRIC8DS0/etCZ9GTOjKBmsL5A0dzOCKlrUPPy
q+RGr8cgJg3CpVIM+WRjajVzJuuxWdWGyZNvy5/My1NB8Do6Kj7Mf7BUFDRkGjLr
OL7RI1UZ/xSKJRplF4+lgx/BmWxZjrk3/lDXhhus26qXuU3H2wBGwfCPAoGANx3F
bUsSHycX0RUhmfAr9FLO6XSPMq3alK4EXoElla4lDcRadfvWkU6DU35998DCDkIg
TEqQkeA6jkhQO8vYq0pzTzGStCx+sPtJWto5fAG8oRqgqjxXF2WWLQsJDVX5s+rJ
GvmShUGAS5KwRmUxz6huhClNHu5GF4xR0huDi+ECgYAZURTCE5p4RZFTDLMGbFFw
ElNKKOmnPkCdfhCrNh9WazduJOwO971uN7t14j0gQ/VFFgxchflpITEX15ZCoSvZ
+9dXOmKNBYvPPDr68NKZTKAzWnhRhB1zI+jXZ0YmDxAIhbqRwh3xxkIw6/Kj9T9E
fg20IAWgmoJ7rc7AcoFMHQ==
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUHx4JBOGyU12gOWGuB5dBegczdfcwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCqyyHVlhZpFR0rHSfSunLrREk0Q9MJSU/pcsbnmYIBpUZS
HHnEStu5B984swApxNmBaPWiW7UaJ2jq8h4NS8Oo2tCasIJF2zWGWgJDEieTEU+d
vpJ/Sfu0MZUpu4obbWERXkmVnCyrDx7v+kSsxukSAWF5iAHT3Oqnouc0AwPJCuU7
5MRD9/0xC6GFurSJQndquKcZJ8wGWkC1WNU9C3VwMy4pYLT84Pmu8bh/6uzupVet
TDDDNgh0SGqbabk0TCG9kgS41ww3GTRf0sOoJdT6Zb2UYA6SQ7iGmu5ZPZ7bQykC
4zGkna+MtM5WldUilkfGN9rPt6xvCycBpif7nUOLAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBlSm8+WQWNqQ/6XZ6RFxCS
Lq3aFKAGGZpX97Y/Q88ZcbJFd+67yORmhCa8mvLYfhIpXXG/IoX4E1PEBohskeah
/nPyeaPAklwSjFYKMKbukYUb3j8hQgs0jFh6+mMvLUcf7bQbmD2ZgUgt7xKVPTHG
59KlnZv+cIMlS50JQU6n3oHv0a9+STMU7GZV8RN14INGGX+RD8shO3xWVZB/BzNj
sjoud8pSpnBJYLH4uucnTXNjrzM8a+S+uaU0kxCdRY3TE8y6PsqC2XaPQctf9O3J
hnFoH9yydMD2leovDedRyENxs05wNlVK+GzUB8/g6++3dqC0Sq4U84yemYh73Pa0
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCqyyHVlhZpFR0r
HSfSunLrREk0Q9MJSU/pcsbnmYIBpUZSHHnEStu5B984swApxNmBaPWiW7UaJ2jq
8h4NS8Oo2tCasIJF2zWGWgJDEieTEU+dvpJ/Sfu0MZUpu4obbWERXkmVnCyrDx7v
+kSsxukSAWF5iAHT3Oqnouc0AwPJCuU75MRD9/0xC6GFurSJQndquKcZJ8wGWkC1
WNU9C3VwMy4pYLT84Pmu8bh/6uzupVetTDDDNgh0SGqbabk0TCG9kgS41ww3GTRf
0sOoJdT6Zb2UYA6SQ7iGmu5ZPZ7bQykC4zGkna+MtM5WldUilkfGN9rPt6xvCycB
pif7nUOLAgMBAAECggEBAJELq/NA4E1jsf7QZuaOk1P8DRNG2m2Thjsiz4sWkhMl
sj+/kSXD0TAlYEw9sFDIrVM6uQimS3onp/GHpz/xbPv0wJ3ucuQykxVDUZJ2U4eR
dwTnOHDDevB//0aOz24ViQ7//QwCsuifEc4Jw9Lbpko1Q/u7JpovjlTJgwJn4QoV
Q5W9gDoQOwtItyfs7hHgHsWB8uZvKbHoUp4/gRTRED/Dwu/kZ9jCYdKt2B+i4Amg
j+8bkcNQMhvt9ZHSRfqAiy3g8Qoufl5YYa3F6+CK5VRovWdQdlAp6gt9dyoNMJ1G
mSY9IXZhMDFwXZkLnwmI+aYD5xepasIqY3rGQ5LOkukCgYEA4Pmn+TF7xyQV9Xpz
CykW3dD3tXkLi+lf0k4Tl+YMBoxB1OQtyIjfdn8L/68evNwVv/31JtVPNxNP2YmJ
PeFe+7LQzadWTbOeMAjjrLoSAGv2xLlwtSOpxON6glWQuOjYMGKmnWSnZnkkIoVv
gYZ2xGO0zbohnBqcg1NssRGORp0CgYEAwliwDzVGRDqUYRcydR2rHJzdQv/zsyPD
OEb7D3GLx85bVrSQGVXWCMqbQVtvJzTuU/K3nNPKNgWnnt/ObLPsyWUYTxZAeLAT
JztAM1bvhFxmEXCY7wpWlcHrK1nNIRFtaWBvLRQVXe7HkAiUGH/p525HnoHfS/TU
LC/Ql42ABkcCgYEA3LYxA7l3LKSLYnwR92YFR/JlwkSRfl6jIih08nW/YIEjaJ+/
Bti5GoCDngEIz9G/CM82PjXQ9EBe+xUCbpH25EnGrau4cJyB2bAu5NrbJEzHGLKx
DxSAzmc5Xjphs/bDeZyexxTjYhYAzFlKTrFDPWJwE9DCfmphGDm1DXYitcUCgYA1
zhfwHe+2NAGgX6u4gN4+ra8UPYhasCv8CKq5O9ZXGuputs6uNPVsuasCDS5YzG6v
DyOGZ5w0GJyvf4bG0YlcuIBiZOa0gwrKcbz0eb0WB/66FVJB27rc+zMAbXw9C3Yf
FnOxJz5DIzhcyAM4RTGcwQtS9uG7Raz4DsTRMHuhQQKBgQCE1yrDDNa0cr3dhA9X
N6SlN4aguCcWFNPHdaH+xB10m4l6rNZZipIsM5sRgBFc0aUY6gkn145thlDukwW3
0hcNIC0tIMeeHT3asLc6A/5utNxSMdhdgSXzJnfPnEabQmi7bnAE2gATw4oU+O77
KM5xV/wvREiyowg4Y49FNstCVw==
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUFhaPwCH7jH8uqupV1SQQhWjqr7QwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC0T15f3tKXrJr19pL+meyy+AxHrhlOfgID0n5BCn6sYGcg
7OzPjMf7JFBavWzj9WGvufAke4mOCOrQ8XbbeTW6lKDow1mSAQYWe29N0Xuz1SQH
xwbFTf83tPzsbDWwxWZdDRG8SmkJ2WigJkG/0PGSlkPm+ttzga7Ehw9E+gUNTYNF
wbVj0+2zNVf6VzbQ++vnh4atHRvTcuMIXXJ9kfJPg9HupgykSi1EMum7fTNQQSRK
VYAyD/qnb4t7xbmzqIciC6uz26ziwMXLOhiV4zibe2gqoeLJBVboMV8WCWJnhSmA
MEXaGgq4cgZ1MhfJdlWa1TB/tCFz7vCHB6o3n5/rAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQC229ik5XvaUZsMoNKWpzPe
7VA5XwAMPImgppwDsQrMlo8cLX7DEUOi0GPHstS8vx6cozRihVhr3YwfUh87MFIb
B2WkIy9dXyutI+KMK9dQWSUKaPcavvLvWBvMGN4bkx/93/CVq/lD7aUkoZ0XNulZ
Pf1SkL6qFjUYZb7l5xJhFeygYqz1cEdf/0u9FJpZPjyI8kRywTJv6cawDWCL3oeS
de1AN/0IWU9ePMiBlFjVjM6dhxP+qobq9WwZkJon3zWHuD5dbegEjS5tmN2g5VYT
1hZaamRbV7aKDLr9Koq42owHByfGYxh1o5pBwnnOdEHB2SMT7djNC1gkDj+PxajW
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC0T15f3tKXrJr1
9pL+meyy+AxHrhlOfgID0n5BCn6sYGcg7OzPjMf7JFBavWzj9WGvufAke4mOCOrQ
8XbbeTW6lKDow1mSAQYWe29N0Xuz1SQHxwbFTf83tPzsbDWwxWZdDRG8SmkJ2Wig
JkG/0PGSlkPm+ttzga7Ehw9E+gUNTYNFwbVj0+2zNVf6VzbQ++vnh4atHRvTcuMI
XXJ9kfJPg9HupgykSi1EMum7fTNQQSRKVYAyD/qnb4t7xbmzqIciC6uz26ziwMXL
OhiV4zibe2gqoeLJBVboMV8WCWJnhSmAMEXaGgq4cgZ1MhfJdlWa1TB/tCFz7vCH
B6o3n5/rAgMBAAECggEAThNYEDdSBS9OYlcEy44nOk/CMX+noZ9ajAEnfk5nD4km
3tD4sd6J8auFx+TiM8tbI1ZmL8X2iDRASX1lNB/GLiaRjniYXmpnEnEcfxvIbtRK
J7v8qI7fhmWuZ0lr7kFr07sHBPtLhGJJtZ8bNU3qbMj4Whoh0GBFJwA8kmeYrGs7
hohIFD6vp4z8lN0gq8Eofgm6r6vEAwC5UAA9DQSfcwlqOJmxTmfY+yoIUiIu8A5B
99/xR0GwZx147CfbNCDV7YdwQCdVv2n6EiSglUrHSLJKYFrF4/9y5XK5DAejn27V
KPGQmAcf5FGlUafrcEWtnX1a56O35WJ6pcB5q0JHYQKBgQDlf3Rnn/V6daL6JU11
1UCs7FjyEx/ZDDOO6dZKYNtywQSujasG5ZGqgJazkd6KSm28m0633q8hrvFxPuBp
T+tt45VQc33rhoaUR39j4ZYdEjzB8mEvNyMZp7ivV45ezVmRQUw3EwNHdlvR4Z6K
VSwHuxHCb+Pk+9Dm6biig36zOQKBgQDJIcuhHXWXEfCnUbZCTSza7Tu+pSc/bv8h
vTHTbdVT/Ogh07q4mI0bX5yKfXUCYiL9G4hjC1hoKfccXsWaCawDHvwIXpcvMa+5
f0RArQ3UHKvCLeLcrlL6ACwzjZ2/ktvu7BIkO8UfbCWrtw3ZstmvpudiZcdT3CO9
E98esRR4QwKBgA5qvFBKLyybOTrHnx8Y33A9hLToWKbU6mQ+8lRH02FZGMcyZR0Q
zN7OJylur3E2jcA8bWyFk7DlAYvgrE5RU/PaSSX9q1phYBDukOUgZcK7w49Xf51s
tErHS4XQVURFWCwU0wnequURXWFI8CG2igaOTOZPCxz2aMAozI2A/zOZAoGBAMRf
PKL3UkHHAEE8ZEhjdTHigXxnXuRuCKb2Q1l8WNYBjNrKD/n+53YcaYhFaSKEkkiw
wv6AqzY4Es4eMattWgZKECRTxiQLzNe9S/QhgejgfUm+50oy4Uy5Mm67C5NpXVXu
IuBBgvpk6nq25Mzx89uthyfo2y4jNrl6V1Nt7OBlAoGAO+xrWyqMmVAJI1hKTs/e
8NUEg9pZrtEz0HWDCD+/+mYXcFZjFk1tXbmM6oluYd6paLJZfXjyNUsBei4vsbHD
gyCWKyut11dpZJScgk6vJKY3jZk4NW229GO7wqPiebZx+izLjZqvwUCqPQN9OjsY
2jn5HwHyVt87z+BwyLiPmFs=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUPgSiFTu/c9pvcsiavcITg6l+XbUwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC0AXXqjde3+iG4nSDVvntiMpMM+vm7Gg6R8yShZEp1zT/h
uov3smxNzKpSAbNA2nPifDIsLI0oVOWgDrZXOi1kXipC98GMjXE0mXItsDojSyih
Y78HKIAeJBtBfLkt2JvyoGxZ6TBBgfgemRQiz/b24QKLLIYjFIlH7VFI6XGMb2PT
rzB8OqwxnBe9orFnCJkGtYVrSQvcrIUX2Vt6SP+7QVXxgJXmm1SpetNjcmAYQ1Dp
QR9leIYRPy91TItvrUUnmP3pC2aJ7RmC7Ts2Fomqed3qnuMEgk1BhTILnZAC4oqb
lKMo082HapNoxbGcjBNIsm/Ns85la/DP3V2FdZINAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBjkhqh1RyS9YGL3OOQumPy
fYzt81tI9dfBcVDISmDYApgBQ9x2z5/JDZjReQuXacNbVYydJjHL2JEbhQvq5ebd
uv56pvNAUwMiM8Ihkos1cgN2QvALBAFYxusFEP02rI5sb9GwW9eSCYDbuJtFsvdN
D974kPNL4B2hLkWyO+f2/epxVJ3i4TSf5GwXIjJERIjNa+LKBCLEDq/IJ3sjQrbs
KZOiHm/NlgaEoqEIZGDE8J0FfhTUrnXHd31/fWe2iFDcbQkOuUCbpphtr/3iChXV
tgkL/OjUF3EID5NlttW4AbIXCwvW+buScK80DLtLEbaxueF7CUooOObsbECh6ZOU
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC0AXXqjde3+iG4
nSDVvntiMpMM+vm7Gg6R8yShZEp1zT/huov3smxNzKpSAbNA2nPifDIsLI0oVOWg
DrZXOi1kXipC98GMjXE0mXItsDojSyihY78HKIAeJBtBfLkt2JvyoGxZ6TBBgfge
mRQiz/b24QKLLIYjFIlH7VFI6XGMb2PTrzB8OqwxnBe9orFnCJkGtYVrSQvcrIUX
2Vt6SP+7QVXxgJXmm1SpetNjcmAYQ1DpQR9leIYRPy91TItvrUUnmP3pC2aJ7RmC
7Ts2Fomqed3qnuMEgk1BhTILnZAC4oqblKMo082HapNoxbGcjBNIsm/Ns85la/DP
3V2FdZINAgMBAAECggEBAJpO6juhTryrU38ES+KPwQukGUU2XSDUrIrXKZ6k7+Pe
iJXEKjqznH5xJczZIkZFPrR4DTarFnLtnE9CbXOHLuRsiMQRybzof5Q8upGKEbyx
sGnxrQ/A21t7TlYsSj6QAtfSSDAnY7O0a/Qm/Aj/yFFJALo39+FYuHqNaXIclLdy
UbKoj5IFPnQQkY2Evd68jF9BP52+J9/eih4qY7t+QVBsDPcGMioDJGTzPXqotiAA
v3BbLmrXsG+DigYvfwFLfyAcD2ICw9jHks6F/h5IdO+WPm9BBiz0jqmJFv0bphiP
xixZC+/CMH5sEinCJXmHG7As16HonMmvw+svx38ZCa0CgYEA3CMZErXFYkFzO9or
c+9hhnrHBLMeCgYJhBSdB6mFzdVLL9MRaZAT5qLrLG+iOVX4nMjcvL7szczAgSbH
jTorHq+kNRc9J0qV6I7U494y04u9XCImTbSkukR4iJBYg25WGRvMF0uT1UfT1RMp
d7u32rmqWhG0MJ40z2GkucVmYrsCgYEA0VSq3dG8oYQ5lXIz/ZSMn/b3OZSKSh8K
c0Jz+EDwfB6KWD8uu0IKa15f/wisPIlm6Fde1hlZ80Mh7BefYBxVu/PzyMc5bQWE
yZa/V2IRCTFtV+Lyq0HT2hc/P4YOnSZWFnJUvItcYALDcAA+XbkE3Nu+6zizW1S9
SUUfBfhxBdcCgYA7xrwUPI+wsp0b745FGQeegNByEkFh72m+F+rcHchbsEOOZP4h
cCI3Sp4ZnuaqMxIjYNev2RhseeD8MQ+W5ei3mHI6iGjutm4mjEJ67edXUmbFEfDc
wOTKP7WLP8cJSXjPsKCm4rrt+2cmQOHNxYeTOT9s3cnUOeGVPqqAV34J6QKBgG+/
jT/BebuXxM3dG5ghtzimNLCOdYzAKWoCbbp3oGoCO8SEZkQdK0bKKOETFi9zAnbC
PaR6ACT3D6LjsXczaSlfQCNNB4EF0y9yxE630XRg6IhkZTu7docUpfUZca+/CXIO
MuI8W2H916tw1dperRPiU3dq24TEJhB5T+h2CpAdAoGAKUTEcbu9bldS5E0xie+y
bnxXl0irA17jwlWz0o3X2rxHwx0fQKDixDbKH3iFFN7MAyAlObqJ/q3ecjrfHA+y
HA+cnex6yHXNzTc6fCKj4ZeKMx8sXOv0t4qtlNLXChfxLQlYndN6VsLuhyy04ZtX
AYRAWJaMU76KDTbwjnBrDEc=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUa6usaYtQvU3SpCXwC1JZ+v6+V+owDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCfSnAPjNYAaVYFm8sz9GPz3PytW3pZhdlEp41qyD7JKgdQ
znBMLwGHx8k2eT//mKovi7/4ASCrtgoti7k06GIRCM34ltcHBtBhwksJ3nlzvW9b
e2r/MzXN9nxNqVFf28Wpp577hngtnhm1Y6Jm7eVZP2C5nrEfOE4wwXkaG1wQn6ED
TvIz5G9pF0BkuqCKFajygtyHl5s3GeuysABMOLnj02K8IClStUd2sD3tuXoOhxZ7
dqtmN0HHKgA6GEeq1YNMpPmHAorJ/qgTWXTvAsHvxHIYAOvmOAFDBwj4dKBR3vCz
YpO7z/AfkHNJQjVMCZS+TilS8KvEOqrXg0jk8wf7AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCYJQ+LL15Qfnbw/Fi45U8Y
oBqdURidfgfqYD2z61hIE7MalIKy8zqsIadQc3+3xnIJRF5QrQ8ctpZuWKBjZ7Lx
3c5NOENmNK4eiD/M5Ip9nA7XyyxLWkNIgpGLvJGmjTsH5XJBQjnUhxWP+hvapcox
t0uhkXafa7iQ2PCZfhAkdS+4rKl5aC2+gNPNN9unbTyrI3pUKv+kfWiV1rW66gdh
QMY98qQwlDA5FP+3Sldln9XbVUwZipEoBB6U4TwMye6ZuCvHUhi7eE037kN/RRWr
vvQxYJQy+J/dMVfCZ+DGdBMp6Hdf/uH+C7Dh9hFK7txq6LvU8sRCJT7CM+WSNNmB
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCfSnAPjNYAaVYF
m8sz9GPz3PytW3pZhdlEp41qyD7JKgdQznBMLwGHx8k2eT//mKovi7/4ASCrtgot
i7k06GIRCM34ltcHBtBhwksJ3nlzvW9be2r/MzXN9nxNqVFf28Wpp577hngtnhm1
Y6Jm7eVZP2C5nrEfOE4wwXkaG1wQn6EDTvIz5G9pF0BkuqCKFajygtyHl5s3Geuy
sABMOLnj02K8IClStUd2sD3tuXoOhxZ7dqtmN0HHKgA6GEeq1YNMpPmHAorJ/qgT
WXTvAsHvxHIYAOvmOAFDBwj4dKBR3vCzYpO7z/AfkHNJQjVMCZS+TilS8KvEOqrX
g0jk8wf7AgMBAAECggEAKBWnVYJvZ/MZ/pdR72UUsg1uWIGorFaOckRnxfNWOXEm
HiOVBtbdX7na3KZugHd+fDCCwnomKo/Ix+VdWf8QjpDUpDXxLod8cN1f3L/reEC3
gSHxrv7ID2hzp2dwXtsDRsozq8APBgu/FHJaL+S1zluwj4VrtRuKMaK+Qt+Xr2bW
j2MpJxv8qJtrUmOipJGlo2eqmYOx4CDs+NzEXQJJSLr7u+UnT6H5LtAhEc0t8h8c
v5l/vBlU5bFcreREGiU5RKjITA7Dip5vTy00qlMoX98bRmI30hlvQSawKbeXBMOV
neV260Em3J28DIcsorI0OMxGK3nju9hNDFGfnxlpwQKBgQDK0Kc9MUOV2I4IWDqh
b+8coFGlT8qNAYh1+9Cd+EfwWgVpQfKrs+2D1IJgBhE2g5o8SDEClVYn/1rbgw7W
z3fyCey1ERzaydRs1QkTsFJs3r39cRRMDVjX8/tt6CsO6DWBK783mVKaWrTLsoAX
PrAngfWO9gr0MzauvbNiJXDQgwKBgQDJD+twjRKqbbOwqbrXq997aoL1QmIFRVuc
Ls4KsLmdeBrGBX7Xg+/smeaWqCpo7qBfxwNbXTAQi0w4KTT/YTZltK+/A7obJdLH
G9h8MxShBL1Dk8b2lTxGwwApHvHSilffpIZJ7lURQWcZnUozwT5/Alh+rJ7yJzZj
eOTDx6BhKQKBgB8DxW9gJzu1ABNamqyxV1mDUrj6+LiTcXDJb1+Y5jdlLMqp4RhM
zZeJWd6hTuSNP3rUd1ozyBcZv6Ut54kF9Qu4ZNBTq5vxnWB/O4IdRp2LenZVYos2
x01O7DYkeOEwtW3paLZx5eXg1SEJTPlBBuMjxo90JLyvUD9slw/9NcFNAoGBAMC2
GIT9QjnGAee/Fw2meAKTuUeYQ9knfEH7fpMyhgYPWyIXnFa259yQOjqGnneK2H5U
grwsWmhRC1H89QYdyAS9pYFg8h0ZKKic4OdSEmCu6TT/TEGGEosEVoATX9bbsJPz
3p636CMs28PqRXfLrboQpn9rtsEEopW/Bw07plXZAoGAZsHZOwRa474VFLR5DPHH
X42wdjWMKR5IRp1hkYwoxMC+ujlMCSJ6BnS1rYQK+795M+sn+9kVVfEv1tMuf+sa
V4oKG9qthjxb+MsqQyKYCF1WqM6jum7dpD47cuhg08/taDHT6yKzFTrT0sJLB3to
OV/477W23T6I0SBvrkruigE=
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUNoDaXQ+0Go9hQxTxGLs0B7vxTDQwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCwHxpAJMp1U0WJHLmyRi9bii71RoGv1NjkH+PuRZxigaFB
VMsjZndD+Is3DdYDWvPD/yQbe+pA0Ne/h9gLA+JAyRClPAhvx0hl20OQ/5AQDHkO
fFcgSyZsnIqqkzprHNHwEu+wJahTHNuRJb9iesNxDqXpV3Ve11wJf2Sh9o807a24
2zTMb40CxdhF47Y2ZypDO6c7DbS/WJmEdTihCh4T+kgqSscXHlGAGlq9M8Vl9Mtd
uDxNzybWV37wHY0XNaHyJSmwlwznVE5Xz7BCjtyL2/Tw2Cp62mil4RvyHv3An3N+
lgC45Mo35mWX84VcBxqXfyNTGtw6oQ2SWllbGjUNAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQA9A7G1S48zTgsU7elNwxTm
ctADVimn5RWpVSHWJnRXCM7XQjzqvZ6LDyQGZAks8bE6cX1yHjJU+bJYJ2foYk3k
cVE0Xqozc9c2a54REY301NnHZB9ks8ptXjf4JZrifqStALW+wotqWIo1OSzcgMYJ
vaP4cUo4Tx29eYCq51jsqW331gY2ZqClzMn6DbhRJVQBH7avnTTbWWShnZ4sZxM1
un7BkM/d3t2ehx3FFBdoMSTCcXa/TolLO4DlCH4b9dojvW4HN42RrTcruwMx6m3/
KgcTOMtluX0W/Ti8H+SqCghru8FK/6HkE3EViCvYnHsr4AyEVXGzk+owTXfJq6vB
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCwHxpAJMp1U0WJ
HLmyRi9bii71RoGv1NjkH+PuRZxigaFBVMsjZndD+Is3DdYDWvPD/yQbe+pA0Ne/
h9gLA+JAyRClPAhvx0hl20OQ/5AQDHkOfFcgSyZsnIqqkzprHNHwEu+wJahTHNuR
Jb9iesNxDqXpV3Ve11wJf2Sh9o807a242zTMb40CxdhF47Y2ZypDO6c7DbS/WJmE
dTihCh4T+kgqSscXHlGAGlq9M8Vl9MtduDxNzybWV37wHY0XNaHyJSmwlwznVE5X
z7BCjtyL2/Tw2Cp62mil4RvyHv3An3N+lgC45Mo35mWX84VcBxqXfyNTGtw6oQ2S
WllbGjUNAgMBAAECggEAVCWIFT1+va+beXcQAe0mk0XiSa32KFw5hET4Uc9QeIAW
22/33mIGeaM2YIdryQ6biPlN9xOtSGp/qjLtNdYVM37dRRT5su4z2PZ5wb1Yx1Iu
RI2D0xoUsa/ZUMYnEyYh5+IkQrS7R3pyLVcrqZGd71ZgTqxKl5Wtk5waKIf0xARA
IS8twb1GcagQ92Q58wNwz4jXgbBHe+QjskaargGxY/wyKfoTGDd1LaAecdOF2QUb
gZ2X/R8gzzh1ew7M3QFHA1ZUlznlX6mqycHkEDdkaA5ZDHMHZjUlZigUl6REGMBu
QUN9FWKmQxvh4lrkyxPbjPl3ZzZWT2S1dHoAm2AkAQKBgQDW+QkIez6s6cvT+oXF
un0cJbWdrtbddKsU1gl3swvoKbT86PdpZ4v88kNrd8TY6TGYzaAUQU+5VlLSEiUR
89Dik/7xfcJ9xAKZk6jkbdQ3PR+jn4KnmZZxUY1r6u3VY98cTxSUErvEepSpYDDj
VLoJ1kvrNeawn+Yelkpu41fpnQKBgQDRu+b7H8jQBDCLTBv/uts99+bH7LCu5udX
PKkhK4EoqBlr6GdnemAeniXYwW1sDspa7dAAEDuvDPVU7q375FttT4Uf4y2KFsTd
0DakcG7eFa3J1qn8EU1KLA6pW+LV+Y73jDzC6alikb2+2TWPAwtX6O0RY1Z2pNfv
K9ArLQ8WMQKBgEUd1qCqd3FCziz+fCohln4JRcZH439aNnNBidO5dleTqUQzZvC1
wRV3kuOno1uWRkL5wcEhao+NSJ2QBekquftPWAWuyGyFK8zS49dl1HhaJ6UE8Q4P
3IXckZqj8wnLzX0dk+Ez0LkQLGH0smM054eoJcqfDue00Vj+OzpB0A8lAoGBALzt
EV1nPUI8c+oWziXnkTTaCZZQHLwAnaXUq9mIUdloyzWL7RGmh80s0pTVcJblH90W
2cYk2U6PUrOGKU19X+owto+J2ezJI99XftFTwlrlll35s7evcjr9QtvGPKhZHDLb
raQ6TW3QMOcozHkd2er/lAWUwT8wsJ7ujZ9HAI8RAoGAVAEhprvCzaKzYHkN6mLe
32H+GjtayEeF5JdXLPA5mmrYHalfT5w7sCuavJ00OptguRFeOIFFq63c0rOZh8jV
g8TFLaV2R3BVYL2Lr2Cc2gmtN+AYBbM9IKzk/JFSTjp5R3N31MM2iL990Qvlj5+N
4UhwyFHCs3KOsaBrWy6eFN0=
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUIMjA9usezqPG812Y++0Upkri/xMwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDLxomVu498bb2IIN/b6aEe/TAO7KlTEHNMSuSA9OtKK9Rn
idxm41gWsyAb5JWqXkIOPg6mhuFCD5Xp1NOO3n541pEbE0P1Bc1XmDyDUq0+VqJp
hoevlCEmDbnfTPpqUWcybpGLeWfteQBWaMyiesi+PD0ABQxdvgDfmoeBzL4QDUhM
WkwHe2IthuUvAwW589PKiKFucxkZnHaZKYAcPzlWsG1+i2NSzL2TbCwFA9+pPOVJ
Aw3QbPmTviIgrfE3/oJbgFY+g1yoh3YALpe4vUjo9g1qW/joqhzLq7ZRMgxkZwyR
kZp/CXFUR4S2iLmU/4ST521avzBi/Mt+YEATvjbPAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBGQ0xssTKZRLCHx6yhG6Wz
eA7v0UIrUUtLBIwN8/EIVuYScv2o29kWQ3ANYhO10Jbj7uh5Pblk1CGkJO+kT54V
Xcl0okSDZ+IEV2D3ogUfOK7KLliHEy5WLfzOs829B38Sm5gQiAG8JdTHj9gPkb65
Cai4YYB2CESOdB16Xa0h0YKwtp+ELgaOOnGrjzUDEp+H+1tL6FOO4+rHxzE5wUAp
uljmdZ4LMqHh9vigEf+G2qpjuQzDgB0yPaQlDNnfus2MkTkyGgRBwPr27bdnNmLF
nJhA0ZnehIuVWm7CVRf1NJD5RbHBqVY3Lr/JElU9DAudrlHnxd6vh1qCquzBoRyr
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDLxomVu498bb2I
IN/b6aEe/TAO7KlTEHNMSuSA9OtKK9Rnidxm41gWsyAb5JWqXkIOPg6mhuFCD5Xp
1NOO3n541pEbE0P1Bc1XmDyDUq0+VqJphoevlCEmDbnfTPpqUWcybpGLeWfteQBW
aMyiesi+PD0ABQxdvgDfmoeBzL4QDUhMWkwHe2IthuUvAwW589PKiKFucxkZnHaZ
KYAcPzlWsG1+i2NSzL2TbCwFA9+pPOVJAw3QbPmTviIgrfE3/oJbgFY+g1yoh3YA
Lpe4vUjo9g1qW/joqhzLq7ZRMgxkZwyRkZp/CXFUR4S2iLmU/4ST521avzBi/Mt+
YEATvjbPAgMBAAECggEAAnGlIMiZFfLy/Pj39lk893Qt6V/pP/fIijezueA2GjOg
XoWGwS0k11Dap7r8GIj83dLcth6UAQjS0XUd/G6qsaRRJTP78qpZJh3LS//n2AGN
/RoB8pciNqSfgBAaSMAlLrOoxzVzi6OR33duTNyQH8f1K1TkKxOmSwg9a88a0HJy
2Qge9vOOGObhuEYJyWY3tYBKOuF/iLbvE8B2Y4Ye4gGn1AU91nLVUNaSf032A7QH
chmBFTGEER3p9vgvZifu5DLcnUIA8vbiBGN8ofiUs9ko8wYEhaVott+B5Tk1WLLr
rUIUwYhJLgbL/lg5zdGlk1U582t9MyKKP+isl5vHwQKBgQDw3HoRigqtOIozmmf9
lxakvsKvPiH86I3vUc/H8q6Bu2mrI3yxR7lsuYe0KggYoAn8DQ3kvZWszbxRGl1k
AbIZqVLzL0+e83VX4J6j/QMKy2s3JHcYSAQZ7nnU1MHVj8VdX5SHwzGcjxdAN9js
7f1tEsSLTfKAHVWKbcaW/n2skQKBgQDYlVdvjjUWhKCk097B997G6eaahRZZWpgK
o1kFru+wZlZyVszzSL1oaJXdg4v1ZQgyJibu3y960RZPG8MT8ND0DXQf7SDIdz4X
2LioWPiOv8kckH1z9AzQnUkUtWbosV53xKHfZiuhNTyjOjfkvVWrDZPO8u0OhZNC
33HDDALdXwKBgQCrKUJlrF8h8YfkW9mCUBf7QsQ+nDyy6N/ULaMmR8LS1kelIja+
FGYkaUOSODxAo5n0z6IL5t2ySxGD4OR06O+TZMxZnElMf13n8OtLRcUfqqaqLPOl
AahIdTuGjxqflOeADygRwhhDVTwEmqtA027AUBHznJSzjiT3lkMFkhvkwQKBgQCW
XpFXHVeUa76Q0Zyd9PcSCYEWlQIgRXq8IA8FmCBHy7WHKuaenkkKvVoXcmZwmJWp
I73yKLhxP8uKXw8AwDiCyPhv1hXluIw+yDPkhekESvlZQKQpJi7jg+AiZZOuSL76
zmVIkkoGYczY0unNgPqCiSmvDBAz/d9xFWuJbMRsZwKBgG0zfPD5r1hk44DpNUda
VwfUXecRVfCMF38N94h+Y5KuuR76fNTEQpv3WLQxnwbvvKsQ6ktM5geSs3oZk57O
ThVwjLgtSZdd9CMp1+sH82iP9kqxCVXNWtwWcoDJ4LCyS94L6OzhA4Vxc0px72Hr
JKDc6KKfmJrHh7z02KlKx95h
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUPBezel0+gYQ75ULotR1tSq2zBDowDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDPpF301kklnHmr9lz++7iRev33RBfOlOugCeTFDnyjgaR3
+PQoAm5yUyVa/Xp8VCe6b8Ksrcj+2xslCwhTtei4TEL19yvybdlQb8ZkZ84WBB0w
22xneZur9ZAcNSx6+SjBVrmXb6f6UA/NXibDheYnGrNwoCJEy08+j1wSscu/9wok
Lq0b/ftD9iHh59xwkuQEm+zzlp6KwdqTKWqzm8+Qpx/9d9yG4EesEGBTq2FIr6kK
BYsVMURKJqmbiG4S2ZDTr2aaVTb3wluV4l8tRPk7vfU8NKJ50/hgIYf5PrjOEN+m
uwlRojkSIPKQi6xWfFaknToV1+BmKPvbjIfRC6tLAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQA4Q1eMPOUARR6xJ9GiU7mn
shWCKbiENr/p16ZjEoFa+uDT+HYkoQc9QnXH7tAkXDnzYmogGnkd/8G0QrHN/812
+yaN2agSlF852Hm3sODQ6VYyP9GjDY5OPTixZ1ZZnezENESGOdrO9FLlJPcEqgLR
MUq82Opri/m3iceHOAz/Zl45dtPkzGhTLwoSmkaBebXPMBfEQyDuGZtahdoHL34o
CKMdDUIe+PI7dKGgzlxTR56azOlxq08U4NkUzflyw8i/lo0nqWblS9i3fOcqxTUF
F0Wo/vgqW34MtM1jmK7J89ob0Shyk4tp+lTFpKyZGYx6gsSZhPsvUKgFaWv5vO7w
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDPpF301kklnHmr
9lz++7iRev33RBfOlOugCeTFDnyjgaR3+PQoAm5yUyVa/Xp8VCe6b8Ksrcj+2xsl
CwhTtei4TEL19yvybdlQb8ZkZ84WBB0w22xneZur9ZAcNSx6+SjBVrmXb6f6UA/N
XibDheYnGrNwoCJEy08+j1wSscu/9wokLq0b/ftD9iHh59xwkuQEm+zzlp6KwdqT
KWqzm8+Qpx/9d9yG4EesEGBTq2FIr6kKBYsVMURKJqmbiG4S2ZDTr2aaVTb3wluV
4l8tRPk7vfU8NKJ50/hgIYf5PrjOEN+muwlRojkSIPKQi6xWfFaknToV1+BmKPvb
jIfRC6tLAgMBAAECggEBAKx7tTC08H41xTx7ojSNlXwD1wOXpM8OFc0Tat3mctK/
1odyXh7+JhEB0H4NIbo1jero+6XFlrld+OaEi5499dtiPh1j/TWc2nBe6UZulFrl
f/ody6cI9a+ahONpqFFet+QiznhlX/wmlXnbRAgXKmBBZd2gp9bNrD4jiDBfUQlc
BHZW7c2hK3oOjzVwKU+gbf/agyccemYBdtqEYPsBHjRchZc/WD7Zt5Xjx1kUhROB
jqdKLiVQrD7Io9XaIxhF9mXnN61FCu+9GrDRy8RYsz0eiZqeRhIkqKT30TDyhWRR
eKTdEbRMtMCMKm7iQHrYEcCUM/wNE4xTLNS6Q9v1Z8ECgYEA/QHQWSvZJY4uVsDB
ocDFAv+umZh0a2XDGHIheCncjuusrt/pWm7m5Sh9zoXQE8AWbTzM26lPAVfCmlhX
xyrWtkiorP+WsFg5D0PJJO8pDw8UDU86pobp8alC4w5LR5oUdYWrvUPiI4J5Z84h
VYQtMH9/F6kExYy3XItkfmQW+T8CgYEA0hksYzCqfcdDjirSCvyAgc2fxyQPfu+Y
VeEZuZXQI1Ar3VQoJe9CwAAAbmGlI70CQb3Ux7nWN0mR1IIPxKbjElCAb2Xd5kRP
IIqekROw47bU1fAsusCkTeuSgt5eXUUu86LIPaOYipIFKaZBCTnysk/TSbx1vESD
v9q2f6v2XvUCgYB1Dg7IAspvXq2/w2SSoq5Dqems9GUAf09ZEwy7HJsHoK//JGdB
SMgYw7gZAb34NUnq9lNNWbLMyz6kzDSoWACIy2sGxyV/pwGXN2Rrax8S8YX0dnCL
NSYtgYMJq8ZWdUn76YFAipSomyfyR+MSPpntsz8owjEL+QOolHFFLKeYXwKBgDWC
Ccb9Vv6PqEnl5/a6VjQ43U+HhJbMiJyepsGYQRktSu6kh1EZ/YMOvQ1fuwI+GfwK
T83KK5+LEiPwN/nakwxQClXUuM3zab+c7kN+o1drcgtGju3FMFNUAs1nutrASvPr
6lmgd7Ia/EueNwQViRUWtXYbFFUtkexj1ITxk96dAoGBAOay9hPJadTnl790s/G7
8V1XGsJYc3uP62FuhmIr+Q6cDJ/yNzdO3GTTx7Lk6Avq/phmbexvGBegeMgewFrt
hQTPDMMiZJv6NsZMJhmZeiW/QZdZxGMQk/051zClEQkzNmkZn9C1uJPJfEcSTy8C
Aa6vQcrVIKjpEG4mO0rZeSJc
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUePevwBw17O1QxSIuitVeEUltmhUwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDYCl75++jqmfKWVWn7sgEgX4IsHVVLdX37I7jnY4nrpdND
ZFHl+JIUHeMPzlnlEHBZHn4yoimLXhuia8VPrss8YH2WcaKyxuTfeoKjxEbs8oqi
rbjkmwTN8SkcMYoO6wXJqBPZaS2L1sQo2HJGPa7l0K6KjDdepuVJiEuoBro5zHLF
Le7g1V0aRHbqDGB6WjbgFh36Jisw6yPuNgcYDDl6fVWN5PT/UxOg1qVNrxPmNUrg
uGlZsCrI3/UwK/cxEv00H0S5qUcLNMb/9wVAvuPhG0UoTIkFPxelB5hSkhujaGRa
5S9N4Wr+k2dNMtdO1swClRjWGj0skG0DWiKb0COLAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAmIlBN0D+64rjkWlN5bk5L
7MVKhgRJmhbEgHW5JmbBkAMEUqf6reyuz+L0TbR2yAkujw69HTAMNvDuvoNewa8Q
x0qtlTJLOgYz/D1lS+Ti/EHcmkrHIKK9O+lBin2RpPoQZHaYLSpRXt1QMqmfn/ct
9Jjx8AnKzTC/nOGDYOYskkPCiQ7JIaVyNFAmFBNoQHVlztDw6pR/Gpnt/jJ4Eyz/
JZSXHTTfqGm+4rRDfwM7yREwoG19ab6T/6Cbbfi5BbalJG5RqH9V7gLQspQIvwlk
ByC8qnXsqTu5UNh6GweiYWSb4zIol6a6i1SGY4lZ8ejkQKezCX5mU1GKkZhX7rOw
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDYCl75++jqmfKW
VWn7sgEgX4IsHVVLdX37I7jnY4nrpdNDZFHl+JIUHeMPzlnlEHBZHn4yoimLXhui
a8VPrss8YH2WcaKyxuTfeoKjxEbs8oqirbjkmwTN8SkcMYoO6wXJqBPZaS2L1sQo
2HJGPa7l0K6KjDdepuVJiEuoBro5zHLFLe7g1V0aRHbqDGB6WjbgFh36Jisw6yPu
NgcYDDl6fVWN5PT/UxOg1qVNrxPmNUrguGlZsCrI3/UwK/cxEv00H0S5qUcLNMb/
9wVAvuPhG0UoTIkFPxelB5hSkhujaGRa5S9N4Wr+k2dNMtdO1swClRjWGj0skG0D
WiKb0COLAgMBAAECggEANoe3nWWmTsD46FU64Rr3CdLRqozk4J0RZXiIzW7keyRq
BNKnkWKCjK1WiMDPE/BoSzZVKDaiQdlJJGALd6dpCR5Z1MVuCa4GSxpDK075kAlQ
UOuEhb9TISBD/ifK7yUHWvUfvXq80lUtQhoQDga3xK49wB7QQwXhTgQnBIxeKQQo
uB6FocwUmnA/Wy12PebdvxnbPTYt4I2WGRmLp+jceYUmn8y2bNx040+IDd438KqQ
4jHuGqa2inpM1xVuGHvKCKvxt7THy4y1GeYDuaSTNPt+ZOzMKj+8tC4tdIiEIzG9
4ctuMBHf+Q27eb6DyTZ0WftTmXAH/Ii1mkdQZsz7EQKBgQD/ywCbUhDqGmgCQB3W
Zdno6goXP9VPemp1CLyjANMm6+uQdckRUfGDSpP38SPLDvjVjfypItSRwEqzsOjz
9I6w4RrRZeftnrIDnsAaHK8x4NLOIsN5uJtHYEaRoaVQI9ja6vQbhNVt9lGIEIO3
/bhbwyILEcxCo2Fzgt8HoZKWLwKBgQDYNyHg0MKtxLMbkDLL5JIzMEXekTC2tunQ
vylmi1hT29SHs94DiHE6qrCQnejSr2TLitX+O20NLRfCDF2U7TCY5CY+V/T78fdJ
HKO/+AM9WggYbWPmrL7xexdbBeMomtye1Ppk2uemkf8CMH1ERvaMeAimIRpcRaLy
pXQpZi2NZQKBgQDlkIoF23wkrfhEdMiSfyw3dbwCq55ESyg5ytKJNBdM6hSqvJrs
eW9YFll//yHRfqlh96EXJpRCDqK8a/xV3Vkmc5A+98dTocY/q3zasn2lNRHcQKTQ
nBZ303biAoG7z8AykQTtoaRuoM8BX1jnisSnThRCfQGlmL3ADmcdkSterwKBgQCl
1muyvwyDMdra6lg70T5d6sm8c4p0qoleZjFACOMftv4lc8120kFe6SryUVwRtRvP
jtah4Dy9nXeai9d/cgoTSvMWYGp0kFvGhSQICxeZCCQrcEPu21K9b1czpqlcLKPJ
Y7wGfWyuc06wBDcglnlmtm6T1dIdMgBQsp0NX+TSjQKBgENTh+6BBRVwiUo901On
fxDPNTvQwk5hiisaeCG34CZ1qFbscDcOQqkwVoE6VmHXIvCw/7QLU9IVOrdf/xY4
Mcx6O9KpVnvA8ZVFU0051qh4HTFltGml5p/mwFly4SiM2M23EXS4N3cZYa5kQnp0
NMOSFFplOmKgVLmjr7ecwHHz
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBqJvyp77D14V2vRSpQEMvr4LaOYwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDaaW7GUi71V+7SiknlTlrVQBokOlO7l6AJ8gjq3UOvYs3c
jd+XGO+hG0QpWhGMFwAD7Vfw2QLqA4MmgkE3xFvL+YadaOI1SkyoLMj+gM1W3NIu
wYn3dWQiB9i+u/Z5nv9rOYtfJAEllQLxY3j+7B+HQsU2bP0oRdUOCgDS7BR+SVuV
6f4YkHxxdcwW8AE4fyqZ3R/ZUXi/Op4H+/9e8nqGPFd1TkARJtXErvS7zRwF7PT+
h0q3m46OyYqYLVmVTAHCNWgDJEnyzYCzzocixe/9EBwVcqE/DS0h4yfxwmJovhWe
BMg+M+vaBQYOtz+23xbQfEW4/dxQecl7DKqmfCPzAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAD9AGq5YOxEAr2veRCi7n3
t+zdX1PCsjIyYRPCsLpjBXklC8lKTUK7QI3P1zAZFkYVxGGn/YZf3gVUMNufFc+n
KY9glRor3qH8AlC7dhRkwj2QOkIS9442w9wgAiYUdofsY9JLV7gx04DK4UuBWuhZ
usDZo7sw6IlvynHP8KOr60SLMlgXb4uKYNAokiC14PL4kCk31i8XaXPqcgvx2WLF
8z5OqUpJrcoIZPQwkAI7ajD2crsJbJ1IFv3ZDNTXfnjoGJBfCtWLk+mkZHpimMBH
7bEpyOLEL90M7zNkEyGmXN7HcxgyLY9LNnRoDvHTCuYMDzJEeN5EBJqi5lc6S3LD
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDaaW7GUi71V+7S
iknlTlrVQBokOlO7l6AJ8gjq3UOvYs3cjd+XGO+hG0QpWhGMFwAD7Vfw2QLqA4Mm
gkE3xFvL+YadaOI1SkyoLMj+gM1W3NIuwYn3dWQiB9i+u/Z5nv9rOYtfJAEllQLx
Y3j+7B+HQsU2bP0oRdUOCgDS7BR+SVuV6f4YkHxxdcwW8AE4fyqZ3R/ZUXi/Op4H
+/9e8nqGPFd1TkARJtXErvS7zRwF7PT+h0q3m46OyYqYLVmVTAHCNWgDJEnyzYCz
zocixe/9EBwVcqE/DS0h4yfxwmJovhWeBMg+M+vaBQYOtz+23xbQfEW4/dxQecl7
DKqmfCPzAgMBAAECggEACByWUqNGvzHu2r7sE6ofUYA5+FJ6PaNZ/ESS9DYXh3IB
90kFntT8QV2D4I1JzYwlIgA0netRYmOTAWEhDvMp/Z9c0ofMrvH9etl+9YTPG4TE
AZyKhThE6cak1CCi/M1c6xyOApCRwlWQcGqjWcRnP1zJekX9+Pru+MCCW1MNR8tc
GbKZ3IDBp+c5APBiaTofBtik3aAylE+ncrSIjSmygaAk1yysGg5cau35enA26nXu
easYo4mDdSGEnz/SkFeVe+XWav1+Hksyu1W2AFVq9ZJHrnH9TuBnwW/nLl3NoSoi
03wgLw1gWvZKPopoqNh1rfGARL74CdyJvbA52iTy8QKBgQD1q3lyYCCL7X2JGsKV
7fV+lHA6V4YCIQlGsBilfDEUErTCATZZZA6RMAjmm26fMNWySHl1lU6n83rTcf1D
r+S3hPA++CmAZez2QzJJjTb7/Kth+Tu2yIZbIlzJMLp7Ef6gLFy4BHWydOgSovAr
uW+Py+YbbFKTIEd25eYMOmr11QKBgQDjmInVphJQybb07U6DT/Nz9yfuUD/6PuDN
GneEnpMoQgc4INg9ebhMBIPvXxYxqkzNYEZiopmTPS1Lk/INC0BklogE/EOpzzXW
HGwjtMB15VaAZamVmXm2P4IZGUaW4dDrSB3lZmJcsuA+AlJqhgwvd/JHF4enVtdI
CogPjaOupwKBgFFC7SMmJN3kKrglP+Q0GBZMp2rE9LDTmKvnJ9/lWp6XKW9a001y
SVdBGlCdbVP+5VDZpEN+pcvsP96dP/cZwX/q20UY9TFhhaZXx9SIf32OsGnx9Qya
+8Y9cY+jLKv04dK9mdXMs9nZzcIMX4E3D23zNiQwCohcDweHODcnQ6YZAoGBALXy
M/6AjRPYrlKPg7ymJdIHO/zgWsULj1toVTPIMYx1fJ/6YeSDcjoTQgYS1gNOSafF
137yziNPPO62j0KuRAQl8wdJRC50YG2Su0CwN0wI02ZB35ig4RQ5ISA/fJcSX5o4
RO4nM2s39NydrpVKJGOuWBlNTj0Qx3noMW19peTxAoGBAOchIvJsdoRIOAUsIyym
QcRGHtELfK8tvSpAubFYYI8fhb5vtmH3LdNrZvmxqJa9di0YRDVCt/Cfq+ZyGruy
buKComyjDK8l7hyjefunR203JcmSWnWNtC97veGBZJeVmzBM115zy2djcaHpSYYw
qmCWX6bxt8M+lvlNp/Zh8Hnp
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUHjQDXM3yOfjn9cS6/zkVXNvAcPYwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDlFI0WeUh9oK/l1+Kpa4JzUd0pgEWwyCKrtaDIMzuTPJEB
XA7OVfkemL9q1UAZ9FljEYXzFXzTk+OXwN3I1S4lFgitdc8xBQLljv5HelEq5H0P
ypUAE+HELxFQ0uWQqLoNvIqrEXh12mgdFvyIqyJj86Cvqv0J4DOEgtsXjxGYO+/4
ioJ+oO0yfe9BbL7rED+gfqUKabloEeL0s51sWrqlMOyOyq1MX1rP3cMmSDjQFcfV
AqY1IF+dgzw/WXbUjvFJPO4IN2lY/v5x9N+i946k1pFvecfXIseyZRym41kpP+Xd
JwxPasgMqcT/3d0BAaQCGpgNkpe3etisK4+0pXp3AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAcxIApP9qu9aa898tHtK5n
bnG1d5B0Tktv5BXkwS+BQ8uytnm6QtOVe4frxUdKUJEK3085Lr0B/j3bJNyJ4m96
fjpjScWHwk7N0egLq761XyBv7D1BjgDAsAYyYNOA4mgBqzfrJtLoDjnf8SMKpocr
ZLDXb6Qy8LGj0D5oaO3kWLzhWEdhFBcEVN/PnnBcuj/vT+MhhLGGJJk8WMp7dajB
I2+E8WW/RxHoXFHnmF3B7TYPhcEZI90AxmIWGnNW1cLArrvnCodpPvc03om+U6qX
kkNKgCYDEIJ5dTJWyjA+hwB6XjRgqshNNcc6FwXb2TAyQm8JQkIlRX4R6bjm5KEr
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDlFI0WeUh9oK/l
1+Kpa4JzUd0pgEWwyCKrtaDIMzuTPJEBXA7OVfkemL9q1UAZ9FljEYXzFXzTk+OX
wN3I1S4lFgitdc8xBQLljv5HelEq5H0PypUAE+HELxFQ0uWQqLoNvIqrEXh12mgd
FvyIqyJj86Cvqv0J4DOEgtsXjxGYO+/4ioJ+oO0yfe9BbL7rED+gfqUKabloEeL0
s51sWrqlMOyOyq1MX1rP3cMmSDjQFcfVAqY1IF+dgzw/WXbUjvFJPO4IN2lY/v5x
9N+i946k1pFvecfXIseyZRym41kpP+XdJwxPasgMqcT/3d0BAaQCGpgNkpe3etis
K4+0pXp3AgMBAAECggEAJrHH+ynVYtMHoy1KLg/o4w3K672tB+VmZdayJ97vizlJ
zQ79uUCwacinXKZUw42Qo7lMBPl2Mk7ivLlpPQk1WDJWmOYzbzZHfPsgXHZ+y134
+ffgHzk8g2Tn6d0Vxc+aTcOxMKAs1stjlrZRRcySbIu0crfRMh/a0+E+nMYf1LTJ
LreWGqApjkVK/lE4DyA/GJfJlNd+fCWVaPRwBVtI+PZmHkl5adonnNyQ4W7bxJEp
WGrD3FjHJ5XGL/dIA1JfkovpjRJQNXY2PgFiGCp4X13wc3V1RHk4j5dTxGLaVFLh
CFp3Xh9CmzuYD8IarLNrqg9xo9fokatGpYLzBch+UQKBgQD/38KSVwvsD/X0SFxB
niTVZYSD/tA98xH5QJuBhjnCHpedriJ696QVF5ncjLl4C1N5c54OW2Ra7T5T/WcY
RzY4x52MntG4umd/R+J7rcU/HLSWADn3vpQtuMqAaRMx1C0iuSsER9zdC3//yIYi
Pj6Neb4CrDIRQdj60I+g4yOFjQKBgQDlMWpCtT47rcYQ/1mC441tctP3xlYz0oSS
RsKRbYWbC+i+GH3WZjl1MjmvbBlLKk4UQKUDuovh5jkGpo4kxUFX3dAgf6Wr/+T5
ZqtjCw9sxCjU4AL50OcaKhPlR1OVMqJu44WiinoPNTDozFwo3blpwB1pUc0FVgvd
7qCvNMYVEwKBgQDUk2KDz5uRCAWPaFp1DVyOiWOZgaYiAYIKMNnAtvHfSyktD9GH
lZuVBmGGcMdZaxdzjFFgnh72x6kDgEAZVHhAnd5PSFb2AK8heGg51jlL4J5LDG8c
WxGiFqbuHd2bhSnmci3Bxa5BWl+B8mc1pb60LNNmRwblfW41mfXpdSs6tQKBgQCs
+7bv0ku+T1IG0jOFDqpXySsi/5dgVaupm66OhNMqSrrHf0S65TzIr7fKJxSQHsX/
kyr4vXuGbHTuCBeQuTCwWMIVRUKNpv3zHwKMJnTl6sfGo6ybUIicvtV1X3g+S5E9
kIv0OgAWKldX3aZRUcf3gQCx1QOg22jpgInWs0Yt8QKBgQCWSBr4r89eX25a1JFR
Q761R1Xr2B+VHRLlzxnDHuqLzuebxlYErYy2/gpjQh3iuGTdtXcviKIvlkZb2BoU
/3QDs5Hgwb99YJv5SxNzkbu46qPsG873wb+L8OOQ4HneLvzovfgvHOFbs7/xeUAl
5UgaquXT9oLVfoI9RDSReFiCsw==
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUaYsQ6TR2c6krUj5rtYG1fdLox7wwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCyZrrU3fBR88wFzlro0PddB8t5ILWZW5T4BqfGtJZUXgFR
wC5beEeufrlXk16bFIxLV55QWEn9PUIn7W5dz6sVmcj82/v52QOs0BctIhkc2ZIn
fj3++1C7hyNcYVAk0aPWXLvSnLx3jY2qGunO2vT13APoi00HeBxYv66ac06m2n82
xBQ/pZNWwCg9XRjPADDk9c6DJTPJGHgeeTmXOAI/obAP5V0FnrkPpC2lXXWdXd+B
Yco12V8sEFxocUQrRhP1tN6B9Aw0w1qTrTdD1jBF91zE+OCeQ+lgupGMZG7LuvOi
wvKocJugWQA3PoblbM4NYz+Q1QR9Z+sjLr/SdRLTAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBs4EPhrB7jb6BH6cMCtKTr
28TcvWfC4eBd2NZKCI5ZsyerfwjIg1F/G7WgmToNE+FR5izQISSTzwzZhbEQlrt/
+bUeuUWHM6wk7on7cmSw7qVt7U7yRBFW5DKVcKKjO7s2Bs5JmVH953RTmRA7pM/0
khHIqJL6GfpxeD4zWO4P0Gipxr7ugqKNTViqZQOlIpj1vZpOOGWSpm/oPmp+XphI
TiwUtjaIW88JOy8oh3v6vM7FOxiAoqVhnkk7jnvYBR2+zrglMY1kNz/xQHYsBBDt
b+RUdVHiPgcPvlD+RhNxhqjfCeoAA8BQ5w9AOpum473CA7efRTKhusjP3dMz7hop
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCyZrrU3fBR88wF
zlro0PddB8t5ILWZW5T4BqfGtJZUXgFRwC5beEeufrlXk16bFIxLV55QWEn9PUIn
7W5dz6sVmcj82/v52QOs0BctIhkc2ZInfj3++1C7hyNcYVAk0aPWXLvSnLx3jY2q
GunO2vT13APoi00HeBxYv66ac06m2n82xBQ/pZNWwCg9XRjPADDk9c6DJTPJGHge
eTmXOAI/obAP5V0FnrkPpC2lXXWdXd+BYco12V8sEFxocUQrRhP1tN6B9Aw0w1qT
rTdD1jBF91zE+OCeQ+lgupGMZG7LuvOiwvKocJugWQA3PoblbM4NYz+Q1QR9Z+sj
Lr/SdRLTAgMBAAECggEBAKQ1QLUcj86vK9UQSsdPSNCdkyEsBVtiW60sWxPgNxry
6B36WfEhtkEcLbc5U3RFJplWzcbAbWImF5Wuys6Yjq40PjbYuYcQxHw1kY+eeiT+
8rNdVO01H+tsiRTIEb/CIx71foBuel9EsOepHBqlmaIP4J0UU1OTr+vUi39osTWM
EDWKS7FrQPGwpzdXwQZ3oDceUbaS6ydSbJO5lyalqXjlwFviV83E9vfC/NjBy5a4
sZ5NaRSE9IrQZ6kpZ3/UDZQ5vke/xuiDBIiZIO1JMlzzb45D6r3lIJ2iQLT4OTEF
Yy8is05IZUpCGmuVMY09lgGSxD4Y84+Owe8EmEk1uVkCgYEA4xpIkhCkHPMnyL5J
3h0XZjbJ4UfwjsLgQhGeSs7AGT4wXiPjL78Qn1RJNXqafTX4+NgWmnYTa/DOV71b
SZtIqsoZtKDgsIc8Nb+MyvraDKnbXVeyNUz/80qHi8tYxWp+6Sortp7PO/j+V3QH
3faHw77J2v/mogmsWgblohc1BI8CgYEAyRoIGMofMFp/h7TkIToS5WEbFFWUC//k
0gtAFbGT+Vvj6ATXIhNgJkgw46ujtGLPQzB41NjGADOaLWb/anIQegEfxKLzOJsO
C9agsLPEdRlZgFWNFBKdUBCyFL4IYWdRVeTuhy3EjFniwXRV03ESxDG2ZELbVvqX
anebLGHHF30CgYEAmRPrXMFozba811wkkFoNnrFJjNef96q13PLhPs1zwNAhbCNG
jLV+L9dxbWHR5ppN0vZc7gqu9rAfdhbGBKxt4+lMQGu8aGEPna8a6OsDtUt8+MMW
9USMteJD0V/k21T4bJQnWPZc+7DPSAWHE/+L7c6ZY0vgmtJoYVqKyKJZ81MCgYBA
M+Jf36+jZVEPx02J2huMRbs6e7PfPNwVvue/xUjDtHWHbnwscdkhf6y0EukZvu4C
umfpNCfKiq7vTdG/bxkZimBVC9zwtnf+iZAVud6/r88mLKn0vZihpiLkgmL0jeKm
tIb+ezsjv9KoBnccIR5nqqNbUQjrtOdAY10UB0djlQKBgQCuSh+3J7rnwIFDPBeW
mcaz06IyQ4PkBp3HjYg4rAHqUxOVl9YgXqWrnOO/slPeNHsI2YIRj2jEp9zfoYc4
uDzbX6GQcfQTbnyvRMahuXNPIEkhZgNSfDgxkdztcjBqcVfCkiMr+A+fTG1WmHgm
ko9Nod4+yQCQ3iU96D8q0SNW3g==
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUdIXMFTtdGFLVnK0Pm2qmcKCMWlYwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDcyOTE5MDgwOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCe22gtTak2xx5y3fPpK9vwCsVWGODc6AxfKo3cGe3Lw7xu
e8R8QPUCGEW9tzGwLvVuPzFnRgnMC+H2sGzh7eSm6Q7+3EyllNxmcVeWcrVUQUZc
zxV+POfQLyWbMzdY90HJRrxVXhK2U5fwYjzvZcjFVm0xwH/tWiFEXRZX8oMP0Szz
A0IwirL/pJc3Y+yvu149pKiGqX6m3id7S5jC6O6Q9b68iBurj9Ypvl30pZbuERTG
uOsMDFhIeQp8imZIqBBXSA0zJgWbc/cYhVkOY9D2RdHf41jqQHDab1J+Ce2f00I0
4OPLJARHVed8XsKD+yjiLQxcuF3/hgSSsQNBKLZ1AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQA7j2j+OoDypCwsAdu3I5le
TezpdosGIbOC9Xcpuu6kjJoCVDbALWNId00pVc7TWLiskoOkaHVsMh/Wz4KkRnah
eNsMM9kmHWLhv+zdECFIbm9IOuLgnbVkwmTaCIhDur7vSPDbwLrkU8ppk9eyYdEj
hl4tnpH9I0PY2GOky7POSgV9kXMEuoW+uV/i23GiBGVuyrklgDtaUXoUuCq3cI4Q
dDz2c0kOQqYlkyanIEGLXalKjaSc73z1bbY2Yqe0OXbwh1qxHqW84gAd3WiK/TAV
DToeMdyg4Z07yaKBG0n2Za3tcNVSH9bVF3jIWvIGyDNq+IRvevPZbKQJgy4lZypZ
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCe22gtTak2xx5y
3fPpK9vwCsVWGODc6AxfKo3cGe3Lw7xue8R8QPUCGEW9tzGwLvVuPzFnRgnMC+H2
sGzh7eSm6Q7+3EyllNxmcVeWcrVUQUZczxV+POfQLyWbMzdY90HJRrxVXhK2U5fw
YjzvZcjFVm0xwH/tWiFEXRZX8oMP0SzzA0IwirL/pJc3Y+yvu149pKiGqX6m3id7
S5jC6O6Q9b68iBurj9Ypvl30pZbuERTGuOsMDFhIeQp8imZIqBBXSA0zJgWbc/cY
hVkOY9D2RdHf41jqQHDab1J+Ce2f00I04OPLJARHVed8XsKD+yjiLQxcuF3/hgSS
sQNBKLZ1AgMBAAECggEAVS/DRcgHneBZa6+qRLfIUYj1GZ5ttwiY2c+wEv+0jTiB
q52jWB5dRKpPe9TpSFlmM6CflYnxZwJYQjmJqf4wR3FjIThxwbl6F1VgasVIh84Z
NVu3YuK2TOV7fSaR35t4I79S71RrJGrfZ4DGvHoQmAIovC1GbLmQbWCdwrvBnJDu
ypVp+EjYXSCI8HlKwntBigsHZtTmrqqM4JZIEQYec+ZlEYP1BLn9Vb264QjDTXoT
EzCtgEhOGtKvSbGUZk0Rhj2hP/LDRZb/wMkvbMTSNKOjxUoXJnbCzglNdo76lWbh
tEZarrK63j5fgsklnfWZfDcMLI5Eckky6JfGdt5vAQKBgQDTeGoQ+ZIj0TX611N4
pVZzrAyMsx9EHGb56ECrJI4Y/jkkPXA6+ySKzTtn7+YTWzl8raO0JuAJZa9sZzes
6RL5T9bUV/JrxoXtWDNmDh8TQSHos12o5iADUg/MUcEAxZLDqQ6DSWgLPZLEaAbM
GLU04eT3j/qpAqN30BAA4UBO7QKBgQDATs25AtpeTcb4F43z++X3DyR7RDYoGaMX
WVPxAOkHJm1mv9QsYf0j+EHOOd4xa1nkV0rwQm2lSMMiN9C6P5Q3lJbfA7s9lKLx
C17xYl80hMnB1POAsXNI9aqOZAVvWwcooGRrqJ9KUvIuUWkXpFveT0xGMLjr0fQr
T+zU0FeMqQKBgCYav3n5jnS3wPNHE3pcyHwlV0mPCSY7u+5yBB0ShCxKur8l9vAZ
ytbb7kVnO9znBi/KFgJjMuFemkJ9QtH8WXflA//VLRBwgDdpOjG8f6r3hIWqtEi3
1rLieYhGfvGFqFFrR/suIfpMiQKs//SMyzIRNjHJltAXcp8nNYsDC5RtAoGAGF6k
IUrkQ0kV6sCJY57LUJihpeFJ/6DoEwBl68eSwC41dOzgRVORkapXJHwe1SJmfNI3
E+VHIcfrun1aPQ/rh3OT/uTpKG+ainNHb81ohS5CpwaGaQuTsW44U90G90qQyKwy
rZXrwa5rNEVqzO0uGyjvYIGyHWg4yfhR6dIRFikCgYEAj2577x3Vb54G/wL25OJx
r78VzNxmlOu8qxrkLgylhLsnZo0dRgCCSrkYx+bM+moMIM3LnG6lN3IPYA9MpTgx
G1DclyXyZNuHnHim9xz7dzJ/HwYJxVulHM05KbaTQ3xYMUdpAXaM04Wv9kwpeDX8
axack/6KTJBo6FRskxPoH4U=
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_8: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_8: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
