from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUHoeobLQu3yMmraIDXDF+F6M4j9IwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDMyMzE3MjkyOVoXDTMyMDMy
MDE3MjkyOVowRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAskK29xVfnH/4tpM+loZOOZX3d0u/NARRkgnPeoTs14M0
dKP+dZ+FRuuqKmJQHuO8+MFfeTFIiI671rWobtdGCXVD+TZ3g4btdtGdvPjIBXJs
RFhYkP/fIjzq0MoJ9O6qlhXh3skispfHRY2ysVHpT4d63tixhycDsMn82Jh92OGm
BaO8UpjIk1twEnfxsKm5MtPbvNJGVzAkwYXWVFdV7GdEYCKsVm94Sd85TpDg0xFq
q5YWOg5mpFbGAExBjFerHSuVBuNsBap0mjL3aIb6MXvQeYp+lKrzeUfkUH06e/Pr
AY+TQPO9ktcUHHZ8+HrXhOODdeDlbC8mWzR9I59AfQIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQBQ/s/lX6Tbdg1g1FIShK+BH+5q
msfNkAQG+mXYGbn6SYQQspYFZdZp4kXLdSKSjok5eWoMnfYN+hy29A5HgeJfdbM4
4Nmt5OUvWT0EOTD1VtdVnsH8tac5Q1XevE0ZK9DXYBSEXqO8sVSt6VWmNT98lmEZ
AVWtawc0zt/31QAZEa5Jjghq/HRbIi6KUX1t3Hx/yVa9Uxiz1dBVE8A+QBwVKOzv
egKu6T94xBCcOeOh0NgluRdFiTr9cXAYNQAUM+WdmyAvFZ4qwuUKam7C7zX+td6M
r80F1SD8qbQgxYS1bwqx6K06xbFRLXpWbyHXG18v6ia+sifWblg6JQnYhxZg
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCyQrb3FV+cf/i2
kz6Whk45lfd3S780BFGSCc96hOzXgzR0o/51n4VG66oqYlAe47z4wV95MUiIjrvW
tahu10YJdUP5NneDhu120Z28+MgFcmxEWFiQ/98iPOrQygn07qqWFeHeySKyl8dF
jbKxUelPh3re2LGHJwOwyfzYmH3Y4aYFo7xSmMiTW3ASd/Gwqbky09u80kZXMCTB
hdZUV1XsZ0RgIqxWb3hJ3zlOkODTEWqrlhY6DmakVsYATEGMV6sdK5UG42wFqnSa
Mvdohvoxe9B5in6UqvN5R+RQfTp78+sBj5NA872S1xQcdnz4eteE44N14OVsLyZb
NH0jn0B9AgMBAAECggEAWbuXmp1Zuc/5hP5t/RuyeO5y2cx5fVfHL/pcRNJw3rOf
Ti/XQaKBVof+6sL+je4aDCZbRwh1+LfQ+m4LUXBwQwaSpvqyArWDB9LQ0nVxSryk
n2rRenwy+Gst0NhDVtZlbJOrVZhuLPSWTP7dOsF+7pfGVDNEekI7a1ziOK3ae7eT
3YjwQejyxE9wWyyAQfsl0WkY6b8boBNYalSZIllPEE7NHmKmtHweXZFcgEMZepUp
cCksnc6VyFI6h14W3aHt9+I0ma4Zn9yfGzTTl5fMiDTMnkJ9+hB07mzrdI9GD7Hw
74v6E3SToqHkKYWkByfWPNlq28Y7jud0FTGRLKsfQQKBgQDZrWf7zjLoDfks55S9
MTSbdz4NegjuOXrNRJ99cnk9UfuUqujaGrw/lMMbY1X2oW/goUlXLyG/Loh7T4dM
0/5BJQHYu8lKngaGVA0/j8nqhjg0Z+hx9sr6tzz+MRVBqjJKrU4MtyERrEyPCAo5
VxSqHq0JCOJNnd2qlm7BQYAuhQKBgQDRpNFRhzKcFY/K3k5P3wSRVfg2742o40DI
qUNgmpTY0c/jEcXFU8/BhHULi9kkSYLXPcJFp36y/AGEJeyHniFMGFmQX4FXyWXj
8GqK4eJqoX3lVHPwHjCO/7RAo3V8JA7hFPl0SpsCQlg+r69gIl7DeI9Y4MuRor8H
zJzWFDeXmQKBgCRiEYFLA8M5oq5Yvsmokcxyb9K81QVMYjQxBh9npNAVBeHhdy4N
Te2qpbnMLrAcZ6C6FJIX9KIJ2xIRRuIWhObKkrZxHMH2C80j+1rmY69pY7eOrpFt
2JtzSSSLe6wQEHve367MZSCZFerKQzs2TOPqYK2j6H9kpYo/vp9anVwpAoGAfYoS
Ip0wTFGJGvXGtYOaS6HMkrEfBmyXpdHeXCIVUkVKFPLWmJTYy0yTfoePT3CJ3nTI
OkfT0kCgc8719jxWOig2sgLPBI/A6R9V3bboi+wK5OKOztJ1R5yOB0sbFmzNUDHs
M5xdeJvcFiXEgm/yiWFPjeyHWr23YWdA392ZcLkCgYA3mSWtslWBQTyRGKTka+ly
hqzIOS0lDwooMPa79MORFoIl/ofRk/XjloyTQyDkMwbkzz4RvqX6IQ5fWWusncQ+
1xCtpSIUA9cXyyVuhSzuTkdnqtVyQeoy8EJlMDF8h1H3R4UrqrQ9NFgfZl/Eoqk8
M5FC/O3n2t4d7G85VO6jOQ==
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUFNReIWFnacmYlEf+oXKER30rJfAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDdivRLL/onTCvG9JKzYXCxW6hrwYRgmiyG4ISrIWlainW3
ZCduM13t4qlWp2lVYCIez8K3NYb+m9Jk4tYJujzU9FhusvAy2D7SeGJGkAvDuYMK
LCRM0m3/Q0fls0RMHyNd7Csg26LNyGukdvEyKmonqA8q5MZENtsRx1tQtHORLlio
kEXjyd67J1wm5m4rOk+DqdrIzSAuomj+M/D1lRh0icjiSE0Wm9PXJllzSp/JyLqN
AMIDIjkG5CZc7cD2yM7OZQ+haCxIbAmxzyWVhLeuGiTP2qZ2ZRML2HXGVkQfbE+c
vFkPKVoY6pOI0USzM6ipqmYO9Y6357SIeSWhNNG1AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBGWHpJNp8iDR5uy14qFYwY
1wwIvQUem0IYADuTXIP3Y+kSKyZpuZeYWFlKzrfTf6wTlmZchcqpidUfkqPS8sFL
4LLRlDFTCWhIiBSs25gLLwRiMTErStedojGS9+smMVpp+/LguAp+kR0zyov7+Qe/
05DW/fgtZFZIuDa9DX2aLcr2LHLpQU2+nKFM5E4dOEEwaf2rDkpqITME00bZRipF
yytQq6MIG+W2dl48b32B+VhU3UtjeJ4bYDY2BUvAoI69XN/RWO2JVZqEcuAKXjIY
m/+snrJJ8RNATWZ0XgFUQ3UL2j98qHwY5XtGNvLfkot6EC48t0jmuPICg/mTxCPV
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDdivRLL/onTCvG
9JKzYXCxW6hrwYRgmiyG4ISrIWlainW3ZCduM13t4qlWp2lVYCIez8K3NYb+m9Jk
4tYJujzU9FhusvAy2D7SeGJGkAvDuYMKLCRM0m3/Q0fls0RMHyNd7Csg26LNyGuk
dvEyKmonqA8q5MZENtsRx1tQtHORLliokEXjyd67J1wm5m4rOk+DqdrIzSAuomj+
M/D1lRh0icjiSE0Wm9PXJllzSp/JyLqNAMIDIjkG5CZc7cD2yM7OZQ+haCxIbAmx
zyWVhLeuGiTP2qZ2ZRML2HXGVkQfbE+cvFkPKVoY6pOI0USzM6ipqmYO9Y6357SI
eSWhNNG1AgMBAAECggEAIeOElQ/Eu0gqlieJXUk1fNvheoJCpqhO0V78zFSzEfeG
JER8x52x65a1gpzfPwESlxX+2hmlCcN6PpZ4WUqUzZqHAH/8wDpV+coSdmrIcesp
wV+ZOesiil6XW+q9Msu8lDxxKHiQgdv7o0/Se3MDhAdwMoaGUZ72idSuAj1oRDfC
sdm8KHLIBXw/+zFjYix45/k+Qn98Gq20Y9n1pF2nO8wLJ9uHKAcBWSW5x5+5B6Gl
zZ26/oFTAJ3UeAAjBnjaBpNDyHxiHZLEOJX0MqSRAQmgbxldgYd8qleju75GBO2k
w+ZGeWzm4i3fioQJEkaZevWkL2IHHWhEiLpB2ejirQKBgQD+VwpGemOudZ8ZiAtm
kg8SvilXfbwFnUjsWPNoJx8MRTvSDEWkJdpWIc/xMRYbf7If5Y+h0cx8tDdTMvNI
G7+j9dh9TQ2TgDtCsa3iF4NGY8YZj5YQqz8uiJeUusXis4rDd965HbBqCDo2k/m4
OtpUkUIMbk7T9IjJZJzllbsMQwKBgQDe/R2N+bSfp02kkOC8LPnSqEjqKNRP9a+e
XVVVcekZJUmMMxJ98uwZ70b1sckLPSzcTQE18YmWLGaSnOa02Zviq3hqF0Rj+W1h
QWVZO9jzgmO8lMWuNXSJ/csuVVZ4ebRoRwGsGynRn7+qmhjoAmFaY3SNfalLxZuy
Mc704zzGpwKBgQDrTeubuK9wQDGplUu24XpAhN4Kq7DAIPvObZ0Dxu3alFL7yY7E
hqCw/yc6pYcmecV57RAtTcQ5uyFUP9cD52gtcM2RXzAoPoKU+X09pzM0dCpai5Ty
ZvxVONnEJ+fcDO9cWBIegXEtJ99zjwOBhjFn+9t3VLZpMds7N3JQlW4vsQKBgBQC
kLlh1ASTpdMDsTcRriVqNojUuyClwmmqpHKzcyBviScMmjc1Kly1bR+1IX5hsfne
6yHlF9yjBV1YuRc3g9aWXorepaN3CYq1rJuSVEidxcdxbj/QyjFr1eTFganz+e11
mb/Q/DK0bCWqCFwhgozy6c2cnimPhQY7k//DuHt3AoGBANipqLaUzia253xefvuZ
pHWiVJJyif5L14boYbJFA9Wibg3K99pDG9uoVBmfChC6Hm6CxvIIDSqSbZGEEio1
ajiPyszsAdvbuqQH0Xm0cDpL4Ngb2QS+CaccXGJkJj4u7rBE/lKyfPjjiLZOvqRS
chyPhdHI5CNzAqqExg2h3lca
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUfZLZhnra/z8yyJivw/7O2simIzowDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDAkSC0hl+/EeP4XUtJDAWCBRosaU7munJ8XX4fZDcmXzsg
p2zdv9UZp2zkfXTYP5zFAnjG9QEiiURMZ4rIKdr/cJXY/93H6dwfrjZTS1gCSlpc
gkuq/cdbOeU6xCX8X/dotSQupbYr6ccPVf22iON/FotilEpP2yOFZi0d54uKnBoq
x6GP22b9/Ij+tQNacPZavQjZD2i7ChtLigtMDmrrFMOrsQjSCQPpGKsXmyNqTo+/
BKAKEs+WghuoVh6G5BeC2EY/PoUohUxBUWlAXThA73yrq/nGQRWfPeNZ2r0d1z9m
AlUakb4a54M8tDO+OOqw985KyhPYRGxOgPDFy4cdAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAQRNledZvjT6+Rtb29W8pN
11WfUj5+QW7DX7/AFd59PXQkPbTf9EPiNtbriPaeOQ/B+jJ10/hGGGUhft4IEzpX
ffQ09CPNAFMiyvvnOQdykH9lvDMcoVYi4EjzFsCa7uVbKSZApeO07hCWRtlEeDrx
QU//I1F/BcGQGh9Evh4LiZZUzRxqlGE11jSBNIpSNkVE0DO90lBwEujvb1OC4YUh
x8Ef3hzI8EkR4VHG8SwX+VlasHAvM06ouKAQeMMNTWxeShaTI+mZkVUgkWJvTxf6
LwmU1B8s9M9hNUailBda/7ztvcZHWxghBhsWICZIngUvt8M5/rrgph+e0rI2QMiP
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDAkSC0hl+/EeP4
XUtJDAWCBRosaU7munJ8XX4fZDcmXzsgp2zdv9UZp2zkfXTYP5zFAnjG9QEiiURM
Z4rIKdr/cJXY/93H6dwfrjZTS1gCSlpcgkuq/cdbOeU6xCX8X/dotSQupbYr6ccP
Vf22iON/FotilEpP2yOFZi0d54uKnBoqx6GP22b9/Ij+tQNacPZavQjZD2i7ChtL
igtMDmrrFMOrsQjSCQPpGKsXmyNqTo+/BKAKEs+WghuoVh6G5BeC2EY/PoUohUxB
UWlAXThA73yrq/nGQRWfPeNZ2r0d1z9mAlUakb4a54M8tDO+OOqw985KyhPYRGxO
gPDFy4cdAgMBAAECggEAPB4Sw8kfoxsGvMcDde6W2ZyWKz9FLqsOitz1Pv+eaBBa
+TrLtf7pnHS0fjDchZZ2btryscpTbGDGPcQlg4/tmsmfPnvC1WKhIhLVSvO+qhhk
VXUoAl3wGv7cHZiW809SghHrFdUOJm95gcQqzQ23WDnFkiURfhS/5imb9DYRTlga
fGzbfwryTCQ+01MvIBDu/jRgDJny56FS75O9owqLgbBf/5NpdZbx16TZ+yS1YZ/X
R2sxyS+/R/KjcJ1iVIyzQ8VmQgeoxC5C/38T5cjy+Iyi+ueFTneMtuzhO35/eQO1
ZVSt36SpbDkxfNPYrnPo4ZC2MrZ6cALCKWORu/+e0QKBgQDyFR+yKGUIUpl0kdlb
qaV0Vjkt3xgSwCpO16viv2KJ3z5HrKtKvaRlx0DI0VwMEZaRfnWe6m15T8sUeiOV
HKbFUPYBUZqeSdisngM2+9zTxsKBVk7Hu/O70pBvwTXGyL1Pu7OgZ8Oo5qlBKo+s
W/Eg+Sopak56pjkmrhRkPuieZwKBgQDLo0CioWNvPz/oiak5pHtxAwWA+fDvj2qa
JGggwdIvRQuQqr9cXyk3f+bHMrGYsZcZib/Jdulym5LmggTa+HDGDVcCBSOkQbuy
1a2/S2XOnLbfT9PPBMk7Y44RpVw0P72drBVPS59ftz0JFwfhyyAbh4lHvj2sbuN0
uIaip2az2wKBgQCeDxjA1AsTYgr7x3apmJyE1v9CahVnuLxm+f4qcFdAOdiKJ703
cZbzNSOhesCkyJ8MpArcFagguu6Xkh/Fbg2da30T41oW25RzMEBdGBlY1L+OfvG1
C4zaJ2NS9E3OWqbwdleT9ewUTXZZLBberLFFnCnhHJ3dCsbp8GM0CLcNJQKBgQCh
O8dHfSUvxhKh2a1leHhMiKno7vz3kMRE+6J+nTgAOVjo2GjfiHEoAlsFSXwYfDQ5
AjoaF87K8ackX7ncbm1MQu+rJ8qKmYk2Fb2WAuq+5pJcyeXYud9i6HZqPlV9ASLv
HntY53Vu4bSv585T1vK7GVt2tIg8aSgrGJdxXb4RlQKBgQDesyxvn8XWcKy6E9LU
M2W6szBKah0VphqyDb5yDeFA+0d7gs7zpTx2hbVz3ux0osuQfT0TtmZlp9dOPi4r
BCUtrflSZpG88z6ZZ08uvQ2SSbV0QCLb3yDMPW7emDWNATVNriS4Trm7yXC7Qkq+
N7ym8cFFFxe4u+vajInVVZV+8A==
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUZmWsnGgQgJO07P9Mrqx1hHBfQbkwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDjcVLjFq2N6GKxvke2xGntOo62h4ze0fNrdj/OifXvpzxf
qnPkhBcb7+6GL/gO9IT6hnTCDSjNQG/Coi1grjoPT9T+DkamwioBcFdIOYwEqPCd
Fk5ZnqwAWWg94+dkb/jlRcFlShNcgDriH/MrgfQ03A4VfqzcNT8GzZ4zwFqAyhiV
KQ56q0qrnIrHQDERII3QMH72EGCVX+32IIkz2CJvo56yngwF+tDzYJYHMJnNTCG8
iVD71v6qBM52G/6bKFRJhyZkKkVqPwptIXInDPY5ETgfZYgD67ffQ5+W1kXlCmmH
PuK8w48Fw7LjRDzLTYRFyDSIT1H5sdRvHLIl9BEnAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBvOTJdNGUD5Zc976Q5SJre
15KN8PaOsLePPISn7e/2DwMGuq7GXnGa4JCb35XTGjX+Wxgnv/0/8asMimay6gwE
YZBcRwakm3l3//4W1ELc6SREoFcUTV49rnccq/N3u7ZrDubf1U9uKvFEpwp9TM8a
nq7tVOe3j+Msyvq4/q/l0nnHX/uuWYrZrC+Cm6tjytmOr6JzAhURFoVx3QnwaD8z
qm+cisSE3/lLuyTzgNUiQkdIC6bCg5KVOrTXFo3T72F7+oeM7h+OiDO71y79x9UH
r6YE8Ab1nYz6Cw1fwy3/QzxtazuTrJ5gBotF0oqCoayEtiOMZr+aQuM/qRs0EeTy
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDjcVLjFq2N6GKx
vke2xGntOo62h4ze0fNrdj/OifXvpzxfqnPkhBcb7+6GL/gO9IT6hnTCDSjNQG/C
oi1grjoPT9T+DkamwioBcFdIOYwEqPCdFk5ZnqwAWWg94+dkb/jlRcFlShNcgDri
H/MrgfQ03A4VfqzcNT8GzZ4zwFqAyhiVKQ56q0qrnIrHQDERII3QMH72EGCVX+32
IIkz2CJvo56yngwF+tDzYJYHMJnNTCG8iVD71v6qBM52G/6bKFRJhyZkKkVqPwpt
IXInDPY5ETgfZYgD67ffQ5+W1kXlCmmHPuK8w48Fw7LjRDzLTYRFyDSIT1H5sdRv
HLIl9BEnAgMBAAECggEAfIJcMs8GYao25UDad3Zc2q500/2uo4hh7pFEaufhh7mQ
dnqUiSO6luOpOzJlZKJ9bbxPjK+xh3Nf+zfXCZc3V4yHeDEOglnGrxT14ycFvMNT
PVuptqwDUwme5EqwMK6PncurDK0Znkjgc0u0TjwNGSbiWugG72ICx9GmaoRBx0BS
1cYu8YaRf5X2PZ7FETJVevEAsLk37iLjDsR/lqJ2Efv0ga4xt+nzxBLs1uOukTB3
W7I/cnsoKLJfBYgmcnIXylx3tlSw/3mawT1JN6goFpX5wgTTeO9NPh+m5DYKfZZh
LGSBV1Yz5d3Eai4hC9ug4E2891Z91AItIdppxGHMaQKBgQD+d38Feab2mQYoeb1c
MfL3ulibU9I6KGyCNmrXjyFjfeB0D+JtS0pfudKWYYBTNVNTTWd8+aOQenRjKgOf
416MDI+EFSo+jF8LunYifUyKJs6UwPE6k+XX336C9p0eTn2DkCnTaIK7WWeVH0OE
Vj7jZdwFIttrwx2mU4viWGfH1QKBgQDk0CTjkO3Q1edoootsxbkQ5kDXMtRyiY7w
AfV0QX6Xd7lQ6b2D5idi1RUAsozWcFzQQnd+7x+YqEOqJ4vFvjajuPzJCp4pRdlb
dd4MY90uFHxyjEgJm/x/aPn1CDHqDBDSKnIhRqf/SsNSbt2Ke77TtVriGqe+m49t
RyjdVyUPCwKBgQC/BJzJU2TOQFirEZfgGW62H6BcGTP6jFXH+WmCnuMFeHyBI1tp
h9cwvKEkWdSmoaUHJ1fELPFnh0TPG77Uyy0yHEuvbuPjSCQg/buocD6AhlkUuTFc
M6GZxx+E1/NhyLHXjOSY2h8o3BgxjOJ1+PgEY3YiNORZpIIhVR3wr0RYcQKBgHrA
q7mmK99okiARa8kr/g/x5wFMVKsp3xQliOAYruhlo3akHzbex2x/MihQobv9Rd24
etEPSh0k0EA9vP+V/0wwVvUoDBfKUER/5GMzRBqPhQATACafl4Nm9wocnmKYnIGT
oez2MfSE0Gqt7Y54urRrS9mXQTzByd1vWp38PXZnAoGBAIMo2HNWUrC0bmEX2sbQ
UvFS05244Qf04jg3QFqm2gmdwbD8sSpkj1FlaKbt5jOy3rMa+ybqGIJldH2m3UhQ
1ULRjFo/fxiiiUUpjHByto8h+G15fHkIXYMR9VEjHhkvwRzScp4bux/OXUAzfSQ5
PWxnvhmehLqJg1cZuRch55xQ
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUJg7OmxTb+nSse9yCvMecvDQ995gwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCoMxRs8WLspmYqmfcq6MqZI2h1bNRqXkdXdDpRTNkdfusp
8Xm5/Oncd2ewVbOIWNtaw0c5Uq6futXmo3cMAf4fTCpQUxEeWcMw1KWK5vudfXFY
w0VNxS9fAR4ByRbNGDcW7HXu0silleuD8onSKxBEyUpNHksqmuWLJ+Av9zvRfl4V
P5WUVr84dpaotLXYx4PxoPINRloIKIrzsEAVwrmV8OxsbsxdlvokUYy6kezTRNqN
7izl2CCi5PvklOHYr9Bf5NgfAE4VMMTcVrQKebTkGAdlJipJ3N7gf75Yi/mMTXnW
SjMSRjJWGub0iowNUEXLXLaSQurQRJ5iCoMCZr4tAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAw9TzzcnbQvjEC4zF4nPr4
w6cNUog8tfiUx3Oh2Hf4+//Urhu+9rO2ylV90apT2kR5qUT0yod3s/9WGMe56P1b
3qES6PTN2LipOT0js9SmmhHmcy+tiQxeKk37SWjFMHMmfpaZHLZROxIAsHUlisYo
Pb45Lm9zd/yofyh0xTHC36KaU7R3mVzE0cKtFKHZIiwpd5BUp638lY6tngQzOOe/
hhxRyJ4XoafugAgW9nykm+zMG9LxhHpoMFIZuZQZED4RKG7gKA8l0VqKm9Cg9DTm
xqhRHtHY9hS47dsHL9Ggv8XsBy4nnkemVhB33DPK9kYRmz+J4Y8gjoqlL7ZL8bnr
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCoMxRs8WLspmYq
mfcq6MqZI2h1bNRqXkdXdDpRTNkdfusp8Xm5/Oncd2ewVbOIWNtaw0c5Uq6futXm
o3cMAf4fTCpQUxEeWcMw1KWK5vudfXFYw0VNxS9fAR4ByRbNGDcW7HXu0silleuD
8onSKxBEyUpNHksqmuWLJ+Av9zvRfl4VP5WUVr84dpaotLXYx4PxoPINRloIKIrz
sEAVwrmV8OxsbsxdlvokUYy6kezTRNqN7izl2CCi5PvklOHYr9Bf5NgfAE4VMMTc
VrQKebTkGAdlJipJ3N7gf75Yi/mMTXnWSjMSRjJWGub0iowNUEXLXLaSQurQRJ5i
CoMCZr4tAgMBAAECggEAKh0H+zMBGtGa+QWtzi+VMnycFfKWyL8sS6hNRbfhELKL
fOf6G2hIwauf6ZW7quLcoUANoDukf1fPYL0C/J2vG/T9DzmNKrU82wgTHtEwpMEY
1SmnO46oirgD5FyN+fIbMQEpkg9yr4r2+gWLHnUr0J05nk98cIFyAcKNLlVPw+bh
C1ScfsCT66dPxBnYNorU9j2Wexu6uvajtrGSTsMtKxvrSlvtcEMuu/RzmLj9ciFI
/8YFQnQYtMS61Yb2JfBrk3OXGjPhQaOeWM/zQpAHVMaJmcViKiWspqP6uZy5d4Cl
i6IDAUjwHnwNjKiXcoleZQLOKXDfzJwCt3SciSHInQKBgQDRNcd9QpmcX1ftWKDe
EIJ8dkUnLyDcvxGSUiNlWf1VQYVmEIg+Iw3OBIjl8ryzHWgsrPi9i9Pj7hChLeRv
XelYZGgbyigXvpH/SyhdyQob/Q2XZ+rpgdH0HKDG+f1fHEYdOggl/F9ybN8TyH7C
al13i3W+5bMjOsCrKgEN/afEhwKBgQDN0UMFv4n0Jm+IC2w4ASKi5lvL+u1n1rIt
S6VFMNm4qlWdUdGfNyQDpwsSoQILh2vlawdsMVqyS2/HlyGXlK4Tc0VHxzOczIU3
mulY6lh2XVDDA5DXmwEnYu5P6Zp9em7X/vFGFnLDmhoMOulqo4tO9BvGWteOldiU
2wh5cAvIqwKBgHW5O24i4el6RTILo0oSJDsBGly4SletNKgPjFdl0gX9fqE2QFQm
yYfaSWaLtt9bdtlc5ANVAYDK35SzDE4WnE3fAi5RDUp/NAxiMG7Fx+iD9vfxw+Bt
6sTgryAIYCj68gFUPG2Tm+n5lXW+ZoXj8IBqe3FWM/1o/C3Uzw8eYx9VAoGBAI2s
Vi5GwndFXdCPzFZgsa7gUp/+ghzQNKXpREJ0deoflf9MqramBixdd8nC+t1kwmiR
W/KlpoDEXJVO+tiUh57r4eyeunBcd/bms2l5JpuTcFxMwA8pq4mpF9H6Q1XMSTB1
VS+hlC4AjZ2Nj87P9LzMW7IWJfsIOqV8gEDXV8UxAoGAQGUk1vmkSG7211QuU4Su
gbRd4JwAoN9LRZQutuTVUJ5E045dh2iIba9giYzqNRIiseZloy7tpotgoNsLfHB3
hnJFGrgqMFgoczqjiH5tlvGXcRqCNvRRCeu8iwXDj5VZrkM6t1W2mgoEA1RjQxIB
9Q+UEMEwZS5D+rdfwaDFnkE=
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBK/eOJ8iPyAfvjMt3GSSInfW8+owDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC6Z/5RC7RCEceZktvq4CJeAaGlKGJFpF3z/THIWoVjJ03N
KpDMprhq8N2HM1pM5I0HPDze0hDCRGpGh3wby3FmVAxb1vJyDTT/DLw5KYDBQaCY
TXwschPu3MYfSJIUXlJVWRC7di3xV6si3L1ALdfmK2des/YWCYP0qIjc1E8j/OVc
wD2PdyHR+p129SsO6WB8KIH/ocTw5YJisQBebUo4m495FhKLcKPiczUpRL4CmZUa
dFkrTWz1Vcr33f6fFybYaWI3lxHHYxOSB3MilDd8Au55tLhkpwpkaqPKWDP6b7au
WFuc3q8DegbYRLyq7qEudsG/u4afrHfI+vovHLVBAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB/MflzZFEWhLZ/ZcHfmVkO
nTs74yALWjdld24er665E/tbRUScuGwpGJDhxoLE3JrsM8wIyqw/dOLqGscNprl2
u5MBRMwzbQncE1kZ9YNyT/1oC84Fee3IFni47hBUJK3o1zOuRlU9cMTj3dttBEG2
hByAv/ZP56H/dQN1/LIGoOHNSRhdzuY33rFYg6ZjV5mnFh4BHQ8jElA6lTiz2uBL
98RePraQx1ONCXyrjBV5o0G1Ra1UmRo/DBvkQu03eZXIyqSrZJKX1xM8345p9SjI
Ztpr9N0YFHRkMrj8SCiqYeRX0LdUW/D5e/gBf5j+dJzFiB6NHgyD6mKORQgxmIPY
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC6Z/5RC7RCEceZ
ktvq4CJeAaGlKGJFpF3z/THIWoVjJ03NKpDMprhq8N2HM1pM5I0HPDze0hDCRGpG
h3wby3FmVAxb1vJyDTT/DLw5KYDBQaCYTXwschPu3MYfSJIUXlJVWRC7di3xV6si
3L1ALdfmK2des/YWCYP0qIjc1E8j/OVcwD2PdyHR+p129SsO6WB8KIH/ocTw5YJi
sQBebUo4m495FhKLcKPiczUpRL4CmZUadFkrTWz1Vcr33f6fFybYaWI3lxHHYxOS
B3MilDd8Au55tLhkpwpkaqPKWDP6b7auWFuc3q8DegbYRLyq7qEudsG/u4afrHfI
+vovHLVBAgMBAAECggEAZXbfxovBZck5xY1b6aBw9IycyUKPI2tRvNKQO4eSXaNy
RQAra0pAze0oGETKnVo2rb6LP5pGhwgodRWgZ5y4sEOFqqP4uj4YH9B10AOYUxl+
6ggbVDIQSY+gxDyDT1T8KfreEbxFS741qDdRSFLr1xy/GpyIkfxB+HWYceOa5HIA
wyxiVuKraonFzA9BA7xL6J7LB/Pkq1gqQsPYbDO+aK3b2vUA+GnaMVpMiysyTNjm
dhzn6Cnorz5dncGbZq7nQ/9ifMG5cUMHpNyANI99qGjkdrCwcfIiinXl9qOfx28n
PMxO7HiR3FdywlylqxPJzVtby/VWtwaAdxzvKGiAtQKBgQDoDo2TyB9ys3uhNbjs
QLL5N/CI/juUKbcyL5etbpN0ovp9DSaF++9ay+4d+YMfpv7I35NldAjj1VPEmghR
u810qv7eL2un7a9qGJvj7MSSizbw4N6Ll84UlxmuOwzbTiRWlXPqPQdBEcTxKMB9
Rg7WMcsjiHQXIQV50XbacyXBIwKBgQDNo6UfFnCIjV5S2jZJ2ZPZNllYTvm5OfeK
GTTB8lqv/8sbW4DGuoc3SDgpUyqBA34gUl01nYU+0hDYTQ/jaUgPZ8a2nAOcwICf
92um+HENTmLaA0RlDssil5k4soLo0NCpv3bxF64p09DdCYwn25af0Dgg+RLtzVa+
QisSROBgSwKBgQDSASGU5N244r72RHTmsSKGsV4ny9PFIP9eFn3wgQpG2ptPghAj
3rxc8gK686v7gBhBVzu/64OEE/GsES2IMiob9AeUsVt+7HX70Ot7GDFI4V3GHeqo
b6gbMCcYau4WpZ/zD2uIRtSCyX7uM9AHTthsdUF+FaXhrIuVE7+4r84x+wKBgQC9
gtuQi9CHt6i+uEUhx/deTZ0HKjkv/4DmbxZUyrHS0uxuOOSzwIEObGr9gpyAKyTY
Sq+F0rZST6uge1xyGruDHwNdlOgrVKj1Q0KdrQYa2it1eV9Vts10Arv9KV5FivNS
DJZj14v1FjS9D6hvrwngHDcuA/zy1LLlQfuJqZoSgwKBgQCa5/XDdJrxy6cYGvOW
PCGv/kKMbfMMjX590VR4+K+hTk2hywqss+kqmRoFraNwtfF/bc1AE00NYGp+yL3D
bz/mSX+BRFPuiE5x/hhH5imfLClvwcjmZvhfE4buVrdj0yFrD+IL8lZsOBvYk5FC
Z8QaFOfz2CDLvK7nZuvPq38w1A==
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUDuk4yYHfeEkTr0RtsKoTAPWmWRYwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDjKy/CjxjtUi82UKxLzsR39LAoE9BUZwLlkvPrugeudoLq
EHlKTolTuvlFJAi1e5PKjJiHdKW2vSrpt9yBj56qw2xt7eJOQKxIE1kdeCdLoK1M
WaVWVekONJSlSqcHkW3NuBVtbAKJO+KIdTMMolYJlheQKBZp3JsSjLakDUQEoGyb
GT/+/xo3OZciBk1acmOBh9mJ///p8LO/oFZXZCXSau3+9K9vzcwS5J3HkDjkNVxb
AJny8gEe6ux0rXzkZLfG8WA7F0SVu+493kDHB4TO6o7UxAWatGVcyG+M3ujJ9iEg
0oeyoCghgpBSX02gM0alwW2cWNrkgisf0tyuJBRdAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAqtpdHxteYdjGDUaNuVzRN
1qmnmD8m+scvNpqYU5wQ4xawZVFyx6k9dl40BYeYvTcvSpBmNoy9fTpuTYVeeOae
glreJiKnulsbMRHwxDjCKvhoCge8ZTsX/0Atfkb+AHNMEN/QXS857ovSy8JoV71Y
S3ZGa01vG6AdHfpin+xHuDBh/B7bCHPBEwNc943PgAeQ09X0ZP/EFb31h2sK/eoR
jytU7Aw/NwCnSaA689xoTmtJp2p7INSTXJNO/rJeRKPxKNF3Jcg9Ngtci7CxkXzi
4+Hs2aSkIAYj05UcYdiLs4TNR2ZrPKA4/ZSZUCCDQAogOEUg+SOMGPkevqpojYvf
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDjKy/CjxjtUi82
UKxLzsR39LAoE9BUZwLlkvPrugeudoLqEHlKTolTuvlFJAi1e5PKjJiHdKW2vSrp
t9yBj56qw2xt7eJOQKxIE1kdeCdLoK1MWaVWVekONJSlSqcHkW3NuBVtbAKJO+KI
dTMMolYJlheQKBZp3JsSjLakDUQEoGybGT/+/xo3OZciBk1acmOBh9mJ///p8LO/
oFZXZCXSau3+9K9vzcwS5J3HkDjkNVxbAJny8gEe6ux0rXzkZLfG8WA7F0SVu+49
3kDHB4TO6o7UxAWatGVcyG+M3ujJ9iEg0oeyoCghgpBSX02gM0alwW2cWNrkgisf
0tyuJBRdAgMBAAECggEBAJe+JFQBBDSankDY2I522pQKVZUfzxxiBvRVGixPAoyO
S1qQkISLO347ugBuVobrukglbEmnKH6Nk9m04E2HIwSML6Sqr214E9y9V9ywgwco
mDoU87VdA6ViiBx1ZmdOxJsTKPUDnhoPb32ZU/VPhss2gBziOj6Sht94MRQabGHt
iPcsgKv4P3I/Ooqw0kDNtYguG1jNH+E2pvYkYF0Ne7S6yWz+hKM1RhMCa0BNCNWz
lNsvtV6v5t18NhpJwFHwap9q8JM6uMZRpT/brI+k8qnJzEvhuJQt6PpLCZCbwBdp
+1vrz5NpnvrsOnFjn/eCioF+MqW7bRZDKP+lN/Fpqx0CgYEA92G0OQV10PXb62yb
gXXtEcCns4NnnDRZ3v8O7JE9umrvh9cJi4DlVKPVI8Ti3m0CpSf1WjvODEGhkh14
dYEAh26dDDhuy3XU8PS5yTMTmgwPGP6VPoHtcVldcmBxG1gjxzadr38hJ/0jha0T
xjjbbE9mX9T8VXX6Tawq44ubqvcCgYEA6xU2IO4ypHX8iikCR1kh4wyK6dosJ3CR
8nXZNDMbiEYPETk1+iD3RwSgk7gXp30hlwaq2aUuImMtggtfm++2GhDZJNXEvFJZ
VxZ1uFi2Hw9MGbrBoB8kf/TSWZm0jRsfGW54rqOvdArtGbw8Uo/fFucqvoGRN4vl
o5+zXf0RcksCgYEAvQwycP0GOykX5kK6V+XpxI5I2juKW2n6YBrkqc6YsLR11oZz
qeNX3iXRhSM6CKafxdzSeCGJ5f3l3kadPpbV86mJZMRfjya+E2HB9MsOqMOcagpr
vTgHX37elcCzzyS9Osk3Gd16VhfyJH7OxMXAkXXgE04tg5XEMcVnhTq0PKMCgYBY
Z+OxQqLc4loUgxOOTWDHCAJ9q0SLmHPqYJNMZCPofaBQ89jutdMIbB8PLl4G6LHn
H+TEcLAG0pFcpHZSKDWtW8Sta47O25EphRLEPuhOiewuiOMkGlIZpLIua/VQU3DA
maDc3EWxOCKuWPG+gsh8znZuqj84Sm4TuI01vWQAPQKBgFvrRPwaahZFLitLbQnw
oyzYKaTReYkcc2VLB5jA7V80VddTBgb5taNk105zl4u00GLxq3m9sr5zl+r4hF+B
hlt1sUypnCrfrqRRzn4GcKmF0o5vgz0zrS0+2lqUxriz4nRIzeyeiUpTPjkufPYp
dW7e/L6tdJx2jn5EkI2wP/HG
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUF+41lzP8r7pBiPCZFG7cMvOPcnowDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC2wkXkBcUaOlajfjIsrbJPbKnSspyB9PbJ2nT/Nga/za94
79C2tTntMhbh40hT6E00HHxmwDOpzEEH+C+vkmhR3zkTFmP9uV2jSyylwBwWnTru
9io58MA/G25FMYH7a/3lKYspeh/mSKWqhV2xN07Mov9JbNAUVT13oHvUMlmhxaoX
pTKehNH6u3dm8ovYlZyimVRbu8d88Ke5atjV613Ci1zV63b/Vt5YmWR3bAw6h10W
UMSrh5pDEXuKplS9dTYOwfkVLhIinFSbyw66k9X1qNZIF2M10rvW8FsZxwtHbdAI
ArD4kB7FrsoezBW2+Drap4aeHD1cMOYZPh9XnW05AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAs7LdVyhNjP4DiXaKCy9De
7skX66TzJiwBBQ+fXjvAcOZCmn6lrje5ZA1pEE2e26huygXcADPntZJWgaV8uQ0M
SXml0t5eSbDFlxOOOVTk7bRyt3+Wj3kz4N0P9ehLKtemKd7A0kYrgcFhylQrEHFq
Ijo8uEhv77AzhJfNHDbqw+qax3rvOG2b1H+7yyn6u6kdiOVbGUd1ChIh1zTFFYrT
WJbF+67bEFy/AEUYFdK53x6M94NWoBKqkIrgvbjf6G+++6IiL+PpaR0j3Dnu86ea
anXRdbkhy36143Kk8GUy/Vx0e0L+aAbLDwobngzvMYactqDo7pqcDaORLSLKiQT5
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQC2wkXkBcUaOlaj
fjIsrbJPbKnSspyB9PbJ2nT/Nga/za9479C2tTntMhbh40hT6E00HHxmwDOpzEEH
+C+vkmhR3zkTFmP9uV2jSyylwBwWnTru9io58MA/G25FMYH7a/3lKYspeh/mSKWq
hV2xN07Mov9JbNAUVT13oHvUMlmhxaoXpTKehNH6u3dm8ovYlZyimVRbu8d88Ke5
atjV613Ci1zV63b/Vt5YmWR3bAw6h10WUMSrh5pDEXuKplS9dTYOwfkVLhIinFSb
yw66k9X1qNZIF2M10rvW8FsZxwtHbdAIArD4kB7FrsoezBW2+Drap4aeHD1cMOYZ
Ph9XnW05AgMBAAECggEAZLviQBP6F0HOnWEikMPQw7x2Qn9Wir8WBB6YXE9QGwpp
TLSKixqK6jWwrSNUq4MggreszgnksBO4SIdA6Xo+a9opIF84EBLLDQWTf2zLTp+t
aydeEP+lR2N8PUFTjtxwXo6ueNcqnAiw37OQ9+wvT9YL9lG2w25UagqYFlcGVoap
eonK4rhlSlj+qSGCZzXoFnJSlht7Z0CNoSg+hWuLWlYYKes7E6IFqTAMCHg1DfjR
YpE4hmLX9nqr6hMQMGI+HXtNW3ogG8vgg6V8BcehyeSyvgZq1+IYQ+cuQh4ijo4s
1D5uWfXVCGl6abKvXZ5Ft2mMEZxX8+6mnyp+qutZgQKBgQDd7ouacyoYc2DccxSP
edRjUrlpG1OjY79KwIfuFRd/jcRcbpxKCjRbztyzd7kWBebEh3rYJCxkX2Mti2+M
3bdNAxupCdtJ5Qkf6ASVEujDIPfHaMP27ZD5sbdCUkgUaPG99V3bj5mP069ZE12T
+nNuoer/MULB1M0Hk/cT6pYK6QKBgQDS0FA7PDgejBQwl3BIsOAkU0CR4Cxfoydd
ST0Qiv68/Z+6wrEoukcE/86OT9fUxoFDITfirkSQvbneIc4nr4igpAA2C0GUAOlJ
yDTyt/MF1jndu9kE3jzBBMMKx9G0x2PuDeMAtUt3b7ObHkoJgxpvafIsZJOCdTjc
rBd1ET090QKBgBmm094DR69RzrVMW+kFhOYCDso2TWGKSvcB7/Q13eRxZ2vjoQ7x
xQGDlIDt6qfAAN9gZXOMItFrMRR3lGosyl4NaOoN6JnO7lIQyE7Ow7aiHeGfm170
MJib0PnKduhdBOwW60VQgMheCFt8YImVHjiAYKAkenna9ePVV26m47bZAoGAGojf
4GTXB3lIPUmCd5PT0p6r/PCDhVIq7UH/rqpgH/eoeEBzPhYcRFPScvU3zG9j68gt
mZmnxbQrxfrpUPN2NgoOgL7v9SocMw5BI9/ldfGd/Pvc+BDlAsKPrjayfZevS1Jy
JS+snQ7xQ3APj5zx4d4q/k12h7ArhRMgLLsLw1ECgYAuYHuen6z7AJkKkD5xOSBm
nNuqfB9GeoKsHHtiP5lUBrkINlarO3CZKRi7xjmr+qw8HkVuejutUBa7KT+yasMt
WLTDq2u/pFo5Lh2GEoZI6GwAraNeRro7O1fLuYK531G43K0S64uNZAW3mzKPKuZW
0jnlPEesX1D3KVAB28v0NQ==
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUaTJzz6JzsH2ZddKgtyDaLvK0+fgwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCcusqOeHXjSZtVYgT32PKxIjsW/TPBlv/ovjQpFIkBZTCC
Rp+O0BNUJ13Kv9MVyyprKlR3EMldjIxolACVS+UIieuIERjufyMQVBuqJg+qr80l
rbBwcKmzB496Lopi4DpX3W3kqaXd1c65RNCAhiQ50ZfEvFwLIhRzxC/ZofRW/iFX
0B2x+LE7TZ8uEXhtzVPc9GYVnEk/I2hN426pX59WmF/+xQ+HKguzCCBQ/7V6TiS8
1dLw4z5aIKedBgvlX8ibDkCUp6jOOfUTh12Xx6nHd3TX9qhL5h9zDfWbdoBdr3PU
tYEgNXrYVq75HTlHoSRCuG4SccoVCwNzdKyjJ4mDAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAKaLVA7Ogf7S4gIwv/3K88
PGJxIhTcgMSyCVdKnPLWRUEofdZVMZEDcVI+l+4iB8sJ0XOs7fZp+bAnaQfgXzE2
wyWAODuytYlYZYc42xlT0PhqNnRKLUKf6uLCtNZFgpmiVmqgvAkzk/SJXTPw2F7q
hFA8K70Z6Wh08rZCP3hXLk5A8h6ejcNBHAoOg7B8Z9AMPlHW474xoGUrLjl01H4S
6C2/7D/URCQFBTrLt4sIvtxe+cAtggB4DVpJk7eoxk7JL4CsRu8flqGLn1wFraqr
jIb+X70mOXY7cO1R0n0uJLgHTU1dDkMlV3xOVfqhE+pe7caknwI0Nfzvlar491Ct
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCcusqOeHXjSZtV
YgT32PKxIjsW/TPBlv/ovjQpFIkBZTCCRp+O0BNUJ13Kv9MVyyprKlR3EMldjIxo
lACVS+UIieuIERjufyMQVBuqJg+qr80lrbBwcKmzB496Lopi4DpX3W3kqaXd1c65
RNCAhiQ50ZfEvFwLIhRzxC/ZofRW/iFX0B2x+LE7TZ8uEXhtzVPc9GYVnEk/I2hN
426pX59WmF/+xQ+HKguzCCBQ/7V6TiS81dLw4z5aIKedBgvlX8ibDkCUp6jOOfUT
h12Xx6nHd3TX9qhL5h9zDfWbdoBdr3PUtYEgNXrYVq75HTlHoSRCuG4SccoVCwNz
dKyjJ4mDAgMBAAECggEAIqF/emWRnuw3v3EOKfms/ojSx6yhEAieeT315pHcCAvk
4RRb00GU08ZzCgbCzJD8yXsr+Lcj12Dj8YOqcVK4w989xO4KNUCwbb438qvAUHXR
/Z5YWy/5v05PXK8F8v0axyltS9ZUiSTiLbvP2mZJgOEYCOeZ6vfXzxCthggsJkBe
diZNCuq8cA4kSnF/v/jPatxJVtV17P/nwd7GOWgZ8pJZ8hOk8uGlwzQWHhynH19Q
keArStXoJwvfr1dceIln860RjqfnuOp8Rl1JAxQIBvHJmdvlOuXve5wF1wCQQuPJ
RGy2UQFe4xDrn9RIBl3Wd05uO3bmFhEFVPJIF/pWcQKBgQDJW+DfEFl25HyKjGd+
VCjJCauBYE3cE1U0jKmYyJwXV+xodUBdcHaCTtGNIos0LMRkaSpwg5/DueYL9pF1
vorrE7F4DaMLvpk/rl1GpzM7MNHuwO1bsIffOswYy2++PHOG0DsmFa2YMGZXMLwz
cl5eJpUq4CO0R8qrB0HfhFd8GQKBgQDHQpTVkKwgdjQFJxGD+51yRqQgtNUjvq4a
RD+UScRxudO3ZIHU0TuK3IRWFOVypagotsvo3tfoEsQ0CJ9WCL7CP+f+/85REKZB
lkhZKAk2lXurZcRRGdGBwurOdRT3kDxLWGpBV4IAGbPM0Vf01SzEbYxeTJuqaA8E
C2YRViNl+wKBgAKHU9iZRPZYQjQfNUGB3w0/QNccFX45A+3oAk0337XvVbmuF0PV
ILfcM4d5MpRSJ5k3NOA61uvHTttBmmwHG4l+MtFWIoEIQLZrAyLbAKqyn0BHTfPD
0MD95Qg+rcWOzsiXntaImSh7Gx3nL8XZntPB2keyjuA5spLZQXuEFvEpAoGAQVE/
Dp7k/aMhvEqpQDV70Bj99kaw043O7odOvCJOReVfVG+a65NGzGcq7jjdWe6Zp/b7
8rMR3V5BeLkW2hH1ziE6wGlETWiCx18nCirIkl7/8hhi+R7YgYvOgqz4mYpraVtr
QU4ZLEVAnjRFe9lhWmZ6q/K62GpR+cZux+IPqn8CgYBVDKjInduDLbFYieirj0Nz
326jhsuafhuVoQ24hSsQNXWnYlN3jWNEsbGly/zRJ9lm0xrlhyUGh7MSG/yau0G2
fE2c0nVSQM+YZqAbzz5q+X/wWIE20H6tmu70qH+MOYV119jzfWc53CAIwRkH/H2o
KbJFO3MTfmwo1mgBjYBV+w==
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUaXeigR1NhYcViVNvWOSNgb1hguMwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDlm9CbdDwaD7gUkwY+Y2by3np+QtBFoJtk4hcbdAQ4Vd27
7sJGve+iYg4vCCg3fdpxKZrM7p8VlRlQOMu2+Nkel726yhvs9hALWx0UVppk4iKV
rj/dzd/Oiwaf/Tk3DwMnfiv4RyUU1YnVusUnche1KKHfwHGCzLAnlu286wQXruug
Xl6onBQiF3rDqkLVrHcqMiasCJHLS2S9xktDiKwNCphATHFuZtzUIZeJK+yNiF+M
JKXN1xQFq8k9kb2q8y8qAgf1dY3wW9Xj4iP1Qo9Bzx1CxJTLpezIk3QTcCWKUkE+
2/4Nly+M5GoJDv59gzjvPmyWPTr6TZ3lrls/Z/rjAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBQBbv4tGvdNY+P2A62GfhR
cyNDjXUKk+YHY64hGeiXp61l8e2Hf58lV9lgBoMpniXUvMk9Nx0g+d1Gsoc9VWHs
LP1MhVaf0zodeK45jJxuzCC+eDHSNmvhkUJEVD8LDgmHTJlddpwYBwKocyr4m3XX
2QMcgiKcYaqIt5MLFwCWuarQ6bXKT88qRVTxKTA4FoqXXqJKCbAsEMql1h+dvXeV
yTwPK3vuRrZxyiIYlILG/tgNS6P+qUwLCnYjoPX2Ml3djMkUhRBdsTWR8wWTYkb0
qmqKNsNL7+OHzUI+Z8WBoja8MHVZohl0iDAvFO7Y67ovldeYS8mlb0Tv3nVRUhiM
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDlm9CbdDwaD7gU
kwY+Y2by3np+QtBFoJtk4hcbdAQ4Vd277sJGve+iYg4vCCg3fdpxKZrM7p8VlRlQ
OMu2+Nkel726yhvs9hALWx0UVppk4iKVrj/dzd/Oiwaf/Tk3DwMnfiv4RyUU1YnV
usUnche1KKHfwHGCzLAnlu286wQXruugXl6onBQiF3rDqkLVrHcqMiasCJHLS2S9
xktDiKwNCphATHFuZtzUIZeJK+yNiF+MJKXN1xQFq8k9kb2q8y8qAgf1dY3wW9Xj
4iP1Qo9Bzx1CxJTLpezIk3QTcCWKUkE+2/4Nly+M5GoJDv59gzjvPmyWPTr6TZ3l
rls/Z/rjAgMBAAECggEBAN3qO7OToucZXDPeacFwtzZy2ncfwkYZVTcq4WRyPAXq
z5TszS4sMuiB1u2T97KyW6bVrDz3QCBO65lCW3nrh4Vu6TwYTOc4Zwdit3dJwI1S
llSOhkGs0evBKNUGm/7f7o+D/aFHucoqHL7KdfSK6+j2bYVhbRQbGwIYeIwHpPvx
CjF4dzPAurZzyKwb1xbjGxe8U6Wz/l27prb7Ac/SowCToFEnZc2UTDlsddxX3JN0
sr4eFLI0O3NQZNC6PQE8AcqXfUzvYmwelieh+Ih6bT4/VdaP+m88Ch82nnjm+aN+
GVVOSSMSPBdltK6MFBGFnklGyFH1PeeUHlr5YoEdUmECgYEA9W+qYw9tbag4iDh2
sHCBMhciAG8y1S8gwjZ8OrIyb5pBd8qjC3LXtDjvQPZEdngIqbgq0bE/vOg+ewnf
1cddOuvaCieje36aCHCRi6ugU1c6zTLU/dRjYEf77qsaku/zLEw9omj7WZWNdIjN
4lKUaAoZqjL/72ptyl/c1xS/UHECgYEA733A+VBgeCun0LQoOOHw5ZeIj0d0JMFn
6oTsC6IzYcagXhZJ74G+l4FZBPM9wQ8H+wqcdbwZDq7VM+klqa692D+Gcs6bHuw/
CwP3wWShwyZt5p/++eVLBc1kR1vKlE16CDLm61t9h/bnbR2afvd0wYRlJd+CPuV0
mCi6m0EeapMCgYAZxPSt2/PQXKY63zrPAbD+8mDWjNZYfc9BtPjMLOOQxjBzhGok
DJXLTWMJfhHoImg+caDFTYf0rKnKv1mqF3mZcyP8hvbqQ3umwTL26Dk4JuN8ogas
8/zPIh+4imyK2vi8QPEDuWQSntowTyDWz3bXiZ/yN9KZb6JBallEl+AScQKBgEh2
7osBjQ8Pdomp2XnMs81kmodwAW6VrtHBQoMKoy10olWVvO1hfr/s/XiH+SmPWMTX
Ixxku9g7gntgkmrTWtIx9oaKiVlD9pdorfCweFnKKPrdcpM+lAK/cRY+af+RqdkN
Pd39IvCe/st/Z53/Vi6v1sMs7AYH+82GlWAgxglNAoGAenbzsZhOZ8QhhC3xPCkV
0iJ6E5znVtXraIPmK22PyiH3yz7X5PFW8QOumS47TDYhX8IIw9qCaH7nMdV4SOvz
vDapMTO6TD+6GzKoMOXCBK3G/maoZMc8ENAQOcUFeFl44mxUVAVnz0dDyFHgTK+Q
NEhbtfmhfnhXGLOU2l+lvgc=
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUdCBu6ITWB8mIr3CFYUGSoidgl9IwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC6CqdPjfQSDqwE+0QwTkW3Gq2z+SdyOkCbA1f65tpk9dzN
yLx2xtHRV433IUFRxY4slpeO/ff/yWI11e8aubv1TJt1Df2XJWsrTSpasHiB0cQu
sBIUPCw0KkvNsZ93UVRArKyiNIut3tFTvM54hzUsSpMnH3gUiF2osJP/qFi9Fm4w
nHhhvjnm98YZ73r9qmS7x1pRLkduOLauQrZeMGtfqPbrDn+zrXISJz/WlVs1RFtj
S//fsuWYX1mecsowyj2uPgCiWxd4uYcnYEmv8o1+3yMucR6dWQCQxxLFaN4vgksz
vxQRQ+GzLYBG4rGXaJhuTd7zNX4MAvFC7dZF4Ey/AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCWFqbiMrpwtfPP9S5YKnFw
kv6aDeUeq6GYfoBdKYnVpfaXQgPXzc8eiNXptAPuMIVoSn811Hg+p9SsEjKBjPlZ
jdbbl44S2owhrJ7N4H5qTSoryBvuTwlh+aQDsDh+x5uO7PQzb2F3yU2cM2MvtU+2
4pYr0Pucs2A0XzqWp+cZLhWHcTOm391Ab+Vr+Q/ZguvOxbmsBCs+qwSlPaktd9Yw
AqNKFau9hAnb++jd3k08EN8GBVlQBP/njdEoWEGjHD2SnTo2z1sv5jF+t9E28Swm
QbkNYNrgryTYJzPDZMMrK6DkkEFnH0djbKjwAdkooHr0pa9COcuYMhsqNMZ8irgY
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC6CqdPjfQSDqwE
+0QwTkW3Gq2z+SdyOkCbA1f65tpk9dzNyLx2xtHRV433IUFRxY4slpeO/ff/yWI1
1e8aubv1TJt1Df2XJWsrTSpasHiB0cQusBIUPCw0KkvNsZ93UVRArKyiNIut3tFT
vM54hzUsSpMnH3gUiF2osJP/qFi9Fm4wnHhhvjnm98YZ73r9qmS7x1pRLkduOLau
QrZeMGtfqPbrDn+zrXISJz/WlVs1RFtjS//fsuWYX1mecsowyj2uPgCiWxd4uYcn
YEmv8o1+3yMucR6dWQCQxxLFaN4vgkszvxQRQ+GzLYBG4rGXaJhuTd7zNX4MAvFC
7dZF4Ey/AgMBAAECggEAVfCJ7UQD1TuV1w9DJpVhuv3F8/dKc4fZREI9KBfwFudE
QoNSHAQn9G5flCN2ixGZZZuDE3jaUPx0M65Jr6zQ2LW0slPuKx4L7YrN3+rZIA8I
cxC+qT5KpSZMsg41PecB5oZdkOh5Ba6CQA5dymua8oTYiSAOVl3P9hbrpxPbOi0S
CAwC5u1FNFnLmT1TCFmQcIH3x1sKssoNLZNMQLJLHg6eFNu9WF4iNctlIcAjgoPI
5+eRvjJiKI5g2ddoYwypcnohNzgvTnlb5KBqo9fGJ+ArThy5x7JyJAfvgfFbKkVA
wlfUfI4n2rPl0XwWwk7y/D5RIRywxC+RpKL7+JPTYQKBgQDtwuvZza+0DMTP8qoU
fWWXksAtKYWUN8iv+zuWMMSauAwy4lzyBDnZQ+JmF3kMxQEPXKdwB347xCOgL8YF
5yygB95FjCjAI7VUVn4R1svhfk3B0vgfAt4o2JHcTN9akRk87wUAocl3KhmGiBXZ
qPxZ3UmBxbzGshAdkgiZ5GDexwKBgQDIUBOH6HbNaTvolMC9IMtZJFcEN1i4xzd0
g27Q2/eljzoqnGOrycV2x2w/iAigeV4bkzrdFaWMoXEAtyQ3OBGhG3Xwapf2TRze
y9dZjVSFWAj5MVPCObkmCTMi8DNaoHQF5nyxzE3ICSf+xgFr5JDDiXroKru5L/g5
LewL3QsKSQKBgQC2ybQorkj2Uxq8BANd3UnNTbURA2r+mCRhpvQYc0Wy7Ovz8rMi
HL2cmuPjOQiHGK3H8aOILTqPGCuLay8COsfEAEiRjz+E9+7f997UOB5mLYP6DwdS
UBIbtOPuSess5YBRqDBgXAFW67bUBqtFuvTG4akxa6PF3f8lvK+AIGOY4QKBgDgs
1L1ZgO+sImPgS4j+iGhwW4LQLq5rF+8x6MLj3ThtyUcn4n/LrvfXh1DtylWOk8ix
6mET8ABXSgSEV8CwlakTtWh9zC4DhCQrEDKKAvj+Lk4L+kxOudCj5dZXfF9e/gql
j7Sg8fM2NiQpzT4/tCVSCcjQKyMNA9StPzQ4gh8ZAoGAZJ/TTNNL0oMgcq1aRmLi
p0yZQOIijGVnbt5l6V8Xtcw3Gb54/mC0Y9kerQkpKzCUxBkT4pZqTJpWHo6cZF0Y
szbK5Ti1iNTlmAn87kG5nKQIUtvg4+rtSixbHy0lTiXHavSr5MXNXAy/3Yr+nSwg
a8dV9Of3/E3C1kAjnrW8Ry4=
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUJWB6PMvY6/sycKKe2rKlyk2Jhx0wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDpNyGq9RLF09KE+uiFLgNAWUXiUWRDWS86+S+knZMa40Pi
iDdpxcRxNgxUVioleNfKIuXQp1eKCwCuAv8js9hRqOIkEfZHtiNaai4iJWYKD8v6
/Mh1iTQ8evvsxR9Edlr2vpf86uWcIZ6NfD2R0QuDNi/rEQimilQr9O0zgpVcZ/rX
lu/ApUkBZP7nRXSgFDwyxub9eGO/XXYCFiaznFEewdEwMxJ7mekMejT+47QZj1PJ
JLII1sgGUMOnwauUqub4L3ibcFtWVI948ckq/vaYsX/MVYZ+Vr8sDpcuAZC+2FuZ
Wj8cjoFXGG2uHbXilw/+9uHiIpH9jE7sQLz7RUOjAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCCivAYNk17t6dwt0l3GmiO
eEQp2nXF7hkt3Nws4+GefOrcCzyTAoinwGzoSJpuv6YdIp8txyylWeEVVrvJRXyg
3m648yIgnp3U5fSD6a2V7GnCSOjCoT1dlcIMFPuOk/XKN/0acfAEsJGscS0y/mVQ
MiJjjNv3K+ZzY8nDu+UxdC+cqLaY3KFF9QarWNjyiDjRi+7NrJN6mdGtZITSND1w
3RXLCSaaB5VTHqkSTGNrSMr8Y5CGgXyPq9sQMLS2Hfb8K/Y57xlnuJJEkHo09pUF
mz79hUFHqgjrtxAd4UoBUujTpwBN1on/KFrYa7fGwmisb1V35Qjjogs8AGD8tnh7
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDpNyGq9RLF09KE
+uiFLgNAWUXiUWRDWS86+S+knZMa40PiiDdpxcRxNgxUVioleNfKIuXQp1eKCwCu
Av8js9hRqOIkEfZHtiNaai4iJWYKD8v6/Mh1iTQ8evvsxR9Edlr2vpf86uWcIZ6N
fD2R0QuDNi/rEQimilQr9O0zgpVcZ/rXlu/ApUkBZP7nRXSgFDwyxub9eGO/XXYC
FiaznFEewdEwMxJ7mekMejT+47QZj1PJJLII1sgGUMOnwauUqub4L3ibcFtWVI94
8ckq/vaYsX/MVYZ+Vr8sDpcuAZC+2FuZWj8cjoFXGG2uHbXilw/+9uHiIpH9jE7s
QLz7RUOjAgMBAAECggEAA8wE/U6OJrBjLg0Tug9cuDB75cpjcoFCNpiWAP0bxwVK
Nqb3F/7DSwCRRNI+T2vfP4g/65y93R5+vVaJJuCntfSk8edk9hfuDWvLIn0vYxyM
uqJg9SDtu8pYzasL7kZrBrdlrBV69YbKmQ0bx4L6yAEa2J3nYSbBZhHPxtXqbp2u
z4knTBjpMEyCAvnPto4GBWYyEmix1PEGWDaZQxhUZcWTCGg61O9A/gLiNMntyAsC
pe9+cqJPUsBau3y5At6mXIcK9psA/bLIzjlimRMzC2WJ0rl0niovVMVEJoetDNFy
CDjUYMH8FHow4ujhA3KHVFwrEhIIz/mmF4QevLrHUQKBgQD5mhnl4C4DCS7/TvdW
0v6eaIvnKyUTKclV/dahbsFlvCMF0TVzI8uSIVPjs/D5FgHVnk5aE8rPN5asfXUj
YU/UjC5qE9sKszThnhW+NitePoaxfgJcvJP3PLIarhZCHV5b4zBmT3OtOAvYfvRa
TJuXpx2YOyxcpXdLLmzWtzWD2QKBgQDvMYAympkIvQWy8VwbUGL5VwO0GaOhxCiR
7IJYefn91cqB9VxV4vElbi2z+wVO0H+mukdBnQ1r9PPL3eTDzL/I9lgIItKXufhz
T6hC/QhZlrp33rFfHH/2fbvBaDVOCEkXEGiQM/IUjN6reR1hRAmt34bj3eEfgjK/
zZyn6+Kh2wKBgQC45uyKeyD6xMHZBgF6g0F1zdLeA/sqEAmDN1DZM/f2yoFTXODw
k7LJZQEFLJa1nxTqz6QRXJogGXj3/NRaykreFJ6JnH3mlkz1WiuXRf+oiD81mzha
xKQEQiVaWF5KygDNpyaClBcIWf2Eer+/aQLWPElTLXq2gyk1O4YLJZtyOQKBgHIB
0Q3NnCWLGt1Ip1MphJM9wzkjg1fGTGQJK7OKJ/qx3P0GesVBDxl9I3GGsuf2/vD0
FqSSe+Q58732/GPLApqBuEHgfynsbRxhGl0bh9BTxHr//ODNj7xn/4bW6ZlQ362L
l5sr9zWOU0+9waArssVaJkwT5IqFHzVGhmWPTA1DAoGBAPlDNCTFmamuBygx+mD0
pAqcCcSNFPT2/QnKAEJKRz2XKNTXrEvfaFKaI7L78wZiKVZpwqKqSTL4C+OeMdG0
T2VKa/FosuS45sW4zA/IQsM6xCSQoSh/O0YcjSvdP6NiRcIO3feZb24TzgOUl/Sf
lBBukQk2x+6YHo4NOH+suXQw
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUIOpxHZYryCoSWIfdQ8uCSoeS3KkwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkzMFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC/LMgHvqhwBTGYi8fLSDC5BAMvpZlHojkCtD2tAe8x4xES
ziFbEN0h3majAaFEbKWf38QwZb8+MTqtqC3hBXLlmQMOHJ98B+pcJiquWmDFadWm
mRv/aSsDcN8Nuil07mTYVl4KjqJ3BIuBgBF6VHU5EtALFPwM/xnFONPB5BC4Gm6X
/Bb9QQ4lBZVbXvuaHoiY/qXZeM/M0J4jGjgW3CvFKx6Cg3QrSPTZQRo7YoFOJzCe
WEU1NjaY32vstiK7qTFJCZ+Vfk3NNU0QealoqUdd7SeTNgPwEpYlTLalyKJHGPAU
yeq2LHmUX9F81MZIdk3Y2ugwonIjdAgo2d1Bft1nAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQC1ACGsaR3WXsh2iMZEtbFU
JDbmDgviv1WCft7Lt0lpTWCNq24PXn5EOFU2UPBcsLCjoMfgvjj+b4dVcGt7mX91
dtMIwEORe9stfr1Y1Frql9nMgk8PyRYDt4oUUUwwZ/MjqU3ZiP4znsiZuEGTAdKb
BqhVubSZdYOIrYV5Chbta7/OXxXpOv458CWLKqvfoDVsWldhQDWOkeh6nz8dkPO3
Jt0IRUPqS7TV2fUcbHLpO3z1xUxL83xN3wgoBafSSbvVcLAN1+//+1JqLPxznSjV
rYf9ERqDwJpIGysbRvIyu+ahf0zJwBwob/O6+1vuryLQ2SdMFIlk57U6JOkePfEy
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC/LMgHvqhwBTGY
i8fLSDC5BAMvpZlHojkCtD2tAe8x4xESziFbEN0h3majAaFEbKWf38QwZb8+MTqt
qC3hBXLlmQMOHJ98B+pcJiquWmDFadWmmRv/aSsDcN8Nuil07mTYVl4KjqJ3BIuB
gBF6VHU5EtALFPwM/xnFONPB5BC4Gm6X/Bb9QQ4lBZVbXvuaHoiY/qXZeM/M0J4j
GjgW3CvFKx6Cg3QrSPTZQRo7YoFOJzCeWEU1NjaY32vstiK7qTFJCZ+Vfk3NNU0Q
ealoqUdd7SeTNgPwEpYlTLalyKJHGPAUyeq2LHmUX9F81MZIdk3Y2ugwonIjdAgo
2d1Bft1nAgMBAAECggEBAKgxA8MckCAN0bZ9s8c6ufLsfskajiIhrLqeTGy7eO+Q
7+J1i48M5R/5BJ+AvZrvYz+mpHpX6csTkKZbghGos48f8TonIIEEjcGIqqA+T0kf
daJere0lX3xlfzgagoKngf167r2nA3RmgT3rqHTRfVg7HuHBEod0n/2No2+/8J2m
zI0eyorzofIjzRZt03/LSJvYKla8MPSEyrPHay+xQTsU9KmqoxXJdH04fWBnvE8N
/187j/AWUroFoZxtyr3+csbmCxYwYasfuLbI8afkrzTLM1bhvbdIdVVzApBjb5Dp
s67i3rxW9+36bWQx7wiTIQbI01ySxGNv0U4vdEFJVPECgYEA8wnp2oYwE96qR+Tp
CAA9PBW0lB6s87c7eF1OFrxVNFjmTvTFA4iELp+6wCe7L/9m2phL9TatJwRreukm
TdSNVn99HORJQrz3wzAc2IM2wVmuykNL9iXBiTS9EyDPv5wb9V8bY3wNXwGeDEgE
1rRfcLwDe9P8ywdXFiWxsa5llWMCgYEAyV7MHNzNl7Vba+Su+FOwgrqSi+wxcFT1
vPpUoy6xnyVYBOteSNoNhIKVrQ5P0gBN85fDjcqYba3dn5NdybcJT1SkBlGSkUSt
3uHEYYCkA/RNY4cbc0rcqIjXfsbhEdGjETV4ekiY3UwkWXRKAwzI6tUi9t+9vWOB
xhwfu3iKaS0CgYEA7zYtt4lmHtiFr5euidJ6cv5GK5f50TPjU/g6WQRrtMdfgA1J
MM4YlC9hR6qTgo2Wtcc61BNJ4GJoS6TZr7dqmd2Hzn0fYpHOJ47ehXi41xwnfys3
xAGreRmwk/gyorzLg/plYckC/CUCY8IrCQyl97cGksW3RjpmTAUz3dfyYlMCgYB+
OSXIkb9tcQi1QMtMbWkfCMQDYTI8L4U5x9B12TcNguMBcmfPUp9WiGQ57daq0/YI
0wCJSIzzcyCQflczsb/sMin+q/Mri9lQ9EOcun4U3HYGBRJ32l0mZ2Bs300FVlrY
1qOGQytOzAOc7v/VmZX3XVJlXSoaJN2byNU7NfvMoQKBgDtfPGowSJN7Jacpt7CT
5CiaF13M+lDwkpMFVNIJj4tWwFpE1IuqWhfSNKkR+vVl3xahxRh2F5X4MQ8LRdtS
11mELfdBi+IRudn4Mpn6Hl/E1U9/wxEFjXfEMZrNQA3ekZTAzMoH0yEsIBCX+KIl
QSJ3WfEjOC9Xe5CR6qPEmR99
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_7: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_7: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
