from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUD5VUdvJQlRhGJg2WJ+/K8I2sYZcwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDMyMzE3MjkyN1oXDTMyMDMy
MDE3MjkyN1owRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEA47sS3nsWACyhnX2pvqdSMSfDWyeF1t+kmVvap2hk22yA
oAM56XCtHifhP8Zu8nI8uumP7Bnh8sW4yqE1Tl/Y5gkYD57r4ZH9o5lj1FvnZnoJ
lERpCpgeR9Lpw6xqfoPt+9a/KR6mQ93AwqH6tyqSicl+7TTNp8UAdAN/oFnymQ3T
VcBXV30YgiX3GIYNvcV0f+hglgA3BsprZLJRuaCv9fLT8PlhCqrFyJ67XflT98nE
0pyaGIAEcvPCPQstAkcc9nnhmARkoAq7/3dsOWRr31paoWAnrSzXJtb+NWomlNEQ
ZADbNd68TIV40H6bcN45ff1nOfC78NJkXIjwdnFmuwIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAnl8bxBpQL41lIPB/o1Fe629IK
pFpJDjLC8xyUZrcoZigEYZ+O06Kbc8W52n3awRlLgSMjPUjwb3JExhPW1JcL2DAJ
ARoiu5XDCoTVAADeUAyf60YfARlu9y+hRDUSgYrUknuvJ07fTobJ4JbpMvP/mI9T
ILNZNJZVcaSD4ectURKYkveGtm5R9F3LIO0gscEFgWkhrPeLjiU6Hm1uuZgjRW8C
o57vHwW4yfmiWaXb3dwIjh8SBMgv/g9iDZskIkTCfRBEp8jM4ZlCAII0sNejSLkG
NjUDOtD3AYD46mLU9uOUkv/ecDn13usCaJSnQ7RfO7S/yGZQEcNw+DHHQXbS
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEwAIBADANBgkqhkiG9w0BAQEFAASCBKowggSmAgEAAoIBAQDjuxLeexYALKGd
fam+p1IxJ8NbJ4XW36SZW9qnaGTbbICgAznpcK0eJ+E/xm7ycjy66Y/sGeHyxbjK
oTVOX9jmCRgPnuvhkf2jmWPUW+dmegmURGkKmB5H0unDrGp+g+371r8pHqZD3cDC
ofq3KpKJyX7tNM2nxQB0A3+gWfKZDdNVwFdXfRiCJfcYhg29xXR/6GCWADcGymtk
slG5oK/18tPw+WEKqsXInrtd+VP3ycTSnJoYgARy88I9Cy0CRxz2eeGYBGSgCrv/
d2w5ZGvfWlqhYCetLNcm1v41aiaU0RBkANs13rxMhXjQfptw3jl9/Wc58Lvw0mRc
iPB2cWa7AgMBAAECggEBANtdA5MNq6alV1SWjKEbGeBBtjujOZg+u5YCVgA2XhjD
Tq9UDD/iis/miGJfadXe1sMRYtKCKBUsApIlcWy6hPspPWUmp38UmucxRWl00dTz
rzCEKU7MMzbqYsVa2wZdXSvesysP3Aa5oAmb8B7qQle5oasq1wNJj+Mwz4qNulNU
nSJZVLbJC05B9+A5zaX1JeLsTDEhxwEatsUf5r4k5khsuw8xfALOjWLQ8x4CQb8W
d6qQIbsERzZFZ5CXqfOSjEA3J2UsvCcmbMZd35Q8AmjZNNGWRekrTolv/7Cw9KkS
rdKKb0hBAwenyTG0VKOCvawMbbyDRJF9X8rdExfwDfECgYEA/ypcZfxA2XghsYmX
vzqWTlwLNWUTOYJKA9wpW/tXqE9aSdFQic6sHhRsjrqEUArdIYmuzr6DKP/UYHiY
zzxNJ0YlqJ9me3h16QDc1l1luswg2ghxLrgoUakXIWWPzXPHBfIQOK1yHBiuQwRD
xj7A7bSV6kI+gS4yeFsn6QfbaFMCgYEA5Hm+LK7ubUNT2q/llaEWhLX60NPeDfMe
wpKusrPmwTTu0/Pm30VDO0p9+Wa/2MK6sOoL4OujTS/5afFRBK4Nhc2T0ldTQvL5
n9O3tLcARlCRquPJr+OQMQKwRAm64e06j8Itz+t6rg94bcgeqgAjAlHaUuhKYDX9
sWQGrPC9mvkCgYEAnvlGbefWg2b8Hv9pgqO+x31DInYhnx/Ue0ksn3kdqOgfiYQW
WHVh+K+i3t3H15KdKOr99SLu1pllOOGJ2vtn2kMy7Ta6g8yOMafu7sNrwRCymwTN
d10XCaF+nrkG+erbIZIplxZA1M5vq6M5kobAbpinGjdBd/xPR3sLh3z0rq8CgYEA
pvDFokSXdkKxrKLFsBUqLQIDKD8Gi07PdQBUocKNozKYJ0qZsR4cx9/gODF5kFqI
quf4kfnbMnURWvW2ayL6QoA5uIGSFuMOvlembWchzj7kkOcr4Vb3brg2LyCk6pu6
JHyPmNLIqxImvqBwt2quKe3BBr8wSShqHAmoTwkAoZECgYEAtNOneyR48yX/AKl3
O86o0y8nOgNX3FfW208IoXSk04oyYV1JGJvwk3p2lG5DkK6Atio1CAwTHGCnK124
ZVGwAun+Eo2jsxgKYtGxEBxIh7pimC+dVjDL65+PtCEbeEI8EwIALZgctMAACTN2
KiiTKFOa19a1Jkm5mVRiAuwxD2A=
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUI/qIR41vNfZrImHDASkbd5CdhdkwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyN1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQClBLYsg7P6WBNexxAiF04sCZN6saN+dI0Q/KAN1Rp2jfTX
nApvuNImoc2fozCViausJmEWKtx7RHQheDJmx+0LSpQ0fgdJJSNK5UVRme/pgVyE
/FACdD+fBuiasX1LoaBUqk7mpfeyQpfwKW5D1q3HgDK5ROmiaMe5VnMD0BvW/QYc
1T3TDuBLXYZpAg7c+fdqmBKx4wnE1v9PqChdUd2AQF2INdQuz3QOHGAQ+cJsXqvy
cwep0LvlK9/j9dy08qKFvc40EZwsYqOh0HT6KzUupVh80qhZxOz3QSok6gNhGpnI
JHOFvJ+i2P48Wb05dCiqBqYkEnNQ252b1l7o+grjAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBYYc7lM9pM40R/SUMzhI4C
D59d0VMwKjTqXRy2ifrcZYVxmc9CAldj+nk04piXC+YxUihsIRSOxppd2I72lbo7
bCRPxj0rYK/iNBlkzFwvVCQ2e/chcKcFOEcXzEpKGzVpL2GyLv/NpxH87hLLJwSG
FPGsMm5MznnMDuCX1ALedLFKyvMoy8SSg/+z7TNiblJxEabxgEADpC/pbkLnJvlv
qQBTPZk9LD02ZXivI624ltlQt92tqIUFZBfQXKe6WDjz2IzeeaYSlhTBKvqzXXXg
aUXnGR1lA3Q7dBaCPSNkUimOm0qT6t81DLkvoSyQu3P0OvKFCmZNLxDbxEO5LBAK
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQClBLYsg7P6WBNe
xxAiF04sCZN6saN+dI0Q/KAN1Rp2jfTXnApvuNImoc2fozCViausJmEWKtx7RHQh
eDJmx+0LSpQ0fgdJJSNK5UVRme/pgVyE/FACdD+fBuiasX1LoaBUqk7mpfeyQpfw
KW5D1q3HgDK5ROmiaMe5VnMD0BvW/QYc1T3TDuBLXYZpAg7c+fdqmBKx4wnE1v9P
qChdUd2AQF2INdQuz3QOHGAQ+cJsXqvycwep0LvlK9/j9dy08qKFvc40EZwsYqOh
0HT6KzUupVh80qhZxOz3QSok6gNhGpnIJHOFvJ+i2P48Wb05dCiqBqYkEnNQ252b
1l7o+grjAgMBAAECggEAYog5rsLFSIompsT94R1BVBIzuWMwWGWHhckSWLASKRAC
Tmuh36vf76lVeiia7e9STmxsNCxLkl8BaKq4jZ567+8MJ3vJJefC9wmHJn5gPnE7
qTxvGcgH5RDe+t9YDTzo2yUGD7qx+ALDbmeOq3sYMLNfljiLuKoP956i9nfg57Ef
4np0TSu2U7qFuVueuTyOAklT8Kwr58/JuTJT8OmWzoAwQj+z/qwLsCOJ6rgc3yUm
mc5LTcsPtejldBHMcMfMp+vIU/rL82DSUacf1YPWRFa29DYkBy31XZVOA1QVx1UY
gKqfTW6Khv7eMj8vJ9bKUyqGg84m/8ruLcGmaL4UgQKBgQDRYh5YQBES4u+zawUV
3GRRt/MmkRWs+JXLntyxzv6r/l1vp8V3idECtyvxWgVBxVsTMwtdwlDNXyVclRpw
962PA2H73U1R0zp0VGi0b4Bhz0ZvTB39gyDk8LKrBZB9FcePs4sHaJDuMjahlKL4
xI0sG41mI+g/kPWpK/ImVjjckwKBgQDJwf/91Y/z+6TLFxm7B/6p6x5ntK0KmtNd
jX54Sbqi/yiR6C9R89ZdRIWne+7udR/6NBuPcrJ6aRRwObE1c0qxYbLGl1Qb/aSa
DQyS2TL6d1WFcgon9uSIEV9lqDGcg7kzIFQGgP0qvnl0LDgHAgNChDyHlKMG4pxA
17oC3HdacQKBgQCmskcWW2s8bhAH95wE24HCzYB3o+pt2zrm8YMizHlU1R3uVtOP
Z9lPICWL8O9efZEUp/7Ulm9eEfHc05hJd+ZlhXvs2TNFgbV4B/uUK3E6bZrV4PO/
cTYvDrIwFi4CZ+SJM5fsPgOkn7V+zqcxBsqd4xGfz9aHRRFPrf0LKHn8oQKBgQCX
UOitd35/fjwaFTk3DMfyqGQlY1xkl7nucDBqBuHzXWsQAxN6Y2ZijQGwm0KXlUBm
Zq5E58D0DdtGT/6YF9/tKVjrmJN8ar8IysCjYkLZlqaNbvou/vxnEKB7namXuTMt
JRHfzt4RMMnmV0Ot/dR0DrlW9iNPBqYp+6GGg9MAAQKBgGnTKFeTMysa2xN+KIpJ
YAZ7QdJqS/PwfdtAO5CdTDruIQfoVsyFG1k+79BNp8ukAwqu1sMy6Wz7anF/YE3b
3idpnIH58jTMCZ59e1OPHbeHEagWeHcURXF4xfw50G+S+T8h9t9rw+oP39tNBNx7
P5GQKfMA2fTj6H+1QLMkTF+E
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBJH2JfwoCndkFqwVE6FeUMjDVx4wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQClPnyntGjxicj7xn5m1Ujkgid5yz+/d/g6kdRTJt0Faeiz
oqm+9o0YUsLeKWSjOhjgcKGPh542JPzYqTaV531R8gIYJEDs9hGR3dbjmeu5RzVd
Ycv3Ru9BInMudjH5GeelUos0nT3OUJlb75QcNB2Q3miP2SfPcHNtGHa72VXCP7mN
zmiadi6gEJyPz32eBAh64CPoV177/sJqqlrFERmo+LyUgNNiTpFqwbKYIW2dCozG
3V/8dz25xQVvOMbVG7GnmRHXr6M6wTOefqsciOiGpPyfsTGfx++W+poGHrT1xqCL
IQNUVJZ+jip0BkWheR//bwe3RqCR/fCpbsd8CwTFAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAP3lZ7n12+Qq96lT5Q28/m
rldsTbJguDNPxOQYx8rvZO21Bf3YjJZmqAFM0H6wBgQf7d0CBru+3NxlwZs9RiLf
bpThwzl+oWWVw9dxyYmcBl6RXf9DvisbIxKvQloUWjPAGfRS64qyOqjjFwBc5dlc
r9AOzgsN1pM7f52o5Ks5frq0vfO20lVbkvFb9TfzcuzRh0xNROlrAVK2q3XEaEab
nBTNTYt5kq8KYU+s0jstlPFF9gGx+NOXKfZmdKtOfribuPJIQ5ADvxGDaWEmQHhF
PlgF7Y0kmP/vUknuY8rwMrGi+cncaafO+GIiaBXDGxa92SNWe2J7RtRWDC5NF1en
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQClPnyntGjxicj7
xn5m1Ujkgid5yz+/d/g6kdRTJt0Faeizoqm+9o0YUsLeKWSjOhjgcKGPh542JPzY
qTaV531R8gIYJEDs9hGR3dbjmeu5RzVdYcv3Ru9BInMudjH5GeelUos0nT3OUJlb
75QcNB2Q3miP2SfPcHNtGHa72VXCP7mNzmiadi6gEJyPz32eBAh64CPoV177/sJq
qlrFERmo+LyUgNNiTpFqwbKYIW2dCozG3V/8dz25xQVvOMbVG7GnmRHXr6M6wTOe
fqsciOiGpPyfsTGfx++W+poGHrT1xqCLIQNUVJZ+jip0BkWheR//bwe3RqCR/fCp
bsd8CwTFAgMBAAECggEBAISIvcp0tMcl0AHAjplD8Bb3HVpeXl7fhkTTugyHWzaA
X5fUm3kCnuAnYQx2/rS8YD+DltFb4NVkjTfpYFKTPLyA8pUSXtCv/B+WYkhip+IO
7wpa6hEG39bKHr/hJOu6j0TWE7i7dVsI4jgOzChi1GPhPtRBQ+DpPGr/+BtqkZId
5/CtnmEf0D9gHTWi5Vp+dLHGHfcmqh0iOp7W4vUsifEX6CGYfyGWJ8/bGYPo7Rj1
juSr7rvXmAubP5ROga8vCsSImg3kkt9sKciXDnP7UsPOUF9LaOXJlODudRCsm1Oe
VyDmhB1pozmcOj5HYKX+RTv/ZGKvSwoh58VjfaW+R/ECgYEA2XKNFhMu6+yLnJCj
7KsyykOJYesiQlmCXxmnsMBY/PoHCw6osXAS4EET461NiiQsMqymutY8s0pp9cBC
tF1XdZ9C4S8zlYxQreowZvdRfUvpLuIxre7joM9uT5NiSWMsfzaa9OaDn3mD1TJM
kgSh19bOQ1PhHr1O2C0dvmTNH5sCgYEAwoqK6CEW+tv12cQ4WcWBZPF8W35JHNmY
lAOG7nR2+MqZIHW6/Ed+zB1fSwkg1WrKU4HHvhsJBUREY6sTB9ynuWoYcS/Edeyg
rGjQDali8g/PylK+QwcVTxkyOGm6Rvx5J6pKYY4HgjcW+hfGXpdBUh83MpoK1Yil
HLJrPf7GIx8CgYBJ0825H/w/V8my95zgXuPYroN3fmjcVB2igkhgB35vLci0ZV67
F80g3JePJqj77PognmPhbZmgWfSN3qAHMuXd5pvDbs45yTEfSzLx0qiVPO/H3j51
ynT4hVTzqZumRQi3jGeiHJ21yIENIo3CydXVPXY8f78gO7AIT5EYsoq+XwKBgCfu
YAy9ngXn2FLWn+ptS934Y1o0VbWCRHs9LhkL9s+iZkPvZm4aDsC+1qyENyUXQmhZ
nzI6QmO+W3tJxiI6/IJmcJXrBBxgcapx6SKkvhaJgFE7IqqHbaxKs7A4o2+mqwel
QJc9m/TycdjrwF/yFApTNfVBATBLV/jH9pNHFExpAoGAd/Ar4NIaO2iOvCjXQIph
D3hkPA+e+K4g9xl81D5f8rFFj7AKXZ+3eIIfbd0501nnY0OVFVdp8IIjsUWHLnT+
OiMngy6lVfelNDegOIeSKLR4e3g3CADOqbhSbsEC44HbSiAjNB3kejN3Z5BMjQAW
zhl3fIHFOAbYHoEc9LC/GN0=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUT34idpoOlGXOYcUny2DMZVL5T4owDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDCzGdbpwHSb2Cr1yhXKPZ2aCWtHEksIl7ao2UCDO+ljCb0
n6PxHAbgVHKJ0vy7mC6Y1VXdstr4FS1Ak22V+4ceo1UW6Tsls4I9RunAjkfAl9J6
CzKCVr31L6GvWhIjgQBkxswmYK9AFx3WbOQfz7kN46usBX3YgAWiUwBseOS8KBuh
EWfguDqxL8yyPHf6v5kWy2QyfwUBITuLQE6AanbLrkoT5bRrE+06X7+PeKidHzXx
b72fSvuJ7ERbNPiHmmVoila6kb3PegcKnKsm7d6Blg9MwCeOcvTXRrXsCFHlJnlZ
YWczAKAvtd/OJeTEC4de4UTuuyuDm2+00FUjVKITAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAgc1DcbsLsxrKHZEoIENxp
2pB5LM2Kq284Pll7Ix5x7OH8JRenLLZCGMLK+AeW25UchHZ8iagHYR6tQrc+7CLI
piE6YKchJu340c3RONXcxDZUKqXBxalUyVcb3z8I/syiqsvDrE94hnGfp4X9Yg/M
7EIdv+I4y41qTxMD4HvVTcXVU5gapEC2mpOQ7mfN/rnIU1Gv6kpwG1FrnUyH+aP/
2lpVSke8eSY59W4hThqZNf5cSGw/t95CBHigePoTqoD5MfmGhhrwGrjr9JHXVMpX
IUNgsbuPb6N5J7a63Ilgr+26X2ZC2zco7Ff5zKz1xKPMvLQ4tGBjm4rwQ1r7F4jH
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDCzGdbpwHSb2Cr
1yhXKPZ2aCWtHEksIl7ao2UCDO+ljCb0n6PxHAbgVHKJ0vy7mC6Y1VXdstr4FS1A
k22V+4ceo1UW6Tsls4I9RunAjkfAl9J6CzKCVr31L6GvWhIjgQBkxswmYK9AFx3W
bOQfz7kN46usBX3YgAWiUwBseOS8KBuhEWfguDqxL8yyPHf6v5kWy2QyfwUBITuL
QE6AanbLrkoT5bRrE+06X7+PeKidHzXxb72fSvuJ7ERbNPiHmmVoila6kb3PegcK
nKsm7d6Blg9MwCeOcvTXRrXsCFHlJnlZYWczAKAvtd/OJeTEC4de4UTuuyuDm2+0
0FUjVKITAgMBAAECggEBAKdCezznGVlm6Mqj469zLKxeoHsTXoDWwjtZMNGh6eNr
g8dni4zrU7wqxm4xC3DIKrpv81p4yCtbg49/BwlQ/6P++oDBoles2pdi3DLJ+DIW
KlNAag4gDNsKGvpFjG2PxpbBW2lYeyG8t5H1zarC4VJbunvp+zR6OFw4iJSa+UvU
ZMXx9a9nw+JvFwwQds1pyXHnyulZ0Eo5mkhZdDn3cA4bC59ZfwQkVJ2/7OMmz4kg
itVU6otQyHDDcH1IpGRi8wYAFNEVjndTpG6LFHmMFEKtJ2i3lLtgiS1n4GjJlgOX
gs3NwSxa/woOoPflFuNFRcfqk9EPnFpO5xmcoIYIZQECgYEA5TJerspGqSsOVemC
9uR8j30RJL2scIFrzxIuMgoh0azMTUAhRXLEeNcf95hZBDW72CGoSBTS7I9wNsbB
HYOIqdXoz1jVGo7GAxV7tvTZKN4jOqn7rPBl6omxppQ9pFAU4bSApKOnEDcWtBk7
YdGedQhlPuOZdewJIzFyxia4hWkCgYEA2ZQ6DuZqDmJOCmw/fw768eQKL11c6J/7
bTEjTha7K3boRqk8Leg1bdPCwOQJNfuWOmjIjTJFBCA1S8+7+2uwFqoOFM5dNoUK
8ff4QD1JtcoqgUPteJDaI8nmz/C/1oCy7+nOkTxQjrX1FbHU02n2rM89hFpPlBBZ
vDS8bgBIEBsCgYAb9dAdLKoAGzONgYYrjmYvrwc3Xzg5JWC8izA9hITpqlXmGqu0
aDLVtxC8SMabP97hmAGKgZfVqg37cLXAXvp+FY1oNiMRMVewqp9EC4yucqMDlhcQ
2ubj/NZCRxVaBTb27ek/rINF9CJ96BIZddQJ3PNU/7kJ7LiUpYSl7bVW+QKBgFCx
yr6P8jGXf/4Zm4sSETv5KVXbuIOGIgejO8bQY2aBWTArv+f+wSIUcZx8dnYQ8uyC
xC6pwDMBhwKw7rUWgV5Gf6ZzytpXiXGoV+frUxUa/5ylhsM6Zcz0KqhgT6XMYZDd
FAGFbxMepOEA7T/jgtsgmV4m6HCvh7hnjqL1c8SVAoGBANkMW7qZKjYx1ikRC5w6
AkBouvDJQ8IP0lr8Z34x1v7YALWSi+nq/q7GD4I4Z1Bot11TXJZvEHf2UoLjbKLs
AoNvbiAIFGbKPmWyBqKmeVCQa000rXQxaDZ9/3SoZmkE7q0Tgv8Yw2wRy9DHEUaR
utOdTTwKn2bPzMmvjuuVGhGK
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUUFx52dcZRD27Ek1S8a4FJOg5WTwwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCvCRPBz1Wjq7GEdOtWDZUp0BTB4pTIuXP2F7bdAwPTJ7Pd
T6mjIPxM85E5sJL0pHvF49BZSFPm3OcrVv/4CHSZ9OV9aDGeioHZj5DdFZJDFv21
0E02uZSDZBJ6b22zbA0dqq/wWm/s6J6dbypcW4895QeH/OqMU//A4dFPeDJzBf0b
1BVjt/1QsFoEymb2nPRd0Pi05ROhuEaM4QuNSmncaFucLnDnn2UE3OB/O5K8zfyG
hsXxJx3RwS+0SLAIbzde9GxQUbU3SS0CFHN9J+UbeOX+fIBOvPrQsWZwRdOveTFS
tcqiEe0InWYXIIsfBxfdI0JNrsSrKlwMAhITg7yfAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAuBrB0tzL1s5Eaxv04bVeY
s2bktuk6zFw87kN9mJBEAQSkVAzx/5DfL/XT4uFhls3VyLOU2yMu7Vhxm2ZuMVXk
QdnhZ43T87lBnDBbZHd1NkrCY8UBqePB6cgA4JpmR1R8ypZmT6/V+POjqKGGwxJu
sxjF0f5VB78yJlPEoAnzYiqZUitZ1Lptq8K4ICORtN2yWG+dsq8Cv/dIvMOvEMpy
O6ozbk1qY0EaRuZAl7S/xghUq3QQOFZLQIkNGSJ5Q5xN1lqPJiDBinAjSb/r/zYn
edxjLvMjHDSLEfzyD9g1nmNq9z/8QsiYdc0mVMkkuvhXGDdCMOFmnZ0Zc3nPdvQ7
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCvCRPBz1Wjq7GE
dOtWDZUp0BTB4pTIuXP2F7bdAwPTJ7PdT6mjIPxM85E5sJL0pHvF49BZSFPm3Ocr
Vv/4CHSZ9OV9aDGeioHZj5DdFZJDFv210E02uZSDZBJ6b22zbA0dqq/wWm/s6J6d
bypcW4895QeH/OqMU//A4dFPeDJzBf0b1BVjt/1QsFoEymb2nPRd0Pi05ROhuEaM
4QuNSmncaFucLnDnn2UE3OB/O5K8zfyGhsXxJx3RwS+0SLAIbzde9GxQUbU3SS0C
FHN9J+UbeOX+fIBOvPrQsWZwRdOveTFStcqiEe0InWYXIIsfBxfdI0JNrsSrKlwM
AhITg7yfAgMBAAECggEAFZiTHXiNYnJOpr8eQjHO06fex8VDAjkPe6+VWlOC50yg
vo+TqJLrTjtHEc0ddJ3Ov63KCRoJcBSVWR2U229/o3c50W1Hof4I42T5RK3iq/Bs
QUCAJl5jWorAVObmrBqKy7xBlPAzmxFgcKBEo7yQQdy+PyMPdVzv00aJYrq7zsEc
BSnzgYsuDK6O7Vo1pnyfQ0z4/rARbGV24VSX/I2hImRBcCzyiQggDXJHUEagJyDN
cmcZj5YaCVCmZLFaKBrLuaCDqh0uhYZ/aOF4vsCwHfz1yAabvF/EOP1x+HeVKdkk
JtIMVwPaeXcOWCS2sOrYmmd0jcgvjqEGniKsmdU9AQKBgQDkRXOeJ6e64Z6AYCh3
QVpqP1b54SeBmaKQHQlrKREmlH0P02xdfEw/mIwCFtOX8daHUhJcPkzwM4F01gcc
lLWxvF+VasfFHjIeo9uhnDewVQ4SnrLJnUrl4Z9c8RabizTD2HK0Lligun7wM/zC
oF0S1gsv8I0pGG6TPBiaRgS2QQKBgQDETCbS795gc5wGedslMNnBBPOPJICXJU9r
YNouUS099iE/3dTLvg/uGHh7jIAHBXGE7umucRL80UM4xI57aGx3wThqaScjvoLb
/E1pE/3bB7qNT9GzDYcVu6pqkW8/MClj6uaa0a7+QQbZMoI6q9NRqvZrOZXyO0Vm
sZq9Hw563wKBgFDxi7DuMNzkujadYlv/UZdRRH8w5rhfCTT/BuL32fwLNVmSR9/S
fpsidasb+wXrHH45jQcmlFOsf+A1MKpi1RbkTCSIi7QLJAyXX/8rjNe7IVVa7tzt
KKzhV4g2eSTItPopW2sm8Ah2eSKl3KALC1XtjmP+cZ+76SHOco7p+yvBAoGANx1u
lTFWTdyIBWV3e3TA3yolvJ4yIL4QE4UpHXIbctdFtKnzUpV14ZMrWP01AUOtAPcX
06vZ+fRDnI/Ltai3M9Sjo3UM0UNveJbZoVREpZgA8CZmKZD1yctcaPmWs7YxGOXe
g7+2E5tscdV1rUWLWtXWxHpxuIad0NyzJsCujx8CgYEAyt4vj4rEjN0gFDfps3vS
nGpRhESh5P53cBQWF8XJhofRTQ8Vc5/9e06QLuTvkJjCwuJqtid7nfW26joC9jf1
oN48roPS4cXgGoj89n+uwgo5UCRSFZI0NTZvg2QRlGXV6N3GT8+MZHygf71LVfhj
X6TMkqmq3+T3pRy3Z5LGJAw=
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUR15D8Dk0zvppH7mRgS1FK1xRwf8wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC+v0wEABCQFqugGlVovy1kKU9YYWmPmK431Z2Gm8CECi6Q
GujhMJ4WYp9g/NhGcP7U6uQnuI1Ab0paDkPW4mMhqpfrrFE+dy0q+G/vlJZnD32U
BvAPHHd6z8QBJ3bM9t1mMZMPwi7iCadwQMDHaz+DOLC9EJO1FhsATAw8FLri8lJz
Acvs7LUwbRqoDn+7gR5lFg+kxSkEr/E0rVQZW27n+5nDE7lwU15O4czbczN+z1jA
ELSn/wJOFNyVsrDANALQ7ibHafWzk7T5wWDUyMsOSOd+E3uYz+myOJej9XpfwL2q
ANPkt8sa9XmJwiG2O/O45Lt/6nsjJzQbVuOW6jcHAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAqb3wJxEyRg3Z4UFzufrmK
WeWqEOCndJj5l3ppvf3yVW2VMoiqVssnfhtQ6LXJUZrl2qrkAYE0LFlWLpr9DQPG
i0Atr3dFH6+6f41pMe4GX2uusR/MdmRoU1mF2TpjxgkS8B5Q2aB23h/q6SR4n4bR
SWO7i3ARFljj9iAMVTOqrpyWbb+wuGWav709BqAXM7ZUYga6ifKaxL7ahr7K7HTY
yXbmisTBUY4yT7RYfvau1GyT93fU7K8cdtXBDHUBpVOWUJFQBHPKVKRivO7DkDTR
sPcphGcNjvGSNqjwGmN4Hzp+WC5/uJahRlhL7Y3+v3pfIeGUnOSatau6UuJpXNl1
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC+v0wEABCQFqug
GlVovy1kKU9YYWmPmK431Z2Gm8CECi6QGujhMJ4WYp9g/NhGcP7U6uQnuI1Ab0pa
DkPW4mMhqpfrrFE+dy0q+G/vlJZnD32UBvAPHHd6z8QBJ3bM9t1mMZMPwi7iCadw
QMDHaz+DOLC9EJO1FhsATAw8FLri8lJzAcvs7LUwbRqoDn+7gR5lFg+kxSkEr/E0
rVQZW27n+5nDE7lwU15O4czbczN+z1jAELSn/wJOFNyVsrDANALQ7ibHafWzk7T5
wWDUyMsOSOd+E3uYz+myOJej9XpfwL2qANPkt8sa9XmJwiG2O/O45Lt/6nsjJzQb
VuOW6jcHAgMBAAECggEBAIrrY39eVLG78Q7PXvjEk1hpRaJGf8zXE7sSVoGcmZ8Q
k0zcbFLlR51iAlVukEztKosC71uGa0lMREhGL14mzq/MQIyhmSH3RewPt+Yyvz8b
5weR7e/zeYj2G/gDN+CawjAVVteZQu/YvBti7YPPNhhphz6K/ihaixuyRw7SwjFZ
rHtR98UAzp/DVJhugvi5vFCsJgkoy9II8Tu0O26+d07W2vcQWsCjzgTkq48VFHWd
xojTsU8LYfu0ryox/w3+Sz0I3EDuOac9LkvJoig23CTiLWsVNXNljiE9APlw39v3
jtcQyJZJm1woXxb0tra9uNwmTZTp1NBSt7bh6PV3HUECgYEA4qtDyMWMH955Ds6e
sqzKH4WTnYXSoQ5Z2eH86ZnQFU+u3VHhG1yERtiThDrXgCUcCmJI/9KdDS+0HH8L
Qh/joBNGaHvqGyap4fR0rYUc2CKHYhixd0xP4CJkPOFOs11KJm7pmJ6B5B41SHHZ
1sl8shoRs/SX8D3E+auuPFpkJHECgYEA124Sob9VPHGeos0SwhZ89PhJVNcB84c4
zLEW8wl7w2up7vIC4h/JvD8k0kcTwnuCu8HRpktjANOjqSZBbty+I0iRxztMkJRz
MmOqW7RfEQhy7vQn7Vx6XYSSH/aXqrJQbjJZqm629famBZwWLIGEgbRIZ+M+fsjP
OaT+2HoK7vcCgYBYORi0+E7FyK2NmdYi7SXuhushkIierxtBtrfdpERdRxpkgg3/
vE6v1HP2L4DZG5iCYibPi4YdL8gGn1webJMIJvhsim5gCvhsPd17/Cdx6F6RS9Mm
/8jHEBu7pmYfYdwOgXTiNi+QPkG25LlI5DtohsUFKdpJY4FbO/sg+n2nwQKBgQCa
78Farx8AT78F23OoP0AzdvZWnCP9H72MCbk1phZq393hyhCkzLPsPYWf7hqZ/vZx
Tt4XOZTEnXHRT4Az2XKuMZ0WquFQAlQvY1q8habxux/eF583qREgfR4S+ujtjT0n
Y/L1Dpdroq6Yzj9sVuIT3rNMdDUYPhg7nxziWDPQ1QKBgQDe9VUT0kxWU38pdbSu
vDlYcJfc+liGzeiG9eKe6vW8dI11iL62EelCjIb+MDa3WNVCWuxt7bjlA1fOiH7a
Zkq3MS6RjYHuK+izNIXSTk/wIrnZ5+h/pKyd6O3zEx21CVPFwXHYQ6ey8+OfeeYw
y7J7htSxk+ms+o2sO3OTMlVxxA==
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUbNfOeBL5Eg+Tt37NytSIPVDVDKowDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDdwdMrIMRVxTYSO0s1krlXy/sAk/BYSKWEUIe6Htzc2GGn
gAVNdvOiVsXc+T213Euw7yvBb0pfRUmS5f1O+uWZespgDTsZUy0SJYOuHhGFmI9I
UelOX6Oy8fRDWVz8lovFKRcr2ytywXTAb1mTGad7VHwPW3DlnE/xeAfmLPjENQxy
qiUjxqgqK1U+mdhxIxMg5hScsFjWdZDvngKzH0bojgicnKwWAymG7eJDd31TFQ3d
Cs0SNPzXmNAOKCRkiAMgaln3hG3FXASQbl09JvEdYPpxcJXUePxBIXh6D8KhkAGS
LoFq4uXSw4cm1fMO/TGHtZgVOFS9+EprA8L2KSjpAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQC3ZKaUzSnUlaeNCdUvyRL4
RYVbzr5RuUPL085/JEtSpXUF7cZPMbpvpw/EWIUp+EPVG8h4/89F4L67MmHwCxgU
VwL2N87lk0b+TpOkLO93mO8gIGy7jJuIvDGqhWS13ocKI0Mm5Gl7n3zPS7pbqj2Z
F82nU6532WK16UBiYBYa4k+ZG4puYXpJc33/M8eiUQK5eY3sUL//OTJVz6WO8vCd
QVUn3+FwKZSJIaMaosKgb1SdHSqeti9RDNdQ44k6bfklZoz/NLOXi3bGUOt7RUp+
PEWLB7UnsI5qUY8aUU6g7PE3qt96dTy/9c+NTcpEnHj20wykofuPkaZOgDNgx51X
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDdwdMrIMRVxTYS
O0s1krlXy/sAk/BYSKWEUIe6Htzc2GGngAVNdvOiVsXc+T213Euw7yvBb0pfRUmS
5f1O+uWZespgDTsZUy0SJYOuHhGFmI9IUelOX6Oy8fRDWVz8lovFKRcr2ytywXTA
b1mTGad7VHwPW3DlnE/xeAfmLPjENQxyqiUjxqgqK1U+mdhxIxMg5hScsFjWdZDv
ngKzH0bojgicnKwWAymG7eJDd31TFQ3dCs0SNPzXmNAOKCRkiAMgaln3hG3FXASQ
bl09JvEdYPpxcJXUePxBIXh6D8KhkAGSLoFq4uXSw4cm1fMO/TGHtZgVOFS9+Epr
A8L2KSjpAgMBAAECggEAUzOe1EamA3xLzkla7Y3QZoWM9mmLOsR+/YbtdcKQoXe6
JAtfcfIYdSdTc5Y8NhiieY8y/o+P+vDXKvuJr/Fo5c3xUlqEevr/JRjYMCLt9g8I
a1z4SUSO+dvYBtDnl4mwhVfmbrj7s0GsWWst04hDk31eUrC/Shb8059yb0UeTRbb
eqwUbr6Ww+ca4IK/MmvPPY7EWwaFEPrp7Qvdm/jEyPEgpXacfIjwJr+taBCdgnjr
lNYxvPyp8hwfsUorZPv+mhqNo4GqJVDQW9AnFTks+gIN+o3UhDG3fngqE4TLfdry
86W3o2Rs37QFR0HozDkk9ODUjoRUwrBkyWuU33zBtQKBgQDu7inz5YzXpWhRabC7
7gL8Y3OJB2DuwMUPmwAsBGBoCV7yqX7+lTa/g9uBjQfsBDhh0tCQwb2T8nKK0vW4
hx230jc0StZqEVmzG7q4xrqWioRFbX/Ullr7IlsNCTSzc/hfEnXpcQH1EdWmMzgr
7vQjYePrAFn8oIAE8n36UyQYawKBgQDtmZPY9/tE9llQEPH8FxFe+AVCnRQHNxQJ
b6AR9ya5dQWx/GkQwvenqORhMbl7GaK7vhUlIx8lBvGCPH/yNXqqMRas4jX042as
vACfphKLiRNIU7PL+e6ds73TJlLUQ9YdOC3UrAilVXdhDDHy6cCPfD6Kg0pbak10
qqCu4P2o+wKBgQChGeslrai6mqftBQOKo6BVx0TWpyf/s/DrZcrG4yiR3YesvQaI
59ljZqfyAULPK8VMiFXi1Q9bm0UKP9Y41rn+APsCAlfyasJ9lvverPiQmtM28O8Z
S0wLOw4DiyqCuXZFvG/OuEjmkmDpUG3WiacJ2G5SPQlv4lSPgWXaDIcxAwKBgFsr
MdLwHGcyy8RwLBoZ092H96S+1x+Jn9ObFGWwWxiQcZYBD2OSHCsmIDO3O7+jb5Dw
d/afCmVPy724bzPGF4JUganmxuNnmk8veGHJ/JW0DEUVcQkUpt22SWFK9D9kpDTk
CJnxRQQDzmHbpxLZZLzp5KmLhS2clYntquhPhqWfAoGAZB+QRC+S2FSjXHCRhASB
snOTlq6dDdpnTjrsv+SQQlnZKScBcotRGKe4SvCGbfCAocwLLenlItTu6/UGKEbq
c28u6ySsPqYCRQ8EwmZcJfU0QgEvBwwzhgcfsiKlf1ck6MKdq6/0CwKE6TP2mAbj
/QFprGRD8Kb/Mqb7BRch9TE=
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUZGh0kY4W3yL0nzJVIYYmCTQM0LwwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDVy8kOTXSTWhLK3BILK95b5/tY1dq7ARqrv4tVDWcXuyGV
vPPNj2BibF3Iv+4Gr/6XeZEWmH2ybbEKrAws9aBIw7ETQhTNjoBlEvkoKvISBkkR
KaQ3lUQ0Km0BONsdSwxkgcgzn61TeSOlWgpOuW8EOXZNSEUJTxp82GbbdVH1TAXH
28oxUvrV/hPltxuQJ+3tcqN78VD2cGPwp4+RNYwklG04Jcj97wjv6v41jVrQ8IR2
k5GYuI8f9V6y1zw45A4XasZDb1/UmKk5cROSI/nJgOqZLmAhjK6eQMx1XqPYm2B/
e5J7V2nrOVhsasddwNH8fx+QhBz8cZwd7uK17oWdAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCpby2yro0LmC4xuhhuqs8q
pn4r6E5i5QTDHa5uVZ/GtNgYDP7x5MsSaWcVFHsq5TONiQY8rFg3iTMfoQTqvVqg
+4Eyopx/b7a8SryImxJXNVCNnY2GZ9DQIojYxDqiqsqDpIlgeR7FRCrjdy0W+5h3
Icbugg7sDeLYnerD9RAQciuClMC8jgAUc8LWXvI715kxTbrr2//8wu0YpfBLHln7
zL3zdyKcaAnqvbBx1FHgj4YI6ozfdpqYX88Uj4aeirCzHzT3QQGoAHXoDLFdg2yX
s44rft3s9/+MKiFdcvaxVkh5UIajc2q2ZZJ/mqdRtW/paO9cv+aNSdgPoRcn9hzb
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDVy8kOTXSTWhLK
3BILK95b5/tY1dq7ARqrv4tVDWcXuyGVvPPNj2BibF3Iv+4Gr/6XeZEWmH2ybbEK
rAws9aBIw7ETQhTNjoBlEvkoKvISBkkRKaQ3lUQ0Km0BONsdSwxkgcgzn61TeSOl
WgpOuW8EOXZNSEUJTxp82GbbdVH1TAXH28oxUvrV/hPltxuQJ+3tcqN78VD2cGPw
p4+RNYwklG04Jcj97wjv6v41jVrQ8IR2k5GYuI8f9V6y1zw45A4XasZDb1/UmKk5
cROSI/nJgOqZLmAhjK6eQMx1XqPYm2B/e5J7V2nrOVhsasddwNH8fx+QhBz8cZwd
7uK17oWdAgMBAAECggEAbOVomi1flHJLoiIn2qLUlpF5l80NpTSxxgtBR+gUu6So
PaHJuMkvudIijs8byTI5hiP4f77aP1jZ1Wq+pOPTaVyrw/hjqjPMOC9K02fUdtPW
wbQpHdqcq8l0TiwMh0YjoMnuFEVfvmW0f1N2bpTK9CbkmAaYi15MSozbDysZvMu2
yDpJqS42jIZIvXvCVzoaZiI7U3fzcplpqpHJ8rPTJANEjMeIa/1tA/ne481m/Rgv
T4slCDyU0bKrz6CvCyVPz3MzDzWmcJxYSMkGbeD73u3IjPEFbcIGHcoJ8C2CCtg1
nQEC8L4eHT6YTFBIQk4rleHTqv86dRgtwoolN4rcIQKBgQDtb9pZ85fAvPXyq3gC
phIFZXz8zMCPZQY+9sdvIz/LkU6kE0dZGB6/CsKAtdYAUtidKtsuz7sJwt2VREaj
loBPRd/F59rYwpQr0dUEsaPNACEv6DVnspRGJs+DFzF/2sQTRt9Ln0BqYP3LemxG
brLOp9q1i+8BB4zLxorHfSEYdQKBgQDmgsZ424fFEgIZk1tX/geCPV2f1Jz7bzBV
TnQqbRpPzatN10fYrvFfcSo3f5tLSel07AHZzjsx5ElbBrT9Agj7kw481xuHPqkf
LpaE+R9umGMF9RG1OUicnhAFt7ll2bu4ZOzNVJfJDm8DZuGQYeUtHmlN/yFtD9SK
kCCVFdDTiQKBgBsxnl6DCbRnb/vVK6+R+apoj0Ic6UkDFw4LEZhm/x1/jPQ5yQgp
PQxAXTqEmPf8hRarG+Nmo1Ng4CQCZ9zAlf1+UTzHa0c8MeA67hzVg58tDqAABm3U
BCtssoOfGmo8UgyrJ1Pv716/sRGm+dOvRgdpLiFw33TMupF0MdzbNfkpAoGBAJT1
p6pMO2WnqIG8jwfC2jlYzJrPu45kIPjPlRQhoyI1B2FrIDuveb2ylJR+uu0hW2M6
bEvDEM/B9YGESQtC+GkSc93vKBPy8zl6UrylfKFsink8EHBrDzhekH4RZxahaMTV
O43I/7lmwWiSYGt8R6wrfeNwXrpqw2+zicqt6V/5AoGBANEQxpu2Ji8SYmEb6hWe
pxYKlCdh62CtRh5cqPSw55G8LXldFK3QmHlOPGljc5XfuW9cOL1AKy3ZqRsrFqHM
/gINfX/9FCxPZ+DMsrnJzrGY+bmF0tvQS1ErdYPL3qqPv7nFY2mpIaiWUsAXFeZ1
ng06udTeYwfGwsNh7T712IZB
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBingUaQUNXQpmRUh3SWSFMUaSqkwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDTqgBgTsNxYUYJrT8MLFe8Myww/wTuLUhZWTkCqGzQ7grt
BPV1d5BTN2gthV1sltE3pjVowQrakbhnYyKQtxkuuaL2j+99cd1ZAC7BopxnDgnw
wNp7lkwsuV9de5GcykCz5wLzkfj5webvaOWsYptahtFkAv2Q2EgeXp8ZK7xoiW9p
uTZ/74+7i+FqY4M3DcM7/RATcQTtKW8qvqF3oFUXlFxZb7j0UMjqPGfzjP0ccze2
zKxes1lgcic8TzCHWztOC4sYpSEfK/djDv2vSVjBBsGOWK+hi8rDCmoOKJonO9Fc
iw431LSHlvVyhg73Xp3HmBz+92IY1/EtJDrMGooHAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCpHVgrVBHGBx+s+CllkVJS
re1AACf94K1PUrnCe3nSPIjsjlauMO1vJEg39XnOdxz1GIj0ZxPVoanRWjJWRC6E
TGivunOZzfREEFrMmvxO/azlgLn2VjhPxXxgyvyhjVE1ZUTabuNCMQtvwvon79Ko
TX0Na8Rkkdx23TPR33YIkQXeGnFHY3Cikc8UiXPus7LMMP89PmVh7ACi4t5v+DRu
CImEvP+jr18Sjhul9aA+CtL5PFPzn8bWlROCAgGI7GZPMhJvugCusHHWSzG8UblK
hWV8Aa5CTndzTOya2regyeZyy/ftXEmjqKjKSH5kfL83MI5MWr7AJMJ2oeEoC1W0
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDTqgBgTsNxYUYJ
rT8MLFe8Myww/wTuLUhZWTkCqGzQ7grtBPV1d5BTN2gthV1sltE3pjVowQrakbhn
YyKQtxkuuaL2j+99cd1ZAC7BopxnDgnwwNp7lkwsuV9de5GcykCz5wLzkfj5webv
aOWsYptahtFkAv2Q2EgeXp8ZK7xoiW9puTZ/74+7i+FqY4M3DcM7/RATcQTtKW8q
vqF3oFUXlFxZb7j0UMjqPGfzjP0ccze2zKxes1lgcic8TzCHWztOC4sYpSEfK/dj
Dv2vSVjBBsGOWK+hi8rDCmoOKJonO9Fciw431LSHlvVyhg73Xp3HmBz+92IY1/Et
JDrMGooHAgMBAAECggEARH0fvgn+Z7OIDB2I5xF6GiWcyQXbvI3eeTrLnbaN71T3
KBaQrj/P7X1iMkiTIE30yML5STodnvfD6YBEcPsuJNZgitOsNLUhYGkUuAc8AISk
ZsigaZkKcPZSi1cumMNBCHVZmSLEo1xAs3sHxi3qAvLY0jm9fp7dRyZq6KQkRNaM
ybYIFrg7mzSwqX9m3MJSvPLiizIN1o7Ckdba89Mc2BNWQROUj1Rl6GoLqJc6w4bN
lHaWlxj0oahL2tcCdzfW19EJ+iXIe8oeb8hgIQUvMvKkenjyEjmqCKSQGEkUL0ae
85Ym2/P1dCWRRqEEgbH7FFK81cdlL85U+oZ1hkmnYQKBgQD4C21Hp1fAKG0Y2MTA
4j8XZfdHMEozFLu0tqoQYPVJhMzfL8XPsVhqqITnTnZDkJcmPuO5UHVgx89eGrpp
7rAIWqNkL2bNzoOEOz01nxXHiwKwhlAjq44MBH0/gXJdbyYwCKM3yhFBvh2TKT02
BYn7WUDzdxgBdafqEYMe9PxwfwKBgQDac98eLwA67RoNhasFHKhu21a+/Ly3z4lP
uq9FzIuBQvTmZuUqS3tDOsm6/la9Fh0yGJAWHd5pdmmYGtvQ7WMB5OXM6WQm0pgm
WrSXozL2AtUQm4M3ZONmlypJhCzBRBYibH7BzvUxQjTestCexdu5OCnOPFKnadnl
cNEIweeieQKBgFTPU2YUiaRiLis4ss1gjkHp00q78CLXC/cWHb/L5xJkHciSBQim
kpylUgvkf/tKDOQ+zI4oPHoC15xNdz+RJQ82Lneq3XOxELa9qogTBNddaGYDBpOr
rL3fKxPzpq7buiriSSxiItRftK0EhLFb43nVYqfcKJEXMXqO0k5bZZTxAoGBAI97
DbAAhPEvLC53fhWUdhih3f8Bd15vZKvGXTrGF1bmSH5QVPKLs0E8CqXUSdpV/QUb
Vv//zEaOrNpnwbsfQClNU5ZcMRjCt4Zxiy4R1fX5dEI9Mlke3bFTVkYFF3Q1KSih
BDx9l1QsPReMcTPnluK3vdWkj1FAWAq4J8PNwDtZAoGBAJMEPX4KfAUequCni1KP
P7iSByUjz0d/4rTBLOL2Evkji69olG99VUOY2z54gPQ1tEAuk1z0z4/r4QF1gWxI
x1w4R5XrvYMUS6R3Lt7aV1uJDbbXJNTeZKxId8E4FHsonpyat5Qb0KP1At2wG4XY
UQ9+vOk/9hf93vP852ZK1tfz
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUcWOy/+2e2VlxzEedhpSZS3UdmKUwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDHS48UM5B+l3SpuKg1ZncimLWwOSyHyCASgN1dTFhFMW7/
WN1hGGrB/2lw8CAdEBb1y+i2+PHo/HQq+2tn6GmT3744GnwS3vZOqvhN0LBA4Eg8
DtE6utFBb4TZKcU2GQqGOHS3BdewXcVdoMfzM4IslqmHaQOXiqVwMrCGjiVKzF2l
SFzZdIsUBFiwSv02ZvWKhb0IbTsm7YK4NTGYKZxP4fsTHHZeBICjL2GEKlkXx47Z
JwthnpxB1AgeIdD+6tp8oCGPZxzd4lJxxTV385WH9zFg7jSp6poAOETra8ZnnceT
YgfHVvY5PEiKB+uZzMiPf9VIoVE3KwhW7JLWktnZAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQDGEr3k2P9Z4lOIwghhuVRf
T0YYzq39Vd/cDpQ/v1Ohs5kMdAEP/sDt5JWamtNLkbUDhbdgrE4Z5uKd2zTmL8Nb
aiT4vJ8E9hYYEheatE0qNJl0v3qxhz2mDGDfuYxGPPnssuxr/6cGWA2u1FasInYo
obLx7tBB3HNgKAtqSJZSwAMAhebJataR3REtkmBkn8s9zaTczwGsavH4AFit9ipB
oXkddyfvr5Ogpo1BEydLIOCv1c94zh9yI4gn9/Gz1uEgQZq6xg+A1VV4p3Oy0LWf
4OjEohsV2dX8KMVbVJwht4HiTv58M+iL9kxvcYe2Ao/z6CnvObxiFgD0eVZjNsVq
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDHS48UM5B+l3Sp
uKg1ZncimLWwOSyHyCASgN1dTFhFMW7/WN1hGGrB/2lw8CAdEBb1y+i2+PHo/HQq
+2tn6GmT3744GnwS3vZOqvhN0LBA4Eg8DtE6utFBb4TZKcU2GQqGOHS3BdewXcVd
oMfzM4IslqmHaQOXiqVwMrCGjiVKzF2lSFzZdIsUBFiwSv02ZvWKhb0IbTsm7YK4
NTGYKZxP4fsTHHZeBICjL2GEKlkXx47ZJwthnpxB1AgeIdD+6tp8oCGPZxzd4lJx
xTV385WH9zFg7jSp6poAOETra8ZnnceTYgfHVvY5PEiKB+uZzMiPf9VIoVE3KwhW
7JLWktnZAgMBAAECggEAd8lLi2ne3KfuACE0QTyAOPQuqGgFAuvfkx+Pbgd4OsaW
n7XrAfQqHsaEutQpiS5ljoFsM6X3yQEMVdVeXksMQkxGSfRpRPJseyY6LpNTjPsB
j8+cJL+rDLiZ0elQVs7AS6JdTLCfTqtd+IOuCtiX0nMQHIqbFRfJjmF5RrbjZUvV
jFWAqG1TjVxPGjxNppn2aFB2OcxjT2mK4p41vWkrlPOMiX9yL1Ven8la05wRL4QY
0uVuhDJ1kAzpFcL38ZApx0Df1uJur+cuDVu7aFrg1A+TFhQjdCXOPPRf64+8ivq9
Qey/NSjl7oYWFUze2bbqIa2iOiCs/zf9zq6nXZMOAQKBgQD759sbH/mrVCF/ltsR
nKSx5OZs6T5Cb3r0gRilwNLYQ0ZWe1z/Ol/FvCidkkHeCTU/1hZ84XTBHci54bXc
PhyJ9FtIJ9byCRP0PN40k7ZBew4Uz3qVvuv6hRchip5yejlPRXRGGziaIiiP4zmj
AmIlxAcRuiUpuUURagotvsADGQKBgQDKiMxIzWY7xtPxZTgBDeQarQGHLd+lC0Ca
Sg4paRxixbDM4sxAOX1EzXWveTeFr3bPNCfzPkOr4Iyt47/uTYA76I9BTFtXFJZw
N94GAXNSBEOuEZ9V8iefUEV7KpO7xpyFlX0VXCD9v6qE1ueg44v2qOzDotjIbrDa
4MRvN4kkwQKBgBIRvpDCiWk1vrVlP8+Smem8zp6PWIzxbDNvszHok/c5VClN7gzM
xiPr7EnpPNpNdMlgdPp+PZ7AoS5cN2xV9DwdEBMr8GoqJolFeHbzBYbK6eaqP1PQ
fyLYOyGHzPfPNp8uDzocJ8I+owQ3O2IrAJlO52bpIFNO29p07cf8P8+5AoGAczjI
H1LbKn6+7MIMzmy8rIBoMiNi7F4ubpha3iwyPe8B2k3crV0HazEIFr/7Wk6sZMzj
PXravNmOrw62jjgBEBQKC7gI7s2DmGvwH7KLjMloR4s2/oo5CGV+YcejLFydh1G4
S4KSMknsFI6+T8WkRrtrlxD6C20NqDffCParSwECgYByF6OIDs1E2i51bk2PkBnP
ktqjaZjlUAEhAR7d9tkqY03zCGwO6XRukSIBugtolUKPvUcTAEoQ8ZyqAr14BZEm
qCaRldCbWdeOYl4Wjg8X3wv3xMGwzsnGcGsgOs2XVykVaiwPtdadpsmdUtndl9Ft
ccTV6COdOO0n19CGUj0O7w==
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUDNXuwE8yqviMvf47HApsgcMIG6kwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC4r+RhnufHjAar0Rj+PEnVQFi2DtJGOVh4u96xaEbiY2EJ
3Z+jZG+pV2ivKfKZJiVCWsMa/XZ9GoDckAM/7/BACMozRYdBXGXJQ8luOaBLh6oy
w+nCMQ7zs6J3meJKm8AXiEpq6y7AGJ2P0EcG5qY7jiKqkNckFvJayuJ7mt9DGxS8
OCNu0ja4waEtcVsMerM11zl4hQAxpm/+zRbTeRdHe6jY7Oxg3/V5e7W9kj6klzAt
LEFq3GNqztXlxEvnNCf2ItJ4RZ6P6dzho7hKQjIICkmzBrApcEZAj2Rhr47q2Prx
Ztw9E3iBTc3qpRkadbhQAtXUHDxTX/wUUzXgkBfXAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQDH2bDcb+NYjee2vV48E2Bc
16MvrBDfgQLA9Nv6oczcE2yfD1qOQTnoLs40QtKhDq2PMivTLSS+x6pstg0R63bH
7cCbWtGOYRDsjbjqTHwAFczQCgxZA3uKUeTaOv5M1jhQ4oP7Oz/oQv4yH7Fv9T0j
QOyCHe+CnLDP5VY0+3UWDSudCDIBWD/BxvsCBva+dstPfz3heIDciGiCRqrSXCh8
ROiBKUh1TaASOtcIKYIJfrLFs5zpHT0zZSppKQcxPeKimCR5q4ZC+CuPXMJzvzrX
xPlO7OvgQ6dJE1/nOnXdXvl085ycWrrefNb7IvJ2Oc2/yB0957jbm0+13tuikXgG
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC4r+RhnufHjAar
0Rj+PEnVQFi2DtJGOVh4u96xaEbiY2EJ3Z+jZG+pV2ivKfKZJiVCWsMa/XZ9GoDc
kAM/7/BACMozRYdBXGXJQ8luOaBLh6oyw+nCMQ7zs6J3meJKm8AXiEpq6y7AGJ2P
0EcG5qY7jiKqkNckFvJayuJ7mt9DGxS8OCNu0ja4waEtcVsMerM11zl4hQAxpm/+
zRbTeRdHe6jY7Oxg3/V5e7W9kj6klzAtLEFq3GNqztXlxEvnNCf2ItJ4RZ6P6dzh
o7hKQjIICkmzBrApcEZAj2Rhr47q2PrxZtw9E3iBTc3qpRkadbhQAtXUHDxTX/wU
UzXgkBfXAgMBAAECggEBALUyxURN7qOmK2lpdjcBmYLjZeYBNqb1XmreEAhJAbrd
u/g8+4IIaVFg0/F/m2hMt6OZfvC9GwJ0/Vbo6HdThoic1x1kquYirC7CFh/R5AYW
rZKvCmqfTUcmyFDFpvKCSv4Lls+9vJl1zSirNPR9WTz3H+Xuw1XCObeAdKLG+SNR
AoHEPBUNUts0kt143osiR6nY8mhkKLxHjjXJJHUaQyUmOkIKSu/fn+zIBCl69t0z
7vAGe5mSB+fMTsQI0o+9Iy1NyBJ/saz73jfJ0xq757uwv64MwTYQirRy941x4xBo
efqZivY9VQuwPpKnjZiUlZZkKA7TneM9DF36opEQVkECgYEA8a3QTmc34UKxFeBg
jd0AP0c6qOnY2NUX6pS2ccjD+tGd+zE+FKB1DGMMysFzRtiTm+Kburcp3lbn0SVI
sUGN5QhsT7jV2Umi330Pbl4PniKlZmpYnz3jXTL07z8E6WYBqWuVaYVQ++sij9p9
W3gpt9lKG+0JiRUdTlS7v4sqZiECgYEAw6GIAaXp4/kokEskx7UA023uKZXE4LOw
QOvI/ZI9STa0GlqnFEKhi0e/Q0U5EpdRJfeDzp4kvYTMUi9Me1riSxaznFvpF1MR
P4JmVwDYVmKTSRvnRRG3lHbgeHA269I/0RMTfUT2fZX6Bfk61qoclSpGl/YVj1j0
vIX095tZzvcCgYAeg/bgX3IT1Ert2zX106jbVJAYkeZagpWRfhOHTHVKbztGY1JW
YmhFFyCfXUvD70a8ESHeso/rzgdZRh7mmsNi3uxmKI1/8SdKlszi/6dzLSa7RsRH
3xWdR/jbWJazLbkZ/kaQW0/9bxQfG9RmP0btOtd7rTNeBrd7k4FdTyIcYQKBgA2e
JuuGcxuNcodo06ybKu2Mz3FRnZzOpUw/nYQZM+7uwea7vLmqUbhyTBwQq4JhyiJM
cn5lf8U5g0eNR1Om5e24LNSLiVQ4UhELsLgJtQV+YyZJrPWf4BmTlNiNZyVPQ2X4
X/juXgIr+HWF/dSHjunLQZK+bI3H8XFWGdFKnRvNAoGAc/IKMwRb9/XtAb405O2H
zu4GfSrFD/c3m7dMryPr3sZjPoatmTwWzFjZ0787kGnzsvGWsOYjXtKluE/g4jBP
nd5CgwRJrUytS45KXlM1AMt8/9lFLYDkVlFrM9FQ/UWJsW0gX346KX9XqtZT6g6e
9JJi34/Q2nL5ZefIN1GL6qY=
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUaVjP5toSZjz+kCPgpM9eyglT71IwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDKT+/vp2gbgVymuRMyDDgpefM0auPvmIFcNGIS7MiCIc+N
qpYCfjaCdZc5gCo0pgS4Z1rqbl88puYH47Awav+b6YXz5jvU66ZssVlRHXdrnD1r
kXTdRGQxEMBy/iUfEdQgOgsk779QoEpAWAyxyHp2r3LSdphnRpHua+04cMdpWiRN
Jv90l/qHL5DEubwd9GIrnOa4BmfCfpyn3waJITN49ngSNumyQiCOoMKIcCRDdt1K
yxTw00cLLUVhhaaOlMGZ2Xvmlpl1UhIpXS6BPnztV7lbAQzgfAKFL7f+ae3hAsrq
jTKKU4BpzwNLsggE0/UaPqrvDP22rcQ0GBtYLUTbAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQACY+ZfFoP7D93ZJmwjFm36
AYwDLDCWbrwk1+MuLGVa3ppnbhb1ZnMpG+SUUoGUZ6BB0/Hq/945Y1igMPsElSRX
qrwq+Rtbr3f3ZqZe/JIVSlpFpPYYdZkXFJYrMkLSGJP8DkJVpmlskbXGqtaqcIQR
CurKKhkBsYsY3Z/YTEf82EHwXifukX2OlCmNWIEJe87/Dx/01GC9jD6iaHgJA76a
RIBwzf9YZqpgBEgOoTH5Pvz88tRf63njMdupgJVsxC03AqVBLFacDQ6aRjYgLedS
8gJnwq0CY6nfO63UkPH1wHBLd8UFSw75FVIUxyeh9JNjiaPj/vlr7sOVseqTaKZK
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDKT+/vp2gbgVym
uRMyDDgpefM0auPvmIFcNGIS7MiCIc+NqpYCfjaCdZc5gCo0pgS4Z1rqbl88puYH
47Awav+b6YXz5jvU66ZssVlRHXdrnD1rkXTdRGQxEMBy/iUfEdQgOgsk779QoEpA
WAyxyHp2r3LSdphnRpHua+04cMdpWiRNJv90l/qHL5DEubwd9GIrnOa4BmfCfpyn
3waJITN49ngSNumyQiCOoMKIcCRDdt1KyxTw00cLLUVhhaaOlMGZ2Xvmlpl1UhIp
XS6BPnztV7lbAQzgfAKFL7f+ae3hAsrqjTKKU4BpzwNLsggE0/UaPqrvDP22rcQ0
GBtYLUTbAgMBAAECggEAFYHP+QMr7xied97e6oggBFDBiQX/+z2UKvAqqOZhHmxn
uyCyV8uBEfdcPzGfyv8HK29ZW+il2TXI6HfNCCinybRWmCoWnDj89TsZSqU+R8NR
SDkrWkZl/E1SmCbqXVYw3cgt3Rxbkz+nBRYXK2MrmahnJXaUFw6KfvUcP87FdC5/
TAqnjEqzBqDQPNQAHQBUseZoggx/1KnSFdw2qx0vmGfEdownvyUD1rXh1VDcrHYe
i+jcQVKGpwQ6pAf8SSqPVA2WK+flOJquSFIUVwjC4mKwWDdEpmJIRMQvcsdiv+3H
1DyDjgbOBBveXAHOcb/RaO1q0SpdQ2on+fOzl+nb6QKBgQD/vICRgwrIgRg7pz7f
U1is42Q4W8PUSRB71uhJv4JRluMY0fDU0MoKFRhNso5JX08tXZJAqCFDgpU35lF5
V4R90am1rHTe1Z+vPrChEzMtPKj2HGVktTnzGw0G3nx/1eqM+w9TbkVZJjZDkLwA
TKTA1GIIGCy5bXA6a/7kg/f0jwKBgQDKhVWknx/LfoJf5P6hhbIYxzUHRAIhYE9F
nAD4Q+AdY0Gs2B3fQl+d0L0EnCrnX14RqpbHfXf+szjcH6ZeCwySd2zMh3Cm36LY
+iq+/oU7qLAh1CxJ7oWJQhExjHDFxyvMinfQ+tMtOEiXdnaCdoMWHWmPrIofG87+
9NQdO2hI9QKBgQC9vi2iSRkKFQZW1EsIxb0oYXqteiB89Ez/pT8p4KafRJVwh+vo
6pTNEEO8+jsp40ZKwX9O66/qeAugswlGP5H1DEefnLoFz3gwPRIuIKG68aPnHsB4
DSJW5n4u14qGCsCBI5GGdG2NrJVcYhmrGzKuQ6YMnWsplTJMlm5DPEsPrwKBgHOk
xa3WS4KY//ugOKKlRHiPsEEw3YKPi1S1a3xYze4aEpOPaSdmsFDetECgqIMsWvv9
jFHn3JBtaOeRjx+ecZRla5QzNumjREtgNu6PSicyATmf/ZZOBKTHPCguCOt2+xS2
cQq9X78vp4wN0khXQi1rqC6pmMmAyKefyEvU84zNAoGBAPkcWAaVvRgSkS71pLZx
CIEZbmzlbDrhKOmq6Ls9GbwnblXuYYhykCQ3YvEFicJK3m85ynHsyJaqxHnQTFE6
RL3vfzdUPu1v6BItzc2IYecvZDQDgNds1z1UH16cw8BtJpdDx1KPeX4aQLjnGbmZ
Fx6ylagPVDw34UcQ2WRdhGPh
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUOwoUduReWasvp/QDg0CoLyhjMnAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyOVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC6ghTGOkfeWwqPLfK1hMgIbY5HaowuUHRXkCyxCF0E994w
CVGnU+dCSJIy+xAqRDvmiQc4DyG4SSskTSCq1tv2xCDmdCb8BFjFVoKwtTpDjIkF
mZBRAWJWnuDxE1zUH1kwR9p/d44Ln+SJQV9/tHdLrn1exmAl7TZ3fMHFKyyXsded
qJ7K/9mlNAHs4Mz2hMZ6h93363bShVRP0clOzdJ0g0/OpXgRkRDSntDwATlBpsYU
p0mWrpyAdPIvADHBWlFZik2Ts/DLpdzPaHG0jUmQ3OFAOUNWBGvGTbkPeWsv3grk
4+m+MYbmoCg30l0ReeWy66J6OdjJMAiKuxoLfuRBAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCYEncQIRyINhibeDZaPwhF
exLV0IfnbLFMpICG36F/sK7b9RFAg1x3SrPk6SXe7odKfmEvjKivptKXnUJ1mojA
cufGQiMY9k+xiLzL/x9nTKMuT6hcGAwdpSZl9T1xQOalI67PVl9OH02Qdab1h1bR
Un5OISmD4D0vtFH4CYXjG//r/SpfbC7d5h7v9/h8rRhZPN/uGgezHE1s6IJdeRas
zRhieSXDW0aW3Y7agkgwdfrPbz4wpEYUpWHDM0dyRMpqww/aXgw32L7Iv2wYJroW
R8FESaGFlY+7aBORNlOqULtg6SEzCy+Bb2Z90iUA1A8UuuGQpIPvZPKfv68Hr/mI
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEwAIBADANBgkqhkiG9w0BAQEFAASCBKowggSmAgEAAoIBAQC6ghTGOkfeWwqP
LfK1hMgIbY5HaowuUHRXkCyxCF0E994wCVGnU+dCSJIy+xAqRDvmiQc4DyG4SSsk
TSCq1tv2xCDmdCb8BFjFVoKwtTpDjIkFmZBRAWJWnuDxE1zUH1kwR9p/d44Ln+SJ
QV9/tHdLrn1exmAl7TZ3fMHFKyyXsdedqJ7K/9mlNAHs4Mz2hMZ6h93363bShVRP
0clOzdJ0g0/OpXgRkRDSntDwATlBpsYUp0mWrpyAdPIvADHBWlFZik2Ts/DLpdzP
aHG0jUmQ3OFAOUNWBGvGTbkPeWsv3grk4+m+MYbmoCg30l0ReeWy66J6OdjJMAiK
uxoLfuRBAgMBAAECggEBAIdEDqMR48vNhaQANBYYHieWpWkASnjQmwBirTccFLKk
vn1iVNkhjgjRr07QLZIp+LOjUBwFRXRthJ+IXJfqyo93AVGCjj+bO3Kr4o8ccQxK
oZnxHOzTLyoZgpT1cQ7bSYkto7ds0xV1On+dbRCmpxq5i22wPE1ldGpGjhZc0LOW
5/kcRquDLYDf/jgwZzfi+bC9tRg+T7YOkUuCWxVetHKIHXunBQzDXv+HjS3SxJOy
bYaW5t8bPPo9ZO0nu2pJcsx4UOffMs53z00YZbKL93rzbHNeYEnUoD6sQoUKgLdL
56cgkQx50lTYtD1O3I9XL//yhw+SyKOVxqFGD9sich0CgYEA390f/dtVouDQLSWs
R0dVrfxCeNsFx7qdSTOM+pMTkfoCVQNF4QyQoFZtZdPTcxiuyhHn5I/pgCbOt0Wd
VAhWB4Q4K1OfUxM/Q7y+BJpL6SgDUrcTXZUeef8JrYC6qGar0u748yBOWt8eYeW9
+WMdN4zxcKyTVnVGd8JMHRUA/jsCgYEA1Ugn+/RjouEUCwZIO4zoHGvPrisU5cOn
AYzIiL0mjF7suGXH3ntKj+8sxvtTImGc39TQWj/E224/pfRi24619b+F8zgXtDgh
f1FZYR/ejgz14+CbLbbVE0GCGIJbejjT3L0L2r0hzQtaMVxxEli+KK2dTYj69FMy
/b2ZQaYgU7MCgYEAxW6Yk2OIYDDTiK2sBeUU3HAZE8teiqq7ot6THD7wSJLs0Zsk
Wvmg57exnde2qdB//vjRwlNlxL71Gs+LlJwRe2mRvCxw3GyiJBRmpVqLTmMaoy2R
J7ym90MFfv6EIJcEPPDDoHDCigQzIHXlGPffwalNGmkpPFwLvP0f8ZofmRcCgYEA
vJPyFoo9VpSgPict0smBqS+CD0M0VPsrPOmXnZ9w6Ag+UcRcdlCY2q7k7oLlPK8G
H7pxBnr/uey/BiMRDYQfSswuyaA9BTHkHEh3OLMO+pZnCzdavY680yvGtZj8/RIl
8TSNuLglnMB+3MoZh9lDOYBYZ2fITCMMIOJ1EWCrkJUCgYEAprFJf5oovD6sZLZz
6AmPdamYCOLKul39P+tav9VvtY4MgQ1Nk3FxXqqsTH8rcos1Za39FIYXVZzAyiB8
hB4VIK5hQULU5NoUgjMdcegnmR80O5znx1jkoG8mGW5v2zi0DCWwQUe0eIqg7Cmo
NCqsxWTlPvhxmdJj/TVownPJrzA=
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_6: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_6: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
