from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUS+xy2kGNomsBGfU0DEELWiHoSa4wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDMyMzE3MjkyNFoXDTMyMDMy
MDE3MjkyNFowRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEA9wgpBPIdclPot8ydp7C8EfKfZXve31sim/LBU9nViOTB
2vZGWcnwmb8bBg9gAaCCeSRHF0FqEmU0hUMDD7AY9npBpIzA4SUjUL3++/kKlZa7
Yw6kWJoogcVXpCYvubeslpReXq7EhrrCwE83uqJ+gmz+pGkEaEoED42mw4xvNl+K
8B+nfYJ9aYlErX3JjQGtby+RWUw9aH3xBDDZ1Fss3+289OQ4+4KV6jPXXKZgniD4
exnpss6LqdVhuRt6Wuhol7eoWl/kpcQfQ77fHr/8xTW1TsuFrHjsgJUXqGi73OuF
esOaijmYCLkgklocSND0LDeF9uzNjKEOXl86iHpOKwIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQDeZ8UXHc6TqZGkvrFIY6U6ycHP
YSH42ihMkqJApBYWEpb8wFM3vAJIOZV0BBYguat8/7gApRGiy+xnq1TFDJiMLRPu
Q1yDWbYXM1fsObgyh83K8ZNQ/nFr0w5o+HcShkjia6pWaNsX5OErrJ57iJefaADU
xnLvxHXPDvwvs9f1mLZIZgzYtv3go9oQVOCgeIKOyV7cFUAAgIeyOidcoQEN6Gvy
DzlkZdmRRkvvIddDG0kcURmhMJzqg3Tn3hmG29wzSbsw6LK9kwr7S9BKNv/bgxDi
DOLVn9LP8qDeRA7zQtbneTtcEU6saUQT8Q9JLyvGUjk+Qgwdj24M79L9s0MR
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEwAIBADANBgkqhkiG9w0BAQEFAASCBKowggSmAgEAAoIBAQD3CCkE8h1yU+i3
zJ2nsLwR8p9le97fWyKb8sFT2dWI5MHa9kZZyfCZvxsGD2ABoIJ5JEcXQWoSZTSF
QwMPsBj2ekGkjMDhJSNQvf77+QqVlrtjDqRYmiiBxVekJi+5t6yWlF5ersSGusLA
Tze6on6CbP6kaQRoSgQPjabDjG82X4rwH6d9gn1piUStfcmNAa1vL5FZTD1offEE
MNnUWyzf7bz05Dj7gpXqM9dcpmCeIPh7Gemyzoup1WG5G3pa6GiXt6haX+SlxB9D
vt8ev/zFNbVOy4WseOyAlReoaLvc64V6w5qKOZgIuSCSWhxI0PQsN4X27M2MoQ5e
XzqIek4rAgMBAAECggEBAIfHjnRPd+v9Pu63ovgm5lifGQm42jm+Z/l7ptOl6f7C
beMidmyn2H1JU1szXDvIs65OSFz58YmG4yVUPfyDeFURwb7mNqYJua2JoPtyWWT7
YqgBxkeFBDq/83ogGx9jW5OwnWZBfXfoc18sq58D7bFWo2hO6MNB25WI8F6PdBlX
uhtGtw67JwXRI9tdBp1sTRwQQqjaG19OBwdHQuE84VBBS+VXt+dOBS0JdkCfFEW9
yIsAFRndIfBKzAGGFZxtabNplDHN8IU52kU68GT7GqWlKxr6maAn8ycvs7RvjL0k
B0uVN//D3nDmDIkw6+fsHcsZ67AhkUdzG90JAyOWTfECgYEA/X2lyNnkqfYKFBeh
47HjiY53hqEBlc6AOCzWZHa1E+12Mfbcyp8Lcto62f1oGlbUDlTIlEc04iUFCepu
9BxccVuLUokiz8vXK/rfx1TOZnJRmKG6c5WGktAJjkoWp6PnjgFoslJ8E77EriZX
SHEOIOTL1arMA/uS+ZF5EYIqq70CgYEA+XolQQ6+EGRUcBLcWlUpsSS/1wgUuhj3
Asjz9qmtwS9ISCfcuYskpwNq40okEpee6RehdGRZhJT4Ks4TiTm8O+izw7wosmoM
Vl+s80K4PPyER23nYMjcS7zyiSd9du5KG35wnThaODLIh/mcMq8KAjta+24EuEaW
aH0ZGa8ZzAcCgYEA1zjF+Gkf3zoZxoNmHSec8961FuY+rU2dyZQwFy4+ggPclYFu
Zs5wbvxgeVLQ/4P3GY/cmSB4AwXBaHDV8Ybe6hP6j4IFv33nW9zuAJS9hXfMVZYC
8z3h+2aMpnW7FGxyHjyOAtFLrYwL+3xsIQJ0J3N6qRgRjdQcLq7XpwjoZ9UCgYEA
miC9bWEXSXdCt27flitxM5DZuJa0f3i2+pB+MNEJmQWGKZX/Bt6RCWHSIpQGjzn/
IlDIHel1aLTEUWW5qhjyUyzkCrRvjDJ6Zs57QlrhCkST0LF0tlXBzETyrouoNtbn
D+9g0bEkA/5T57Xtq15614AmKJoC7nolqG5JGJYWYPcCgYEA+/mnN9vovnX+l7Lq
QEv4qvL2BMQc3WFb2Z+/grJBuMEgN8EtI2MaOu0ZAI3eDSj8SUs/4gVfGEn2T4qU
VRmRAAVgxHdf2nXKi7wEvx44KMlb6aTYfs+uRQW6G3ymZ+AysIBVwqd4b5ll9z5u
+CFwKYdV42KKgp87D/v9+oNDTjw=
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUcVyMMiaYY4UmD0lc+D0TSzOgx6AwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCq6EP4SllvUyXjblM/2V88nxkpBwgC9ta7Ndd8pxIZR4Oy
lnNYiaes3gTVurf7HMAIZ0wHnlzRZghVvpZQ3eKGR1ETKYXaoRzlgwa1uZKGn8/a
DBU2bhioG31zYIOZ/QDf3ZcUR5JkcybdpY+Yj7YGowRkLT/GGN+5GgTA7tXJRWJQ
lpHNaIjFgjj5fKB+xXck6OhVHftl+rB2ZPrVgWaXPDBWjgpF1SJnxsbmOK9o4kB6
bw6zm2wuByZrOYg8ckuIqbJhDjINKesfcyb9qSk77h+8ILj9b11OzZUfX7PhvgO1
+W9se/RCYtfGgT4nSh9No7l2vA/IkwOnZOK7nBgDAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAHcwPIii2n0DabvcPo4Kfz
iiHQfxOxlnTovNmI3VIWNYoe+ElYkuzKUlwbYEve0dEJwu6mWazIEo+Qexgv1Cs3
Yn7djsmsC7q8pOvSmw+3t+6aOXGzeANcFUPJTgNIlxA0sucHoWwpROLsndBdqVWQ
LsV5IwgLJbcUt3tjaIsqfUXabqJMm/KleCd6uDzOuFlW7E1jdUyPomvbOKgc/jAt
/AxQimzkMt2uBRH/2IyOW1IS+035AxyyCfZgyhJIhf0l5oA6IiIvS47utLJ/DtWb
93+WPiBYIgNofNr2qGrDtK8Pm6BjjJtBlFvu9gNcHn0E2mC6TKNg2ppFNxXdX70Q
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCq6EP4SllvUyXj
blM/2V88nxkpBwgC9ta7Ndd8pxIZR4OylnNYiaes3gTVurf7HMAIZ0wHnlzRZghV
vpZQ3eKGR1ETKYXaoRzlgwa1uZKGn8/aDBU2bhioG31zYIOZ/QDf3ZcUR5Jkcybd
pY+Yj7YGowRkLT/GGN+5GgTA7tXJRWJQlpHNaIjFgjj5fKB+xXck6OhVHftl+rB2
ZPrVgWaXPDBWjgpF1SJnxsbmOK9o4kB6bw6zm2wuByZrOYg8ckuIqbJhDjINKesf
cyb9qSk77h+8ILj9b11OzZUfX7PhvgO1+W9se/RCYtfGgT4nSh9No7l2vA/IkwOn
ZOK7nBgDAgMBAAECggEAaOQQAyyuYxKm6ERnt4ITX0NNz85O7nLMKy3KSOjIxNcN
Tufjdu1VCVVhpkLoc6ebfAzZrrtUv/ddGjLUUmE7i6ntalNLoXjMIVgfIBz6fsFK
ccqEollDrLjib5NGcZXDmaGH/ZxHjnrV2aao0LsyvjQCl/DleRD/Db2YOUjb0KBR
k4KD178M181wdQteNoG8hPoRyvcg5eX930HN23IBmiEcK/mbc+y/tyIWMMpvWdjX
5zpzxZQVRiA9DPpJRubua+0uIfWBUG4SODDEjpHCFw2oRVjXX407yFVwdO/B98Qg
MxuftbYvie8mxTo+Ue+zFnHk4fIkg8uYyLciudspEQKBgQDeOtn7Mxo/5565XazK
Nzeahgr51srOT57CToQFCxRPK+roI+8hlcvkydyQaPDcIQIgrBkbSAqmHb5joz2H
ix+DZbPsrJ/KCT5OiUxTbUDDyZGGRZEKzTX2GJlsKs3KmJBrgGZ4Vaj67KNUNp9J
EmpxMhxVIdqh7JGf25Ehgi859QKBgQDE4N7/9kHH2W59FcxhHo2gSqiT9+wry45G
vn6X5B1mKYCR1IOYa1jj+j39MGDp+bQLSSv2jSjBuLjcXASrdkvI8h68JoocKVk7
kxCb499FgOz65mGsBZo9Vb1DRvp6Jh7xfC9XD1pHbcOVM9fNXWSK5bCwsirf46r0
Lum3apl3FwKBgB8zIgFrdkb8jMM3jJfDUtIl+YqEBmsasI5VGaHfoVVQNCWtTdho
QHz5fjbkFNTC6ZqOruOupJgX2vAALhZGiQEYmT8kKTbjP1UlX4ri7tHODdlNEQT0
NJw9beTKyaOk8bm2CCzi0duQt4mONaS7qigEQggNvbU4EmXgHKsYrOq1AoGATQ+H
ucB19veQW72QheMjpD4UxfYgpvPB+MbPXjyXlUlhXbNE3wAFhxaH9PZeuLZYVqKJ
ZrPR5CGdmgMagNKIz1qV1Sdwn50/pCXoNlx3JAlWuM48JMz8lk1dC1xY5j7Nlc/5
56XGvHamO1xTd7q6g/NruX3Dcmb2nyVNrdE3yHkCgYBQC0bs0ndDcIJSzPzk5RoM
aVBU82sqLUEEbkoRkmVrafzaqOdR05hFbHVz2Cv073hi6S6vdVa2s0qnGePAnH4X
dqRb2sfAQTLnG2UAluLWZHv/W2GA5tRLvc+5qlwl6p7Md+XiKvTdhQdIAl5vB5+j
ngHm3mk51YQVAtLYCSCBIw==
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUIpT5MM70VeIvnygCEHRVsL6Aq80wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDsxtOxdud/1pyMnhIdMYyqWmH80gO0Afp/ojKApcqzV3aB
KBFfQWLp4hc+CwykpAItx3vuTNXn/dQFxzC2NXrmq1OlPiPUcxorzctxqDNdoXlj
WTtxjkC+kxvvA2d7hgl+Huz3JxTWWMt+fM8eLTAOdVpPea7unW5GfQ4TwhdEMsGQ
4AmUylw/vjJDUaiOHlKwwD2c4EakZNd35pCtRZfNjM3CF9BxdK2xysWp+xoOIY2C
G61UFfaXiVK+XkbZB1g0+nhNEsur03gFXkFEVmetXZvpfTvQ3J8a3f/sguzLqmYq
spKleR4utiP3llVrgnKPWpDiMvsx+xRbMlbSUMvHAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAV6jnHn5x8uYtbM9jN3cqQ
FK0OrZPSDsk+QJt1I0U0+HF8j2jMZ1RTxRhUCnjCoytqbh/fT/Xk+8s0N614lvja
84fmW8dKq+asD2mWrPZeEgpipk+fzthUOrovNobAWtpdEqjKWEvQxMOICijEXFbv
95V4kZS7JN+s3jAf5nXOK9EhGVI9214UyGNZZU/nzFKlOLcZFhGBibUAT7oA9bKi
BLbCPI4/CIdUnwaK7y8xF9z9KL+A24ZZzhLNVC35gl0zESgVqa0DN9XQ+GP0qC1S
1Z6PF4qBDeta+3R28PtfPIiNpYJ6uHAOT/iDmIWBKTGC2Y6NVs2diNZSOlZXSzN6
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDsxtOxdud/1pyM
nhIdMYyqWmH80gO0Afp/ojKApcqzV3aBKBFfQWLp4hc+CwykpAItx3vuTNXn/dQF
xzC2NXrmq1OlPiPUcxorzctxqDNdoXljWTtxjkC+kxvvA2d7hgl+Huz3JxTWWMt+
fM8eLTAOdVpPea7unW5GfQ4TwhdEMsGQ4AmUylw/vjJDUaiOHlKwwD2c4EakZNd3
5pCtRZfNjM3CF9BxdK2xysWp+xoOIY2CG61UFfaXiVK+XkbZB1g0+nhNEsur03gF
XkFEVmetXZvpfTvQ3J8a3f/sguzLqmYqspKleR4utiP3llVrgnKPWpDiMvsx+xRb
MlbSUMvHAgMBAAECggEAY4fs4xOlmsJ/SkkEOkti4xVdTWaG8ftG7rIi4ptOyvbA
NOi/7LfSuZg1xvnkFa1v0QijGvgnjv7PSqKB4oY2pJJude7aJus/nBxFIgDfnsNL
AK045LI0myfBvUZEENO2V9LuL7K4+qWW3RPgCMJcCifgj7oKA/ofqffVnA6hsyOH
5I6yB9xoKJKynIPUPCeTG/PW1VGsuC/hEZqDLMIRQ3TMlpBO9OeUGFI69nsT4CA1
rSC3aVhQq5J3ebwev/G0ooDKi0VlmOSQj4AaMrd4vtLbMvbJpjIm9CYanAbBx62L
airmzK1ZddEStoUHGO6wXVjHDif+mC6+sBL7kIOUUQKBgQD47sqhjHmDUkQ4UIWn
J8NXJHezVI5UF7alAh7upw1u2sMVC7rbgy9hK9g2y+mVImxsVQI8hyrMR/4EjOBB
DXvINpxzNmeTms3dW6tT3FFoaNlMp4XvecRsOFFeYgmXEK2RxeL+/MNQl2EC3M3X
JMeHCDPtK8cd6qpmQrA+MQajuQKBgQDzf6+9l8w5YmMdcaUqPZwCYeQsaspqXmXo
ekzE4ypqhVvH+gOC5As/m4fxNCdyQAlXIoCSzSAmsmy7iWTkIK3bGAxBIuX6F4Zw
366xWbGJXtsG/ccLsTTA2n3/Xc0lYvmasvoI4QMiX+qMX0MjwhJqb4vspBiT5M+n
iXGDLHGrfwKBgQCTykm5Qco+wg/Ik13WUNAzo24BpRjfKjkAnFK7A6kBAJZDn3Qv
sSHnAf3bApNKPGa8pneucd1h7PgNwYm+dX/g7TNTX6B8zLKeUjdUkYAvidhBH1Bw
Tg3k5kbAz1m8O2WhHyhWlMBsz4MEDQ2URrzDGYair5QG2fSSw9MZCUhU2QKBgD5c
JRXZGmRX3ipcQIBg5uN1TopRjyVOp6qyJ5cE1ogRP0Ant15+KKNRoa8UPEX2QG4g
V+1Au0stxssAlOYXuG6z6e+EkIFMJRIjNwoUfnM/57gSpjdIWspJKpuL2k4I2wPT
clVzyumyxs7MVtWBjlXT23HvVJwLrWKqwHdnmnThAoGAIOVXvCHXlD4LQpJHboQT
7oCP4Jofy5FKgM7vTu9/5lLuirDleK+XfZhAcVUOKbhMXdTJgm8JEqa9Iw02wApz
2EUFTlvdOUEzBrkLHyX586ZiF7142w/wE2Zo6sca76e9n+iR7junUdcQSpR8/DmE
93CjXWPBrmVS1IlmEtCGFP8=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBOIDJICHJA4JiPMdTj1KC19GQOgwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDUjguITn4XjS5HDyHEP5Gmq+dgP1dxpYLMDWnJtHZatsYJ
0x/rnEmDTReeQgiCbISO1oyK/TZ/L1IfzoRTm///uNns8uBnku2VmUDaTUd5K6ws
WqxN3YU+h3P5de6otb0DGkayANr3bMy3KQqGm/XxQB2VvXuo4nzbB4Tk5jDO6vtk
lG4184IbY+08nrj41L3YNCOynSnRDi+1ipfc/hrIKuCA5Giuf56S02hHapjEw8+W
Tvokx1drAlcJkFBLDVuPd146L7klCAhENaIYxJmoqLme9ZNOta2jmSEpeIHbsw1x
HPJNi+6n/Kh7k8Lsp0fE+jgQfPDEaqOXsnLCZOcxAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBXHURcU2ox80IFiBq8xEDO
cmHDZVOrQqpmOdygP+q/JRFoX9jF6X0nR17DBfDedgBz1ghax993nXwGJswvs1K+
1DsTIKxO2HJefd/5iur6mxLFF8RXdku9as1tfNx7CZMm9WcML3XJu/u1/E+JRUFT
+QdoAX3+GnZGY6g+2MUSo11+3Ide9aaHvRUVDIXxqxDOZgLvy+EpIoQU4lkL7cuJ
CuFB0LYM9FMih1BX1uEu3wnCRhJq2nJuIObMEU8wQj8MmgPZTcJh5tyVR8OeDZ73
CACnvjXydwYvFmcB/NCMLpolQxxgrpYKrz8dx1NN8mZRNb+HUrM2tiLsWKAdFEid
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDUjguITn4XjS5H
DyHEP5Gmq+dgP1dxpYLMDWnJtHZatsYJ0x/rnEmDTReeQgiCbISO1oyK/TZ/L1If
zoRTm///uNns8uBnku2VmUDaTUd5K6wsWqxN3YU+h3P5de6otb0DGkayANr3bMy3
KQqGm/XxQB2VvXuo4nzbB4Tk5jDO6vtklG4184IbY+08nrj41L3YNCOynSnRDi+1
ipfc/hrIKuCA5Giuf56S02hHapjEw8+WTvokx1drAlcJkFBLDVuPd146L7klCAhE
NaIYxJmoqLme9ZNOta2jmSEpeIHbsw1xHPJNi+6n/Kh7k8Lsp0fE+jgQfPDEaqOX
snLCZOcxAgMBAAECggEBANAk3VQ4kS+c+DFrtwRHv+i4NBbDUG0gyAnsJKj6CGBi
1WGvlnWSEUb7ymIWheC6RcDehrhgp+o6O7Cb+mcpv7H6oaVwXaHvdqrlbWWZAaG9
y5ePn2WMxLtrx30FKJWbiqEsLQiI3+Qlbf76uK0Csv/xakdFS4AhcmTGYzQH2snz
9s9iFwrpx2DBXT0o4pEvkVWuZVAjM2UzcXsRqQItVNod4CU4dO3bhdTkS6FX3Zm0
eitA5S93H/CNZMaiw5nGz3YNLjeBL9mzNSq4fmZ9tFPJNt178EQpIMTbt2BgNXa4
n0W5R5MlwmXaSO4pFQ+uFl/7QWgKuFwCHOAkiNW3cAECgYEA8n8AdakQ+Wnm/hHG
FWvBkYdvBpzuTPNppSpLevi2DDyIBvuIRkVUPJWsziBex9op51ShvFpUxS8fdqOU
gcXqdyc0PQju7iN9/qVz5XUepls6zjFovC7OWt95x9Tok6tD1SeFiTXyOlKHMyyg
GXaZ08V7xBkKW+fpQx9do52i3QECgYEA4GQ0RyEGH1OazbzbobY9kdyWn0lWkJhZ
3GpbX9fcyhO3hPyBBRIZt4THeJ5j3mioATh4TVGESeIhDyxC12Cdm538sP72atIK
1oB2QM5IK6UJc23TgHzih2J3cseR36pnn/mupy3ECYQLEsVpgdTp4h4AyHKgXHyB
Rw8uMi9GmjECgYA9syjHxzulale2v4j5/E/lGmOaeCV9+NUhjDBmWo/fbythM3DK
CGvVenPcgon7KbxNus/oH8e/4CyOQDLSDiyJIrV87h/1AZzWRPzHHlStGTtOKW4v
q20f3AqdWMPQhtwciRDGB67ZPhReZfVaZT3gjzfdfk2PcuN8C6gEsGA3AQKBgQCv
NQ6sy1hgdYNWSbSknAuPLNJfJYB1/r+Ln3Ahcgdvsd2F9TM4pl12MjMeN257ZvRn
n5QvqwrENdDibAj06velXsLD4RC/b6oOutea2nb3vTGX85VFqj2mwHfMI4//OKsY
+ngpCU8crwGGcqZjPcAxUoQB/56/GGhI9812WfuiwQKBgQDL8d69OdN9wKfpNnJg
HPesd9nyZkE7UjqDJXK1w1A2CbPZk8j8LGyIODvw9KPKkpJnU/JgVz7l0gjD7TaC
6CWtOciuvFRsantzLbpVB8TAYuNqoUdmmVw8VLhb4XPbFUaeS/axDCHe1KKFOHF3
eFAr2KwjeIcF5kHccNakZDNEyA==
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUN7Hj/9zSlPgvmKSmTRU0Kd3ok3QwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDgmG/ekJTb+4NZslwT7MXUZGuOOId95dTgXWrev88flfsE
+lEl1MvVKQLVi3F1I/mxZujYbCW4bRqmwEM/jwpLNxd6lzQjGLoePQWTURCBdnAY
RtslK1eetPhKRMJTTzaH21prkEEEwjqNb4he91O95VMApYSkEX1vOPd6LhxW2X5E
Z7rwZzgL+qwKtQy0VdnxYIcBnEXIKanNodC3vR6BRTU8vBvMM1wtxjKAAcs+fQVY
6eyBu3Z450Fo2Ge1+orDgLdN1qSFEDw/DU98V7Xo8CzEoBV0vRxja7VU3kRqIMKk
EyVwjD6QBfm6CadVC0+vj3B8sbFF4C+w/gkZUkodAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB0UQbCG+es9N/hKKbzG6+P
nXbd/c8LB0iJIPZ6xyPWoZsyzPmItMt3KFnYko7EbZ083Uuvfy+IyHSPcxihxQl4
qLGvjxHG+relpKexwnhYgRWuW7d8xI2WMjDT7Xs6q6npbCQjwpZXbKxe2Sr/WMu/
HitB3RwZ/CCeQL5oh8rm7TRWi6boqJXG6Yx6jjPRrs+f+V7deXNxHs2eV3RUKdBp
Lc6IiNoTtdkZm9MS+xsucm0HJa/Mf0/Gbos5A9oqB++q8FR18Rg7cEt6oTyPjlBF
xq/9SRUCLAeaIVufV+Be/bx/tX117/MUQth3cqSqlMkPfvyIYmZFbJbr2wlyQ4wS
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDgmG/ekJTb+4NZ
slwT7MXUZGuOOId95dTgXWrev88flfsE+lEl1MvVKQLVi3F1I/mxZujYbCW4bRqm
wEM/jwpLNxd6lzQjGLoePQWTURCBdnAYRtslK1eetPhKRMJTTzaH21prkEEEwjqN
b4he91O95VMApYSkEX1vOPd6LhxW2X5EZ7rwZzgL+qwKtQy0VdnxYIcBnEXIKanN
odC3vR6BRTU8vBvMM1wtxjKAAcs+fQVY6eyBu3Z450Fo2Ge1+orDgLdN1qSFEDw/
DU98V7Xo8CzEoBV0vRxja7VU3kRqIMKkEyVwjD6QBfm6CadVC0+vj3B8sbFF4C+w
/gkZUkodAgMBAAECggEANZBlbcExn11WsDe3ehEIBWWFuT+GIOKFaJUe/czlCvVs
Dn3ciJc9nbLQODmvb26LCGIwuhzgyiFLL+W+pBPrMpELCnOxPYWSLdAD2mSE+TtT
9JZBgZXaqcEjTiMj7VaA/Nm1sN2QhCAGcuDctzlpQWrF5uuSvMZnEfWWIA+LNrLp
2zw+wYY3sAB4Yd1zIvigYiVC7H+NuIZsHNQ0EmYPeq+ZuPKtzQnbBjIIm2ULIxhR
bpnjbyJEjxDO/XAHMCacSgoeUWewjC/M9FRKUbQJ29bJyRc/L0x9amOYyFCiztTk
xnAQJaXRoX0w9KQtLG7J95VbDj+n205ZL995vIlXCQKBgQD3FT0YCAXOlMcT/W4U
2odJ9DGq0RQuj8WzEFw6xEnJW87nn6ZA37NLRS12JAnuzhXPPlReueEbeqDG1C+C
3qCuDabuk83lR6QgM2xCgMzAwsDwG3bjy/DdMttJ7lGfYfngXUy7F+jEb+xMynM0
CA25z1O4+RGiTpf6ex9t+I9BewKBgQDos3CS5KFVtZG7lpl3y3aFVIU5Y36WYjgw
eGkMIVd1PInaTFTeTW90+2HSL2QVTcmS00g+2d/dHfZR/XeVZrvl7/S0dSUdpizW
Cl0qoNTVPs69TTGTTPN6iCyFzflyXVvsvLA6n48lfcX5CMrdjmAMScoBSmLdngwW
+LuxXsETRwKBgQC4trX/my/MKklR1mpPSLdPQDFJRBjUXkMsBJUOkeOflvTtD9sY
MKQ3JzY/Vd3fG04OqsgkMM3q3xgGzGXgblKtDCO5w+FvAMngENFkPinUCUR3u/B7
h+E/XF+3u2RlxLcrVlSgodUv1YRQPCE3yrWILUinxfu63QqdBSKP8fwWtQKBgQCl
QXm6+B8TTUTXoZYPmzDqcyHBpcTqa4pX8cs4UB1aJsoHe5nx3bA/tZ68s+cxsfJr
ER0HdZcj4vlhNM5ODY13ODfiSCc5rR++SdHsSheb8WTEzyNb5pQq+rYTuDlkXKTB
tSa6G0J/b5i+yN25BjlzwJty2y7nECypy68PwakAVQKBgBZV0cLftqtdxmLAs79h
g8T3g9sip3kusxoNdxY1zAVJsHuQ6cg230ay2+fGgP330+tIktFue9bJCFwaEryp
dm0PKHmzD9W5Sy59zP7FLAjX4rc1IEQlzT171ey0hitHmt2LN/WDoCLjlb7AByzb
KxQF+djd9S/j6fxmhGItcJ6k
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUH2fAuEi168jppWUawNNToTni7CQwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDRJQfoJxErXVdwTU4sAQ+05EX8tC1REoYFJyB3hhB4LfOz
meCPe85X6FTYbcPdaL3NVevqEL2hzbqESD5Gf5Fvx9ctIdzwYv674P/tqPrIkTd+
cLshBKaR6CeSjPt5cFbWhg1hnmWy9Ta7SsYqOXh2aBQJKTRIK80U9b+8iVs407E+
NCMljerodAdePW5X13i0ca9ifwbTZkS2/c9nQEi7qldj18/MVax6qezY0aKqu/96
8DSSTc6uUiNLKmRYP5xRJw06ggVooviX7snMzG6SgsbLK2tZJXeJj/EECOY4UrPc
FOkVmjxGBP3QD0oLoXnZpxvutS72ovUrcPxAMImxAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBSOIrT/3mFkZmuoQ/7UcPR
TOssC9o0xAwR0iRdziNQBZne2zLCxk6p32di+T6GIJahqYFqVU2cfDyyw9YUCr3P
nbMjuwsSrvor4LwJ9jlWKRRyBm/adCttg6OQIO3rYk/rX7XE+fBY1wYhqK+KcSCb
iRLqHIPEo9On/kpaSOWKFeSrGLMkj8nQWMNNtbzTNcdhQlxEGXcxPsVb3PGs2b0p
n63n55HTUbiL0UsHQvxR8gr0YiSpmlgJLi5pipDbyMiVHyCxj5j5vEovXckRliVd
iEbH235NTXPtJ9aBVEDsHW7W1AhzK5gh0Ev0xOC9vP98qTYR+4Oq/3Mz9r2jP5/d
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDRJQfoJxErXVdw
TU4sAQ+05EX8tC1REoYFJyB3hhB4LfOzmeCPe85X6FTYbcPdaL3NVevqEL2hzbqE
SD5Gf5Fvx9ctIdzwYv674P/tqPrIkTd+cLshBKaR6CeSjPt5cFbWhg1hnmWy9Ta7
SsYqOXh2aBQJKTRIK80U9b+8iVs407E+NCMljerodAdePW5X13i0ca9ifwbTZkS2
/c9nQEi7qldj18/MVax6qezY0aKqu/968DSSTc6uUiNLKmRYP5xRJw06ggVooviX
7snMzG6SgsbLK2tZJXeJj/EECOY4UrPcFOkVmjxGBP3QD0oLoXnZpxvutS72ovUr
cPxAMImxAgMBAAECggEBAMGfV9ecO2/7JVUprIJepSzh3M1b/Uw+KucgVxVwf1TT
rfeLMPOFOf32cH5B+H/FVVqA/jyfLQBcFx4aR9U6iumCiHoXDJVcANrtLeLXev0u
O8MKGKQzywXveJtbfADseOh4CHFklGB+ViJE0nsK47QzHMFybR2Xt3B9Jvoj69kJ
rlvoxyKZOcqFdIHBDLmbzmV0BUo5m95T5oeAtTWpKZb7bH2MSt3Mlp2F+qs8NzLx
QGVrS6pqZd88EJ5J1xJEe2Va9z1HEFx21AWOTOELIYrgrZwEoQxrWtYJyv6QB3a5
qwShJN97gsw+BAZtLZ7uyX1+59spEORlasc24av9pWUCgYEA6+M3yUCA5AnIjU+Y
pxmdtRdEWHJi+Nn2Raaw3vdGlnfKFY8vUxXSrJUcPVVyqdFZb8PDcnDjZwvD4tk0
kxI3E+eXl7Yy3FKeZifQ9yuRRyk5p/HLp04xXqinw94DqeO0wwQWec8GhXAz2SbY
6JJbb8vf6ud21Ld4ClHOSbuOON8CgYEA4voWiUN/0QlL+ePAcUaExF9S9MLkL5gm
H+9SORjbatTDi/kZ/FOUNWKBturN6vMycDpdJTXVL8j+fse6oZtzl3JQYbKTxLsi
/uG98M8t/LUReUq9ASWlxtcbYufXBn0TXbj36NHPM5S/QZy7ExcwaL44hGxbLLOE
05lSUthZP28CgYEAxmEU7X/95coEjDNAomd8pmum4utwKPDFmNYTMbCsAKdFoNQG
bM2Rm+rbEQnnoMGbgc8VdA1UcbkHSKR6/qT3BRpj9wcXxwsEg81AhF5zk3EsN/21
1EKCaqVUUflJA3uo7clmTZK6XUZ7lEiDazSLCX5gFmILIeIaZjNeVcwSU+kCgYEA
mstCCVTOW6pCdWa8vMQCEcaM1b4ATvEttwPJCIWKRn5Z6iD1dt8tKYdHvY6+5mf7
UwyKr7DZ9l/WKHJgNozEtVlRtn9KRZX2lOsxVYSF8V0vUJAG/DxHpabX14kTXSp5
xaY69D36WEwubznLX4amDhkEhFM9juvTP1fGDBfeLeMCgYBJ/8WI47aq0oPGfrUs
tV53EO12bF3wUcs/fmL7hLZnJ4h7yX0r8J+Vtd7ja/Y0QpKNir7PQcp22OBkuQva
5wX6stuQF+DsbaGZahvSF9gITzFyc09YgozKgpbza6KMfzrIkRYcAUC/chmFTUJA
/QGRi14DETwITFBT8JK4ewINqg==
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUFPTg1QrNlWLRFn/hC78RXi0IOD8wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDB7fCDqqnna6BfaJsv4xztP80jBCygHHhHdliSWbGX/tm0
lK716u0lBRiI3FmzPk9MqKMuV2Vvjsqm7gwLzG3oMHKaUPJUOiVf5v5/rXauNiAA
m/sfRAROef+ZVoVmU6rqwnGvTf6POI/MPdEbCPGIXu3bWjPXPq/BKzJ0KCJh7ekR
DaFWCkfQEs3Zilr2ehrdObzwHOxJh408t2qGeCQDlQeDXZYa5cTHo0tNoSWdfJIi
1jNlEnvpo6ZV4fyKY1MiN42J/2swaxypdS3KxvPZzKWebgaloFaZoY3HziotiIva
EnJrUXNgQI1lW4/a7jooQ4c7A0t2XBidRS5Sohx7AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCAQP7xtLehAfWTp1k3E7IM
eMT0Qm2iBWQqB4RLxIJWgHyVHYeY7Lp7lS+BZFKHOkbVoc2J8cA3qGGDw3WrmQuF
uRxfL+bLC+HMSjEvPbXmnMWAqMKmVBzOvZf91VVKsFR0h4Gyt78EFteZVEHZI5bQ
jC2RLte2uCtht/Wum74z7jGzplx3fRV+zcig7Gka8IwTcHaRpfhhZa0wbbR3Kfe0
uXcCgDF18rwr2uIDNPBmJfy9C3nyQugWzNV/j/FDmrqHD94tagfDx5wYPb/ZFVpM
TRg94mZSL6OkgITfba9MkOBcVGbkCO15NckC8rm0p3ngbEgu62eW9FlwsE8b1bVK
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDB7fCDqqnna6Bf
aJsv4xztP80jBCygHHhHdliSWbGX/tm0lK716u0lBRiI3FmzPk9MqKMuV2Vvjsqm
7gwLzG3oMHKaUPJUOiVf5v5/rXauNiAAm/sfRAROef+ZVoVmU6rqwnGvTf6POI/M
PdEbCPGIXu3bWjPXPq/BKzJ0KCJh7ekRDaFWCkfQEs3Zilr2ehrdObzwHOxJh408
t2qGeCQDlQeDXZYa5cTHo0tNoSWdfJIi1jNlEnvpo6ZV4fyKY1MiN42J/2swaxyp
dS3KxvPZzKWebgaloFaZoY3HziotiIvaEnJrUXNgQI1lW4/a7jooQ4c7A0t2XBid
RS5Sohx7AgMBAAECggEBALBfiqL1EFlc1RpwtNM0pxZPNG5oWX205t93js5rrM0k
BzPpFcaqxssoe0vdu+b9AHoj1WVMLwDqyPxQ+7uvTTYi+dfHTt2zlFJIb6YHSSzg
JPLo6ddhsNj+s6vtuJ178rJX7bUWJjJzqrSCdC82TxVL4N/ihct5Q7dXZiemaL7O
XgH10NPmdnptvbp9gjx6LgcM97E91BslDeSYKKZ+Qxuh0Sysl+EzVX80/AfEm99d
ryZOwS4mef558HtuxLcaNO1Due4iKWJKoeZI418hRZh2ASjpyFKcoDswNYWyg9pt
XfNis9T9omox6gIfaM0S7nY2I6FOS/v0ODcACpyLUIECgYEA9t1LEBYZpG/YoRrd
mvLuyeGFJW2Hf/Bj6KZU7tTtnd07bdv4o0SIShtdu4rp4sq+yS9wd6XTgN9Rs6E3
CzWrK0OkbisuSVdm9fx5alMQKS3gE9959WJJ43wULGnHYlKZCCILMO4AZODnfQ5o
cdNvKaESv5KXytBYFliOj30DmUsCgYEAyRsosNqL3fBZi33oxifg0/EGFQ1tJbvn
ApKLc8eAe+cAz2qwidejzYEWbDqhQUKK3qHNFz6ACnbCyohqRr38dqjQxJ4KBHfG
66iFl44qZKYi2fDvSTvlCCue73ArIIR2kLiO4OeRp/wbqVPv5F72Djz8wDRB3qXp
ZW9ezmdMO5ECgYBoQOp7X6nynN1ypCLkViXsEhalyMzJhh7bWKtTtY6n9Y8shRJK
+R1JlqcOFctSYOcTlbo8fUaGDUm2v6W8USz5d3aQpCHHDWdJCRfJhEy1507TdbRO
ofSsYnEulHmEl3dTTPVG86ws7iI02QnY0D8I6KI/T0xVdYlN3pZOGLCVYwKBgQCV
vB8D7vUM/pPthIX4ZGDF7UN2EVUfL1TFWY9zWSuVFV5JEUr4lxJjRKYJV24RRRZY
xWgK0oJLSDmoywE2QubjArbObk1PHk+BzywIt9Vgs0Jnuziu8mWJO9FOvdmekIIn
JwNa+ZA93zxJSzHme74Aw+/8u+v/dtDcsZuJWugrwQKBgQChIpOu89zL79WIcKvx
y0ErughaITTuXQ55c2wf3iFOnbk60FJwYjJqWwkmurc/w2NEm/G9tXQVeEw3YyrT
zDexl0Jtlbe3uG72aTVyHFERyaaZ9wkirHHHfN3b6zNpscgWDmjOrJthuOYl8NnE
0gbyHge8dF2YFmhxtFAcEzlU3Q==
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUC/PhYZPSyT/cH2+54Hfayu9ZXIQwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCog5fCeSavpTI1/3mA/Jv9XJF6ZGRzmNJq8JdRPUd/V6dQ
eU5cOE7QGXbqBV1gQUOXIf8Ke9wgwcMPGRLBbhMQcd9CqWK/rZZOuczRBoqyEvQP
YhkyPWmIbRsNTLg6KYxghdCD9Ps75YWBpxb7uGwKgYadixPGGTDlbGw4m4T+xoSX
kkXcoCiYf+AnWdT/xYloEG+ovy0oBfOfv3q3ps7ECZRX/hZ+4RCRgA1IYi4z7VwL
JepZz87PH6zv9D1CmtraQVZUD3UJRfMGVsimLlH09r+mbZm3Ndu9cO7fLLkLzLP6
w9hhibZtnNAOyLDYrgOjl70bGjePzeodmqzPMY2zAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB2/xNHBk4oXI5iOyhh4Kob
7ZVFfnjnOFFVhoWYAHSL4rJy6Zk12VwqsvUh4viwkSgmpKkZxyjQR7rKGTyopzHJ
aUEV7mhHc6lpM1biTZyXHz9PIJAgiHe1J+CTm5qVx9STi1b1cJ1FlTYK+7TT/noZ
Pscg1KOw5rmUbTcJ6UnBF1EtSSl+JzPZDxE0/NKBKJey/vRZXj8l4WLiN7sZTr9v
n3AnByDua5653q+AOTjoWP6/U/w1JWa4QNCzk05qBnFLczWGmU/oAXuvIRkTZ+wq
L/VQNnOjmBDeN+LAVAjUxDuGxVJiuCQisUiV5KZVl2kAayCgJccEI5N+OYKO2oI+
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCog5fCeSavpTI1
/3mA/Jv9XJF6ZGRzmNJq8JdRPUd/V6dQeU5cOE7QGXbqBV1gQUOXIf8Ke9wgwcMP
GRLBbhMQcd9CqWK/rZZOuczRBoqyEvQPYhkyPWmIbRsNTLg6KYxghdCD9Ps75YWB
pxb7uGwKgYadixPGGTDlbGw4m4T+xoSXkkXcoCiYf+AnWdT/xYloEG+ovy0oBfOf
v3q3ps7ECZRX/hZ+4RCRgA1IYi4z7VwLJepZz87PH6zv9D1CmtraQVZUD3UJRfMG
VsimLlH09r+mbZm3Ndu9cO7fLLkLzLP6w9hhibZtnNAOyLDYrgOjl70bGjePzeod
mqzPMY2zAgMBAAECggEAbTHQThk5Q0n1jl38euO1pOit8DRLj0hw2RELzH277b17
0r64UzO9hkVp890EE9JWnQFPhZibHLLR1d+2cpcETXysYkLmlTRDmMH3AV+O0jNL
6Qf1McPvtZKVm/mhyzaPGyC67Db78WUaLNh8ISLxB6HE/CNZ7dz2/UNToR7NgFVP
0A2fLST+2MhFaCXxekK4Ssg6HktvN2dUg3GyYA8PnFtgDzkcNIbFYvtqv+dXZwzI
w+teOrXdx8zIlKAyAZDuKYyN7dzhpQM1l0qGG40gBioap8ZG9PtKDXyj26k3Smbw
1fmBcM6J+CouAjQ+3Tumiabct06XPWYmWqixZiK5gQKBgQDXG7BeU2Xb0GIooDGO
lQ8mvHBUxfYnUiOvHvph8tZGRZHMKi1iooO+/Lc3JVQ0lbaYO6cCrWr+SOV/pzQz
5sBB0Xz3mGJiBBabPjQ3C2UEbQ0i5S+1QJoQCPVFeLSYq9n11rynZ5EvgZlb0JKC
krR31ir01UkPGiEvs4e4T8peQQKBgQDIjGKTQELgzLoZfvNo8G3TmZFaxpaFek/i
k3ruyjH1AubX2s/R47aK8Ou9zh3W570nI55b+aaY8jzBMibYCAm9cqFTPzHWJ3An
kjfQ2Jw5+UESGD3GA2VcW/qNr9BkTY+PJTOXtRMTnblnCfavaa1BJCgKWM9gXYeG
B8WQhuCW8wKBgQDMI4/eBIFu+TSeX2CIcrddSInGOdRf/pi00c5GdEGbkNxLiF9n
8tjawFRTtk5SVR5jHIFjjhYy2hVKbvCgrMUZ8WgKRQhhAoY9r+u3rU2hxKgpzJzZ
A0TyIL47vtCM7tI7dx20NRpYnkJfGvJfjkBMVeiQT3U1KtQBw/vyE272wQKBgFYH
8xmcDZSF/qeFUEIKMfL+A97fJh8oczCNd8UMNBYZIpIiqdguSVadN2P7Ec3pJ7ms
i/iExjUCZZGzQ/qUqCj/Dbm6eFSYIoK3NP6AjbRI+uMaRxW0yzytsHQrocgFhbow
iUthQEe/95L+MTbarJovOoYFxyBdvw9+MgBn+9yFAoGAC/X+58U1usmpZYeyinyX
PvcPyMbRIQQVezI6+wBPcTQzN8orTQn6j+r7VLDdABdaa2f3/pB5EWTYnmKRIoKn
PbShaxVYigIdVkNvr8WSssmfUdsUYiLYEP14hvYyMKu51ksYkqWsvVoxIcnVBlk1
zMMX9G1pTIPd77XmoutdzNA=
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUKXI5XpFZ30y1ouQq11Ke6CJYc80wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC5cLVLbbFTsBDiYGEvK2t3V2I1o/OjEbX/xqAcfYasvNTo
E8q61KL3tjIB5kdKYp2Ywl0ibUSnM8M9Zm2uMz+Wrpc0YB1H6IEpoN796q36m6Xh
/O/lDpatgwZkRiBnKVAuvifGeVb868keNBKAZ2DNHdpQcRtbkG6jMKSNonmOh3Jx
nurvv01mvf7VR7iTc9o4kBIgO2lOnxB2dpFcPxdi/kIIGjrUgU7tzAh4SfQgKKVg
WwRDk4BrlLWLRGkPsIvvoUNkVuC0adqXOaX+8WRfalw1mNed3OpYQ+W0SjHWuw7S
CxrpcfvXMniy3CpEdBJmbtKyC8Somj41QxmRRZblAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBVYAjTaWQpR8Ke7zD5ahJg
G/UDUUh9ZhUGCc4E0e2+qVjDgkJMqNjXx+OUUvj+iKo0A0UI/QJYf5n7kxs6C0GP
JLqt/OHbxdqRji3GQvftRAMjaIQ0KmRUIgN0XwbDUvFJ7QHBdV33AeWvDh1wWvtD
DYmMDausznQQBlYApt5LDq/Y+96rmMiaPGOga1Lz1GWON5v8RU3qPLyc8GgCeoaV
zoVLKiGDVtrhUzaOBTsZ464ZH74hIzjEb/QDqyoQYgk4o1RSdewNhnzmwWmS6hXD
E11IwGGiy0ix9OWyL5WyXvjHqjtJ219KIYQuLsEV/lOdHsybBcAQygjVqgMkz5CL
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC5cLVLbbFTsBDi
YGEvK2t3V2I1o/OjEbX/xqAcfYasvNToE8q61KL3tjIB5kdKYp2Ywl0ibUSnM8M9
Zm2uMz+Wrpc0YB1H6IEpoN796q36m6Xh/O/lDpatgwZkRiBnKVAuvifGeVb868ke
NBKAZ2DNHdpQcRtbkG6jMKSNonmOh3Jxnurvv01mvf7VR7iTc9o4kBIgO2lOnxB2
dpFcPxdi/kIIGjrUgU7tzAh4SfQgKKVgWwRDk4BrlLWLRGkPsIvvoUNkVuC0adqX
OaX+8WRfalw1mNed3OpYQ+W0SjHWuw7SCxrpcfvXMniy3CpEdBJmbtKyC8Somj41
QxmRRZblAgMBAAECggEBAJMxd3Yr17mJ450My5dZa7AK2JWjUdx6TnB8BNMYgDHU
oVqleyHZbpIZOJBxbN0KcfWzMaIGAZyGZc7y4tSHMU41vyd/sz5Eu2GDo/0ArqBh
s8Yxs2mprsiDXCtzznyUOmUf4wqTfgy8S6OByb3KUPf/Xi7D2OdROcCm97bE5J/Q
YNR0gBPQCRh8eafT81J6/jS4yLurQqYfZN/dUIeNZMsq8Snn/Ppra8HDanFCPgqk
L1Oht9lkJMFufO39WdbjMbeZkdwBhX4RmpT9RnOY4dAL/QXgWQ7NLxMeVZvmtdQC
/zQ2k5PN/8s1BfLpCEGlA31rdq0+/O83gRt23S8P4/ECgYEA6HXaA82leiUklggc
aGEqpjMUgGH2kIk+WZDeiT6VLgWuF+DOPO7mbV1oHylQ7R27if4ouZAxv5xellMn
zoqpETYxe24/vXC3VFPHH7spAK67P8p9jzPwDs3MaT2zBfHwSp1+BhybiCqtGM5i
G/BZndHWb1vTH0DflCMEBlstxUMCgYEAzDfwWC5dKYgpS1T3XpLyQJnzL7D7VSHi
0NhQymttu8+uyZ2JkjWkJFQtwfSTu7D6v6dS+JSTRPcJkFNI/lb7RZnnu5Jj5p4n
Nl67KfVw2C4MGLBUv3OZXYmS8Vwh9cRY+QsB7k4FV8ZS25yDr5entR1ethaDZeQx
jv16qFVY3LcCgYEAoJ9uOVqLkM7BbPnFx0n8kkKRU/RczppGftTfL64Snm5GUTGA
0BGzHraAD6gYxv7Yaw03TqEX/vIpWW2z/79H+yCbKFKRsHCF/Lq2yHImbtZNhFKC
V8TnhxMkv0NmxCDcjHIudkKmJXx3hsB0giGdirNHnEKyqtHEqzNWwJ2YDskCgYBv
BqKGbn57y+kXaZQrOJy3/nq2HPQnborPnCsgQZOhHeIa/qkCcmNQ1OsjnYKL8kYA
2ElFmBEQ13W9n2n5zPRC/M99rLLfeHA9IPeEckntXet5qLQKeiCRN/BJhBt6cEsm
6pMcKhLBi7MUbl0xo7OrxdHuEQNS6+L9qFV9Gxl6tQKBgBcQk4Cd98y8Ulmt9+Un
rYds/FAO4q1SpnZpYVGHr93rIsL7EJO/4BViCXxT0YeqJp8tvSOrPMdT43OkIWwj
0gb/qvk7eT4KhCTDa7WY3p2LKzwgiKnk9G8OwRHYXTDpmvASRSkXHEilCBMJdqtM
W6AxtaSOGNymAr+UMZYWxZb/
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIURVoAXVmDtr+4fUDOOVA0ZXW+RTEwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDZsq3BSwg/a/I3AlY+Uj3d4S+W8jIhWHI8XHX5Ud7k+auJ
gfKvA/D6PrYI/TunHFzTGdVaGOd2y2Ylw7KUFZ9YIjtfQfNI0UnuIEyovcmLBiw2
tCtQE7ItEgLkrEjgBX8DNWlQxGKZ8+HAeY5Ux3eRsLJJn3fBFAxOtC+cxF5hFFvt
EcGTMo1lYr/A/XKt5Klh8eoOLkE8JNbwuO7AQC5NQN1AP3ZP+3rOC6AU+xdECF33
9H3gyfXeGk5ixLpV/d+Oz3VzRgmBCBt7+QLT/MSgm+xD3hO21MB2cBBIHJ6bzeTy
4nwvidsnSPPn6RoHg5vTR6HFmLvALirbiA0arr3/AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBl4c1dN+9iucNMtM0bLiAq
qeGRLnjGhizrhXuI0PtO5zrgmWgPnuJ/gZUwoPrGczO5g8ZO2zQhDuz8QWXLCNby
UL5C0aQrMafIqawKd3oumnHFOotY5eW4hf1rKyYfCGJ15xisWDIXuVSHzf6YlNlk
avHfchtw3I6xPIt6ui08qnRjuxVeoHbKKgM3DOx3vfvWiOyjXI0pZt2uYdMHdX8s
kOqJVoEF7XvSheDLXjhF7iWeGDmqjuBHv6eRfnA20MOXbE2l26Oa7M9z4xzVZBvU
GxtQwVXfxwmo54EuxVSS23gTD2q85JRRfPWuZnOs+NUr7e8P9MkejuC7iuvA2P7G
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDZsq3BSwg/a/I3
AlY+Uj3d4S+W8jIhWHI8XHX5Ud7k+auJgfKvA/D6PrYI/TunHFzTGdVaGOd2y2Yl
w7KUFZ9YIjtfQfNI0UnuIEyovcmLBiw2tCtQE7ItEgLkrEjgBX8DNWlQxGKZ8+HA
eY5Ux3eRsLJJn3fBFAxOtC+cxF5hFFvtEcGTMo1lYr/A/XKt5Klh8eoOLkE8JNbw
uO7AQC5NQN1AP3ZP+3rOC6AU+xdECF339H3gyfXeGk5ixLpV/d+Oz3VzRgmBCBt7
+QLT/MSgm+xD3hO21MB2cBBIHJ6bzeTy4nwvidsnSPPn6RoHg5vTR6HFmLvALirb
iA0arr3/AgMBAAECggEAEOk7bC+K9XpKN5G75112Jt1OWBh6YnK/dQbtty9v9DOc
6rKoioXw20+xzmL1llays0dndndGy8ijJ73bCnvfg/YszIqP/pEbgB8MNXOAy4bw
OlOmpbLR/YRPqzni81wZ8MLeaoLG8hSq7cvDjbxtAmlKgEOeBuaqyhZfOHtcpYfN
p5E3OGYR3nzI1kfwVvQ6E9YRI0DRTq36gnF5nua1LMhjbWYXRCjYkhEwLYEzCkrY
wwey9MqzhVwBEEADZfsr1kDECgBJNlTfEJyc6CVRQ5nM9rSYax6zYT5vWlsjYzZg
uHCi/qRGbsyKG2NdGAwcJVw4nC40rpBHQcIrb0I/oQKBgQDyZnWa9jleC3zl+BB6
lWJvbe99t1cepFEqSQaiqTL6jo9rnluBLFLDMjp2PcskP9CT/kjuBLQW3wUJh4VB
MMF/Zr/Bn35EfiTc05H1ZhXERC0CdP0N5KoN9lCqilJD7b16iwFLy6p8j7wLUL6T
dpLiomqlKnJqPnxms48JxnIDjwKBgQDl6W0YTSgjNFo+ZsftpFKBJz4P8y2YyaUN
B6QDW/m88o8J2vAK80eHvewakcZ5gO4RlkjAwxxxUnqsFBDgeyTZ+asePd1ufYc0
H76fXjPEBf2K/uxUoa+s6/FOeFKJ1Fe5D3YCnfAcUBjbHig9FFMFP4cm7PjrCaqi
g4UYx3SmkQKBgQDbWZ5o2RF2qfye+gindRD7dsc2wzbh8p3EHwsTHPuVwnXEVCvH
y30lSAmhQC/YoKq1kXEbekQhQjWDtw/9uwoOqMMziomvn1rqPcYiA/wEfBEi3Qy1
isvcEJ5UhREGiVdiUfGdTjL7vvHSZ4HdXXpz/bd1uOCKhfr60NfKZ7p6vwKBgHWm
4xX5fd2uD7Q5InxAh5vh+gdteNrj7VtimpLBgWYodfwkFoxz/BnBnc3m5TsOOEW1
sxs5fRecjnv6dLx7J9uHwQJjxCmjgQmyaPji2vin3BxB4axZZS3HO5/dQNeZWx6v
g8NJETNb5axTnWHMQcPAw6euwp58Pt6VEQoiH1aRAoGAN9HLpUoxUGfK89b6ZvLm
xLdoBLUyroIleNZNaQuiiWSEBN3diusLZv78i5JuOyBqA3e74iHW4gpvcUMeMq/u
jaj5tGi3njXk/jP4VB4oWuNT+k8X/QHzS6A92UrcwX7/ZSAoDBrAiKZXwdKC1JLH
pWAOTyrQdQ9UkfF3OLKjh1E=
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUGfJCme460FNV8uIRcAb2+fNOKnowDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC5pSuCco5DLrrC806I0t4XFEp/2HgHVve+xI3mIyl4A+mL
XXasrNMeVEo3MU1ADZBntZJcDl16PvHx01/sY5vo+0BwjzXIZyl96B5yH0ibxWeo
tZbkaU2FOg1/aR1sDL9guxQZ3JfrOA7AhFX+W5o36X9ySUsVcj9IFSuBd4WreAz+
lo/DCcsdNq6PvfpwR3Lz9VURBsYmRseO7cHdcASzr/UbfaIYFaJxYQzUkC127qXt
6KEqaUKPwt6/pNSCx6PChTS9isqz7oTg8CH9Ku8M9lQz+w9J9T1/AmuFnKUhLAg6
MVvl7bGDG657ndawiUYLsFnAtCQBxjnhdhngv0LPAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCr3TlMTjaxIWlpeaHo0rcR
CmZNB01iJQKHhu6HEKJunILBf1eH8Gm/CLftytMtbxPfEUB/OG04CvDfCYAk+yVK
lVhlLXKU1MHNbjCEYYhL9Nai862dxvAMLI4PMbrhIl9qPYfQ2tZ/yRKKZIy0Jnsx
EQECv1dFXTDPFZOd8/ViNFmHNLR9cHAnEuTFKnM2NoTOYlRF+f01yTF3AAAgdNw5
ViGPO3v4Xv5XeLVmpxOqG4ZXdCE4ZfSkqmR3MuDpe5GsYYOeEClLSZJxX4kNwd7e
EK8qZ/rAt2Yk+/O/FKGa5C59qj3dKiVVTN5UPfFD+cPYFFjCNjy+GP+Mw8sKit+r
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC5pSuCco5DLrrC
806I0t4XFEp/2HgHVve+xI3mIyl4A+mLXXasrNMeVEo3MU1ADZBntZJcDl16PvHx
01/sY5vo+0BwjzXIZyl96B5yH0ibxWeotZbkaU2FOg1/aR1sDL9guxQZ3JfrOA7A
hFX+W5o36X9ySUsVcj9IFSuBd4WreAz+lo/DCcsdNq6PvfpwR3Lz9VURBsYmRseO
7cHdcASzr/UbfaIYFaJxYQzUkC127qXt6KEqaUKPwt6/pNSCx6PChTS9isqz7oTg
8CH9Ku8M9lQz+w9J9T1/AmuFnKUhLAg6MVvl7bGDG657ndawiUYLsFnAtCQBxjnh
dhngv0LPAgMBAAECggEBAJtAJPXPhWdrseYNAXVtGywj3PWzexVwRnlz+NMoPqrO
YsYY4IEheuDXTsV/ZoIVldkVQJPZs5TjBQTeZ07SMnWRgN9g9HJmy40uzB9WSCt0
1+6ABfN4mMq8tMMDjgZpVra3XOUP1MByPewD/8Jaqsrta5aQ8si5pXBLu/lmkhPF
P99XesSb9o0jRsohC+D9ClepfX2r3VZ8Vy3XOHOKbQlFToWYGqGlgbr1nZ1r1mg2
+PpkQ0LSc2Fojbje5uS/MZLP+8gJESca+W6ZOrvSLvsbpQrsuLb7uNMq3FJaFzCl
QWN2fPHA13toOW+hNLUXSBtdDhCVpGb1y/bS+Jk7tBkCgYEA9F6lF1boNGdhVu13
rvzyL+oqJMr6h21tCP0Lw3mMFssP81a9NcuzLFJvElSkgNFSBk6ot6k2h61lnAMk
5adq8xosqyfFgYxSy0f5wysB5huHLGV/6iWgrTRfOpCNbSRQvbS6wdAuvkZxa4Ci
exgh8tK5wRkMj9sX7jXeEiWoNDMCgYEAwnsJWjXZ/Lfodykq1ZHnmv0btJiHvWah
K+38s2UPBBoKu+3fJIo6J3XLhR+hvl5C8M5QGTosWm4YfWkgEpArPyiTD75bbDuO
qZxjRF1RNLaMqT1/DAhHgS1Km/xxOMTdL/WD0/1KNVWQAv+j9VVIRZNguP+Gj1eG
HdYOwj2HevUCgYAzBxRoNECWuMOtuDaWtsEH2ljkh/Ial3H+P4DWV6o2FD8HbCRk
eF24spn49O3I7Gy5XnGCsHXvjPi7xDhPME935g5PyyVF8PxU8HmqFG/4EeV/Es7M
IQFVSatc+lRd5whpJLUexY8NMn56mUjUdWyZXQFm3gkufOyZVGxD09M02wKBgDxC
BwnOebZV/U8+kCkQRiS9m+H/CL/klreXy56CB38L2puT/nnB4nbrhp2+yUzExBT8
t9C5N5jlV+0zr15RETVGixprrsQASBnBfPhnuYuNrFOb3EuMHSunLuDZ/PLL/ISp
m6kJZ/7SfgaP0utm+zejjGqFsdmkEsgX1QbWLa4pAoGAcQSdwhtLP8Fhcfe7aOHo
Jpxdqh7l6HhLqKES6nURn9qNq9gu0P9x9Pj1C4mMFIP2Z7sjhF1qzk629FVxRujw
EshJTdj1syRNby9/XCh/uggCUHpD2NkVpcCnTmoN9ccnj8NwxZBOR8LQ81WyVzmU
8cnuPKU82EyrqhH1afc4fz8=
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUEfp1B/UPB0Hf5bcKFsJZ/Jg5ZUMwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDAIc6vaGVenMWjN8uyIetlwtTXCVRK0aTwLj6HHXpcJCSF
bIhvsZRlZ7Fvu4VelVNzXH/kmZhpUXY59QQObspZ2z7TfVLgS0r4mAU8WqmCGi+F
7cLVX7Du2E06jGhsBgKd9l6Ybud0SlW2/y8IzdIq75bW9qD7viAkbXg6sSR1zqwg
2lFpoSKaf9TFvdbgtiCIeCbTQEwTZktYEEd3S+yY/HierG9RTcpXSJvC1Orcv/J8
iH89U+C8QfNjULCChEOWhaw+qol2fKOK3394JsujORUn/9eHeJt1otc3JWnyR0DG
ok4y62xxl/y529npRJEkwXO7zoZXQVm+PoWZvYHDAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCEugh4aiI6L9PbBZDEnc7o
tUU2boCKwOsI6igtPaBhZZcQhyTi/qlmPMKZm58TFS8s//oiKhD3q31+OhQIe/Ak
pvuwJwcJLe0r4iUzbtGJsn3aIpXP+GHqEDM+38tZhXMpxq5Kv8Zp8Nm7R7XidGHg
OOBXQ64UDTUAHYvs+n4ltYLgTsqCPPWsHxieABjC3YDBJAdGa/H4cRB/qU7vKNkN
uAyfhVLBzaAcyYtQBef9cuulTUaE+KA8mN1kJNbA/b3E2MCGYCqf4eNN6gRdmtxG
16aP/7qxvVlgWh1mYfUvIlszazjI8TI2N1y1JZOWpmO4RoyWhvqhWdPXKC/HyVub
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDAIc6vaGVenMWj
N8uyIetlwtTXCVRK0aTwLj6HHXpcJCSFbIhvsZRlZ7Fvu4VelVNzXH/kmZhpUXY5
9QQObspZ2z7TfVLgS0r4mAU8WqmCGi+F7cLVX7Du2E06jGhsBgKd9l6Ybud0SlW2
/y8IzdIq75bW9qD7viAkbXg6sSR1zqwg2lFpoSKaf9TFvdbgtiCIeCbTQEwTZktY
EEd3S+yY/HierG9RTcpXSJvC1Orcv/J8iH89U+C8QfNjULCChEOWhaw+qol2fKOK
3394JsujORUn/9eHeJt1otc3JWnyR0DGok4y62xxl/y529npRJEkwXO7zoZXQVm+
PoWZvYHDAgMBAAECggEBAL2gIEfK91F71SwUI3x6McRLmJlrYcA+TVWnrprYIy3R
liIBTl8+msHCp8MpBqalJqnS/371gRFhDxiAlDJScnBhDQ7av/MTHLliALjimi4H
/iNm2EaTnSL+ZKqGbYFAJVEWGaLEwrdprlNgZGGCEg3CTdN3sscDjOGnEWSL9Po2
+nlHj3OFZJPZrTQkh8oRQXtf/cgtUDVKHBMaXeVZnNIvepaSW40y0clW4D70dEOy
NtYgPreUXgrkceXRz7TJbY5M6AwfvO7GYtMiER1zlWvnAK+AU6vUzCxek784hPQq
uiuhtJKf7H8dYxu9ShNWF+OITurFGx+qHnBk+u7Q4EECgYEA9T7hlIAkoq0ESOzl
6PssluYZ51AIFiRr+74VRbDh+nTnZuRPvYzhjpx9CXFezn2LQT8k8+rK25fH1tEI
0bv3b3K8LNytkE2KPk0tH8RitGq2cN/s7j2QK7yjCC/r/OCW3juSPIO42/QmFfgP
2IhzP/hO4VQbnMufVLBapQI6/1ECgYEAyI6s1PajiAlKDbAqf2ha5HrKwFC6rsuP
2RVmSKUdWnZLBO2ctzcKN8VuY+K8CGh1E3zL/OWWfnf0GLcnKiViDRgN5TSh4jv0
fJ4pSB+XFjetcHa1eGcrlbiXs538FkVzYLCFJgzOVwa17XcMP+CvtdaiGoSvlpAJ
eAz/e1n7ctMCgYEAyZvr7hx6AZGiWCEH0EPMIDEBUnskaq9+ZfGZozUKUM8R/C/s
rbLHKmnTEJQ2kCH8/KJgSnTWVzerfRlS2rhfbSsxLuArftl/sD/ZvKfBTPf9C0XK
jP/nKU1l6TEcG0K2Q/NNAJp4ubk4Jg9LV4K02/3ROsPd/0QVs5VWrxfqUEECgYAa
/CeBGBZ0zVsrcFKnhfEE4Qi6y6Hytu0J9nkmuSCz9UquxRHbDQrQ6j2qLu3B69wk
3RvNUU7ogVdUpAAfCZyhymTEPEqz2AFTayx+ydFYafFqOm68XpVctdOjlVQ/4uRd
VCL2Na7lwr9jzirVxXOe8dwp2USO6556irUtcbQFhQKBgErhJh3hT8MaJITjkP+K
RBrvronn1x3iE4cApN2hOHtlaaf06HmazxGCBzElC3xmAac4kWqMXbE3e2nyiW6T
yBPH3fYzKH3SJhQ9vFcaMHmZgnSDR8NcrVeL3CMqxmhxgo7hnOG11fNsGpBxgyGg
GJygRZjw2nPID7SBUjH5vEq4
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUQGJa9B0MRFmHuvjXjyCBbXypCBEwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNVoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDGNB8T3gN1kLSJ4QhzMcoS7UPLvoWxvxVqYUSEap+4EI//
LDKVlFKOl5icf808nVxGwb2XD7Io5wkX1kppBiqudri+WwHn9ayyhdpSi6eUsi3G
suPObKUTzNH9LOli6DA++GBaYoQUVXoOKWz3DVk8QMSCXgej5+09owdwIMHl8ytV
G36/LpPjH8Chr4y2MAUtz2Dc/Evyq8XfBIeD835Azhr2RXs3c/AOXVWXPt9A2BW8
sA7WvztNhYnqtL4EXpgG6H018aZTnCMEHEbil05fkfs+zRxgncqQ5BDSqARbkSDu
SeczaJtmW7E4yqRZTFZF2AnssyDuPQcl+qiYNNU1AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCFCSfOPoAbrIMBPLkiHGOv
a3OJmi/Kw9qfOp6iCVb4A0CE9ShzBZJqvSfZ/CnPeLsXy9zaRytrVHgkOXQyzbbv
uKiaBgwnLT1VFQlPorGBVJZisLl6uc+PIPK+9syqnOvaeilbI/UH1WrcESwrV2C1
7CcV8ibj7a9WnWC0LvzNMDHFKqPyOUTmBZWHvS21fYHUXV/5abX19TmwOzJTOWuc
cms/M6RfeldLIgGhxGnqn1un2KLXJ9wGHqcTVkbp3Fvk3Sk/T2zxgmJCLLLzI7Ap
cvVw1It2vL4bmGfF/1CTjfawhEbmtvTl1NkY/e0c2AORZ1eCvz/ZQYuwZxCseP0u
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDGNB8T3gN1kLSJ
4QhzMcoS7UPLvoWxvxVqYUSEap+4EI//LDKVlFKOl5icf808nVxGwb2XD7Io5wkX
1kppBiqudri+WwHn9ayyhdpSi6eUsi3GsuPObKUTzNH9LOli6DA++GBaYoQUVXoO
KWz3DVk8QMSCXgej5+09owdwIMHl8ytVG36/LpPjH8Chr4y2MAUtz2Dc/Evyq8Xf
BIeD835Azhr2RXs3c/AOXVWXPt9A2BW8sA7WvztNhYnqtL4EXpgG6H018aZTnCME
HEbil05fkfs+zRxgncqQ5BDSqARbkSDuSeczaJtmW7E4yqRZTFZF2AnssyDuPQcl
+qiYNNU1AgMBAAECggEAUpTg5fw44MEcF96lEKoMEfq9pqSJO9fr6lkAnVN3nM95
z83wfZZBF5xeP8aYEstV6T1L6yblClnI1h+4/S1Ol0ZsDxQIJUedXvyaTI5XkoLy
w7lBZX6rASbzz1LpIwavI22FZ+NoOLislD36Yq0zIwGxXsgi0s4NcQL+VF+xqkb8
9Wc7wnV0LH7jsEk3DiUDVdlCvDCDVOuspOj63031H0aZR77OpcqzR3hqX/TYkMOs
91F64owY4Ayda9zXg+nJvx5h8LyWTqeW4e2BRxxCWRcf3reQ/EeGbKwLVjjvQNyp
SiiIkAM6HkZ8P5bzrQYN5aqJvkjkg4ngeYrGBOrrgQKBgQDx6CK/2cW4k1X7I3YW
CSsqjaSp2zIyeU6wLWml1+xST8KXHosHZYAr7zZuhaafMiSqEj3rCVnVjwtcVLl+
oxB547rlU3BDKGTQpCeUn91NhPcXNK5nrV3wJwPen+cytxdPcf0c59gmigXV4BO1
xsI/5JzdJL0lzNgNy63n1oDzxQKBgQDRwC80chU5RUv0Q7IhAtIGwZMX27bds/MJ
RoZQdzzZpyu5HAkRxLOl81qPw1s7OTS1HutlrCRuuWHFGpULbysTiO+E9IA72zCr
cavggyOEacnaBzzXM9XU3JFjSNHnzrPjFaSStrTUxiERwnmDJroPq3XLXWCWriG3
TOGsVx3CsQKBgCfz9wlIpmc9rk20JaSuDvsQOcnz8e50KpLebTx+1QEjOzhKSxwF
n42iDJNkb4iLd5K/QIq5GKU04uN0+s33kJkRC6Ukir4MxdnPwtnBLYPIGiczBDsL
XyBy0SjLsBuoMallYjCL+h8jXKNeRuMW2K5Ey8OadcLweh6NLUPFIbchAoGBAMz5
v+fDuQPvuWsqoK/r3q2ljAabu5frHA2rcuS9saSN3oeWYzKPBHSfXZfydHxqyhxZ
6/a/BBeEaIxDDvZOnE0J2/AVNB/Kc0SH4EyWOyZSb2T2/7jauhO7vQTGjAK5mEfJ
xbtue0cXnAeMAk1tkhRwHbwwM4zs/JvxsPRHahjxAoGAAlRSSamCk3Pig02/6bO0
ASWDksoRfp81GqsocXof+sea4jnNOtOyM9xTAEIgbooGVyakCxNSnEnTdWtrNkxy
7JrD6xdelPw8BxpxJMd/kJhj+YQQDiVNxm2I99r1MAHG1bq/evaXm071jP5hvS/e
d8a1rEOCndTj7T9DNTBfYl0=
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_4: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_4: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
