# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['esque',
 'esque.cli',
 'esque.clients',
 'esque.config',
 'esque.controller',
 'esque.messages',
 'esque.resources',
 'esque.ruleparser',
 'esque.validation']

package_data = \
{'': ['*'], 'esque.validation': ['schemas/*']}

install_requires = \
['avro-python3==1.8.2',
 'click>=7.0,<8.0',
 'confluent-kafka[avro]>=1.2,<2.0',
 'fastavro>=0.22.5,<0.23.0',
 'pendulum>=2.0,<3.0',
 'pykafka>=2.8,<3.0',
 'pyyaml>=5.1,<6.0',
 'requests>=2.22,<3.0',
 'toml>=0.10.0,<0.11.0',
 'yamale>=2.0,<3.0']

entry_points = \
{'console_scripts': ['esque = esque.cli.commands:esque']}

setup_kwargs = {
    'name': 'esque',
    'version': '0.2.0b3',
    'description': 'esque - an operational kafka tool.',
    'long_description': '# esque - an operational Kafka tool\n\n[![pypi Version](https://img.shields.io/pypi/v/esque.svg)](https://pypi.org/project/esque/)\n[![Python Versions](https://img.shields.io/pypi/pyversions/esque.svg)](https://pypi.org/project/esque/)\n![Build Status](https://github.com/real-digital/esque/workflows/Style,%20Unit%20And%20Integration%20Tests/badge.svg)\n[![Coverage Status](https://coveralls.io/repos/github/real-digital/esque/badge.svg?branch=master)](https://coveralls.io/github/real-digital/esque?branch=master)\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n\nIn the Kafka world nothing is easy, but `esque` (pronounced *esk*) is an attempt at it.\n\n`esque` is a user-centric command line interface for Kafka administration.\n\n## Why should you care?\n\nSome stuff is hard, and that is okay, but listing your kafka topics shouldn\'t be.\n\nWhile adopting kafka at real.digital we noticed the immense entry barrier it poses to newcomers.\nWe can\'t recount how often we wrote Slack messages asking for the script to check the\nstatus of topics or consumer groups. This is partly (but not only) due to a\nfragmented and unclear definition of tooling and APIs for kafka.\nIn a wide array of administration tools, `esque` distances itself by striving to provide Kafka Ops for Humans, in a usable and natural way.\n\nWe feel that the goal of `esque` embodies the principle: “**keep easy things easy, and make hard things possible**”.\n\n## Principles\n\n* batteries included\n* feature rich\n* robust\n* insightful\n* by engineers for engineers\n\n## Feature Overview\n\n* Support for any type of Kafka deployment >1.2\n* Display Resources (Topics, Consumer Groups, Brokers)\n* Get detailed Overviews of Resources (Topics, Consumer Groups, Brokers)\n* Create/Delete Topics\n* Edit Topic Configurations\n* Edit Consumer Offset for Topics\n* SASL/SSL Support out of the box\n* Consume and Produce to and from Avro and Plaintext Topics (including Avro Schema Resolution from Schema Registry)\n* Context Switch (Easily Switch between pre-defined Clusters)\n* Kafka Ping (Test roundtrip time to your kafka cluster)\n\n## Command Overview\n\n```bash\n$ esque\n\nUsage: esque [OPTIONS] COMMAND [ARGS]...\n\n  esque - an operational kafka tool.\n\n  In the Kafka world nothing is easy, but esque (pronounced esk) is an\n  attempt at it.\n\nOptions:\n  --recreate-config  Overwrites the config with the sample config.\n  --version          Show the version and exit.\n  -v, --verbose      Return stack trace on error.\n  --no-verify        Skip all verification dialogs and answer them with yes.\n  --help             Show this message and exit.\n\nCommands:\n  apply     Apply a set of topic configurations.\n  config    Configuration-related options.\n  consume   Consume messages from a topic.\n  create    Create a new instance of a resource.\n  ctx       List contexts and switch between them.\n  delete    Delete a resource.\n  describe  Get detailed information about a resource.\n  edit      Edit a resource.\n  get       Get a quick overview of different resources.\n  ping      Test the connection to the kafka cluster.\n  produce   Produce messages to a topic.\n  set       Set resource attributes.\n\n```\n\n## Installation and Usage\n\n### Installation\n\n`esque` is available at [pypi.org](https://pypi.org/project/esque/) and can be installed with `pip install esque`. `esque` requires Python 3.6+ to run.\n\n#### SASL Support\n\nWhen your cluster is secured with SASL authentication, you\'ll need to install our fork of pykafka since pykafka itself\ndoesn\'t support it. We\'ve opened a pull request https://github.com/Parsely/pykafka/pull/972 but at the time of\nwriting it hasn\'t been merged yet.\n\n```bash\npip install -U git+https://github.com/real-digital/pykafka.git@feature/sasl-scram-support\n```\n\n`esque` will also prompt you with the above command as soon as you need it in case you\'re not sure if you actually do.\n\n### Autocompletion\n\nThe autocompletion scripts for `bash` and `zsh` can be generated by running `esque config autocomplete`.\n\n### Usage\n\n#### Config Definition\n\nWhen starting `esque` for the first time the following message will appear:\n\n```bash\nNo config provided in ~/.esque\nShould a sample file be created in ~/.esque [y/N]:\n```\n\nWhen answering with `y` `esque` will copy over the [sample config](https://github.com/real-digital/esque/blob/master/esque/config/sample_config.yaml) to `~/.esque/esque_config.yaml`.\nAfterwards you can modify that file to fit your cluster definitions.\n\nAlternatively might just provide a config file following the sample config\'s file in that path.\n\n##### Config Example\n\n```yaml\nversion: 1\ncurrent_context: local\ncontexts:\n  # This context corresponds to a local development cluster\n  # created by docker-compose when running esque from the host machine.\n  local:\n    bootstrap_servers:\n      - localhost:9092\n    security_protocol: PLAINTEXT\n    schema_registry: http://localhost:8081\n    default_values:\n      num_partitions: 1\n      replication_factor: 1\n```\n\n#### Config file for "apply" command\n\nThe config for the apply command has to be a yaml file and\nis given with the option -f or --file.\n\nIn the current version only topic configurations can be\nchanged and specified.\n\nIt has to use the same schema, which is used\nfor the following example:\n\n```yaml\ntopics:\n  - name: topic_one\n    replication_factor: 3\n    num_partitions: 50\n    config:\n      cleanup.policy: compact\n  - name: topic_two\n    replication_factor: 3\n    num_partitions: 50\n    config:\n      cleanup.policy: compact\n```\n\n## Development\n\nTo setup your development environment, make sure you have at least Python 3.6 & [poetry](https://github.com/sdispater/poetry) installed, then run\n\n```bash\npoetry install\npoetry run pip install -U git+https://github.com/real-digital/pykafka.git@feature/sasl-scram-support\npoetry shell\n```\n\n### Pre Commit Hooks\n\nTo install pre commit hooks run:\n\n```bash\npip install pre-commit\npre-commit install\npre-commit install-hooks\n```\n\n### Run tests\n\n#### Integration Tests\n\nesque comes with a docker-compose based kafka stack which you can start up with `make test-suite`.\n\nYou can then run the integration tests against this stack with `pytest tests/ --integration --local`.\n\nAlternatively you can go the fast way and just run the whole stack + integration tests in docker:\n\n```bash\nmake integration-test\n```\n\n#### Unit Tests\n\nIf you only want the unit tests, just run:\n\n```bash\nmake test\n```\n\n## Alternatives\n\n- [LinkedIn KafkaTools](https://github.com/linkedin/kafka-tools)\n- [PyKafka Tools](https://github.com/Parsely/pykafka/blob/master/pykafka/cli/kafka_tools.py)\n- [Official Kafka Scripts](https://github.com/apache/kafka/tree/trunk/bin)\n- [kafkacat](https://github.com/edenhill/kafkacat)\n- [kaf](https://github.com/birdayz/kaf)\n',
    'author': 'real.digital',
    'author_email': 'opensource@real-digital.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/real-digital/esque',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
