/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.plugins.pythoneventserver;

import com.google.common.eventbus.Subscribe;
import org.micromanager.Studio;
import org.micromanager.data.DataProviderHasNewImageEvent;
import org.micromanager.data.Datastore;
import org.micromanager.internal.utils.MustCallOnEDT;
import org.micromanager.plugins.pythoneventserver.PythonEventServerFrame;

public class ImageListener {
    private PythonEventServerFrame.ServerThread server_;
    private Datastore store_;
    private final Studio studio_;

    public ImageListener(Studio studio, PythonEventServerFrame.ServerThread serverThread, Datastore datastore) {
        this.studio_ = studio;
        this.store_ = datastore;
        this.server_ = serverThread;
        this.store_.registerForEvents((Object)this);
    }

    @Subscribe
    public void onDataProviderHasNewImageEvent(DataProviderHasNewImageEvent event) {
        this.server_.sendImage(event);
        this.server_.addLog("DataProviderHasNewImageEvent");
    }

    @MustCallOnEDT
    public void close() {
        this.store_.unregisterForEvents((Object)this);
        this.store_ = null;
    }
}

