# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/15_coordinates_input.ipynb (unless otherwise specified).

__all__ = []

# Internal Cell
import warnings
from attr import asdict
from ..mltypes import BboxCoordinate
from ipywidgets import HBox, BoundedIntText, Layout
from typing import Callable, Optional

# Internal Cell

class CoordinateInput(HBox):
    def __init__(
        self,
        uuid: int = None,
        bbox_coord: BboxCoordinate = None,
        input_max: BboxCoordinate = None,
        coord_changed: Optional[Callable] = None,
        disabled: bool = False
    ):
        super().__init__()
        self.disabled = disabled
        self.uuid = uuid
        self._input_max = input_max
        self.coord_changed = coord_changed
        self.coord_labels = ['x', 'y', 'width', 'height']
        self.children = self.inputs
        self.layout = Layout(width="auto", overflow="initial")

        if bbox_coord:
            self.bbox_coord = bbox_coord  # type: ignore

    def __getitem__(self, key: str) -> int:
        return self.children[self.coord_labels.index(key)].value

    def __setitem__(self, key: str, value: int):
        self.children[self.coord_labels.index(key)].value = value

    @property
    def inputs(self) -> list:
        widget_inputs = []
        for in_p in self.coord_labels:
            widget_input = BoundedIntText(
                min=0,
                max=None if self._input_max is None else getattr(self._input_max, in_p),
                layout=Layout(width="55px"),
                continuous_update=False,
                disabled=self.disabled
            )
            widget_inputs.append(widget_input)
            widget_input.observe(self._on_coord_change, names="value")

        return widget_inputs

    @property
    def bbox_coord(self) -> BboxCoordinate:
        values = [c.value for c in self.children]
        return BboxCoordinate(
            **dict(zip(self.coord_labels, values))
        )

    @bbox_coord.setter
    def bbox_coord(self, bbox_coord: BboxCoordinate):
        for i, v in enumerate(asdict(bbox_coord).values()):
            self.children[i].value = v

    @property
    def input_max(self) -> Optional[BboxCoordinate]:
        return self._input_max

    @input_max.setter
    def input_max(self, input_max: dict):
        for i, label in enumerate(self.coord_labels):
            self.children[i].max = input_max[label]

    def _on_coord_change(self, change: dict):
        if self.coord_changed:
            try:
                idx = list(self.children).index(change["owner"])
                self.coord_changed(self.uuid, self.coord_labels[idx], change["new"])
            except ValueError:
                warnings.warn("Invalid coordinate change")