/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.util;

/**
 * Simple stopclock for measuring elapsed time. Internally, it uses a
 * millisecond counter (<code>System.currentTimeMillis</code>). On many Java
 * implementations, this counter may not be accurate on a millisecond level.
 */
public class Timer {

    /**
     * Contains time information
     */
    private long time;

    /**
     * Creates a new timer, and calls tic
     */
    public Timer() {
        tic();
    }

    /**
     * Starts the timer, and resets counter to zero.
     */
    public void tic() {
        time = System.currentTimeMillis();
    }

    /**
     * Returns the number of seconds elapsed since tic was last called. Note
     * that the class constructor calls tic.
     * 
     * @return Number of seconds since tic was called
     */
    public double toc() {
        return ((System.currentTimeMillis() - time)) / 1000.;
    }

}
