/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.LowerSymmPackMatrix;
import mt.UpperSymmPackMatrix;
import mt.fact.NotConvergedException;
import mt.fact.SymmEigenvalueDecomposition;
import mt.fact.SymmPackEigenvalueComputer;
import mt.ll.BLASkernel.UpLo;

/**
 * Test of the symmetric, dense eigenvalue solver
 */
public class SymmPackEigenvalueTest extends SymmEigenvalueTest {

	private LowerSymmPackMatrix L;

	private UpperSymmPackMatrix U;

	public SymmPackEigenvalueTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		super.setUp();
		L = new LowerSymmPackMatrix(A);
		U = new UpperSymmPackMatrix(A);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		L = null;
		U = null;
	}

	public void testLowerStaticFactorize() throws NotConvergedException {
		assertEquals(L, SymmPackEigenvalueComputer.factorize(L.copy()));
	}

	public void testLowerRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(L, SymmPackEigenvalueComputer.factorize(L.copy()));
		assertEquals(L, SymmPackEigenvalueComputer.factorize(L.copy()));
	}

	public void testUpperStaticFactorize() throws NotConvergedException {
		assertEquals(U, SymmPackEigenvalueComputer.factorize(U.copy()));
	}

	public void testUpperRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(U, SymmPackEigenvalueComputer.factorize(U.copy()));
		assertEquals(U, SymmPackEigenvalueComputer.factorize(U.copy()));
	}

	public void testLowerFactor() throws NotConvergedException {
		SymmPackEigenvalueComputer ec =
			new SymmPackEigenvalueComputer(A.numRows(), UpLo.Lower);
		assertEquals(L, ec.factor(L.copy()));
	}

	public void testUpperFactor() throws NotConvergedException {
		SymmPackEigenvalueComputer ec =
			new SymmPackEigenvalueComputer(A.numRows(), UpLo.Upper);
		assertEquals(U, ec.factor(U.copy()));
	}

	public void testLowerRepeatFactor() throws NotConvergedException {
		SymmPackEigenvalueComputer ec =
			new SymmPackEigenvalueComputer(A.numRows(), UpLo.Lower);
		SymmEigenvalueDecomposition evd = ec.factor(L.copy());
		assertEquals(L, evd);
		evd = ec.factor(L.copy(), evd);
		assertEquals(L, evd);
	}

	public void testUpperRepeatFactor() throws NotConvergedException {
		SymmPackEigenvalueComputer ec =
			new SymmPackEigenvalueComputer(A.numRows(), UpLo.Upper);
		SymmEigenvalueDecomposition evd = ec.factor(U.copy());
		assertEquals(U, evd);
		evd = ec.factor(U.copy(), evd);
		assertEquals(U, evd);
	}

}
