/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.DenseMatrix;
import mt.DiagMatrix;
import mt.Matrix;
import mt.fact.NotConvergedException;
import mt.fact.SVD;
import mt.fact.SingularvalueComputer;
import junit.framework.TestCase;

/**
 * Test the singular value solver
 */
public class SingularvalueTest extends TestCase {

    /**
     * Matrix to decompose
     */
    private DenseMatrix A;

    /**
     * Maximum matrix size, to avoid too slow tests
     */
    private final int max = 100;

    public SingularvalueTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        int n = Utilities.getInt(max);
        A = new DenseMatrix(n, n);
    }

    protected void tearDown() throws Exception {
        A = null;
    }

    public void testStaticFactorize() throws NotConvergedException {
        assertEquals(A, SingularvalueComputer.factorize(A));
    }

    public void testLowerRepeatStaticFactorize() throws NotConvergedException {
        assertEquals(A, SingularvalueComputer.factorize(A));
        assertEquals(A, SingularvalueComputer.factorize(A));
    }

    public void testFactor() throws NotConvergedException {
        SingularvalueComputer sc = new SingularvalueComputer(A.numRows(), A
                .numColumns());
        assertEquals(A, sc.factor(A.copy()));
    }

    public void testLowerRepeatFactor() throws NotConvergedException {
        SingularvalueComputer sc = new SingularvalueComputer(A.numRows(), A
                .numColumns());
        SVD svd = sc.factor(A.copy());
        assertEquals(A, svd);
        svd = sc.factor(A.copy(), svd);
        assertEquals(A, svd);
    }

    private void assertEquals(Matrix A, SVD svd) {
        DiagMatrix S = new DiagMatrix(svd.getS());
        DenseMatrix U = svd.getU();
        DenseMatrix Vt = svd.getVt();

        // Compute U*S*Vt
        Matrix s = U.mult(S.mult(Vt, new DenseMatrix(S.numRows(), Vt
                .numColumns())), new DenseMatrix(A.numRows(), A.numColumns()));

        // Check that A=U*S*Vt
        for (int i = 0; i < A.numRows(); ++i)
            for (int j = 0; j < A.numColumns(); ++j)
                assertEquals(A.get(i, j), s.get(i, j), 1e-12);
    }

}
