/*
 * Copyright (C) 2003-2005 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.Matrix;
import mt.fact.OrthogonalDecomposition;
import mt.fact.RQComputer;

/**
 * RQ test
 */
public class RQTest extends OrthogonalTest {

    public RQTest(String arg0) {
        super(arg0);
    }

    public void testStaticFactorize() {
        assertEquals(A, RQComputer.factorize(A));
    }

    public void testRepeatStaticFactorize() {
        assertEquals(A, RQComputer.factorize(A));
        assertEquals(A, RQComputer.factorize(A));
    }

    public void testFactor() {
        RQComputer c = new RQComputer(A.numRows(), A.numColumns());
        assertEquals(A, c.factor(A.copy()));
    }

    public void testRepeatFactor() {
        RQComputer c = new RQComputer(A.numRows(), A.numColumns());
        OrthogonalDecomposition od = c.factor(A.copy());
        assertEquals(A, od);
        od = c.factor(A.copy());
        assertEquals(A, od);
    }

    public void testStaticFactorizeNonSquare() {
        assertEquals(Ac, RQComputer.factorize(Ac));
    }

    public void testRepeatStaticFactorizeNonSquare() {
        assertEquals(Ac, RQComputer.factorize(Ac));
        assertEquals(Ac, RQComputer.factorize(Ac));
    }

    public void testFactorNonSquare() {
        RQComputer c = new RQComputer(Ac.numRows(), Ac.numColumns());
        assertEquals(Ac, c.factor(Ac.copy()));
    }

    public void testRepeatFactorNonSquare() {
        RQComputer c = new RQComputer(Ac.numRows(), Ac.numColumns());
        OrthogonalDecomposition od = c.factor(Ac.copy());
        assertEquals(Ac, od);
        od = c.factor(Ac.copy());
        assertEquals(Ac, od);
    }

    private void assertEquals(Matrix A, OrthogonalDecomposition od) {
        assertEquals(A, od.getR().mult(od.getQ(), A.copy().zero()));
    }

}
