/*
 * Copyright (C) 2003-2005 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Runs all the tests
 */
public class AllTests {

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for mt.test");
		//$JUnit-BEGIN$
		suite.addTest(new TestSuite(BandMatrixTest.class));
		suite.addTest(new TestSuite(DenseMatrixTest.class));
		suite.addTest(new TestSuite(DenseVectorTest.class));
		suite.addTest(new TestSuite(DiagMatrixTest.class));
		suite.addTest(new TestSuite(LQTest.class));
		suite.addTest(new TestSuite(LowerSPDBandMatrixTest.class));
		suite.addTest(new TestSuite(LowerSPDDenseMatrixTest.class));
		suite.addTest(new TestSuite(LowerSPDPackMatrixTest.class));
		suite.addTest(new TestSuite(LowerSymmBandMatrixTest.class));
		suite.addTest(new TestSuite(LowerSymmDenseMatrixTest.class));
		suite.addTest(new TestSuite(LowerSymmPackMatrixTest.class));
		suite.addTest(new TestSuite(LowerTriangBandMatrixTest.class));
		suite.addTest(new TestSuite(LowerTriangDenseMatrixTest.class));
		suite.addTest(new TestSuite(LowerTriangPackMatrixTest.class));
		suite.addTest(new TestSuite(QLTest.class));
		suite.addTest(new TestSuite(QRTest.class));
		suite.addTest(new TestSuite(RQTest.class));
		suite.addTest(new TestSuite(SPDTridiagMatrixTest.class));
		suite.addTest(new TestSuite(SingularvalueTest.class));
		suite.addTest(new TestSuite(SquareDenseMatrixTest.class));
		suite.addTest(new TestSuite(SymmBandEigenvalueTest.class));
		suite.addTest(new TestSuite(SymmDenseEigenvalueTest.class));
		suite.addTest(new TestSuite(SymmPackEigenvalueTest.class));
		suite.addTest(new TestSuite(SymmTridiagEigenvalueTest.class));
		suite.addTest(new TestSuite(SymmTridiagMatrixTest.class));
		suite.addTest(new TestSuite(TridiagMatrixTest.class));
		suite.addTest(new TestSuite(UnitLowerTriangBandMatrixTest.class));
		suite.addTest(new TestSuite(UnitLowerTriangDenseMatrixTest.class));
		suite.addTest(new TestSuite(UnitLowerTriangPackMatrixTest.class));
		suite.addTest(new TestSuite(UnitUpperTriangBandMatrixTest.class));
		suite.addTest(new TestSuite(UnitUpperTriangDenseMatrixTest.class));
		suite.addTest(new TestSuite(UnitUpperTriangPackMatrixTest.class));
		suite.addTest(new TestSuite(UpperSPDBandMatrixTest.class));
		suite.addTest(new TestSuite(UpperSPDDenseMatrixTest.class));
		suite.addTest(new TestSuite(UpperSPDPackMatrixTest.class));
		suite.addTest(new TestSuite(UpperSymmBandMatrixTest.class));
		suite.addTest(new TestSuite(UpperSymmDenseMatrixTest.class));
		suite.addTest(new TestSuite(UpperSymmPackMatrixTest.class));
		suite.addTest(new TestSuite(UpperTriangBandMatrixTest.class));
		suite.addTest(new TestSuite(UpperTriangDenseMatrixTest.class));
		suite.addTest(new TestSuite(UpperTriangPackMatrixTest.class));
		suite.addTest(new TestSuite(DenseLUTest.class));
		suite.addTest(new TestSuite(BandLUTest.class));
		suite.addTest(new TestSuite(DenseCholeskyTest.class));
		//$JUnit-END$
		return suite;
	}
}
