/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MPP.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mpp;

/**
 * Performs a reduction operation. When performing a reduction, start with the
 * value return by the appropriate <i>init </i> function, for example:
 * 
 * <pre>
 * int[] x, y;
 * Reduction r;
 * // ...
 * r.initInt(x);
 * r.opInt(x, y);
 * </pre>
 * 
 * <p>
 * Many predefined reductions are available in {@link mpp.Reductions}.
 * </p>
 */
public interface Reduction {

    void initByte(byte[] x);

    void initChar(char[] x);

    void initShort(short[] x);

    void initInt(int[] x);

    void initFloat(float[] x);

    void initLong(long[] x);

    void initDouble(double[] x);

    void opByte(byte[] x, byte[] y);

    void opChar(char[] x, char[] y);

    void opShort(short[] x, short[] y);

    void opInt(int[] x, int[] y);

    void opFloat(float[] x, float[] y);

    void opLong(long[] x, long[] y);

    void opDouble(double[] x, double[] y);

}
