/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrepareOutForMatlab {
    private final File mEfmFile;
    private final File mLogFile;
    private final File mDataFile;
    private final File mScriptFile;

    public PrepareOutForMatlab(String efmFile, String logFile, String dataFile, String scriptFile) {
        this.mEfmFile = new File(efmFile);
        this.mLogFile = new File(logFile);
        this.mDataFile = new File(dataFile);
        this.mScriptFile = new File(scriptFile);
    }

    public void exec() throws IOException {
        this.writeDataFile();
        this.writeScriptFile();
    }

    public void writeDataFile() throws IOException {
        int lineNo = 0;
        try {
            String line;
            PrintWriter out = new PrintWriter(new FileWriter(this.mDataFile));
            BufferedReader reader = new BufferedReader(new FileReader(this.mEfmFile));
            Pattern pat = Pattern.compile("^\\[([0-9]+)\\]:\\s*([01]+)$");
            boolean started = false;
            boolean ended = false;
            while ((line = reader.readLine()) != null) {
                ++lineNo;
                Matcher matcher = pat.matcher(line);
                if (matcher.matches()) {
                    if (!started) {
                        if (lineNo != 2) {
                            throw new IOException("expected only 1 heading row");
                        }
                        started = true;
                    }
                    String rowIndex = matcher.group(1);
                    String efm = matcher.group(2);
                    if (Integer.parseInt(rowIndex) != lineNo - 2) {
                        throw new IOException("expected efm " + (lineNo - 2) + " but found " + rowIndex);
                    }
                    out.println(efm);
                    continue;
                }
                if (!started) continue;
                if (ended) {
                    throw new IOException("expected only 1 tailing row");
                }
                ended = true;
            }
            out.close();
            if (!started) {
                throw new IOException("pattern not found in efm file");
            }
        }
        catch (IOException ex) {
            throw new IOException(String.valueOf(ex.getMessage()) + " [line: " + lineNo + "]");
        }
        catch (Exception ex) {
            String msg = "unexpected exception, e=" + ex + " [line: " + lineNo + "]";
            System.err.println(msg);
            ex.printStackTrace();
            throw new IOException(msg);
        }
    }

    public void writeScriptFile() throws IOException {
        int lineNo = 0;
        try {
            String line;
            PrintWriter out = new PrintWriter(new FileWriter(this.mScriptFile));
            BufferedReader reader = new BufferedReader(new FileReader(this.mLogFile));
            Pattern pat = Pattern.compile("^.*stoich\\{([0-9]+)\\}(.*)$");
            boolean started = false;
            boolean ended = false;
            while ((line = reader.readLine()) != null && !ended) {
                ++lineNo;
                Matcher matcher = pat.matcher(line);
                if (matcher.matches()) {
                    started = true;
                    String rowIndex = matcher.group(1);
                    String rest = matcher.group(2);
                    out.println("stoich[" + rowIndex + "]" + rest);
                    continue;
                }
                if (!started) continue;
                ended = true;
            }
            out.close();
            if (!started) {
                throw new IOException("pattern not found in log file");
            }
        }
        catch (IOException ex) {
            throw new IOException(String.valueOf(ex.getMessage()) + " [line: " + lineNo + "]");
        }
        catch (Exception ex) {
            String msg = "unexpected exception, e=" + ex + " [line: " + lineNo + "]";
            System.err.println(msg);
            ex.printStackTrace();
            throw new IOException(msg);
        }
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("2 input/ 2 output files expected: efm-file log-file data-file script-file");
            System.exit(1);
        }
        try {
            PrepareOutForMatlab inst = new PrepareOutForMatlab(args[0], args[1], args[2], args[3]);
            System.out.println("parsing input files:");
            System.out.println("\t" + inst.mEfmFile.getAbsolutePath());
            System.out.println("\t" + inst.mLogFile.getAbsolutePath());
            System.out.println("...");
            inst.exec();
            System.out.println("output written to files:");
            System.out.println("\t" + inst.mDataFile.getAbsolutePath());
            System.out.println("\t" + inst.mScriptFile.getAbsolutePath());
            System.out.println("done.");
        }
        catch (Exception ex) {
            System.err.println("failed, e=" + ex);
            ex.printStackTrace();
            System.exit(2);
        }
    }
}

