/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.polynomial;

import ru.sscc.matrix.RectBandedMatrix;
import ru.sscc.matrix.SymBandedMatrix;
import ru.sscc.matrix.solve.CholeskyBandSolver;
import ru.sscc.spline.base.OrderedMesh;
import ru.sscc.spline.base.OrderedPreparator;
import ru.sscc.spline.base.SmoothingPreparator;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class OddSplinePreparator
extends SmoothingPreparator {
    protected OrderedPreparator preparator;
    protected CholeskyBandSolver solver = null;

    public OddSplinePreparator(OrderedMesh orderedMesh, int n) {
        super(orderedMesh.size);
        this.preparator = orderedMesh.makePreparator(n);
    }

    public double calculationCost() {
        this.ensureSolverPrepared();
        RectBandedMatrix rectBandedMatrix = this.preparator.getH();
        return ((double)rectBandedMatrix.bandWidth * (this.weightMultiple > 0.0 ? 4.0 : 2.0) + (double)this.solver.getMatrix().halfWidth * 4.0) * (double)rectBandedMatrix.nRows;
    }

    public RectBandedMatrix getH() {
        return this.preparator.getH();
    }

    public final CholeskyBandSolver getSolver() {
        return this.isSolverPrepared() ? this.solver : null;
    }

    public void prepareSolver(double d) throws CalculatingException {
        this.prepareMultiples(d);
        RectBandedMatrix rectBandedMatrix = this.preparator.getH();
        int n = rectBandedMatrix.bandWidth - (d == 0.0 ? 1 : 0);
        if (this.solver == null || this.solver.getMatrix().halfWidth != n) {
            this.solver = new CholeskyBandSolver(rectBandedMatrix.nRows, n, false);
        } else {
            this.solver.reuse(false);
        }
        SymBandedMatrix symBandedMatrix = this.solver.getMatrix();
        this.preparator.calculateA(symBandedMatrix);
        if (d > 0.0) {
            rectBandedMatrix.compose(this.matrixMultiple, this.weightMultiple, symBandedMatrix, this.weights, symBandedMatrix);
        }
        this.solver.factorize();
        this.solverPrepared = true;
    }

    public void solve(RealVector realVector, RealVector realVector2, RealVector realVector3) {
        this.ensureSolverPrepared();
        RectBandedMatrix rectBandedMatrix = this.preparator.getH();
        rectBandedMatrix.multiply(realVector, realVector2);
        this.solver.solve(realVector2, realVector2);
        if (realVector3 != null) {
            if (this.weightMultiple > 0.0) {
                rectBandedMatrix.multiplyT(realVector2, realVector3);
                if (this.weights != null) {
                    RealPointer realPointer = realVector3.getPointer();
                    RealPointer realPointer2 = this.weights.getPointer();
                    int n = rectBandedMatrix.nColumns;
                    while (n > 0) {
                        realPointer.mul(realPointer2.get() * this.weightMultiple);
                        --n;
                        realPointer.next();
                        realPointer2.next();
                    }
                } else if (this.weightMultiple != 1.0) {
                    realVector3.multiply(this.weightMultiple, this.sourceSize);
                }
            } else {
                realVector3.assign(0.0, this.sourceSize);
            }
        }
        if (this.matrixMultiple != 1.0) {
            realVector2.multiply(this.matrixMultiple, rectBandedMatrix.nRows);
        }
    }
}

