/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.analytic;

import ru.sscc.spline.SplineBody;
import ru.sscc.spline.SplineWorkspace;
import ru.sscc.spline.analytic.GSplineWorkspace;
import ru.sscc.spline.base.ReducedMesh;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.SimplePointer;

public class GSplineBody
implements SplineBody {
    protected ReducedMesh mesh;
    protected int kernelDegree;
    protected int splineDegree;
    protected int dataSize;

    public GSplineBody(ReducedMesh reducedMesh, int n, int n2) {
        if (n2 < 0 || n2 > 1 || n < 1 || n >= 2 * n2 + 2) {
            throw new IllegalArgumentException("Incorrect degree parameters");
        }
        this.mesh = reducedMesh;
        this.splineDegree = n;
        this.kernelDegree = n2;
        this.dataSize = reducedMesh.size + n2 * reducedMesh.reducedDimension + 1;
    }

    public double calculate(SplineWorkspace splineWorkspace) {
        return RealMath.innerProduct(((GSplineWorkspace)splineWorkspace).basis, splineWorkspace.data, this.dataSize);
    }

    public SplineWorkspace createWorkspace(RealPointer realPointer) {
        return new GSplineWorkspace(realPointer, this.dataSize, this.mesh.reducedDimension);
    }

    public int dimension() {
        return this.mesh.initialDimension;
    }

    public int getVectorLength() {
        return this.dataSize;
    }

    public int maxQuote() {
        return this.dataSize;
    }

    public void prepareBasis(RealPointer realPointer, RealPointer realPointer2) {
        int n = this.mesh.size;
        switch (this.splineDegree) {
            case 1: {
                int n2 = 0;
                while (n2 < n) {
                    realPointer2.set(-Math.sqrt(this.mesh.squaredDistance(n2, realPointer)));
                    ++n2;
                    realPointer2.next();
                }
                break;
            }
            case 2: {
                int n3 = 0;
                while (n3 < n) {
                    double d = this.mesh.squaredDistance(n3, realPointer);
                    realPointer2.set(d == 0.0 ? 0.0 : d * Math.log(d));
                    ++n3;
                    realPointer2.next();
                }
                break;
            }
            default: {
                int n4 = 0;
                while (n4 < n) {
                    double d = this.mesh.squaredDistance(n4, realPointer);
                    realPointer2.set(d == 0.0 ? 0.0 : d * Math.sqrt(d));
                    ++n4;
                    realPointer2.next();
                }
                break block0;
            }
        }
        realPointer2.set(1.0);
        realPointer2.next();
        if (this.kernelDegree > 0) {
            RealMath.assign(realPointer2, realPointer, this.mesh.reducedDimension);
        }
        realPointer2.shift(-n - 1);
    }

    public void prepareWorkspace(SplineWorkspace splineWorkspace, double d, int n, int n2) {
        if (this.mesh.initialDimension != 1) {
            throw new IllegalStateException("Cannot use 1D call for multi-D spline");
        }
        if (n != 0) {
            throw new IllegalArgumentException("Cannot calculate a spline derivative");
        }
        this.prepareWorkspace(splineWorkspace, new SimplePointer(d), n2);
    }

    public void prepareWorkspace(SplineWorkspace splineWorkspace, RealPointer realPointer, int n) {
        GSplineWorkspace gSplineWorkspace = (GSplineWorkspace)splineWorkspace;
        this.mesh.reducePoint(realPointer, gSplineWorkspace.point);
        this.prepareBasis(gSplineWorkspace.point, gSplineWorkspace.basis);
        gSplineWorkspace.dataCount = this.dataSize;
        gSplineWorkspace.dataIndex = 0;
    }
}

