/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealDirectSolver;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.SimplePointer;

public abstract class RealSquareSolver
extends RealDirectSolver {
    protected DenseMatrix matrix = null;

    protected RealSquareSolver() {
    }

    protected RealSquareSolver(DenseMatrix denseMatrix) {
        this.attach(denseMatrix);
    }

    public void attach(DenseMatrix denseMatrix) {
        this.matrix = denseMatrix;
        this.setFactorized(false);
        if (denseMatrix != null) {
            denseMatrix.ensureSquareMatrix();
            denseMatrix.reuse();
        }
    }

    public static void forwardSubstitution(RealContainer realContainer, int n, int n2, int n3, RealPointer realPointer, RealPointer realPointer2, RealPointer realPointer3, int n4) {
        if (realPointer2.equals(realPointer3)) {
            realPointer2 = (RealPointer)realPointer2.clone();
        }
        realPointer3.invert();
        n2 += n3;
        int n5 = 0;
        while (n5 < n4) {
            realPointer3.set((realPointer2.get() - realContainer.preProduct(n, -n3, realPointer3, n5)) / realPointer.get());
            realPointer3.previous();
            realPointer2.next();
            realPointer.next();
            ++n5;
            n += n2;
        }
    }

    public final DenseMatrix getMatrix() {
        return this.matrix;
    }

    public final void reuse() {
        this.setFactorized(false);
        this.matrix.reuse();
    }

    public static void solveLowerTriangular(DenseMatrix denseMatrix, boolean bl, RealVector realVector, RealVector realVector2) {
        denseMatrix.ensureSquareMatrix();
        int n = denseMatrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        RealContainer realContainer = denseMatrix.getContainer();
        int n2 = denseMatrix.rowStep;
        int n3 = denseMatrix.columnStep;
        int n4 = denseMatrix.startIndex;
        RealSquareSolver.forwardSubstitution(realContainer, n4, n2, n3, bl ? new SimplePointer(1.0) : realContainer.getPointer(n4, n2 + n3), realVector.getPointer(), realVector2.getPointer(), n);
    }

    public static void solveUpperTriangular(DenseMatrix denseMatrix, boolean bl, RealVector realVector, RealVector realVector2) {
        denseMatrix.ensureSquareMatrix();
        int n = denseMatrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        RealContainer realContainer = denseMatrix.getContainer();
        int n2 = denseMatrix.rowStep;
        int n3 = denseMatrix.columnStep;
        int n4 = n - 1;
        int n5 = denseMatrix.startIndex + (n2 + n3) * n4;
        RealSquareSolver.forwardSubstitution(realContainer, n5, -n2, -n3, bl ? new SimplePointer(1.0) : realContainer.getPointer(n5, -n2 - n3), realVector.getPointer(n4, -1), realVector2.getPointer(n4, -1), n);
    }

    public final int sourceSize() {
        return this.matrix.nRows;
    }

    public final int targetSize() {
        return this.matrix.nColumns;
    }
}

