/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import java.util.Arrays;
import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.RealMatrix;
import ru.sscc.matrix.solve.RealSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealVector;

public abstract class RealDirectSolver
implements RealSolver {
    static final String NONPOSITIVE = "Nonpositive matrix";
    static final String ILLPOSED = "Ill-posed matrix";
    private boolean factorized = false;

    public DenseMatrix constructInverse(DenseMatrix denseMatrix) {
        denseMatrix = this.ensureInversion(denseMatrix);
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        int n2 = denseMatrix.nColumns;
        double[] dArray = new double[n2];
        DoubleVector doubleVector = new DoubleVector(dArray);
        int n3 = 0;
        while (n3 < n2) {
            Arrays.fill(dArray, 0.0);
            dArray[n3] = 1.0;
            this.solve(doubleVector, realVector);
            realContainer.shiftVector(realVector, n);
            ++n3;
        }
        return denseMatrix;
    }

    public DenseMatrix constructRefinedInverse(RealMatrix realMatrix, DenseMatrix denseMatrix) {
        realMatrix.ensureDimensions(this.sourceSize(), this.targetSize());
        denseMatrix = this.ensureInversion(denseMatrix);
        RealContainer realContainer = denseMatrix.getContainer();
        RealVector realVector = realContainer.getVector(denseMatrix.startIndex, denseMatrix.rowStep, denseMatrix.nRows);
        int n = denseMatrix.columnStep;
        int n2 = denseMatrix.nColumns;
        double[] dArray = new double[n2];
        DoubleVector doubleVector = new DoubleVector(dArray);
        DoubleVector doubleVector2 = new DoubleVector(n2);
        DoubleVector doubleVector3 = new DoubleVector(denseMatrix.nRows);
        int n3 = 0;
        while (n3 < n2) {
            Arrays.fill(dArray, 0.0);
            dArray[n3] = 1.0;
            this.solveAndRefine(realMatrix, doubleVector, realVector, doubleVector2, doubleVector3);
            realContainer.shiftVector(realVector, n);
            ++n3;
        }
        return denseMatrix;
    }

    protected final void ensureFactorized() {
        if (!this.factorized) {
            throw new IllegalStateException("Nonfactorized matrix");
        }
    }

    private final DenseMatrix ensureInversion(DenseMatrix denseMatrix) {
        int n = this.targetSize();
        int n2 = this.sourceSize();
        if (denseMatrix == null) {
            denseMatrix = new DenseMatrix(n, n2);
        } else {
            denseMatrix.ensureAlgebraic();
            denseMatrix.ensureDimensions(n, n2);
        }
        return denseMatrix;
    }

    public abstract void factorize() throws CalculatingException;

    public final boolean isFactorized() {
        return this.factorized;
    }

    protected final void setFactorized(boolean bl) {
        this.factorized = bl;
    }

    public abstract void solve(RealVector var1, RealVector var2);

    public boolean solveAndRefine(RealMatrix realMatrix, RealVector realVector, RealVector realVector2) {
        realMatrix.ensureDimensions(this.sourceSize(), this.targetSize());
        return this.solveAndRefine(realMatrix, realVector, realVector2, new DoubleVector(this.sourceSize()), new DoubleVector(this.targetSize()));
    }

    private boolean solveAndRefine(RealMatrix realMatrix, RealVector realVector, RealVector realVector2, RealVector realVector3, RealVector realVector4) {
        double d;
        int n = this.targetSize();
        double d2 = realMatrix.relativeAccuracy() * 2.0;
        double d3 = 3.0;
        this.solve(realVector, realVector2);
        while ((d = realVector2.normMax(n)) != 0.0) {
            realMatrix.multiply(realVector2, realVector3);
            realVector3.addVector(realVector, -1.0);
            this.solve(realVector3, realVector4);
            realVector2.addVector(realVector4, -1.0, n);
            double d4 = realVector4.normMax();
            if (d4 <= d2 * d) break;
            double d5 = d4 / d;
            if (d5 > d3 / 2.0) {
                return false;
            }
            d3 = d5;
        }
        return true;
    }

    public abstract int sourceSize();

    public abstract int targetSize();
}

