/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import java.util.Arrays;
import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealDirectSolver;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public abstract class RealCommonSolver
extends RealDirectSolver {
    protected DenseMatrix matrix = null;
    protected int range = 0;
    protected double[] balanceVector = null;
    private boolean balanceTag = false;
    private int nullSpaceRange = 0;
    private RealContainer nullSpace = null;
    private boolean[] columnTags = null;
    private double reductionAccuracy = 0.0;

    protected RealCommonSolver() {
    }

    protected RealCommonSolver(DenseMatrix denseMatrix) {
        this.attach(denseMatrix);
    }

    public void attach(DenseMatrix denseMatrix) {
        this.matrix = denseMatrix;
        this.setFactorized(false);
        if (denseMatrix != null) {
            this.columnTags = new boolean[denseMatrix.nColumns];
            this.setBalanceTag(false);
            denseMatrix.reuse();
        }
    }

    public void backSubstitution(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        realVector.ensureLength(this.range);
        int n = this.matrix.nColumns;
        realVector2.ensureLength(n);
        if (this.range > 0) {
            this.doBackSubstitution(realVector, realVector2);
        }
        if (this.range == n) {
            return;
        }
        RealPointer realPointer = realVector2.getPointer(this.range, -1);
        RealPointer realPointer2 = realVector2.getPointer(n, -1);
        int n2 = n;
        while (n2-- > 0) {
            realPointer2.next().set(this.columnTags[n2] ? realPointer.next().get() : 0.0);
        }
        if (this.nullSpaceRange == 0) {
            return;
        }
        realPointer = this.nullSpace.getPointer();
        realPointer2.reset(0, 1);
        int n3 = 0;
        n2 = 0;
        while (n2 < this.nullSpaceRange) {
            double d = this.nullSpace.postProduct(n3, 1, realPointer2, n);
            RealMath.addVector(realPointer2, realPointer.reset(n3, 1), -d, n);
            ++n2;
            n3 += n;
        }
    }

    protected void balance() {
        double d;
        int n = this.matrix.nRows;
        int n2 = this.matrix.nColumns;
        RealContainer realContainer = this.matrix.getContainer();
        int n3 = this.matrix.rowStep;
        int n4 = this.matrix.columnStep;
        double[] dArray = new double[n2];
        int n5 = 0;
        int n6 = this.matrix.startIndex;
        while (n5 < n2) {
            d = realContainer.postProduct(n6, n3, n6, n3, n);
            dArray[n5] = d == 0.0 ? 1.0 : 1.0 / Math.sqrt(d);
            ++n5;
            n6 += n4;
        }
        DoublePointer doublePointer = new DoublePointer(dArray);
        double d2 = -1.0 / Math.log(256.0);
        if (this.balanceVector == null) {
            this.balanceVector = new double[n];
        }
        n5 = 0;
        n6 = this.matrix.startIndex;
        while (n5 < n) {
            d = realContainer.weightedProduct(n6, n4, n6, n4, doublePointer, n2);
            if (d == 0.0) {
                d = 1.0;
            } else if ((d = RealMath.power(16.0, (int)Math.round(Math.log(d) * d2))) != 1.0) {
                realContainer.multiply(n6, n4, d, n2);
            }
            this.balanceVector[n5] = d;
            ++n5;
            n6 += n3;
        }
    }

    protected final void columnFactorized(int n) {
        this.columnTags[n] = true;
    }

    protected void doBackSubstitution(RealVector realVector, RealVector realVector2) {
        RealContainer realContainer = this.matrix.getContainer();
        int n = this.matrix.rowStep;
        int n2 = this.matrix.columnStep;
        int n3 = this.range - 1;
        int n4 = this.matrix.startIndex + (n + n2) * n3;
        RealSquareSolver.forwardSubstitution(realContainer, n4, -n, -n2, realContainer.getPointer(n4, -n - n2), realVector.getPointer(n3, -1), realVector2.getPointer(n3, -1), this.range);
    }

    protected abstract void doFactorize();

    protected final void ensureTransformable(DenseMatrix denseMatrix) {
        if (denseMatrix.nRows != this.matrix.nRows) {
            throw new IllegalArgumentException("Incompatible rows number");
        }
    }

    public void factorize() throws CalculatingException {
        int n;
        if (this.isFactorized()) {
            return;
        }
        this.matrix.lock();
        this.setFactorized(true);
        Arrays.fill(this.columnTags, false);
        this.range = 0;
        this.nullSpaceRange = 0;
        int n2 = Math.min(this.matrix.nRows, this.matrix.nColumns);
        if (n2 == 0) {
            return;
        }
        if (this.hasBalanceTag()) {
            this.balance();
        }
        this.nullSpace = (n = this.matrix.nColumns - this.matrix.nRows) <= 0 ? null : this.matrix.getContainer().newContainer(this.matrix.nColumns * n);
        this.doFactorize();
        if (this.range != n2) {
            throw new CalculatingException("The matrix range is nonmaximal");
        }
    }

    public final double[] getBalanceVector() {
        this.ensureFactorized();
        return this.balanceVector;
    }

    public final DenseMatrix getMatrix() {
        return this.matrix;
    }

    public final int getMatrixRange() {
        this.ensureFactorized();
        return this.range;
    }

    public final DenseMatrix getNullSpace() {
        this.ensureFactorized();
        return this.nullSpaceRange == 0 ? null : new DenseMatrix(this.nullSpace, this.matrix.nColumns, this.nullSpaceRange, false);
    }

    public final int getNullSpaceRange() {
        this.ensureFactorized();
        return this.nullSpaceRange;
    }

    public final double getReductionAccuracy() {
        return this.reductionAccuracy;
    }

    public final boolean hasBalanceTag() {
        return this.balanceTag;
    }

    protected void prepareNullVector(int n) {
        RealContainer realContainer = this.matrix.getContainer();
        int n2 = this.matrix.nColumns;
        int n3 = n2 * (this.nullSpaceRange + 1);
        if (this.nullSpace == null) {
            this.nullSpace = realContainer.newContainer(n3);
        } else if (this.nullSpace.size() < n3) {
            this.nullSpace.resize(n3);
        }
        int n4 = this.nullSpaceRange * n2;
        this.backSubstitution(realContainer.getVector(this.matrix.startIndex + n * this.matrix.columnStep, this.matrix.rowStep, this.range), this.nullSpace.getVector(n4, 1, n2));
        this.nullSpace.set(n4 + n, -1.0);
        double d = this.nullSpace.postProduct(n4, 1, n4, 1, n2);
        this.nullSpace.multiply(n4, 1, 1.0 / Math.sqrt(d), n2);
        ++this.nullSpaceRange;
    }

    public final void reuse(boolean bl) {
        this.setFactorized(false);
        this.setBalanceTag(bl);
        this.matrix.reuse();
    }

    public final void setBalanceTag(boolean bl) {
        if (!this.isFactorized()) {
            this.balanceTag = bl;
            if (!bl || this.balanceVector != null && this.balanceVector.length != this.matrix.nRows) {
                this.balanceVector = null;
            }
        }
    }

    public final void setReductionAccuracy(double d) {
        this.reductionAccuracy = d;
    }

    public void solve(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        int n2 = this.matrix.nColumns;
        realVector.ensureLength(n);
        if (this.range == 0) {
            realVector2.assign(0.0, n2);
            return;
        }
        realVector2.ensureLength(n2);
        RealVector realVector3 = this.range == n && this.range == n2 ? realVector2 : new DoubleVector(n);
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector3.getPointer();
        if (!this.balanceTag) {
            RealMath.assign(realPointer2, realPointer, n);
        } else {
            int n3 = 0;
            while (n3 < n) {
                realPointer2.set(realPointer.get() * this.balanceVector[n3]);
                ++n3;
                realPointer.next();
                realPointer2.next();
            }
        }
        this.transform(realVector3);
        this.backSubstitution(realVector3, realVector2);
    }

    public final int sourceSize() {
        return this.matrix.nRows;
    }

    public final int targetSize() {
        return this.matrix.nColumns;
    }

    public abstract void transform(DenseMatrix var1);

    public abstract void transform(RealVector var1);

    public abstract void transformT(RealVector var1);
}

