/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.SimplePointer;

public class GaussSolver
extends RealSquareSolver {
    public GaussSolver() {
    }

    public GaussSolver(int n) {
        super(new DenseMatrix(n, n));
    }

    public GaussSolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public GaussSolver(RealContainer realContainer, int n) {
        super(new DenseMatrix(realContainer, n, n));
    }

    public void factorize() throws CalculatingException {
        int n;
        if (this.isFactorized()) {
            return;
        }
        this.matrix.lock();
        if (this.matrix.nRows == 0) {
            this.setFactorized(true);
            return;
        }
        RealContainer realContainer = this.matrix.getContainer();
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep;
        int n4 = this.matrix.nRows;
        double d = this.matrix.relativeAccuracy() * 8.0;
        int n5 = n = this.matrix.startIndex;
        int n6 = n;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            double d2 = Math.abs(realContainer.get(n6)) * d;
            double d3 = realContainer.add(n6, -realContainer.postProduct(n5, n3, n, n2, n7));
            if (Math.abs(d3) <= d2) {
                throw new CalculatingException("Ill-posed matrix");
            }
            int n9 = n8 = n6;
            int n10 = n5;
            int n11 = n;
            int n12 = n7 + 1;
            while (n12 < n4) {
                realContainer.add(n9 += n3, -realContainer.postProduct(n11 += n3, n2, n5, n3, n7));
                realContainer.set(n8 += n2, (realContainer.get(n8) - realContainer.postProduct(n10 += n2, n3, n, n2, n7)) / d3);
                ++n12;
            }
            ++n7;
            n6 += n2 + n3;
            n5 += n2;
            n += n3;
        }
        this.setFactorized(true);
    }

    public void solve(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        int n2 = this.matrix.columnStep;
        int n3 = this.matrix.rowStep;
        int n4 = this.matrix.startIndex;
        RealContainer realContainer = this.matrix.getContainer();
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector2.getPointer();
        RealSquareSolver.forwardSubstitution(realContainer, n4, n3, n2, new SimplePointer(1.0), realPointer, realPointer2, n);
        realPointer2.reset(n - 1, -1);
        RealSquareSolver.forwardSubstitution(realContainer, n4 += (n - 1) * (n3 + n2), -n3, -n2, realContainer.getPointer(n4, -n2 - n3), realPointer2, realPointer2, n);
    }
}

