/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix;

import ru.sscc.matrix.RealMatrix;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class DenseMatrix
extends RealMatrix {
    public final int startIndex;
    public final int rowStep;
    public final int columnStep;

    public DenseMatrix(int n, int n2) {
        this(new DoubleContainer(n * n2), n, n2);
    }

    public DenseMatrix(RealMatrix realMatrix) {
        this(realMatrix.getContainer().newContainer(realMatrix.nRows * realMatrix.nColumns), realMatrix.nRows, realMatrix.nColumns);
        this.assign(realMatrix);
    }

    public DenseMatrix(RealContainer realContainer, int n, int n2) {
        this(realContainer, n, n2, true);
    }

    protected DenseMatrix(RealContainer realContainer, int n, int n2, int n3, int n4, int n5) {
        super(realContainer, n, n2);
        this.startIndex = n3;
        this.rowStep = n4;
        this.columnStep = n5;
    }

    public DenseMatrix(RealContainer realContainer, int n, int n2, boolean bl) {
        this(realContainer, n, n2, 0, bl ? n2 : 1, bl ? 1 : n);
    }

    public double add(int n, int n2, double d) {
        return this.entries.add(this.pos(n, n2), d);
    }

    public void assign(DenseMatrix denseMatrix) {
        this.ensureAlgebraic();
        this.ensureDimensions(denseMatrix);
        RealPointer realPointer = this.entries.getPointer();
        int n = this.startIndex;
        int n2 = denseMatrix.rowStep;
        int n3 = denseMatrix.columnStep;
        RealPointer realPointer2 = denseMatrix.entries.getPointer();
        int n4 = denseMatrix.startIndex;
        int n5 = 0;
        while (n5 < this.nRows) {
            RealMath.assign(realPointer.reset(n, this.columnStep), realPointer2.reset(n4, n3), this.nColumns);
            ++n5;
            n += this.rowStep;
            n4 += n2;
        }
    }

    public void assign(RealMatrix realMatrix) {
        this.ensureAlgebraic();
        this.ensureDimensions(realMatrix);
        RealPointer realPointer = this.entries.getPointer();
        int n = 0;
        int n2 = this.startIndex;
        while (n < this.nRows) {
            int n3 = 0;
            realPointer.reset(n2, this.columnStep);
            while (n3 < this.nColumns) {
                realPointer.set(realMatrix.get(n, n3));
                ++n3;
                realPointer.next();
            }
            ++n;
            n2 += this.rowStep;
        }
    }

    public Object clone() {
        if (this.entries.size() == this.nRows * this.nColumns) {
            return super.clone();
        }
        DenseMatrix denseMatrix = new DenseMatrix(this.entries.newContainer(this.nRows * this.nColumns), this.nRows, this.nColumns);
        denseMatrix.assign(this);
        return denseMatrix;
    }

    public double get(int n, int n2) {
        return this.entries.get(this.pos(n, n2));
    }

    public double mul(int n, int n2, double d) {
        return this.entries.mul(this.pos(n, n2), d);
    }

    public void multiply(RealVector realVector, RealVector realVector2) {
        this.ensureAlgebraic();
        realVector.ensureLength(this.nColumns);
        realVector2.ensureLength(this.nRows);
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = this.entries.getPointer();
        int n = this.startIndex;
        int n2 = 0;
        while (n2 < this.nRows) {
            realVector2.set(n2, RealMath.innerProduct(realPointer, realPointer2.reset(n, this.columnStep), this.nColumns));
            ++n2;
            n += this.rowStep;
        }
    }

    public void multiplyT(RealVector realVector, RealVector realVector2) {
        this.ensureAlgebraic();
        realVector.ensureLength(this.nRows);
        realVector2.ensureLength(this.nColumns);
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = this.entries.getPointer();
        int n = this.startIndex;
        int n2 = 0;
        while (n2 < this.nColumns) {
            realVector2.set(n2, RealMath.innerProduct(realPointer, realPointer2.reset(n, this.rowStep), this.nRows));
            ++n2;
            n += this.columnStep;
        }
    }

    protected final int pos(int n, int n2) {
        return this.startIndex + this.rowStep * n + this.columnStep * n2;
    }

    public final void reuse() {
        this.unlock();
    }

    public double set(int n, int n2, double d) {
        return this.entries.set(this.pos(n, n2), d);
    }

    public final DenseMatrix submatrix(int n, int n2, int n3, int n4) {
        return this.submatrix(n, n2, n3, n4, 1, 1);
    }

    public final DenseMatrix submatrix(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseMatrix(this.entries, n3, n4, this.pos(n, n2), this.rowStep * n5, this.columnStep * n6);
    }

    public final DenseMatrix transpose() {
        this.ensureAlgebraic();
        return new DenseMatrix(this.entries, this.nColumns, this.nRows, this.startIndex, this.columnStep, this.rowStep);
    }
}

