/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class OperandResolver {
    private OperandResolver() {
    }

    public static ValueEval getSingleValue(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        Eval result = arg instanceof RefEval ? ((RefEval)arg).getInnerValueEval() : (arg instanceof AreaEval ? OperandResolver.chooseSingleElementFromArea((AreaEval)arg, srcCellRow, srcCellCol) : arg);
        if (result instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)result);
        }
        if (result instanceof ValueEval) {
            return result;
        }
        throw new RuntimeException("Unexpected eval type (" + result.getClass().getName() + ")");
    }

    public static ValueEval chooseSingleElementFromArea(AreaEval ae, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval result = OperandResolver.chooseSingleElementFromAreaInternal(ae, srcCellRow, srcCellCol);
        if (result == null) {
            result = BlankEval.INSTANCE;
        }
        if (result instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)result);
        }
        return result;
    }

    private static ValueEval chooseSingleElementFromAreaInternal(AreaEval ae, int srcCellRow, short srcCellCol) throws EvaluationException {
        if (ae.isColumn()) {
            if (ae.isRow()) {
                return ae.getValues()[0];
            }
            if (!ae.containsRow(srcCellRow)) {
                throw EvaluationException.invalidValue();
            }
            return ae.getValueAt(srcCellRow, ae.getFirstColumn());
        }
        if (!ae.isRow()) {
            if (ae.containsRow(srcCellRow) && ae.containsColumn(srcCellCol)) {
                return ae.getValueAt(ae.getFirstRow(), ae.getFirstColumn());
            }
            throw EvaluationException.invalidValue();
        }
        if (!ae.containsColumn(srcCellCol)) {
            throw EvaluationException.invalidValue();
        }
        return ae.getValueAt(ae.getFirstRow(), srcCellCol);
    }

    public static int coerceValueToInt(ValueEval ev) throws EvaluationException {
        double d = OperandResolver.coerceValueToDouble(ev);
        return (int)Math.floor(d);
    }

    public static double coerceValueToDouble(ValueEval ev) throws EvaluationException {
        if (ev instanceof NumericValueEval) {
            return ((NumericValueEval)ev).getNumberValue();
        }
        if (ev instanceof StringEval) {
            Double dd = OperandResolver.parseDouble(((StringEval)ev).getStringValue());
            if (dd == null) {
                throw EvaluationException.invalidValue();
            }
            return dd;
        }
        throw new RuntimeException("Unexpected arg eval type (" + ev.getClass().getName() + ")");
    }

    public static Double parseDouble(String pText) {
        double val;
        String text = pText.trim();
        if (text.length() < 1) {
            return null;
        }
        boolean isPositive = true;
        if (text.charAt(0) == '-') {
            isPositive = false;
            text = text.substring(1).trim();
        }
        if (!Character.isDigit(text.charAt(0))) {
            return null;
        }
        try {
            val = Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Double(isPositive ? val : -val);
    }

    public static String coerceValueToString(ValueEval ve) {
        if (ve instanceof StringValueEval) {
            StringValueEval sve = (StringValueEval)ve;
            return sve.getStringValue();
        }
        if (ve instanceof NumberEval) {
            NumberEval neval = (NumberEval)ve;
            return neval.getStringValue();
        }
        if (ve instanceof BlankEval) {
            return "";
        }
        throw new IllegalArgumentException("Unexpected eval class (" + ve.getClass().getName() + ")");
    }
}

