/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileInputStream;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileReader {
    private MatFileHeader matFileHeader;
    private Map<String, MLArray> data;
    private ByteOrder byteOrder;
    private MatFileFilter filter;

    public MatFileReader(String fileName) throws FileNotFoundException, IOException {
        this(new File(fileName), new MatFileFilter());
    }

    public MatFileReader(String fileName, MatFileFilter filter) throws IOException {
        this(new File(fileName), filter);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter());
    }

    public MatFileReader(File file, MatFileFilter filter) throws IOException {
        this.filter = filter;
        this.data = new LinkedHashMap<String, MLArray>();
        FileChannel roChannel = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer buf = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
        this.readHeader(buf);
        while (buf.remaining() > 0) {
            this.readData(buf);
        }
        roChannel.close();
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    @Deprecated
    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String name) {
        return this.data.get(name);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    private ByteBuffer inflate(ByteBuffer buf, int numOfBytes) throws IOException {
        byte[] compressed = new byte[numOfBytes];
        buf.get(compressed);
        Inflater decompresser = new Inflater();
        decompresser.setInput(compressed);
        byte[] result = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            try {
                int i;
                do {
                    i = decompresser.inflate(result);
                    dos.write(result);
                } while (i > 0);
            }
            catch (DataFormatException e) {
                throw new MatlabIOException("Cound not decompress data: " + e);
            }
        }
        finally {
            decompresser.end();
        }
        ByteBuffer out = ByteBuffer.wrap(baos.toByteArray());
        out.order(this.byteOrder);
        return out;
    }

    private void readData(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        switch (tag.type) {
            case 15: {
                this.readData(this.inflate(buf, tag.size));
                break;
            }
            case 14: {
                int toread;
                int red;
                int pos = buf.position();
                MLArray element = this.readMatrix(buf, true);
                if (element != null) {
                    this.data.put(element.getName(), element);
                } else {
                    red = buf.position() - pos;
                    toread = tag.size - red;
                    buf.position(buf.position() + toread);
                }
                red = buf.position() - pos;
                toread = tag.size - red;
                if (toread == 0) break;
                throw new MatlabIOException("Matrix was not red fully! " + toread + " remainging in the buffer.");
            }
            default: {
                throw new MatlabIOException("Incorrect data tag: " + tag);
            }
        }
    }

    private MLArray readMatrix(ByteBuffer buf, boolean isRoot) throws IOException {
        MLArray mlArray;
        int[] flags = this.readFlags(buf);
        int attributes = flags[0];
        int nzmax = flags[1];
        int type = attributes & 0xFF;
        int[] dims = this.readDimension(buf);
        String name = this.readName(buf);
        if (isRoot && !this.filter.matches(name)) {
            return null;
        }
        switch (type) {
            case 2: {
                MLStructure struct = new MLStructure(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                int padding = tag.size % 8 != 0 ? 8 - tag.size % 8 : 0;
                String[] fieldNames = new String[numOfFields];
                int i = 0;
                while (i < numOfFields) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                    ++i;
                }
                buf.position(buf.position() + padding);
                int index = 0;
                while (index < struct.getM() * struct.getN()) {
                    int i2 = 0;
                    while (i2 < numOfFields) {
                        tag = new ISMatTag(buf);
                        MLArray fieldValue = this.readMatrix(buf, false);
                        struct.setField(fieldNames[i2], fieldValue, index);
                        ++i2;
                    }
                    ++index;
                }
                mlArray = struct;
                break;
            }
            case 1: {
                MLCell cell = new MLCell(name, dims, type, attributes);
                int i = 0;
                while (i < cell.getM() * cell.getN()) {
                    ISMatTag tag = new ISMatTag(buf);
                    MLArray cellmatrix = this.readMatrix(buf, false);
                    cell.set(cellmatrix, i);
                    ++i;
                }
                mlArray = cell;
                break;
            }
            case 6: {
                MLDouble mldouble = new MLDouble(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                double[] ad = tag.readToDoubleArray();
                int i = 0;
                while (i < ad.length) {
                    mldouble.setReal(ad[i], i);
                    ++i;
                }
                if (mldouble.isComplex()) {
                    tag = new ISMatTag(buf);
                    ad = tag.readToDoubleArray();
                    i = 0;
                    while (i < ad.length) {
                        mldouble.setReal(ad[i], i);
                        ++i;
                    }
                }
                mlArray = mldouble;
                break;
            }
            case 4: {
                MLChar mlchar = new MLChar(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                char[] ac = tag.readToCharArray();
                int i = 0;
                while (i < ac.length) {
                    mlchar.setChar(ac[i], i);
                    ++i;
                }
                mlArray = mlchar;
                break;
            }
            case 5: {
                MLSparse sparse = new MLSparse(name, dims, attributes, nzmax);
                ISMatTag tag = new ISMatTag(buf);
                int[] ir = tag.readToIntArray();
                tag = new ISMatTag(buf);
                int[] jc = tag.readToIntArray();
                tag = new ISMatTag(buf);
                double[] ad1 = tag.readToDoubleArray();
                int n = 0;
                int i = 0;
                while (i < ir.length) {
                    if (i < sparse.getN()) {
                        n = jc[i];
                    }
                    sparse.setReal(ad1[i], ir[i], n);
                    ++i;
                }
                if (sparse.isComplex()) {
                    tag = new ISMatTag(buf);
                    double[] ad2 = tag.readToDoubleArray();
                    int n1 = 0;
                    int i3 = 0;
                    while (i3 < ir.length) {
                        if (i3 < sparse.getN()) {
                            n1 = jc[i3];
                        }
                        sparse.setImaginary(ad2[i3], ir[i3], n1);
                        ++i3;
                    }
                }
                mlArray = sparse;
                break;
            }
            default: {
                throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(type));
            }
        }
        return mlArray;
    }

    private String zeroEndByteArrayToString(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int i = 0;
        while (i < bytes.length && bytes[i] != 0) {
            dos.writeByte(bytes[i]);
            ++i;
        }
        return baos.toString();
    }

    private int[] readFlags(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] flags = tag.readToIntArray();
        return flags;
    }

    private int[] readDimension(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] dims = tag.readToIntArray();
        return dims;
    }

    private String readName(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        char[] ac = tag.readToCharArray();
        String s = new String(ac);
        return s;
    }

    private void readHeader(ByteBuffer buf) throws IOException {
        int version;
        byte[] endianIndicator = new byte[2];
        byte[] descriptionBuffer = new byte[116];
        buf.get(descriptionBuffer);
        String description = this.zeroEndByteArrayToString(descriptionBuffer);
        if (!description.matches("MATLAB 5.0 MAT-file.*")) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
        buf.position(buf.position() + 8);
        byte[] bversion = new byte[2];
        buf.get(bversion);
        buf.get(endianIndicator);
        if ((char)endianIndicator[0] == 'I' && (char)endianIndicator[1] == 'M') {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            version = bversion[1] & 0xFF | bversion[0] << 8;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            version = bversion[0] & 0xFF | bversion[1] << 8;
        }
        buf.order(this.byteOrder);
        this.matFileHeader = new MatFileHeader(description, version, endianIndicator);
    }

    private class ISMatTag
    extends MatTag {
        public ByteBuffer buf;
        private int padding;

        public ISMatTag(ByteBuffer buf) throws IOException {
            boolean compressed;
            super(0, 0);
            this.buf = buf;
            int tmp = buf.getInt();
            if (tmp >> 16 == 0) {
                this.type = tmp;
                this.size = buf.getInt();
                compressed = false;
            } else {
                this.size = tmp >> 16;
                this.type = tmp & 0xFFFF;
                compressed = true;
            }
            this.padding = this.getPadding(this.size, compressed);
        }

        public double[] readToDoubleArray() throws IOException {
            int elements = this.size / this.sizeOf();
            double[] ad = new double[elements];
            MatFileInputStream mfis = new MatFileInputStream(this.buf, this.type);
            int i = 0;
            while (i < elements) {
                ad[i] = mfis.readDouble();
                ++i;
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return ad;
        }

        public int[] readToIntArray() throws IOException {
            int elements = this.size / this.sizeOf();
            int[] ai = new int[elements];
            MatFileInputStream mfis = new MatFileInputStream(this.buf, this.type);
            int i = 0;
            while (i < elements) {
                ai[i] = mfis.readInt();
                ++i;
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return ai;
        }

        public char[] readToCharArray() throws IOException {
            int elements = this.size / this.sizeOf();
            char[] ac = new char[elements];
            MatFileInputStream mfis = new MatFileInputStream(this.buf, this.type);
            int i = 0;
            while (i < elements) {
                ac[i] = mfis.readChar();
                ++i;
            }
            if (this.padding > 0) {
                this.buf.position(this.buf.position() + this.padding);
            }
            return ac;
        }
    }
}

