/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class LevelFilter
implements Filter {
    private final Level threshold;
    private final Type filterType;

    public LevelFilter() {
        this.filterType = this.getTypeFromProperties();
        this.threshold = this.getThresholdFromProperties();
    }

    private final Type getTypeFromProperties() {
        String pname = String.valueOf(this.getClass().getName()) + ".type";
        String str = LogManager.getLogManager().getProperty(pname);
        try {
            return Type.valueOf(str);
        }
        catch (Exception ex) {
            System.err.println("ERROR: could not parse log config " + pname + ", e=" + ex);
            return Type.LessSevere;
        }
    }

    private final Level getThresholdFromProperties() {
        String pname = String.valueOf(this.getClass().getName()) + ".threshold";
        String str = LogManager.getLogManager().getProperty(pname);
        try {
            return Level.parse(str);
        }
        catch (Exception ex) {
            System.err.println("ERROR: could not parse log config " + pname + ", e=" + ex);
            return Level.WARNING;
        }
    }

    public LevelFilter(Type filterType, Level threshold) {
        if (filterType == null) {
            throw new NullPointerException("filter type is required");
        }
        if (threshold == null) {
            throw new NullPointerException("threshold is required");
        }
        this.filterType = filterType;
        this.threshold = threshold;
    }

    public boolean isLoggable(LogRecord record) {
        return this.filterType.isLoggable(record, this.threshold);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MoreSevere{

            public boolean isLoggable(LogRecord record, Level threshold) {
                return record.getLevel().intValue() > threshold.intValue();
            }
        }
        ,
        AtLeastAsSevere{

            public boolean isLoggable(LogRecord record, Level threshold) {
                return record.getLevel().intValue() >= threshold.intValue();
            }
        }
        ,
        AtMostAsSevere{

            public boolean isLoggable(LogRecord record, Level threshold) {
                return record.getLevel().intValue() <= threshold.intValue();
            }
        }
        ,
        LessSevere{

            public boolean isLoggable(LogRecord record, Level threshold) {
                return record.getLevel().intValue() < threshold.intValue();
            }
        };


        public abstract boolean isLoggable(LogRecord var1, Level var2);
    }
}

