/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.mt;

import ch.javasoft.smx.exception.SingularMatrixException;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.ops.ext.ExternalOpsImpl;
import ch.javasoft.smx.ops.mt.Convert;
import ch.javasoft.smx.ops.mt.LogPkg;
import ch.javasoft.smx.ops.sscc.SsccOpsImpl;
import ch.javasoft.util.logging.LogPrintWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import mt.DenseMatrix;
import mt.DiagMatrix;
import mt.Matrix;
import mt.fact.NotConvergedException;
import mt.fact.SVD;
import mt.fact.SingularvalueComputer;
import mt.ll.Interface;

public class MtOpsImpl
extends ExternalOpsImpl {
    public static final int DEFAULT_PRECISION = 10;
    private final int mPrecision;
    private final double mZero;

    static {
        String libName;
        boolean any = false;
        if (Interface.blas().getClass().getName().endsWith("JLAPACK_BLASkernel")) {
            libName = System.mapLibraryName("nni_blas");
            System.out.println("WARNING: native BLAS library '" + libName + "' not found, defaulting to pure java version.");
            any = true;
        }
        if (Interface.lapack().getClass().getName().endsWith("JLAPACK_LAPACKkernel")) {
            libName = System.mapLibraryName("nni_lapack");
            System.out.println("WARNING: native LAPACK library '" + libName + "' not found, defaulting to pure java version.");
            any = true;
        }
        if (any) {
            System.out.println("java.library.path=" + System.getProperty("java.library.path"));
        }
    }

    public MtOpsImpl() {
        this(10);
    }

    public MtOpsImpl(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("negative precision: " + precision);
        }
        this.mPrecision = precision;
        this.mZero = Math.pow(10.0, -this.mPrecision);
    }

    public DoubleMatrix nullspace(ReadableDoubleMatrix src) {
        try {
            return Convert.fromExternal(this.getNull(this.getSvd(src, true)));
        }
        catch (RuntimeException ex) {
            LogPkg.LOGGER.info("retrying with sscc library");
            return new SsccOpsImpl().nullspace(src);
        }
    }

    public int nullity(ReadableDoubleMatrix src) {
        return src.getColumnCount() - this.rank(src);
    }

    public int rank(ReadableDoubleMatrix src) {
        return this.rank(this.getSvd(src, false));
    }

    private int rank(SVD svd) {
        double[] sing = svd.getS();
        int rank = sing.length;
        int ii = 0;
        while (ii < sing.length) {
            if (sing[ii] <= this.mZero) {
                rank = ii;
                break;
            }
            ++ii;
        }
        return rank;
    }

    public DoubleMatrix invert(ReadableDoubleMatrix src) {
        if (src.getColumnCount() == src.getRowCount()) {
            SVD svd = this.getSvd(src, true);
            Matrix u = this.getU(svd);
            Matrix vt = this.getVt(svd);
            double[] s = svd.getS();
            int ii = 0;
            while (ii < s.length) {
                if (s[ii] < this.mZero) {
                    throw new SingularMatrixException("singular matrix: " + src, ii);
                }
                s[ii] = 1.0 / s[ii];
                ++ii;
            }
            Matrix ut = this.transpose(u);
            Matrix v = this.transpose(vt);
            Matrix inv = this.multiply(this.multiply(v, (Matrix)new DiagMatrix(s)), ut);
            return Convert.fromExternal(inv);
        }
        throw new IllegalArgumentException("not a square matrix: " + src);
    }

    private Matrix submatrix(Matrix mx, int rStart, int rEnd, int cStart, int cEnd) {
        DenseMatrix res = new DenseMatrix(rEnd - rStart, cEnd - cStart);
        int row = 0;
        while (row < res.numRows()) {
            int col = 0;
            while (col < res.numColumns()) {
                res.set(row, col, mx.get(rStart + row, cStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    private SVD getSvd(ReadableDoubleMatrix src, boolean vectors) {
        SingularvalueComputer svc = new SingularvalueComputer(src.getRowCount(), src.getColumnCount(), vectors);
        try {
            Matrix mxSrc = Convert.toExternal(src);
            DenseMatrix dmxSrc = mxSrc instanceof DenseMatrix ? (DenseMatrix)mxSrc : new DenseMatrix(mxSrc);
            return svc.factor(dmxSrc);
        }
        catch (NotConvergedException ex) {
            LogPkg.LOGGER.severe("svd not converged, e=" + (Object)((Object)ex));
            LogPrintWriter log = new LogPrintWriter(LogPkg.LOGGER, Level.SEVERE);
            ex.printStackTrace((PrintWriter)log);
            log.flush();
            log = new LogPrintWriter(LogPkg.LOGGER, Level.INFO);
            src.writeToMultiline(log);
            log.flush();
            throw new RuntimeException("cannot create svd for matrix, e=" + (Object)((Object)ex), ex);
        }
    }

    private void print(Matrix mx) {
        System.out.println("{");
        int row = 0;
        while (row < mx.numRows()) {
            System.out.print(" [");
            int col = 0;
            while (col < mx.numColumns()) {
                if (col > 0) {
                    System.out.print(", ");
                }
                System.out.print(mx.get(row, col));
                ++col;
            }
            System.out.println("]");
            ++row;
        }
        System.out.println("}");
    }

    private Matrix multiply(Matrix mxA, Matrix mxB) {
        DenseMatrix res = new DenseMatrix(mxA.numRows(), mxB.numColumns());
        return mxA.mult(mxB, (Matrix)res);
    }

    private Matrix getU(SVD svd) {
        return this.submatrix((Matrix)svd.getU(), 0, svd.getU().numRows(), 0, svd.getS().length);
    }

    private Matrix getVt(SVD svd) {
        return this.submatrix((Matrix)svd.getVt(), 0, svd.getS().length, 0, svd.getVt().numColumns());
    }

    private Matrix getNull(SVD svd) {
        int rank = this.rank(svd);
        DenseMatrix vt = svd.getVt();
        if (vt.numRows() > rank) {
            return this.transpose(this.submatrix((Matrix)vt, rank, vt.numRows(), 0, vt.numColumns()));
        }
        return new DenseMatrix(rank, 0);
    }

    public double[] getSignularValues(ReadableDoubleMatrix mx) {
        SVD svd = this.getSvd(mx, true);
        double[] singVals = new double[svd.getVt().numRows()];
        double[] singValsNotZero = svd.getS();
        System.arraycopy(singValsNotZero, 0, singVals, 0, singValsNotZero.length);
        return singVals;
    }

    private Matrix transpose(Matrix mx) {
        return mx.transpose((Matrix)new DenseMatrix(mx.numColumns(), mx.numRows()));
    }
}

