/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.transform;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.polco.InequalityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.impl.AbstractEqualityCone;
import ch.javasoft.polco.transform.LogPkg;
import ch.javasoft.polco.transform.TransformHelper;
import ch.javasoft.polco.transform.TransformedInequalityCone;
import ch.javasoft.polco.transform.TransformedPolyhedralCone;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.logging.Loggers;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedEqualityCone<Num extends Number, Arr>
extends AbstractEqualityCone<Num, Arr>
implements TransformedPolyhedralCone<Num, Arr> {
    private final InequalityPolyhedralCone<Num, Arr> parent;
    private final AtomicReference<Arr[]> mxTtoOriginal = new AtomicReference();
    private Arr[] mxT1;
    private Arr[] mxT2;

    public TransformedEqualityCone(PolyhedralCone<Num, Arr> toTransform) {
        this(toTransform instanceof InequalityPolyhedralCone ? (InequalityPolyhedralCone)toTransform : new TransformedInequalityCone<Num, Arr>(toTransform));
    }

    public TransformedEqualityCone(InequalityPolyhedralCone<Num, Arr> toTransform) {
        super(toTransform.getLinAlgOperations());
        this.parent = toTransform;
        this.transform();
    }

    @Override
    public PolyhedralCone<Num, Arr> getParentCone() {
        return this.parent;
    }

    @Override
    public PolyhedralCone<Num, Arr> getOriginalCone() {
        return TransformHelper.getOriginalCone(this);
    }

    @Override
    public int getDimensions() {
        return this.parent.getRowCountB();
    }

    public ArrayOperations<Arr> getArrayOperations() {
        return this.getLinAlgOperations().getArrayOperations();
    }

    @Override
    public Arr[] getA() {
        return this.mxT2;
    }

    @Override
    public Num getA(int row, int col) {
        LinAlgOperations linalg = this.getLinAlgOperations();
        return (Num)linalg.getNumberArrayOperations().get(this.mxT2, row, col);
    }

    @Override
    public int getRowCountA() {
        LinAlgOperations linalg = this.getLinAlgOperations();
        return linalg.getArrayOperations().getRowCount(this.mxT2);
    }

    @Override
    public Arr[] getTransformationMatrixToParent() {
        return this.mxT1;
    }

    @Override
    public Arr transformToOriginal(Arr x2) {
        return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
    }

    private void transform() {
        int r;
        boolean logFine = Loggers.isLoggable(LogPkg.LOGGER, Level.FINE);
        boolean logFiner = logFine && Loggers.isLoggable(LogPkg.LOGGER, Level.FINER);
        boolean logFinest = logFiner && Loggers.isLoggable(LogPkg.LOGGER, Level.FINEST);
        LinAlgOperations linalg = this.getLinAlgOperations();
        ArrayOperations<Object> aops = linalg.getArrayOperations();
        NumberOperators nops = linalg.getNumberOperators();
        NumberArrayOperations naops = linalg.getNumberArrayOperations();
        BinaryOperator mul = nops.binary(BinaryOperator.Id.multiply);
        BinaryOperator div = nops.binary(BinaryOperator.Id.divide);
        AggregatingUnaryOperator nrmDiv = nops.aggregatingUnary(AggregatingUnaryOperator.Id.normDivisor);
        BooleanUnaryOperator isOne = nops.booleanUnary(BooleanUnaryOperator.Id.isOne);
        BooleanUnaryOperator isZero = nops.booleanUnary(BooleanUnaryOperator.Id.isZero);
        int dims = this.parent.getDimensions();
        int rows = this.parent.getRowCountB();
        Arr[] mxB = this.parent.getB();
        A[] mx = naops.newZeroMatrix(rows, rows + dims);
        aops.copyMatrixElements(mxB, 0, 0, mx, 0, 0, rows, dims);
        int i = 0;
        while (i < rows) {
            naops.set(mx, i, i + dims, naops.getNumberOperators().one());
            ++i;
        }
        int[] rowmap = new int[rows];
        int[] colmap = new int[dims];
        int[] ptRank = new int[1];
        Arr[] rref = linalg.rowEchelon(mx, true, rowmap, colmap, ptRank);
        int rank = ptRank[0];
        if (logFine) {
            LogPkg.LOGGER.fine("rank: " + rank);
            LogPkg.LOGGER.fine("rowmap: " + Arrays.toString(rowmap));
            LogPkg.LOGGER.fine("colmap: " + Arrays.toString(colmap));
            if (logFinest) {
                LogPrintWriter finestWriter = new LogPrintWriter(LogPkg.LOGGER, Level.FINEST);
                aops.printMatrix(finestWriter, "rref", rref);
                finestWriter.flush();
            }
        }
        if (rank < dims) {
            LogPkg.LOGGER.info("cone is not pointed, B has not full column rank: " + rank + "<" + dims);
            LogPkg.LOGGER.warning("the " + (dims - rank) + " linealities of this unpointed cone are not reported");
        }
        A[] mxT1 = aops.newMatrix(dims, rows);
        A[] mxT2 = aops.newMatrix(rows - rank, rows);
        if (logFine) {
            LogPkg.LOGGER.fine("transformed cone: P = { x = T1 x2  ,  T2 x2 = 0 , x2 >= 0  ;  T1:" + dims + "x" + rows + " , T2:" + (rows - rank) + "x" + rows + " }");
        }
        Object ptrDiagMul = aops.newVector(1);
        Object vecDiag = this.isDiagMultipleOne(rref, mxB, rank, 0, dims, colmap, ptrDiagMul);
        boolean diagIsIdent = isOne.booleanOperate(ptrDiagMul, 0);
        int c = 0;
        while (c < rows) {
            r = 0;
            while (r < rank) {
                aops.copyMatrixElement(rref, r, c + dims, mxT1, colmap[r], rowmap[c]);
                if (!diagIsIdent) {
                    mul.operate(mxT1[colmap[r]], rowmap[c], ptrDiagMul, 0, mxT1[colmap[r]], rowmap[c]);
                    div.operate(mxT1[colmap[r]], rowmap[c], vecDiag, r, mxT1[colmap[r]], rowmap[c]);
                }
                ++r;
            }
            r = rank;
            while (r < dims) {
                naops.set(mxT1, colmap[r], rowmap[c], nops.zero());
                ++r;
            }
            r = rank;
            while (r < rows) {
                aops.copyMatrixElement(rref, r, c + dims, mxT2, r - rank, rowmap[c]);
                ++r;
            }
            ++c;
        }
        if (nops.getDivisionSupport().isExact()) {
            int c2;
            Object ptrTmp = naops.newZeroVector(1);
            nrmDiv.operate(mxT1, 0, 0, dims, rows, ptrTmp, 0);
            if (!isOne.booleanOperate(ptrTmp, 0) && !isZero.booleanOperate(ptrTmp, 0)) {
                r = 0;
                while (r < rank) {
                    c2 = 0;
                    while (c2 < rows) {
                        div.operate(mxT1[r], c2, ptrTmp, 0, mxT1[r], c2);
                        ++c2;
                    }
                    ++r;
                }
            }
            r = 0;
            while (r < rows - rank) {
                nrmDiv.operate(mxT2[r], 0, rows, ptrTmp, 0);
                if (!isOne.booleanOperate(ptrTmp, 0) && !isZero.booleanOperate(ptrTmp, 0)) {
                    c2 = 0;
                    while (c2 < rows) {
                        div.operate(mxT2[r], c2, ptrTmp, 0, mxT2[r], c2);
                        ++c2;
                    }
                }
                ++r;
            }
        }
        this.normalize(mxT1);
        this.normalize(mxT2);
        if (logFiner) {
            LogPrintWriter finerWriter = new LogPrintWriter(LogPkg.LOGGER, Level.FINER);
            if (logFinest) {
                LogPrintWriter finestWriter = new LogPrintWriter(LogPkg.LOGGER, Level.FINEST);
                aops.printVector(finestWriter, "diag D", vecDiag, true);
                finestWriter.flush();
            }
            aops.printMatrix(finerWriter, "T1", mxT1);
            aops.printMatrix(finerWriter, "T2", mxT2);
            finerWriter.flush();
        }
        this.mxT1 = mxT1;
        this.mxT2 = mxT2;
    }

    private Arr isDiagMultipleOne(Arr[] mxIdentT, Arr[] mxB, int rank, int rowOffsetT, int colOffsetT, int[] colmap, Arr ptrDiagMul) {
        LinAlgOperations linalg = this.getLinAlgOperations();
        NumberOperators nops = linalg.getNumberOperators();
        ArrayOperations<Object> aops = linalg.getArrayOperations();
        NumberArrayOperations naops = linalg.getNumberArrayOperations();
        BinaryOperator add = nops.binary(BinaryOperator.Id.add);
        BinaryOperator mul = nops.binary(BinaryOperator.Id.multiply);
        BinaryOperator div = nops.binary(BinaryOperator.Id.divide);
        UnaryOperator nor = nops.unary(UnaryOperator.Id.normalize);
        AggregatingUnaryOperator gcd = nops.aggregatingUnary(AggregatingUnaryOperator.Id.normDivisor);
        BooleanUnaryOperator isOne = nops.booleanUnary(BooleanUnaryOperator.Id.isOne);
        int jlen = aops.getRowCount(mxB);
        boolean allOne = true;
        int i = 0;
        while (i < rank && allOne) {
            allOne &= isOne.booleanOperate(mxIdentT[i], i);
            ++i;
        }
        if (allOne) {
            naops.set(ptrDiagMul, 0, nops.one());
            return (Arr)naops.newOneVector(rank);
        }
        Object ptrDiag = aops.newVector(rank);
        Object ptrTmp = aops.newVector(2);
        naops.set(ptrTmp, 0, nops.one());
        int i2 = 0;
        while (i2 < rank) {
            naops.set(ptrTmp, 1, nops.zero());
            int j = 0;
            while (j < jlen) {
                mul.operate(mxIdentT[rowOffsetT + i2], colOffsetT + j, mxB[j], colmap[i2], ptrDiag, i2);
                add.operate(ptrTmp, 1, ptrDiag, i2, ptrTmp, 1);
                nor.operate(ptrTmp, 1, ptrTmp, 1);
                ++j;
            }
            aops.copyVectorElement(ptrTmp, 1, ptrDiag, i2);
            gcd.operate(ptrTmp, 0, 2, ptrTmp, 1);
            div.operate(ptrDiag, i2, ptrTmp, 1, ptrTmp, 1);
            mul.operate(ptrTmp, 0, ptrTmp, 1, ptrTmp, 0);
            ++i2;
        }
        aops.copyVectorElement(ptrTmp, 0, ptrDiagMul, 0);
        if (isOne.booleanOperate(ptrDiagMul, 0)) {
            naops.set(ptrDiagMul, 0, nops.one());
        }
        return (Arr)ptrDiag;
    }
}

