/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixUtil {
    public static BigIntegerRationalMatrix convertToBigIntegerRationalMatrix(ReadableMatrix mx, Zero zero, boolean enforceNewInstance) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return ((ReadableBigIntegerRationalMatrix)mx).toBigIntegerRationalMatrix(enforceNewInstance);
        }
        if (mx instanceof ReadableDoubleMatrix) {
            double[] values = ((ReadableDoubleMatrix)mx).toDoubleArray();
            return new DefaultBigIntegerRationalMatrix(values, mx.getRowCount(), mx.getColumnCount(), zero.mZeroPos);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    public static void writeMatrix(ReadableMatrix matrix, OutputStream out) throws IOException {
        MatrixUtil.writeMatrixInternal(matrix, out);
    }

    private static <N extends Number> void writeMatrixInternal(ReadableMatrix<N> matrix, OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int cols = matrix.getColumnCount();
        int rows = matrix.getRowCount();
        NumberOperations<N> ops = matrix.getNumberOperations();
        dout.writeUTF(matrix.getClass().getName());
        dout.writeInt(rows);
        dout.writeInt(cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                ops.writeTo(matrix.getNumberValueAt(row, col), dout);
                ++col;
            }
            ++row;
        }
        dout.flush();
    }

    public static ReadableMatrix<?> readMatrix(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        try {
            String className = din.readUTF();
            Integer zero = 0;
            ReadableMatrix template = (ReadableMatrix)Class.forName(className).getConstructor(Integer.TYPE, Integer.TYPE).newInstance(zero, zero);
            NumberOperations ops = template.getNumberOperations();
            int rows = din.readInt();
            int cols = din.readInt();
            Number[][] vals = ops.newArray(rows, cols);
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    vals[row][col] = ops.readFrom(din);
                    ++col;
                }
                ++row;
            }
            return (ReadableMatrix)Class.forName(className).getConstructor(vals.getClass(), Boolean.TYPE).newInstance(new Object[]{vals, Boolean.TRUE});
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
    }

    private MatrixUtil() {
    }
}

