/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.search;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.tree.AdjacencyFilter;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.search.SuperSetSearch;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchAdjacencyFilter<T extends ConcurrentToken>
implements AdjacencyFilter<T> {
    private final BitPatternTree treePos;
    private final BitPatternTree treeNeg;
    private final BitPatternTree treeZer;

    public <Col extends Column, N extends Number> DefaultSearchAdjacencyFilter(BitPatternTree treePos, BitPatternTree treeNeg, BitPatternTree treeZer) {
        this.treePos = treePos;
        this.treeNeg = treeNeg;
        this.treeZer = treeZer;
    }

    @Override
    public <Col extends Column, N extends Number> boolean filter(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, AdjCandidates<Col> candidates, IBitSet commonPattern) throws IOException {
        int ind = 0;
        int len = candidates.size();
        if (ind < len) {
            while (ind < len) {
                IBitSet inter = candidates.getIntersection(ind);
                SuperSetSearch<T> search = new SuperSetSearch<T>(inter);
                search.traverse(columnHome, iterationModel, token, this.treeZer);
                boolean remove = search.hasSuperSetFound();
                if (!remove) {
                    search = new SuperSetSearch(inter, candidates.getColumnIndexPos(ind));
                    search.traverse(columnHome, iterationModel, token, this.treePos);
                    remove = search.hasSuperSetFound();
                    if (!remove) {
                        search = new SuperSetSearch(inter, candidates.getColumnIndexNeg(ind));
                        search.traverse(columnHome, iterationModel, token, this.treeNeg);
                        remove = search.hasSuperSetFound();
                    }
                }
                if (remove) {
                    if (ind != --len) {
                        candidates.swap(ind, len);
                    }
                    candidates.removeLast();
                    continue;
                }
                ++ind;
            }
        }
        return candidates.size() != 0;
    }
}

