/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.progress;

import ch.javasoft.metabolic.efm.progress.ProgressMonitor;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractStringProgressWriter
implements ProgressMonitor {
    private final int decimalPrecision;
    private final int smallestIncrement;
    private final NumberFormat format;

    public AbstractStringProgressWriter(Mode mode, int n) {
        if (mode.getDecimalPrecision(n) < 0) {
            throw new IllegalArgumentException("decimal precision cannot be negative: " + mode.getDecimalPrecision(n));
        }
        this.decimalPrecision = mode.getDecimalPrecision(n);
        this.smallestIncrement = mode.getSmallestIncrement(n);
        this.format = AbstractStringProgressWriter.getFormat(this.decimalPrecision);
    }

    private static NumberFormat getFormat(int decimalPrecision) {
        StringBuilder sb = new StringBuilder("##0");
        if (decimalPrecision > 0) {
            sb.append('.');
        }
        while (decimalPrecision > 0) {
            sb.append('0');
        }
        sb.append('%');
        return new DecimalFormat(sb.toString());
    }

    public final int getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public final int getSmallestIncrement() {
        return this.smallestIncrement;
    }

    public void notifyProgress(double progress) throws IOException {
        this.write(progress, String.valueOf(this.format.format(progress)) + "\n");
    }

    protected abstract void write(double var1, String var3) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Decimal{

            int getDecimalPrecision(int value) {
                return value;
            }

            int getSmallestIncrement(int value) {
                return (int)Math.ceil((double)(value + 2) * Math.log(10.0) / Math.log(2.0));
            }
        }
        ,
        Partition{

            int getDecimalPrecision(int value) {
                return (int)Math.floor(Math.log10(value) - 2.0);
            }

            int getSmallestIncrement(int value) {
                return 32 - Integer.numberOfLeadingZeros(value - 1);
            }
        };


        abstract int getDecimalPrecision(int var1);

        abstract int getSmallestIncrement(int var1);
    }
}

