/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.mat;

import ch.javasoft.metabolic.Annotation;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.EfmProcessor;
import ch.javasoft.metabolic.efm.output.UnmappingEfmProcessor;
import ch.javasoft.metabolic.efm.output.mat.MatFileWriter;
import ch.javasoft.metabolic.efm.output.mat.MatReservedVariableEfmProcessor;
import ch.javasoft.metabolic.efm.output.mat.PartitionedMatFileWriter;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.util.IntArray;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileOutputFormatter
implements EfmOutputFormatter<PartitionedMatFileWriter> {
    protected final MetabolicNetwork mOriginalNetwork;
    protected final EfmProcessor<MatFileWriter> mEfmProcessor;

    public MatFileOutputFormatter() {
        this(null, new MatReservedVariableEfmProcessor());
    }

    public MatFileOutputFormatter(MetabolicNetwork originalNetwork) {
        this(originalNetwork, new UnmappingEfmProcessor<MatFileWriter>(new MatReservedVariableEfmProcessor(), originalNetwork));
    }

    public MatFileOutputFormatter(MetabolicNetwork originalNetwork, EfmProcessor<MatFileWriter> efmProcessor) {
        this.mOriginalNetwork = originalNetwork;
        this.mEfmProcessor = efmProcessor;
    }

    protected MetabolicNetwork getOriginalNetwork(EfmOutputCallback cb, EfmOutputEvent evt) {
        MetabolicNetwork net = this.mOriginalNetwork;
        if (net == null && (net = evt.getMetabolicNetwork()) instanceof CompressedMetabolicNetwork && cb.getGranularity().isUncompressionNeeded()) {
            net = ((CompressedMetabolicNetwork)net).getRootNetwork();
        }
        return net;
    }

    @Override
    public void formatHeader(EfmOutputCallback cb, PartitionedMatFileWriter writer, EfmOutputEvent evt) throws IOException {
        writer.getPartMatFileWriter(cb, evt, 0L, this.getOriginalNetwork(cb, evt), this.mEfmProcessor);
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, PartitionedMatFileWriter writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        MatFileWriter matWriter = writer.getPartMatFileWriter(cb, evt, efmIndex, this.getOriginalNetwork(cb, evt), this.mEfmProcessor);
        this.mEfmProcessor.addEfm(cb, matWriter, evt, efmIndex);
    }

    @Override
    public void formatEfmValue(EfmOutputCallback cb, PartitionedMatFileWriter writer, EfmOutputEvent evt, long efmIndex, int valueIndex, Number value) throws IOException {
        throw new IOException("internal error: formatEfmValue() should not be called");
    }

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, PartitionedMatFileWriter writer, EfmOutputEvent evt, long efmIndex) throws IOException {
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, PartitionedMatFileWriter writer, EfmOutputEvent evt, long countEfms) throws IOException {
        writer.close(cb, evt, countEfms, this.mEfmProcessor);
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return false;
    }

    protected static void writeNetworkFootPrint(MetabolicNetwork net, MatFileWriter writer, String fileNameWithoutEnding, String partFileName, int partIndex, int partCount) {
        MatFileOutputFormatter.writeAnnotations(net, writer, fileNameWithoutEnding, partFileName, partIndex, partCount);
        LinkedHashMap<String, Integer> compartmentNames = new LinkedHashMap<String, Integer>();
        IntArray metaboliteCompartments = new IntArray();
        String[] metaNames = new String[net.getMetabolites().length()];
        int i = 0;
        while (i < metaNames.length) {
            Integer index;
            Metabolite meta = net.getMetabolites().get(i);
            metaNames[i] = meta.getName();
            String cmpName = "Default";
            if (meta instanceof CompartmentMetabolite) {
                cmpName = ((CompartmentMetabolite)meta).getCompartment();
            }
            if ((index = (Integer)compartmentNames.get(cmpName)) == null) {
                index = compartmentNames.size() + 1;
                compartmentNames.put(cmpName, index);
            }
            metaboliteCompartments.add(index);
            ++i;
        }
        writer.write("compartmentNames", compartmentNames.keySet().toArray(new String[compartmentNames.size()]));
        writer.write("metaboliteNames", metaNames);
        writer.write("metaboliteCompartments", metaboliteCompartments.toArray());
        writer.write("unbalancedMetabolites", IntArray.EMPTY_ARRAY);
        IntArray exchangeIndices = new IntArray();
        int rlen = net.getReactions().length();
        String[] reacNames = new String[rlen];
        String[] reacForms = new String[rlen];
        double[] reacLb = new double[rlen];
        double[] reacUb = new double[rlen];
        int i2 = 0;
        while (i2 < rlen) {
            Reaction reac = net.getReactions().get(i2);
            reacNames[i2] = reac.getName();
            reacForms[i2] = reac.toString();
            reacLb[i2] = reac.getConstraints().getLowerBound();
            reacUb[i2] = reac.getConstraints().getUpperBound();
            if (reac.isExternal()) {
                exchangeIndices.add(i2 + 1);
            }
            ++i2;
        }
        writer.write("reactionNames", reacNames);
        writer.write("reactionFormulas", reacForms);
        writer.write("reactionLowerBounds", reacLb);
        writer.write("reactionUpperBounds", reacUb);
        writer.write("exchangeReactions", exchangeIndices.toArray());
        MatFileOutputFormatter.writeStoich(net, writer);
    }

    private static void writeStoich(MetabolicNetwork net, MatFileWriter writer) {
        double[][] stoich = StoichiometricMatrices.createStoichiometricMatrix(net);
        writer.write("stoichSubstrates", MatFileOutputFormatter.getSubStoich(stoich, -1));
        writer.write("stoichProducts", MatFileOutputFormatter.getSubStoich(stoich, 1));
        writer.write("stoich", stoich);
    }

    private static double[][] getSubStoich(double[][] stoich, int sgn) {
        double[][] subStoich = new double[stoich.length][];
        int r = 0;
        while (r < subStoich.length) {
            subStoich[r] = new double[stoich[r].length];
            int c = 0;
            while (c < subStoich[r].length) {
                subStoich[r][c] = stoich[r][c];
                if ((double)sgn * Math.signum(subStoich[r][c]) < 0.0) {
                    subStoich[r][c] = 0.0;
                }
                ++c;
            }
            ++r;
        }
        return subStoich;
    }

    private static void writeAnnotations(MetabolicNetwork net, MatFileWriter writer, String fileNameWithoutEnding, String partFileName, int partIndex, int partCount) {
        Annotation[] annotationArray = Annotation.values();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            Object value = annot.getAnnotation(net);
            if (value != null) {
                annot.checkValue(value);
            }
            switch (annot) {
                case ModelName: {
                    if (value == null) {
                        value = fileNameWithoutEnding;
                    }
                }
                case Version: 
                case Organism: {
                    if (value == null) {
                        value = "";
                    }
                    writer.write(annot.getMnetName(), (String)value);
                    break;
                }
                case Date: {
                    if (value == null) {
                        value = new Date();
                    }
                    SimpleDateFormat fmt = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
                    writer.write(annot.getMnetName(), "File " + partFileName + " (" + (partIndex + 1) + " of " + partCount + ") created by efmtool on " + fmt.format(value));
                    break;
                }
                case BiomassReaction: {
                    if (value == null) {
                        writer.write(annot.getMnetName(), IntArray.EMPTY_ARRAY);
                        break;
                    }
                    int index = net.getReactionIndex(((Reaction)value).getName());
                    if (index == -1) {
                        throw new IllegalStateException("unknown reaction in network: " + value);
                    }
                    writer.write(annot.getMnetName(), index + 1);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown annotation: " + (Object)((Object)annot));
                }
            }
            ++n2;
        }
    }
}

