/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.output.AbstractFormattedOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.LogPkg;
import ch.javasoft.metabolic.efm.output.OutputMode;
import ch.javasoft.metabolic.efm.output.UnmappingEfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.text.BinaryTextOutputFormatter;
import ch.javasoft.metabolic.efm.output.text.DoubleTextOutputFormatter;
import ch.javasoft.metabolic.efm.output.text.SignTextOutputFormatter;
import ch.javasoft.util.logging.LogPrintWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOutputCallback
extends AbstractFormattedOutputCallback<PrintWriter> {
    private final boolean mAllowLoggingDuringOutput;

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode) {
        this(originalNetwork, mode, TextOutputCallback.getOutputFormatter(true, mode));
    }

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode, EfmOutputFormatter<PrintWriter> formatter) {
        this(originalNetwork, mode, LogPkg.LOGGER, Level.INFO, formatter);
    }

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode, Logger logger, Level level, EfmOutputFormatter<PrintWriter> formatter) {
        this(originalNetwork, mode, new LogPrintWriter(logger, level), formatter, !mode.granularity.isPerEfmOutput());
    }

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode, OutputStream out, boolean allowLoggingDuringOutput) {
        this(originalNetwork, mode, out, TextOutputCallback.getOutputFormatter(false, mode), allowLoggingDuringOutput);
    }

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode, OutputStream out, EfmOutputFormatter<PrintWriter> formatter, boolean allowLoggingDuringOutput) {
        super(mode, new UnmappingEfmOutputFormatter<PrintWriter>(formatter, originalNetwork), Print.createWriter(out));
        this.mAllowLoggingDuringOutput = allowLoggingDuringOutput;
    }

    public TextOutputCallback(MetabolicNetwork originalNetwork, OutputMode mode, Writer writer, EfmOutputFormatter<PrintWriter> formatter, boolean allowLoggingDuringOutput) {
        super(mode, new UnmappingEfmOutputFormatter<PrintWriter>(formatter, originalNetwork), Print.createWriter(writer));
        this.mAllowLoggingDuringOutput = allowLoggingDuringOutput;
    }

    private static EfmOutputFormatter<PrintWriter> getOutputFormatter(boolean log, OutputMode mode) {
        switch (mode.granularity) {
            case BinaryCompressed: 
            case BinaryUncompressed: {
                return new BinaryTextOutputFormatter(log, log);
            }
            case SignUncompressed: {
                return new SignTextOutputFormatter(log, log);
            }
            case DoubleUncompressed: {
                return new DoubleTextOutputFormatter(log, log);
            }
        }
        throw new IllegalArgumentException("unsupported mode: " + (Object)((Object)mode));
    }

    @Override
    protected void callbackPost(EfmOutputEvent evt) throws IOException {
        super.callbackPost(evt);
        ((PrintWriter)this.mWriter).flush();
    }

    @Override
    public boolean allowLoggingDuringOutput() {
        return this.mAllowLoggingDuringOutput;
    }
}

